/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.processes;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.comp.CXMLContext;
import oracle.xml.comp.CXMLHandlerBase;
import oracle.xml.comp.CXMLStream;
import oracle.xml.comp.CXMLWriter;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.Output;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.scalable.InfosetWriter;
import org.xml.sax.ContentHandler;

public class CompressWriterProcess
extends Process {
    CXMLHandlerBase compHandler;
    CXMLStream cxmlstream;
    String outmode;

    @Override
    public void initialize() {
        Input input = this.getInput("xml");
        input.supportType(0);
        input.supportType(1);
        input.supportType(8);
        Output output = this.getOutput("compxml");
        output.supportType(7);
        output.supportType(8);
    }

    @Override
    public ContentHandler SAXContentHandler() throws PipelineException {
        if (this.cxmlstream != null) {
            this.cxmlstream.close();
        }
        this.setCXMLStream();
        this.compHandler = new CXMLHandlerBase(this.cxmlstream);
        return this.compHandler;
    }

    private void setCXMLStream() throws PipelineException {
        try {
            OutputStream outputStream = this.getOutputStream("compxml");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            this.cxmlstream = new CXMLStream(new CXMLContext());
            this.cxmlstream.setObjectOutput((ObjectOutput)objectOutputStream);
        }
        catch (IOException iOException) {
            this.error(30003, 17, iOException);
        }
    }

    @Override
    public void execute() throws PipelineException {
        if (this.cxmlstream == null) {
            this.setCXMLStream();
        }
        Source source = this.getInputSource("xml");
        try {
            if (source instanceof DOMSource) {
                XMLDocument xMLDocument = (XMLDocument)((DOMSource)source).getNode();
                CXMLWriter cXMLWriter = (CXMLWriter)this.cxmlstream.getInfosetWriter();
                xMLDocument.save((InfosetWriter)cXMLWriter);
                cXMLWriter.close();
                this.cxmlstream.close();
            } else if (source instanceof StreamSource) {
                this.error(30002, 17, new String[]{"DOMSource and SAXSource"});
            } else {
                this.cxmlstream.close();
            }
        }
        catch (IOException iOException) {
            this.error(30003, 17, iOException);
        }
    }
}

