/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.pipeline.controller.PipeDocElement;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.PipelineProcessor;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.SAXHandler;
import oracle.xml.pipeline.controller.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Input
extends PipeDocElement {
    private Source source;
    private Process prevProcess;
    private String body;
    private URL url;
    private int available = -1;
    boolean[] properties;
    private int xmlType = -1;
    private SAXHandler shdlr;
    private boolean saxBufferingDone = true;

    Input(XMLElement xMLElement, PipelineProcessor pipelineProcessor) throws MalformedURLException, PipelineException {
        this.setId(xMLElement.getAttribute("id"));
        this.setName(xMLElement.getAttribute("name"));
        this.setLabel((String)pipelineProcessor.resolveAttribute(xMLElement.getAttribute("label")));
        this.setUrl(this.getLabel());
        this.properties = new boolean[11];
        if (this.getLabel() == "") {
            this.setAvailStatus(1);
            if (xMLElement.hasChildNodes()) {
                this.source = new DOMSource(xMLElement.getFirstChild());
            }
        } else {
            Document document = xMLElement.getOwnerDocument();
            NodeList nodeList = document.getElementsByTagName("output");
            boolean bl = false;
            for (int i = 0; i < nodeList.getLength() && !bl; ++i) {
                String string;
                Element element = (Element)nodeList.item(i);
                if (!element.hasAttributes() || !(string = element.getAttribute("label")).equals(this.getLabel())) continue;
                bl = true;
            }
            if (bl) {
                this.setAvailStatus(0);
            } else {
                this.connectToURL();
            }
        }
    }

    void connectToURL() {
        try {
            InputStream inputStream = Util.createInStream(this.getUrl());
            this.source = new StreamSource(inputStream);
        }
        catch (IOException iOException) {
            this.setAvailStatus(0);
            return;
        }
        this.setAvailStatus(1);
    }

    void cleanup() throws IOException {
        if (this.source instanceof StreamSource) {
            Closeable closeable = ((StreamSource)this.source).getInputStream();
            if (closeable != null) {
                closeable.close();
            } else {
                closeable = ((StreamSource)this.source).getReader();
                if (closeable != null) {
                    ((Reader)closeable).close();
                }
            }
        }
    }

    synchronized boolean isAvailable() {
        return this.available == 1;
    }

    synchronized void setAvailStatus(int n) {
        this.available = n;
    }

    String getBody() {
        return this.body;
    }

    private void setBody(String string) {
        this.body = string;
    }

    URL getUrl() {
        return this.url;
    }

    private void setUrl(String string) throws MalformedURLException {
        this.url = Util.createURL(string);
    }

    void setSource(Source source) {
        this.source = source;
    }

    Source getSource() {
        return this.source;
    }

    Process getPrevProcess() {
        return this.prevProcess;
    }

    void setPrevProcess(Process process) {
        this.prevProcess = process;
    }

    public void supportType(int n) {
        this.properties[n] = true;
    }

    boolean supportsType(int n) {
        return this.properties[n];
    }

    void setXMLType(int n) {
        this.xmlType = n;
    }

    public boolean isXMLType(int n) {
        return n == this.xmlType;
    }

    SAXHandler getSAXHandler() {
        return this.shdlr;
    }

    void setSAXHandler(SAXHandler sAXHandler) {
        this.shdlr = sAXHandler;
    }

    void setSAXBufferingDone(boolean bl) {
        this.saxBufferingDone = bl;
    }

    boolean isSAXBufferingDone() {
        return this.saxBufferingDone;
    }
}

