/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.awt.Color;
import java.util.Vector;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.xml.differ.DiffTreeNode;
import oracle.xml.differ.DiffXmlTokenizer;
import oracle.xml.differ.LeafOffset;
import oracle.xml.differ.Offset;
import oracle.xml.differ.XMLStyledDocument;

class DiffStyledDocument
extends XMLStyledDocument {
    protected final int MODIFIED = 10;
    protected final int NEW = 20;
    protected final int SAME = 30;
    protected final int DELETED = 40;
    protected final int BLANK = 50;
    protected Vector blankOffsets;
    protected Vector newOffsets;
    protected Vector deletedOffsets;
    protected Vector modifiedOffsets;
    protected SimpleAttributeSet blankSAS;
    protected SimpleAttributeSet newSAS;
    protected SimpleAttributeSet modifiedSAS;
    protected SimpleAttributeSet deletedSAS;

    public DiffStyledDocument() {
    }

    public DiffStyledDocument(DiffTreeNode diffTreeNode) {
        this.initAttrib();
        this.initOffsets();
        this.newSAS = new SimpleAttributeSet();
        StyleConstants.setForeground(this.newSAS, Color.blue);
        this.modifiedSAS = new SimpleAttributeSet();
        StyleConstants.setForeground(this.modifiedSAS, Color.red);
        this.deletedSAS = new SimpleAttributeSet();
        StyleConstants.setForeground(this.deletedSAS, Color.blue);
        this.blankSAS = new SimpleAttributeSet();
        StyleConstants.setBackground(this.blankSAS, Color.gray);
        SimpleAttributeSet simpleAttributeSet = this.getTagSimpleAttrSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        this.setTagSimpleAttrSet(simpleAttributeSet);
        simpleAttributeSet = this.getAttributeValueSimpleAttrSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        this.setAttributeValueSimpleAttrSet(simpleAttributeSet);
        simpleAttributeSet = this.getPIDataSimpleAttrSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        this.setPIDataSimpleAttrSet(simpleAttributeSet);
        simpleAttributeSet = this.getCommentDataSimpleAttrSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        this.setPIDataSimpleAttrSet(simpleAttributeSet);
        simpleAttributeSet = this.getCDATASimpleAttrSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        this.setPIDataSimpleAttrSet(simpleAttributeSet);
        simpleAttributeSet = this.getDTDSimpleAttrSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        this.setDTDSimpleAttrSet(simpleAttributeSet);
        DiffXmlTokenizer diffXmlTokenizer = new DiffXmlTokenizer();
        diffXmlTokenizer.setXMLHandler(this);
        diffXmlTokenizer.tokenize(diffTreeNode);
        this.format();
    }

    @Override
    protected void format() {
        this.formatTags();
        this.formatAttributeNames();
        this.formatAttributeValues();
        this.formatCommentData();
        this.formatPINames();
        this.formatPIData();
        this.formatPCDATA();
        this.formatCDATA();
        this.formatSymbols();
        this.formatModifiedNodes();
        this.formatNewNodes();
        this.formatDeletedNodes();
        this.formatBlankNodes();
        this.formatDTD();
    }

    protected void formatModifiedNodes() {
        Offset[] offsetArray = this.getModifiedOffset(this.modifiedOffsets);
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.modifiedSAS, true);
            }
        }
    }

    protected void formatDeletedNodes() {
        Offset[] offsetArray = this.getDeletedOffset(this.deletedOffsets);
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.deletedSAS, true);
            }
        }
    }

    protected void formatNewNodes() {
        Offset[] offsetArray = this.getNewOffset(this.newOffsets);
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.newSAS, true);
            }
        }
    }

    protected void formatBlankNodes() {
        Offset[] offsetArray = this.getBlankOffset(this.blankOffsets);
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.blankSAS, true);
            }
        }
    }

    protected Offset[] getNewOffset(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new Offset[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Offset[] getDeletedOffset(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new Offset[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Offset[] getBlankOffset(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new Offset[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Offset[] getModifiedOffset(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new Offset[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void handleXMLToken(String string, int n, int n2, int n3) {
        LeafOffset leafOffset = new LeafOffset(this.previousOffset, n2);
        switch (n3) {
            case 10: {
                if (this.modifiedOffsets == null) {
                    this.modifiedOffsets = new Vector();
                }
                this.modifiedOffsets.addElement(leafOffset);
                break;
            }
            case 20: {
                if (this.newOffsets == null) {
                    this.newOffsets = new Vector();
                }
                this.newOffsets.addElement(leafOffset);
                break;
            }
            case 40: {
                if (this.deletedOffsets == null) {
                    this.deletedOffsets = new Vector();
                }
                this.deletedOffsets.addElement(leafOffset);
                break;
            }
            case 50: {
                if (this.blankOffsets == null) {
                    this.blankOffsets = new Vector();
                }
                this.blankOffsets.addElement(leafOffset);
            }
        }
        this.handleXMLToken(string, n, n2);
    }
}

