/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import oracle.xml.diff.AppendDiffOp;
import oracle.xml.diff.DeleteDiffOp;
import oracle.xml.diff.DiffOp;
import oracle.xml.diff.DiffOpReceiver;
import oracle.xml.diff.DiffOpsToDOM;
import oracle.xml.diff.InsertDiffOp;
import oracle.xml.diff.NodeDiffData;
import oracle.xml.diff.Options;
import oracle.xml.diff.XmlInternalUtils;
import oracle.xml.diff.XmlMapper;
import oracle.xml.diff.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class XmlOutputBuilder {
    ArrayList<NodeDiffData> firstInputDiffData;
    ArrayList<NodeDiffData> secondInputDiffData;
    ArrayList<DiffOp> diffOperations;
    DiffOpReceiver diffOpReceiver;
    HashMap<String, String> prefixToNamespace;
    HashMap<String, String> namespaceToPrefix;
    int defaultNamespacePrefixCounter;
    Document output;
    Options options;
    int generationId;
    DocumentBuilder docBuilder;

    XmlOutputBuilder(XmlMapper xmlMapper, DiffOpReceiver diffOpReceiver, Options options, DocumentBuilder documentBuilder) {
        this.firstInputDiffData = xmlMapper.firstInputDiffData;
        this.secondInputDiffData = xmlMapper.secondInputDiffData;
        this.diffOperations = new ArrayList();
        this.diffOpReceiver = diffOpReceiver;
        this.prefixToNamespace = new HashMap();
        this.prefixToNamespace.put("xd", DiffOpsToDOM.diffNamespace);
        this.namespaceToPrefix = new HashMap();
        this.namespaceToPrefix.put(DiffOpsToDOM.diffNamespace, "xd");
        this.defaultNamespacePrefixCounter = 0;
        if (diffOpReceiver instanceof DiffOpsToDOM) {
            this.output = ((DiffOpsToDOM)diffOpReceiver).getDoc();
        }
        this.options = options;
        this.generationId = 0;
        this.docBuilder = documentBuilder;
    }

    void returnDiffOpReceiver() throws Exception {
        this.diffOpReceiver.receiveDiff(this.diffOperations);
    }

    void computeXPathsAndNamespaces() throws Exception {
        if (!this.options.includeXPaths() && !this.options.textualOutput()) {
            return;
        }
        Node node = null;
        for (DiffOp diffOp : this.diffOperations) {
            diffOp.setPath(this.computeXPath(diffOp));
            if (this.options.textualOutput()) {
                if (diffOp.getOpName() == DiffOp.Name.INSERT_BY_APPENDING) {
                    node = this.output.importNode(diffOp.getNew(), true);
                    this.assignPrefixesAndRegisterNamespaces(diffOp.getParent(), diffOp.getNew(), node);
                    diffOp.setNew(node);
                } else if (diffOp.getOpName() == DiffOp.Name.INSERT_BEFORE_NODE) {
                    Node node2 = diffOp.getNew();
                    if (node2.getNodeType() == 9) {
                        if (node2.getFirstChild() != null) {
                            node = this.docBuilder.newDocument();
                            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                                node.appendChild(((Document)node).importNode(node3, true));
                            }
                            this.assignPrefixesAndRegisterNamespaces(diffOp.getSibling(), node2, node);
                        }
                    } else {
                        node = this.output.importNode(node2, true);
                        this.assignPrefixesAndRegisterNamespaces(diffOp.getSibling(), node2, node);
                    }
                    diffOp.setNew(node);
                }
            }
            diffOp.setPrefixToNamespace(this.prefixToNamespace);
        }
    }

    void assignPrefixesAndRegisterNamespaces(Node node, Node node2, Node node3) {
        Node node4 = node2.getFirstChild();
        Node node5 = node3.getFirstChild();
        while (node4 != null) {
            this.assignPrefixesAndRegisterNamespaces(node, node4, node5);
            node4 = node4.getNextSibling();
            node5 = node5.getNextSibling();
        }
        if (node2.getNodeType() == 1) {
            String string = this.getAndRegisterPrefix(node, node2);
            if (string != null) {
                node3.setPrefix(string);
            }
            NamedNodeMap namedNodeMap = node2.getAttributes();
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node6 = namedNodeMap.item(i);
                if (!XmlInternalUtils.isXmlns(node6)) {
                    string = this.getAndRegisterPrefix(node, node6);
                    if (string == null) continue;
                    Node node7 = namedNodeMap2.getNamedItemNS(this.prefixToNamespace.get(string), node6.getLocalName());
                    node7.setPrefix(string);
                    continue;
                }
                ((Element)node3).removeAttributeNS(node6.getNamespaceURI(), node6.getLocalName());
            }
        }
    }

    String getAndRegisterPrefix(Node node, Node node2) {
        String string = node2.getPrefix();
        if (string != null) {
            String string2;
            String string3 = null;
            if (node.getNodeType() != 9 && node.getNodeType() != 11 || node.getFirstChild() != null) {
                string3 = node.lookupNamespaceURI(string);
            }
            if ((string2 = node2.lookupNamespaceURI(string)) == null) {
                string2 = node2.getNamespaceURI();
            }
            if (string3 == null || string3 != null && string3.equals(string2)) {
                string3 = this.prefixToNamespace.get(string);
                if (string3 != null && !string3.equals(string2)) {
                    string = this.getPrefix(string2);
                }
            } else {
                string = this.getPrefix(string2);
            }
            this.prefixToNamespace.put(string, string2);
            this.namespaceToPrefix.put(string2, string);
        } else if (node2 instanceof Element) {
            String string4 = node2.lookupNamespaceURI(null);
            if (string4 != null) {
                string = this.getPrefix(string4);
                this.prefixToNamespace.put(string, string4);
                this.namespaceToPrefix.put(string4, string);
            } else {
                string = null;
            }
        }
        return string;
    }

    private String computeXPath(DiffOp diffOp) {
        NodeDiffData nodeDiffData;
        int n = diffOp.getSiteNodeId();
        int n2 = diffOp.textNodeNumber;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0 && n == this.firstInputDiffData.size()) {
            NodeDiffData nodeDiffData2 = this.firstInputDiffData.get(n - 1);
            Node node = nodeDiffData2.node;
            if (node.getNodeType() == 9 || node.getNodeType() == 11 || node.getNodeType() == 2) {
                return "/";
            }
            return "/" + this.getNameForOutput(node) + "[1]";
        }
        if (diffOp.getOpName() == DiffOp.Name.DELETE && n2 >= 0) {
            nodeDiffData = this.firstInputDiffData.get(n - 1);
            stringBuffer.insert(0, "/text()[" + nodeDiffData.xpathPositions[n2] + "]");
            n = nodeDiffData.parentId;
        }
        while (n > 0 && n <= this.firstInputDiffData.size()) {
            nodeDiffData = this.firstInputDiffData.get(n - 1);
            Node node = nodeDiffData.node;
            if (n == this.firstInputDiffData.size() && (node.getNodeType() == 9 || node.getNodeType() == 11)) break;
            if (nodeDiffData.xpathPositions != null && nodeDiffData.xpathPositions[0] > 0) {
                stringBuffer.insert(0, "/" + this.getNameForOutput(nodeDiffData.node) + "[" + nodeDiffData.xpathPositions[0] + "]");
            }
            n = nodeDiffData.parentId;
        }
        return stringBuffer.toString();
    }

    String getNameForOutput(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                String string;
                String string2 = null;
                string2 = node.getLocalName() == null && node.getNamespaceURI() == null && node.getPrefix() == null ? node.getNodeName() : ((string = this.getPrefixAndRegisterNamespace(node)) == null ? node.getLocalName() : string + ":" + node.getLocalName());
                return string2;
            }
            case 4: {
                return "node()";
            }
            case 8: {
                return "comment()";
            }
            case 3: {
                return "text()";
            }
            case 2: {
                return "attribute()";
            }
            case 7: {
                return "processing-instruction()";
            }
        }
        return null;
    }

    String getPrefixAndRegisterNamespace(Node node) {
        String string = node.getPrefix();
        String string2 = null;
        if (string == null) {
            string2 = node.lookupNamespaceURI(null);
            if (string2 != null) {
                if (!this.namespaceToPrefix.containsKey(string2)) {
                    string = this.getPrefix(string2);
                    this.namespaceToPrefix.put(string2, string);
                    this.prefixToNamespace.put(string, string2);
                    return string;
                }
                return this.namespaceToPrefix.get(string2);
            }
            return null;
        }
        string2 = node.lookupNamespaceURI(string);
        if (!this.prefixToNamespace.containsKey(string)) {
            this.prefixToNamespace.put(string, string2);
            this.namespaceToPrefix.put(string2, string);
        } else if (!this.prefixToNamespace.get(string).equals(string2)) {
            string = this.getPrefix(string2);
            this.prefixToNamespace.put(string, string2);
            this.namespaceToPrefix.put(string2, string);
        }
        return string;
    }

    private String getPrefix(String string) {
        String string2 = this.namespaceToPrefix.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = "oraxdfns_" + this.defaultNamespacePrefixCounter;
        while (this.prefixToNamespace.containsKey(string2)) {
            ++this.defaultNamespacePrefixCounter;
            string2 = "oraxdfns_" + this.defaultNamespacePrefixCounter;
        }
        return string2;
    }

    void putDiffOpsInDocumentOrder() {
        if (!this.options.textualOutput()) {
            return;
        }
        Collections.sort(this.diffOperations);
    }

    void determineDeletesAndInserts() {
        this.determineDeletesAndInserts(this.firstInputDiffData.get(this.firstInputDiffData.size() - 1), true);
        this.determineDeletesAndInserts(this.secondInputDiffData.get(this.secondInputDiffData.size() - 1), false);
    }

    void printDiffOut() {
        try {
            for (DiffOp diffOp : this.diffOperations) {
                if (diffOp == null) continue;
                if (diffOp.getOpName() == DiffOp.Name.DELETE) {
                    if (diffOp.getCurrent().getNodeType() == 3 && ((Text)diffOp.getCurrent()).isElementContentWhitespace()) {
                        System.out.println("Deleting node id: " + diffOp.siteNodeId + " whitespace text node " + " path: " + diffOp.getCurrentXPath() + "\n");
                        continue;
                    }
                    System.out.println("Deleting node id: " + diffOp.siteNodeId + " path: " + diffOp.getCurrentXPath() + "\nNode:\n" + XmlUtils.nodeToString(diffOp.getCurrent(), false));
                    continue;
                }
                if (diffOp.getOpName() == DiffOp.Name.INSERT_BEFORE_NODE) {
                    System.out.println("Inserting node id: " + diffOp.newNodeId + " node:\n" + XmlUtils.nodeToString(diffOp.getNew(), false) + "before node at path: " + diffOp.getSiblingXPath() + "\nNode:\n" + XmlUtils.nodeToString(diffOp.getSibling(), false));
                    continue;
                }
                if (diffOp.getOpName() != DiffOp.Name.INSERT_BY_APPENDING) continue;
                System.out.println("Appending node id: " + diffOp.newNodeId + " node:\n" + XmlUtils.nodeToString(diffOp.getNew(), false) + " to the parent node at path: " + diffOp.getParentXPath() + "\nNode:\n" + XmlUtils.nodeToString(diffOp.getParent(), false));
            }
        }
        catch (Exception exception) {
            System.err.println("Internal error when printing out diff information");
        }
    }

    private void determineDeletesAndInserts(NodeDiffData nodeDiffData, boolean bl) {
        int n = nodeDiffData.firstChildId;
        NodeDiffData nodeDiffData2 = null;
        while (n > 0) {
            nodeDiffData2 = bl ? this.firstInputDiffData.get(n - 1) : this.secondInputDiffData.get(n - 1);
            this.determineDeletesAndInserts(nodeDiffData2, bl);
            n = nodeDiffData2.siblingId;
        }
        if (!nodeDiffData.isMapped()) {
            nodeDiffData.outputBuilderState = bl ? NodeDiffData.OutputBuilderState.DELETED : NodeDiffData.OutputBuilderState.INSERTED;
            return;
        }
        if (nodeDiffData.parentId > 0) {
            if (bl) {
                if (!this.getFirstInputParentDiffData(nodeDiffData).isMapped() || this.getSecondInputMappedNodeDiffData((NodeDiffData)nodeDiffData).parentId != this.getFirstInputParentDiffData((NodeDiffData)nodeDiffData).mappedNodeId) {
                    nodeDiffData.outputBuilderState = NodeDiffData.OutputBuilderState.DELETED;
                }
            } else if (!this.getSecondInputParentDiffData(nodeDiffData).isMapped() || this.getFirstInputMappedNodeDiffData((NodeDiffData)nodeDiffData).parentId != this.getSecondInputParentDiffData((NodeDiffData)nodeDiffData).mappedNodeId) {
                nodeDiffData.outputBuilderState = NodeDiffData.OutputBuilderState.INSERTED;
            }
        } else if (bl) {
            if (nodeDiffData.Id == this.firstInputDiffData.size() && nodeDiffData.mappedNodeId != this.secondInputDiffData.size()) {
                nodeDiffData.outputBuilderState = NodeDiffData.OutputBuilderState.DELETED;
            }
        } else if (nodeDiffData.Id == this.secondInputDiffData.size() && nodeDiffData.mappedNodeId != this.firstInputDiffData.size()) {
            nodeDiffData.outputBuilderState = NodeDiffData.OutputBuilderState.INSERTED;
        }
    }

    void determineDeletesAndInsertsForNodesMovedUnderSameParent() {
        this.determineDeletesAndInsertsForNodesMovedUnderSameParent(this.firstInputDiffData.get(this.firstInputDiffData.size() - 1));
    }

    private void determineDeletesAndInsertsForNodesMovedUnderSameParent(NodeDiffData nodeDiffData) {
        int n = nodeDiffData.firstChildId;
        NodeDiffData nodeDiffData2 = null;
        while (n > 0) {
            nodeDiffData2 = this.firstInputDiffData.get(n - 1);
            this.determineDeletesAndInsertsForNodesMovedUnderSameParent(nodeDiffData2);
            n = nodeDiffData2.siblingId;
        }
        if (!nodeDiffData.isMapped()) {
            return;
        }
        ArrayList<PositionPair> arrayList = new ArrayList<PositionPair>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        n = nodeDiffData.firstChildId;
        int n2 = 0;
        while (n > 0) {
            NodeDiffData nodeDiffData3 = this.firstInputDiffData.get(n - 1);
            if (nodeDiffData3.outputBuilderState == NodeDiffData.OutputBuilderState.UNTOUCHED) {
                arrayList.add(new PositionPair(nodeDiffData3.position, nodeDiffData3.position));
                ++n2;
            }
            n = nodeDiffData3.siblingId;
        }
        int n3 = this.secondInputDiffData.get((int)(nodeDiffData.mappedNodeId - 1)).firstChildId;
        if (arrayList.size() == 0) {
            return;
        }
        while (n3 > 0) {
            NodeDiffData nodeDiffData4 = this.secondInputDiffData.get(n3 - 1);
            if (nodeDiffData4.outputBuilderState == NodeDiffData.OutputBuilderState.UNTOUCHED) {
                arrayList2.add(this.firstInputDiffData.get((int)(nodeDiffData4.mappedNodeId - 1)).position);
            }
            n3 = nodeDiffData4.siblingId;
        }
        if (arrayList.size() != arrayList2.size()) {
            throw new RuntimeException(XmlInternalUtils.getMessageFetcher().getMessage0("XMLDIFF-0004"));
        }
        ArrayList<Integer> arrayList3 = this.findOptimalMinimalChanges(arrayList, arrayList2);
        Iterator<Integer> iterator = arrayList3.iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            Integer n4 = iterator.next();
            while (n4 != arrayList.get(n2).getFirst()) {
                arrayList.get(n2).setFirst(null);
                ++n2;
            }
            ++n2;
        }
        while (!iterator.hasNext() && n2 < arrayList.size()) {
            arrayList.get(n2).setFirst(null);
            ++n2;
        }
        n = nodeDiffData.firstChildId;
        nodeDiffData2 = null;
        Integer n5 = null;
        block6: for (int i = 0; i < arrayList.size(); ++i) {
            n5 = arrayList.get(i).getFirst();
            if (n5 != null) continue;
            int n6 = arrayList.get(i).getSecond();
            while (n > 0) {
                nodeDiffData2 = this.firstInputDiffData.get(n - 1);
                if (nodeDiffData2.position == n6) {
                    nodeDiffData2.outputBuilderState = NodeDiffData.OutputBuilderState.DELETED;
                    this.secondInputDiffData.get((int)(nodeDiffData2.mappedNodeId - 1)).outputBuilderState = NodeDiffData.OutputBuilderState.INSERTED;
                    n = nodeDiffData2.siblingId;
                    continue block6;
                }
                n = nodeDiffData2.siblingId;
            }
        }
    }

    private ArrayList<Integer> findOptimalMinimalChanges(ArrayList<PositionPair> arrayList, ArrayList<Integer> arrayList2) {
        int n;
        int n2;
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n3 = arrayList.size();
        int n4 = arrayList2.size();
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            for (n = n4 - 1; n >= 0; --n) {
                nArray[n2][n] = arrayList.get(n2).getFirst().equals(arrayList2.get(n)) ? nArray[n2 + 1][n + 1] + 1 : Math.max(nArray[n2 + 1][n], nArray[n2][n + 1]);
            }
        }
        n2 = 0;
        n = 0;
        while (n2 < n3 && n < n4) {
            if (arrayList.get(n2).getFirst().equals(arrayList2.get(n))) {
                arrayList3.add(arrayList.get(n2).getFirst());
                ++n2;
                ++n;
                continue;
            }
            if (nArray[n2 + 1][n] >= nArray[n2][n + 1]) {
                ++n2;
                continue;
            }
            ++n;
        }
        return arrayList3;
    }

    void generateDeleteOperations() {
        this.generateDeleteOperations(this.firstInputDiffData.get(this.firstInputDiffData.size() - 1));
    }

    private void generateDeleteOperations(NodeDiffData nodeDiffData) {
        if (nodeDiffData.outputBuilderState == NodeDiffData.OutputBuilderState.DELETED) {
            Object var2_2 = null;
            ArrayList<Node> arrayList = nodeDiffData.originalTextNodes;
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.diffOperations.add(new DeleteDiffOp(nodeDiffData, i, this.generationId));
                    ++this.generationId;
                }
            } else {
                this.diffOperations.add(new DeleteDiffOp(nodeDiffData, this.generationId));
                ++this.generationId;
            }
            return;
        }
        int n = nodeDiffData.firstChildId;
        NodeDiffData nodeDiffData2 = null;
        while (n > 0) {
            nodeDiffData2 = this.firstInputDiffData.get(n - 1);
            this.generateDeleteOperations(nodeDiffData2);
            n = nodeDiffData2.siblingId;
        }
    }

    void generateInsertAndAppendOperations() {
        this.generateInsertAndAppendOperations(this.secondInputDiffData.get(this.secondInputDiffData.size() - 1));
    }

    void createInsertOrAppendOperations(NodeDiffData nodeDiffData, NodeDiffData nodeDiffData2, boolean bl) {
        ArrayList<Node> arrayList = nodeDiffData2.originalTextNodes;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (bl) {
                    this.diffOperations.add(new InsertDiffOp(nodeDiffData, nodeDiffData2, i, this.generationId));
                } else {
                    this.diffOperations.add(new AppendDiffOp(nodeDiffData, nodeDiffData2, i, this.generationId));
                }
                ++this.generationId;
            }
        } else {
            if (bl) {
                this.diffOperations.add(new InsertDiffOp(nodeDiffData, nodeDiffData2, this.generationId));
            } else {
                this.diffOperations.add(new AppendDiffOp(nodeDiffData, nodeDiffData2, this.generationId));
            }
            ++this.generationId;
        }
    }

    private void generateInsertAndAppendOperations(NodeDiffData nodeDiffData) {
        if (nodeDiffData.outputBuilderState == NodeDiffData.OutputBuilderState.INSERTED) {
            int n;
            int n2 = nodeDiffData.siblingId;
            NodeDiffData nodeDiffData2 = null;
            while (n2 > 0) {
                nodeDiffData2 = this.secondInputDiffData.get(n2 - 1);
                if (nodeDiffData2.outputBuilderState == NodeDiffData.OutputBuilderState.UNTOUCHED && (n = nodeDiffData2.mappedNodeId) > 0) {
                    this.createInsertOrAppendOperations(this.firstInputDiffData.get(n - 1), nodeDiffData, true);
                    return;
                }
                n2 = nodeDiffData2.siblingId;
            }
            n = nodeDiffData.parentId;
            int n3 = 0;
            if (n > 0) {
                n3 = this.secondInputDiffData.get((int)(n - 1)).mappedNodeId;
            }
            DiffOp diffOp = this.locateLastTopDelete();
            if (n <= 0 || n3 == this.firstInputDiffData.size() && diffOp != null && this.options.textualOutput()) {
                this.createInsertOrAppendOperations(this.firstInputDiffData.get(diffOp.getSiteNodeId() - 1), nodeDiffData, true);
            } else {
                this.createInsertOrAppendOperations(this.firstInputDiffData.get(n3 - 1), nodeDiffData, false);
            }
            return;
        }
        int n = nodeDiffData.firstChildId;
        NodeDiffData nodeDiffData3 = null;
        while (n > 0) {
            nodeDiffData3 = this.secondInputDiffData.get(n - 1);
            this.generateInsertAndAppendOperations(nodeDiffData3);
            n = nodeDiffData3.siblingId;
        }
    }

    DiffOp locateLastTopDelete() {
        for (int i = 0; i < this.diffOperations.size(); ++i) {
            DiffOp diffOp = this.diffOperations.get(i);
            if (diffOp.getOpName() != DiffOp.Name.DELETE) continue;
            NodeDiffData nodeDiffData = this.firstInputDiffData.get(diffOp.getSiteNodeId() - 1);
            int n = nodeDiffData.parentId;
            if ((!this.isFirstInputNonEmptyDocOrDocFragment(n) || nodeDiffData.siblingId > 0) && n > 0) continue;
            return diffOp;
        }
        return null;
    }

    boolean isFirstInputNonEmptyDocOrDocFragment(int n) {
        Node node;
        short s;
        return n > 0 && ((s = (node = this.firstInputDiffData.get((int)(n - 1)).node).getNodeType()) == 9 || s == 11);
    }

    private NodeDiffData getFirstInputParentDiffData(NodeDiffData nodeDiffData) {
        return this.firstInputDiffData.get(nodeDiffData.parentId - 1);
    }

    private NodeDiffData getFirstInputMappedNodeDiffData(NodeDiffData nodeDiffData) {
        return this.firstInputDiffData.get(nodeDiffData.mappedNodeId - 1);
    }

    private NodeDiffData getSecondInputParentDiffData(NodeDiffData nodeDiffData) {
        return this.secondInputDiffData.get(nodeDiffData.parentId - 1);
    }

    private NodeDiffData getSecondInputMappedNodeDiffData(NodeDiffData nodeDiffData) {
        return this.secondInputDiffData.get(nodeDiffData.mappedNodeId - 1);
    }

    private class PositionPair {
        Integer firstPosition;
        int secondPosition;

        PositionPair(int n, int n2) {
            this.firstPosition = n;
            this.secondPosition = n2;
        }

        void setFirst(Integer n) {
            this.firstPosition = n;
        }

        void setSecond(int n) {
            this.secondPosition = n;
        }

        Integer getFirst() {
            return this.firstPosition;
        }

        int getSecond() {
            return this.secondPosition;
        }
    }
}

