/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.diff;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import javax.xml.parsers.DocumentBuilder;
import oracle.xml.diff.NodeDiffData;
import oracle.xml.diff.Options;
import oracle.xml.diff.XmlInternalUtils;
import oracle.xml.diff.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XmlMapper {
    ArrayList<NodeDiffData> firstInputDiffData = new ArrayList(100);
    ArrayList<NodeDiffData> secondInputDiffData = new ArrayList(100);
    HashMap<String, ArrayList<NodeDiffData>> matchCandidates = new HashMap(100);
    HashMap<String, AncestorsAndSiblings> matchCandidateByAncestorsAndSiblings = new HashMap(100);
    int numberOfAncestorsToCache = 2;
    int numberOfSiblingsToCache = 1;
    Options options;
    MessageDigest md5temp = MessageDigest.getInstance("MD5");

    XmlMapper(Node node, Node node2, Options options, DocumentBuilder documentBuilder) throws NoSuchAlgorithmException {
        this.options = options;
        Document document = null;
        if (this.options.normalizeTextNodes()) {
            document = documentBuilder.newDocument();
        }
        this.processInput(node, true, 1, document);
        this.firstInputDiffData.get((int)(this.firstInputDiffData.size() - 1)).position = 1;
        this.processInput(node2, false, 1, document);
        this.secondInputDiffData.get((int)(this.secondInputDiffData.size() - 1)).position = 1;
        this.registerMatchCandidatesByAncestorsAndSiblings();
    }

    private NodeDiffData processTextNodes(Node node, boolean bl, HashMap<String, Integer> hashMap, Document document) throws NoSuchAlgorithmException {
        Node node2;
        NodeDiffData nodeDiffData = new NodeDiffData();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        String string = XmlInternalUtils.getWholeText(node);
        int n = string.length();
        int n2 = (string = string.trim()).length();
        if (n2 > 0) {
            node2 = this.adjacentTextNodes(node) || n != n2 ? document.createTextNode(string) : node;
        } else {
            return null;
        }
        Node node3 = node;
        int n3 = 1;
        while (this.adjacentTextNodes(node3)) {
            ++n3;
            node3 = node3.getNextSibling();
        }
        if (n3 > 1 || n != n2) {
            nodeDiffData.originalTextNodes = new ArrayList(n3);
            node3 = node;
            for (int i = 0; i < n3; ++i) {
                nodeDiffData.originalTextNodes.add(node3);
                node3 = node3.getNextSibling();
            }
        }
        this.computeHashAndWeight(node2, nodeDiffData, messageDigest, messageDigest2);
        if (bl && (this.options.includeXPaths() || this.options.textualOutput())) {
            String string2 = XmlInternalUtils.getName(node);
            Integer n4 = hashMap.get(string2);
            if (n4 == null) {
                n4 = 0;
            }
            nodeDiffData.xpathPositions = new int[n3];
            for (int i = 0; i < n3; ++i) {
                Integer n5 = n4;
                Integer n6 = n4 = Integer.valueOf(n4 + 1);
                nodeDiffData.xpathPositions[i] = n4;
            }
            hashMap.put(string2, n4);
        }
        nodeDiffData.Id = bl ? this.firstInputDiffData.size() + 1 : this.secondInputDiffData.size() + 1;
        nodeDiffData.hash = messageDigest.digest();
        nodeDiffData.hashAsHexString = XmlMapper.byteArrayToHexString(nodeDiffData.hash);
        nodeDiffData.localHashAsHexString = XmlMapper.byteArrayToHexString(messageDigest2.digest());
        nodeDiffData.node = node2;
        if (bl) {
            this.firstInputDiffData.add(nodeDiffData);
        } else {
            this.secondInputDiffData.add(nodeDiffData);
        }
        return nodeDiffData;
    }

    private NodeDiffData processInput(Node node, boolean bl, int n, Document document) throws NoSuchAlgorithmException {
        Comparable<Integer> comparable;
        NodeDiffData nodeDiffData = new NodeDiffData();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        if (XmlInternalUtils.ignoreNode(node)) {
            return null;
        }
        this.computeHashAndWeight(node, nodeDiffData, messageDigest, messageDigest2);
        nodeDiffData.xpathPositions = new int[1];
        nodeDiffData.xpathPositions[0] = n;
        HashMap<String, Integer> hashMap = null;
        if (bl && (this.options.includeXPaths() || this.options.textualOutput())) {
            hashMap = new HashMap<String, Integer>();
        }
        if (node.getNodeType() == 3 && this.options.normalizeTextNodes()) {
            return this.processTextNodes(node, bl, hashMap, document);
        }
        int n2 = 1;
        NodeDiffData nodeDiffData2 = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            NodeDiffData nodeDiffData3;
            comparable = 0;
            if (node2.getNodeType() == 3 && this.options.normalizeTextNodes()) {
                nodeDiffData3 = this.processTextNodes(node2, bl, hashMap, document);
                node2 = this.skipToLastTextNode(node2);
            } else {
                if (bl && (this.options.includeXPaths() || this.options.textualOutput())) {
                    String string = XmlInternalUtils.getName(node2);
                    comparable = hashMap.get(string);
                    if (comparable == null) {
                        comparable = 1;
                    } else {
                        Integer n3 = comparable;
                        Integer n4 = comparable = Integer.valueOf(comparable + 1);
                    }
                    hashMap.put(string, (Integer)comparable);
                }
                nodeDiffData3 = this.processInput(node2, bl, (int)comparable, document);
            }
            if (nodeDiffData3 == null) continue;
            if (nodeDiffData2 == null) {
                nodeDiffData2 = nodeDiffData3;
                nodeDiffData.firstChildId = nodeDiffData3.Id;
            } else {
                nodeDiffData2.siblingId = nodeDiffData3.Id;
                nodeDiffData3.previousSiblingId = nodeDiffData2.Id;
            }
            nodeDiffData3.position = n2++;
            nodeDiffData.weight += nodeDiffData3.weight;
            messageDigest.update(nodeDiffData3.hash);
            nodeDiffData2 = nodeDiffData3;
        }
        nodeDiffData.Id = bl ? this.firstInputDiffData.size() + 1 : this.secondInputDiffData.size() + 1;
        int n5 = nodeDiffData.firstChildId;
        comparable = null;
        while (n5 != 0) {
            if (bl) {
                comparable = this.firstInputDiffData.get(n5 - 1);
                ((NodeDiffData)comparable).parentId = nodeDiffData.Id;
                n5 = ((NodeDiffData)comparable).siblingId;
                continue;
            }
            comparable = this.secondInputDiffData.get(n5 - 1);
            ((NodeDiffData)comparable).parentId = nodeDiffData.Id;
            n5 = ((NodeDiffData)comparable).siblingId;
        }
        nodeDiffData.hash = messageDigest.digest();
        nodeDiffData.hashAsHexString = XmlMapper.byteArrayToHexString(nodeDiffData.hash);
        nodeDiffData.localHashAsHexString = XmlMapper.byteArrayToHexString(messageDigest2.digest());
        nodeDiffData.node = node;
        if (bl) {
            this.firstInputDiffData.add(nodeDiffData);
        } else {
            this.secondInputDiffData.add(nodeDiffData);
        }
        return nodeDiffData;
    }

    void computeMapping() {
        NodeDiffData nodeDiffData;
        NodeDiffData nodeDiffData2 = this.firstInputDiffData.get(this.firstInputDiffData.size() - 1);
        if (this.mapRootNodes(nodeDiffData2, nodeDiffData = this.secondInputDiffData.get(this.secondInputDiffData.size() - 1))) {
            nodeDiffData2.mapNode(nodeDiffData);
        }
        this.computeMapping(nodeDiffData);
    }

    boolean mapRootNodes(NodeDiffData nodeDiffData, NodeDiffData nodeDiffData2) {
        short s = nodeDiffData.node.getNodeType();
        short s2 = nodeDiffData2.node.getNodeType();
        return s == 9 && s2 == 9 || s == 11 && s2 == 11 || s == 1 && s2 == 1 && this.areElementNamesAndAttributesEqual(nodeDiffData.node, nodeDiffData2.node);
    }

    private void computeMapping(NodeDiffData nodeDiffData) {
        NodeDiffData nodeDiffData2;
        PriorityQueue<NodeDiffData> priorityQueue = new PriorityQueue<NodeDiffData>(100);
        NodeDiffData nodeDiffData3 = nodeDiffData;
        priorityQueue.add(nodeDiffData);
        while (priorityQueue.size() > 0) {
            nodeDiffData = (NodeDiffData)priorityQueue.poll();
            nodeDiffData2 = this.findBestCandidate(nodeDiffData, true);
            if (nodeDiffData2 != null) {
                this.mapNodes(nodeDiffData2, nodeDiffData);
                this.mapAncestors(nodeDiffData2, nodeDiffData);
                continue;
            }
            int n = nodeDiffData.firstChildId;
            while (n != 0) {
                nodeDiffData = this.secondInputDiffData.get(n - 1);
                priorityQueue.add(nodeDiffData);
                n = nodeDiffData.siblingId;
            }
        }
        priorityQueue.add(nodeDiffData3);
        NodeDiffData nodeDiffData4 = null;
        while (priorityQueue.size() > 0) {
            nodeDiffData4 = (NodeDiffData)priorityQueue.poll();
            if (!nodeDiffData4.isMapped() && (nodeDiffData2 = this.findBestCandidate(nodeDiffData4, false)) != null) {
                this.mapNodes(nodeDiffData2, nodeDiffData4);
                this.mapAncestors(nodeDiffData2, nodeDiffData4);
                continue;
            }
            int n = nodeDiffData4.firstChildId;
            while (n != 0) {
                nodeDiffData4 = this.secondInputDiffData.get(n - 1);
                priorityQueue.add(nodeDiffData4);
                n = nodeDiffData4.siblingId;
            }
        }
    }

    private NodeDiffData findBestCandidate(NodeDiffData nodeDiffData, boolean bl) {
        Serializable serializable;
        ArrayList arrayList;
        String string;
        Object object5;
        Object object2;
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        boolean bl2 = true;
        Integer n = 0;
        Integer n2 = 0;
        Object object3 = 0;
        Integer n3 = 0;
        NodeDiffData nodeDiffData2 = null;
        Iterator<NodeDiffData> iterator = null;
        NodeDiffData nodeDiffData3 = null;
        if (nodeDiffData.parentId > 0) {
            nodeDiffData3 = this.secondInputDiffData.get(nodeDiffData.parentId - 1);
        }
        int n4 = this.numberOfAncestorsToCache;
        for (int i = 0; i < n4; ++i) {
            Object object4 = n;
            n = n + 1;
            object2 = n;
            object4 = this.matchCandidateByAncestorsAndSiblings.get(nodeDiffData.hashAsHexString);
            if (object4 != null && (object2 = this.matchCandidateByAncestorsAndSiblings.get((Object)nodeDiffData.hashAsHexString).ancestorsByLevel) != null && i < ((ArrayList)object2).size() && (object5 = (HashMap)((ArrayList)object2).get(i)) != null) {
                if (nodeDiffData3 != null) {
                    this.md5temp.reset();
                    this.computeHashAndWeight(nodeDiffData3.node, null, null, this.md5temp);
                    string = XmlMapper.byteArrayToHexString(this.md5temp.digest());
                } else {
                    string = null;
                }
                arrayList = (ArrayList)((HashMap)object5).get(string);
                if (arrayList != null && arrayList.size() > 0) {
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        nodeDiffData2 = iterator.next();
                        if (nodeDiffData2.isMapped()) {
                            iterator.remove();
                            continue;
                        }
                        if (linkedHashMap.containsKey(nodeDiffData2.Id)) {
                            n3 = (Integer)linkedHashMap.get(nodeDiffData2.Id) + 1;
                            linkedHashMap.put(nodeDiffData2.Id, n3);
                            if (n3 <= n2) continue;
                            n2 = n3;
                            object3 = nodeDiffData2.Id;
                            continue;
                        }
                        linkedHashMap.put(nodeDiffData2.Id, 1);
                        if (!bl2) continue;
                        n2 = 1;
                        object3 = nodeDiffData2.Id;
                        bl2 = false;
                    }
                }
            }
            if (nodeDiffData3 == null || nodeDiffData3.parentId <= 0) break;
            nodeDiffData3 = this.secondInputDiffData.get(nodeDiffData3.parentId - 1);
        }
        NodeDiffData nodeDiffData4 = null;
        if (nodeDiffData.previousSiblingId > 0) {
            nodeDiffData4 = this.secondInputDiffData.get(nodeDiffData.previousSiblingId - 1);
        }
        for (int i = 0; i < this.numberOfSiblingsToCache; ++i) {
            object2 = n;
            n = n + 1;
            object5 = n;
            object2 = this.matchCandidateByAncestorsAndSiblings.get(nodeDiffData.hashAsHexString);
            if (object2 != null && (object5 = this.matchCandidateByAncestorsAndSiblings.get((Object)nodeDiffData.hashAsHexString).leftSiblingsByLevel) != null && i < ((ArrayList)object5).size() && (serializable = (HashMap)((ArrayList)object5).get(i)) != null) {
                if (nodeDiffData4 != null) {
                    this.md5temp.reset();
                    this.computeHashAndWeight(nodeDiffData4.node, null, null, this.md5temp);
                    string = XmlMapper.byteArrayToHexString(this.md5temp.digest());
                } else {
                    string = null;
                }
                arrayList = (ArrayList)((HashMap)serializable).get(string);
                if (arrayList != null && arrayList.size() > 0) {
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        nodeDiffData2 = iterator.next();
                        if (nodeDiffData2.isMapped()) {
                            iterator.remove();
                            continue;
                        }
                        if (linkedHashMap.containsKey(nodeDiffData2.Id)) {
                            n3 = (Integer)linkedHashMap.get(nodeDiffData2.Id) + 1;
                            linkedHashMap.put(nodeDiffData2.Id, n3);
                            if (n3 <= n2) continue;
                            n2 = n3;
                            object3 = nodeDiffData2.Id;
                            continue;
                        }
                        linkedHashMap.put(nodeDiffData2.Id, 1);
                        if (!bl2) continue;
                        n2 = 1;
                        object3 = nodeDiffData2.Id;
                        bl2 = false;
                    }
                }
            }
            nodeDiffData4 = nodeDiffData4 != null && nodeDiffData4.previousSiblingId > 0 ? this.secondInputDiffData.get(nodeDiffData4.previousSiblingId - 1) : null;
        }
        NodeDiffData nodeDiffData5 = null;
        if (nodeDiffData.siblingId > 0) {
            nodeDiffData5 = this.secondInputDiffData.get(nodeDiffData.siblingId - 1);
        }
        for (int i = 0; i < this.numberOfSiblingsToCache; ++i) {
            HashMap hashMap;
            object5 = n;
            n = n + 1;
            serializable = n;
            object5 = this.matchCandidateByAncestorsAndSiblings.get(nodeDiffData.hashAsHexString);
            if (object5 != null && (serializable = this.matchCandidateByAncestorsAndSiblings.get((Object)nodeDiffData.hashAsHexString).rightSiblingsByLevel) != null && i < ((ArrayList)serializable).size() && (hashMap = (HashMap)((ArrayList)serializable).get(i)) != null) {
                if (nodeDiffData5 != null) {
                    this.md5temp.reset();
                    this.computeHashAndWeight(nodeDiffData5.node, null, null, this.md5temp);
                    string = XmlMapper.byteArrayToHexString(this.md5temp.digest());
                } else {
                    string = null;
                }
                arrayList = (ArrayList)hashMap.get(string);
                if (arrayList != null && arrayList.size() > 0) {
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        nodeDiffData2 = iterator.next();
                        if (nodeDiffData2.isMapped()) {
                            iterator.remove();
                            continue;
                        }
                        if (linkedHashMap.containsKey(nodeDiffData2.Id)) {
                            n3 = (Integer)linkedHashMap.get(nodeDiffData2.Id) + 1;
                            linkedHashMap.put(nodeDiffData2.Id, n3);
                            if (n3 <= n2) continue;
                            n2 = n3;
                            object3 = nodeDiffData2.Id;
                            continue;
                        }
                        linkedHashMap.put(nodeDiffData2.Id, 1);
                        if (!bl2) continue;
                        n2 = 1;
                        object3 = nodeDiffData2.Id;
                        bl2 = false;
                    }
                }
            }
            nodeDiffData5 = nodeDiffData5 != null && nodeDiffData5.siblingId > 0 ? this.secondInputDiffData.get(nodeDiffData5.siblingId - 1) : null;
        }
        if ((Integer)object3 > 0) {
            nodeDiffData2 = this.firstInputDiffData.get((Integer)object3 - 1);
            while (nodeDiffData2 != null && !XmlInternalUtils.equal(nodeDiffData2.node, nodeDiffData.node, this.options)) {
                linkedHashMap.remove(object3);
                object3 = 0;
                n2 = 0;
                for (Object object5 : linkedHashMap.keySet()) {
                    n3 = (Integer)linkedHashMap.get(object5);
                    if (n3 <= n2) continue;
                    object3 = object5;
                    n2 = n3;
                }
                if ((Integer)object3 > 0) {
                    nodeDiffData2 = this.firstInputDiffData.get((Integer)object3 - 1);
                    continue;
                }
                nodeDiffData2 = null;
            }
            if (nodeDiffData2 != null) {
                if (bl) {
                    if (n2.equals(n)) {
                        return nodeDiffData2;
                    }
                    return null;
                }
                return nodeDiffData2;
            }
        }
        if (bl) {
            return null;
        }
        arrayList = this.matchCandidates.get(nodeDiffData.hashAsHexString);
        if (arrayList != null) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                nodeDiffData2 = iterator.next();
                if (nodeDiffData2.isMapped() || !XmlInternalUtils.equal(nodeDiffData2.node, nodeDiffData.node, this.options)) continue;
                iterator.remove();
                return nodeDiffData2;
            }
        }
        return null;
    }

    private void mapAncestors(NodeDiffData nodeDiffData, NodeDiffData nodeDiffData2) {
        int n = this.numberOfAncestorsToCache + (int)(nodeDiffData2.weight / this.secondInputDiffData.get((int)(this.secondInputDiffData.size() - 1)).weight);
        for (int i = 0; i < n; ++i) {
            Node node;
            Node node2;
            int n2 = nodeDiffData.parentId;
            int n3 = nodeDiffData2.parentId;
            if (n2 <= 0 || n3 <= 0) continue;
            nodeDiffData = this.firstInputDiffData.get(n2 - 1);
            nodeDiffData2 = this.secondInputDiffData.get(n3 - 1);
            if (nodeDiffData.isMapped() || nodeDiffData2.isMapped() || !this.areElementNamesAndAttributesEqual(node2 = nodeDiffData.node, node = nodeDiffData2.node)) continue;
            nodeDiffData.mappedNodeId = n3;
            nodeDiffData2.mappedNodeId = n2;
        }
    }

    private boolean areElementNamesAndAttributesEqual(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!XmlInternalUtils.areNameAndValueEqual(node, node2, this.options)) {
            return false;
        }
        return XmlInternalUtils.attributesEqual(node, node2, this.options);
    }

    private void mapNodes(NodeDiffData nodeDiffData, NodeDiffData nodeDiffData2) {
        if (nodeDiffData.isMapped() || nodeDiffData2.isMapped()) {
            return;
        }
        nodeDiffData.mapNode(nodeDiffData2);
        int n = nodeDiffData.firstChildId;
        int n2 = nodeDiffData2.firstChildId;
        while (n > 0 && n2 > 0) {
            nodeDiffData = this.firstInputDiffData.get(n - 1);
            nodeDiffData2 = this.secondInputDiffData.get(n2 - 1);
            this.mapNodes(nodeDiffData, nodeDiffData2);
            n = nodeDiffData.siblingId;
            n2 = nodeDiffData2.siblingId;
        }
    }

    private void registerMatchCandidatesByAncestorsAndSiblings() {
        this.registerMatchCandidatesByAncestorsAndSiblings(this.firstInputDiffData.get(this.firstInputDiffData.size() - 1));
    }

    private void registerMatchCandidatesByAncestorsAndSiblings(NodeDiffData nodeDiffData) {
        ArrayList<NodeDiffData> arrayList;
        String string;
        int n = nodeDiffData.firstChildId;
        NodeDiffData nodeDiffData2 = null;
        while (n > 0) {
            nodeDiffData2 = this.firstInputDiffData.get(n - 1);
            this.registerMatchCandidatesByAncestorsAndSiblings(nodeDiffData2);
            n = nodeDiffData2.siblingId;
        }
        ArrayList<NodeDiffData> arrayList2 = this.matchCandidates.get(nodeDiffData.hashAsHexString);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
            this.matchCandidates.put(nodeDiffData.hashAsHexString, arrayList2);
        }
        arrayList2.add(nodeDiffData);
        AncestorsAndSiblings ancestorsAndSiblings = this.matchCandidateByAncestorsAndSiblings.get(nodeDiffData.hashAsHexString);
        if (ancestorsAndSiblings == null) {
            ancestorsAndSiblings = new AncestorsAndSiblings();
            this.matchCandidateByAncestorsAndSiblings.put(nodeDiffData.hashAsHexString, ancestorsAndSiblings);
        }
        NodeDiffData nodeDiffData3 = null;
        if (nodeDiffData.parentId > 0) {
            nodeDiffData3 = this.firstInputDiffData.get(nodeDiffData.parentId - 1);
        }
        for (int i = 0; i < this.numberOfAncestorsToCache; ++i) {
            HashMap<String, ArrayList<NodeDiffData>> hashMap = null;
            if (i < ancestorsAndSiblings.ancestorsByLevel.size()) {
                hashMap = ancestorsAndSiblings.ancestorsByLevel.get(i);
            }
            if (hashMap == null) {
                hashMap = new HashMap();
                ancestorsAndSiblings.ancestorsByLevel.add(hashMap);
            }
            if (nodeDiffData3 != null) {
                this.md5temp.reset();
                this.computeHashAndWeight(nodeDiffData3.node, null, null, this.md5temp);
                string = XmlMapper.byteArrayToHexString(this.md5temp.digest());
            } else {
                string = null;
            }
            arrayList = hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(string, arrayList);
            }
            arrayList.add(nodeDiffData);
            if (nodeDiffData3 == null || nodeDiffData3.parentId <= 0) break;
            nodeDiffData3 = this.firstInputDiffData.get(nodeDiffData3.parentId - 1);
        }
        NodeDiffData nodeDiffData4 = null;
        if (nodeDiffData.previousSiblingId > 0) {
            nodeDiffData4 = this.firstInputDiffData.get(nodeDiffData.previousSiblingId - 1);
        }
        if (ancestorsAndSiblings.leftSiblingsByLevel == null) {
            ancestorsAndSiblings.leftSiblingsByLevel = new ArrayList(this.numberOfSiblingsToCache);
        }
        for (int i = 0; i < this.numberOfSiblingsToCache; ++i) {
            HashMap<String, ArrayList<NodeDiffData>> hashMap = null;
            if (i < ancestorsAndSiblings.leftSiblingsByLevel.size()) {
                hashMap = ancestorsAndSiblings.leftSiblingsByLevel.get(i);
            }
            if (hashMap == null) {
                hashMap = new HashMap();
                ancestorsAndSiblings.leftSiblingsByLevel.add(hashMap);
            }
            if (nodeDiffData4 != null) {
                this.md5temp.reset();
                this.computeHashAndWeight(nodeDiffData4.node, null, null, this.md5temp);
                string = XmlMapper.byteArrayToHexString(this.md5temp.digest());
            } else {
                string = null;
            }
            arrayList = hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(string, arrayList);
            }
            arrayList.add(nodeDiffData);
            if (nodeDiffData4 == null || nodeDiffData4.previousSiblingId <= 0) break;
            nodeDiffData4 = this.firstInputDiffData.get(nodeDiffData4.previousSiblingId - 1);
        }
        NodeDiffData nodeDiffData5 = null;
        if (nodeDiffData.siblingId > 0) {
            nodeDiffData5 = this.firstInputDiffData.get(nodeDiffData.siblingId - 1);
        }
        if (ancestorsAndSiblings.rightSiblingsByLevel == null) {
            ancestorsAndSiblings.rightSiblingsByLevel = new ArrayList(this.numberOfSiblingsToCache);
        }
        for (int i = 0; i < this.numberOfSiblingsToCache; ++i) {
            HashMap<String, ArrayList<NodeDiffData>> hashMap = null;
            if (i < ancestorsAndSiblings.rightSiblingsByLevel.size()) {
                hashMap = ancestorsAndSiblings.rightSiblingsByLevel.get(i);
            }
            if (hashMap == null) {
                hashMap = new HashMap();
                ancestorsAndSiblings.rightSiblingsByLevel.add(hashMap);
            }
            if (nodeDiffData5 != null) {
                this.md5temp.reset();
                this.computeHashAndWeight(nodeDiffData5.node, null, null, this.md5temp);
                string = XmlMapper.byteArrayToHexString(this.md5temp.digest());
            } else {
                string = null;
            }
            arrayList = hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(string, arrayList);
            }
            arrayList.add(nodeDiffData);
            if (nodeDiffData5 == null || nodeDiffData5.siblingId <= 0) break;
            nodeDiffData5 = this.firstInputDiffData.get(nodeDiffData5.siblingId - 1);
        }
    }

    void optimizeChildrenMappings() {
        this.optimizeChildrenMappings(this.secondInputDiffData.get(this.secondInputDiffData.size() - 1));
    }

    private void optimizeChildrenMappings(NodeDiffData nodeDiffData) {
        if (nodeDiffData.isMapped()) {
            NodeDiffData nodeDiffData2 = nodeDiffData;
            HashMap<String, NodeDiffData> hashMap = new HashMap<String, NodeDiffData>();
            int n = nodeDiffData.firstChildId;
            while (n > 0) {
                nodeDiffData = this.secondInputDiffData.get(n - 1);
                if (!nodeDiffData.isMapped()) {
                    if (hashMap.containsKey(nodeDiffData.localHashAsHexString)) {
                        hashMap.put(nodeDiffData.localHashAsHexString, null);
                    } else {
                        hashMap.put(nodeDiffData.localHashAsHexString, nodeDiffData);
                    }
                }
                n = nodeDiffData.siblingId;
            }
            HashMap<String, NodeDiffData> hashMap2 = new HashMap<String, NodeDiffData>();
            n = this.firstInputDiffData.get((int)(nodeDiffData2.mappedNodeId - 1)).firstChildId;
            while (n > 0) {
                nodeDiffData = this.firstInputDiffData.get(n - 1);
                if (!nodeDiffData.isMapped() && hashMap.get(nodeDiffData.localHashAsHexString) != null) {
                    if (hashMap2.containsKey(nodeDiffData.localHashAsHexString)) {
                        hashMap2.put(nodeDiffData.localHashAsHexString, null);
                    } else {
                        hashMap2.put(nodeDiffData.localHashAsHexString, nodeDiffData);
                    }
                }
                n = nodeDiffData.siblingId;
            }
            for (String string : hashMap2.keySet()) {
                nodeDiffData = (NodeDiffData)hashMap2.get(string);
                if (nodeDiffData == null) continue;
                NodeDiffData nodeDiffData3 = (NodeDiffData)hashMap.get(string);
                if (!this.areElementNamesAndAttributesEqual(nodeDiffData.node, nodeDiffData3.node)) continue;
                nodeDiffData3.mapNode(nodeDiffData);
            }
            n = nodeDiffData2.firstChildId;
            while (n > 0) {
                nodeDiffData = this.secondInputDiffData.get(n - 1);
                this.optimizeChildrenMappings(nodeDiffData);
                n = nodeDiffData.siblingId;
            }
        }
    }

    void printDiffData() {
        NodeDiffData nodeDiffData;
        int n;
        System.out.println("Begin First Input");
        for (n = 0; n < this.firstInputDiffData.size(); ++n) {
            nodeDiffData = this.firstInputDiffData.get(n);
            System.out.println("Begin");
            System.out.println("  Node is: " + nodeDiffData.node.getNodeName() + " id: " + nodeDiffData.Id);
            System.out.println("  Node is: prefix " + nodeDiffData.node.getPrefix() + " local name " + nodeDiffData.node.getLocalName() + " uri " + nodeDiffData.node.getNamespaceURI());
            try {
                System.out.println("  Node is: " + XmlUtils.nodeToString(nodeDiffData.node, false));
            }
            catch (Exception exception) {
                System.out.println("  Exception printing out node");
            }
            System.out.println("  Mapped second input node is " + nodeDiffData.mappedNodeId);
            System.out.println("  Parent id: " + nodeDiffData.parentId + " sibling id: " + nodeDiffData.siblingId);
            System.out.println("  First child id: " + nodeDiffData.firstChildId + " position: " + nodeDiffData.position);
            System.out.println("  Weight: " + nodeDiffData.weight + " hash: " + nodeDiffData.hashAsHexString + " local hash: " + nodeDiffData.localHashAsHexString);
            System.out.println("  OutputBuilderState: " + (Object)((Object)nodeDiffData.outputBuilderState));
            System.out.println("End");
        }
        System.out.println("End First Input");
        System.out.println("Begin Second Input");
        for (n = 0; n < this.secondInputDiffData.size(); ++n) {
            nodeDiffData = this.secondInputDiffData.get(n);
            System.out.println("Begin");
            System.out.println("  Node is: " + nodeDiffData.node.getNodeName() + " id: " + nodeDiffData.Id);
            System.out.println("  Node is: prefix " + nodeDiffData.node.getPrefix() + " local name " + nodeDiffData.node.getLocalName() + " uri " + nodeDiffData.node.getNamespaceURI());
            try {
                System.out.println("  Node is: " + XmlUtils.nodeToString(nodeDiffData.node, false));
            }
            catch (Exception exception) {
                System.out.println("  Exception printing out node");
            }
            System.out.println("  Mapped first input node is " + nodeDiffData.mappedNodeId);
            System.out.println("  Parent id: " + nodeDiffData.parentId + " sibling id: " + nodeDiffData.siblingId);
            System.out.println("  First child id: " + nodeDiffData.firstChildId + " position: " + nodeDiffData.position);
            System.out.println("  Weight: " + nodeDiffData.weight + " hash: " + nodeDiffData.hashAsHexString + " local hash: " + nodeDiffData.localHashAsHexString);
            System.out.println("  OutputBuilderState: " + (Object)((Object)nodeDiffData.outputBuilderState));
            System.out.println("End");
        }
        System.out.println("End Second Input");
    }

    private void computeHashAndWeight(Node node, NodeDiffData nodeDiffData, MessageDigest messageDigest, MessageDigest messageDigest2) {
        switch (node.getNodeType()) {
            case 1: {
                String string = XmlInternalUtils.constructElemOrAttrHashString(node, this.options);
                if (messageDigest != null) {
                    messageDigest.update(string.getBytes());
                }
                messageDigest2.update(string.getBytes());
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n = namedNodeMap.getLength();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < n; ++i) {
                        Node node2 = namedNodeMap.item(i);
                        if (XmlInternalUtils.isXmlns(node2)) continue;
                        arrayList.add(XmlInternalUtils.constructElemOrAttrHashString(node2, this.options));
                    }
                    Collections.sort(arrayList);
                    for (String string2 : arrayList) {
                        if (messageDigest != null) {
                            messageDigest.update(string2.getBytes());
                        }
                        messageDigest2.update(string2.getBytes());
                    }
                    if (nodeDiffData != null) {
                        nodeDiffData.weight = (double)n * 0.5;
                    }
                }
                if (nodeDiffData == null) break;
                nodeDiffData.weight += 1.0;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                String string = node.getNodeName() + " " + node.getNodeValue();
                if (messageDigest != null) {
                    messageDigest.update(string.getBytes());
                }
                messageDigest2.update(string.getBytes());
                if (nodeDiffData == null) break;
                nodeDiffData.weight = 1.0 + Math.log(node.getNodeValue().length());
                break;
            }
            case 9: 
            case 11: {
                if (nodeDiffData != null) {
                    nodeDiffData.weight = 1.0;
                }
                if (messageDigest != null) {
                    messageDigest.update(node.getNodeName().getBytes());
                }
                messageDigest2.update(node.getNodeName().getBytes());
            }
        }
    }

    private boolean adjacentTextNodes(Node node) {
        Node node2;
        return node.getNodeType() == 3 && (node2 = node.getNextSibling()) != null && node2.getNodeType() == 3;
    }

    private Node skipToLastTextNode(Node node) {
        while (node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    private class AncestorsAndSiblings {
        ArrayList<HashMap<String, ArrayList<NodeDiffData>>> ancestorsByLevel;
        ArrayList<HashMap<String, ArrayList<NodeDiffData>>> leftSiblingsByLevel;
        ArrayList<HashMap<String, ArrayList<NodeDiffData>>> rightSiblingsByLevel;

        AncestorsAndSiblings() {
            this.ancestorsByLevel = new ArrayList(XmlMapper.this.numberOfAncestorsToCache);
        }
    }
}

