/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction;

import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObjectInvalidException;

public final class TransactionReference {
    static final int ACTIVE = 1;
    static final int ROLLED_BACK = 2;
    static final int COMMITTED = 3;
    private Transaction m_Transaction = null;
    private TransactionReference m_ParentTransactionReference = null;
    private int m_State = 1;

    private void setTransaction(Transaction transaction) {
        this.m_Transaction = transaction;
    }

    private TransactionReference getParentTransactionReference() {
        return this.m_ParentTransactionReference;
    }

    private void setState(int n) {
        this.m_State = n;
    }

    private int getState() {
        return this.m_State;
    }

    TransactionReference(Transaction transaction, TransactionReference transactionReference) {
        this.setTransaction(transaction);
        this.m_ParentTransactionReference = transactionReference;
        this.setState(1);
    }

    public Transaction getTransaction() {
        return this.m_Transaction;
    }

    void transactionCommitted() {
        this.setState(3);
        this.setTransaction(null);
    }

    void transactionRolledBack() {
        this.setState(2);
        this.setTransaction(null);
    }

    public TransactionReference checkVisbility(Transaction transaction) throws TransactionalObjectInvalidException {
        TransactionReference transactionReference = this.getCurrentReference();
        if (transactionReference.getState() == 3) {
            return transactionReference;
        }
        if (transactionReference.getTransaction().isAncestorOf(transaction)) {
            return transactionReference;
        }
        throw new TransactionalObjectInvalidException();
    }

    public TransactionReference getCurrentReference() {
        block5: for (TransactionReference transactionReference = this; transactionReference != null; transactionReference = transactionReference.getParentTransactionReference()) {
            switch (transactionReference.getState()) {
                case 2: {
                    throw new TransactionalObjectInvalidException();
                }
                case 1: {
                    return transactionReference;
                }
                case 3: {
                    if (null != transactionReference.getParentTransactionReference()) continue block5;
                    return transactionReference;
                }
            }
        }
        throw new TransactionalObjectInvalidException();
    }
}

