/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymmetricConditionElement
extends SyntaxObject {
    public static final String ALL = "ALL";
    public static final String NONE = "NONE";
    static final String[] SIMPLE_QUALIFIERS = new String[]{"ALL", "NONE"};
    private MdmPrimaryDimension m_Dimension;
    private String m_Qualifier;
    private Condition m_Condition;
    private MdmDimensionLevel[] m_Levels;

    private MdmDimensionLevel[] getLevelsInternal() {
        return this.m_Levels;
    }

    private SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, String string, Condition condition, MdmDimensionLevel[] mdmDimensionLevelArray, boolean bl) {
        SymmetricConditionElement.validateValue(mdmPrimaryDimension);
        this.m_Dimension = mdmPrimaryDimension;
        if (null != string) {
            this.m_Qualifier = SymmetricConditionElement.validateEnum(string, SIMPLE_QUALIFIERS);
        } else if (null != condition) {
            SymmetricConditionElement.validateValue(condition);
            this.m_Condition = condition;
        } else {
            SymmetricConditionElement.validateValues(mdmDimensionLevelArray);
            this.m_Levels = bl ? (MdmDimensionLevel[])mdmDimensionLevelArray.clone() : mdmDimensionLevelArray;
        }
        this.initialize();
    }

    private static MdmDimensionLevel[] createMdmDimLevelArray(List<MdmDimensionLevel> list) {
        if (null == list) {
            return null;
        }
        MdmDimensionLevel[] mdmDimensionLevelArray = new MdmDimensionLevel[list.size()];
        list.toArray(mdmDimensionLevelArray);
        return mdmDimensionLevelArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        if (null != this.m_Condition) {
            validationContext.validate(this.m_Condition);
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.m_Condition) {
            return this.m_Condition.isDefinitionComplete();
        }
        return true;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        boolean bl = null == syntaxPrintingContext.getXMLWriter() || syntaxPrintingContext.getXMLWriter().isMetadataXMLVersionSameOrLaterThan("1.2");
        syntaxPrintingContext.appendIdentifier(this.m_Dimension.getInternalID());
        if (null != this.m_Qualifier) {
            if (this.m_Qualifier.equalsIgnoreCase(ALL)) {
                if (bl) {
                    syntaxPrintingContext.append(" ALL");
                } else {
                    syntaxPrintingContext.append(" WHERE (1 = 1)");
                }
            } else if (bl) {
                syntaxPrintingContext.append(" NONE");
            } else {
                syntaxPrintingContext.append(" WHERE (1 != 1)");
            }
        } else if (null != this.m_Condition) {
            syntaxPrintingContext.append(" WHERE ");
            syntaxPrintingContext.print(this.m_Condition);
        } else if (bl) {
            syntaxPrintingContext.append(" LEVELS (");
            for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                if (0 != i) {
                    syntaxPrintingContext.append(",");
                    syntaxPrintingContext.newLineAndIndent();
                }
                syntaxPrintingContext.appendIdentifier(this.getLevelsInternal()[i].getInternalID());
            }
            syntaxPrintingContext.append(")");
        } else {
            syntaxPrintingContext.append(" WHERE ");
            syntaxPrintingContext.appendIdentifier(this.m_Dimension.getInternalID());
            syntaxPrintingContext.append(".LEVEL_NAME ");
            if (1 == this.getLevelsInternal().length) {
                syntaxPrintingContext.append("= ");
                syntaxPrintingContext.appendQuotedString(this.getLevelsInternal()[0].getName());
            } else {
                syntaxPrintingContext.append("IN (");
                for (int i = 0; i < this.getLevelsInternal().length; ++i) {
                    if (0 != i) {
                        syntaxPrintingContext.append(",");
                        syntaxPrintingContext.newLineAndIndent();
                    }
                    syntaxPrintingContext.appendQuotedString(this.getLevelsInternal()[i].getName());
                }
                syntaxPrintingContext.append(")");
            }
        }
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, String string) {
        this(mdmPrimaryDimension, string, null, null, false);
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, Condition condition) {
        this(mdmPrimaryDimension, null, condition, null, false);
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, MdmDimensionLevel[] mdmDimensionLevelArray) {
        this(mdmPrimaryDimension, null, null, mdmDimensionLevelArray, true);
    }

    public SymmetricConditionElement(MdmPrimaryDimension mdmPrimaryDimension, List<MdmDimensionLevel> list) {
        this(mdmPrimaryDimension, null, null, SymmetricConditionElement.createMdmDimLevelArray(list), false);
    }

    public MdmPrimaryDimension getDimension() {
        return this.m_Dimension;
    }

    public Condition getCondition() {
        return this.m_Condition;
    }

    public MdmDimensionLevel[] getLevels() {
        if (null != this.getLevelsInternal()) {
            return (MdmDimensionLevel[])this.getLevelsInternal().clone();
        }
        return null;
    }

    public String getQualifier() {
        if (null != this.m_Qualifier) {
            if (this.m_Qualifier.equalsIgnoreCase(ALL)) {
                return ALL;
            }
            return NONE;
        }
        return null;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSymmetricConditionElement(this, object);
    }
}

