/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.RowExpression;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;

public final class IntervalLiteralExpression
extends RowExpression {
    public static final String DAY = "DAY";
    public static final String HOUR = "HOUR";
    public static final String MINUTE = "MINUTE";
    public static final String SECOND = "SECOND";
    public static final String YEAR = "YEAR";
    public static final String MONTH = "MONTH";
    public static final int DEFAULT_LEADING_PRECISION = 2;
    public static final int DEFAULT_FRACTIONAL_SECONDS_PRECISION = 6;
    static final String[] ALL_PERIODS = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND"};
    private String m_LeadingPeriod;
    private String m_TrailingPeriod;
    private String m_Value;
    private int m_LeadingPrecision;
    private int m_LeadingFractionalSecondsPrecision = 6;
    private int m_TrailingFractionalSecondsPrecision = 6;

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("INTERVAL '");
        syntaxPrintingContext.append(this.getValue());
        syntaxPrintingContext.append("' ");
        syntaxPrintingContext.append(this.getLeadingPeriod());
        if (2 != this.getLeadingPrecision()) {
            syntaxPrintingContext.append("(");
            syntaxPrintingContext.append(this.getLeadingPrecision());
            if (6 != this.getLeadingFractionalSecondsPrecision()) {
                syntaxPrintingContext.append(", ");
                syntaxPrintingContext.append(this.getLeadingFractionalSecondsPrecision());
            }
            syntaxPrintingContext.append(")");
        }
        if (null != this.getTrailingPeriod()) {
            syntaxPrintingContext.append(" TO ");
            syntaxPrintingContext.append(this.getTrailingPeriod());
            if (6 != this.getTrailingFractionalSecondsPrecision()) {
                syntaxPrintingContext.append(" (");
                syntaxPrintingContext.append(this.getTrailingFractionalSecondsPrecision());
                syntaxPrintingContext.append(")");
            }
        }
    }

    public IntervalLiteralExpression(String string, String string2, int n, int n2, String string3, int n3) {
        int n4 = ALL_PERIODS.length;
        int n5 = IntervalLiteralExpression.validateEnum(string2, ALL_PERIODS, 0, n4);
        this.m_LeadingPeriod = ALL_PERIODS[n5];
        if (n5 < 2) {
            this.setDataType(DataType.YM_INTERVAL);
            n4 = 2;
        } else {
            this.setDataType(DataType.DS_INTERVAL);
        }
        if (null != string3) {
            int n6 = IntervalLiteralExpression.validateEnum(string3, ALL_PERIODS, n5, n4);
            this.m_TrailingPeriod = ALL_PERIODS[n6];
        }
        IntervalLiteralExpression.validateValue(string);
        this.m_Value = string;
        IntervalLiteralExpression.validateInteger(n5, 0, 9);
        this.m_LeadingPrecision = n;
        if (SECOND == this.m_LeadingPeriod) {
            IntervalLiteralExpression.validateInteger(n2, 1, 9);
            this.m_LeadingFractionalSecondsPrecision = n2;
        }
        if (SECOND == this.m_TrailingPeriod) {
            IntervalLiteralExpression.validateInteger(n3, 1, 9);
            this.m_TrailingFractionalSecondsPrecision = n3;
        }
    }

    public IntervalLiteralExpression(String string, String string2, int n, String string3) {
        this(string, string2, n, 6, string3, 6);
    }

    public IntervalLiteralExpression(String string, String string2, String string3) {
        this(string, string2, 2, 6, string3, 6);
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitIntervalLiteralExpression(this, object);
    }

    public String getLeadingPeriod() {
        return this.m_LeadingPeriod;
    }

    public String getTrailingPeriod() {
        return this.m_TrailingPeriod;
    }

    public String getValue() {
        return this.m_Value;
    }

    public int getLeadingPrecision() {
        return this.m_LeadingPrecision;
    }

    public int getLeadingFractionalSecondsPrecision() {
        return this.m_LeadingFractionalSecondsPrecision;
    }

    public int getTrailingFractionalSecondsPrecision() {
        return this.m_TrailingFractionalSecondsPrecision;
    }
}

