/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.BuildCommand;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSpecification
extends SyntaxObject {
    private BuildCommand[] m_Commands;
    private String m_Name;

    private BuildCommand[] getCommandsInternal() {
        return this.m_Commands;
    }

    private BuildSpecification(String string, BuildCommand[] buildCommandArray, boolean bl) {
        this.m_Name = string;
        BuildSpecification.validateValues(buildCommandArray);
        this.m_Commands = bl ? (BuildCommand[])buildCommandArray.clone() : buildCommandArray;
        this.initialize();
    }

    private static BuildCommand[] createBuildCommandArray(List<BuildCommand> list) {
        if (null == list) {
            return null;
        }
        BuildCommand[] buildCommandArray = new BuildCommand[list.size()];
        list.toArray(buildCommandArray);
        return buildCommandArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getCommandsInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getCommandsInternal());
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("BUILD SPEC ");
        syntaxPrintingContext.append(this.getName());
        this.printCommands(syntaxPrintingContext);
    }

    void printCommands(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.decrementIndent();
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.incrementIndent();
        syntaxPrintingContext.append("(");
        for (int i = 0; i < this.getCommandsInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getCommandsInternal()[i]);
        }
        syntaxPrintingContext.decrementIndent();
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append(")");
        syntaxPrintingContext.incrementIndent();
    }

    public BuildSpecification(String string, BuildCommand[] buildCommandArray) {
        this(string, buildCommandArray, true);
    }

    public BuildSpecification(String string, List<BuildCommand> list) {
        this(string, BuildSpecification.createBuildCommandArray(list), false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBuildSpecification(this, object);
    }

    public BuildCommand[] getCommands() {
        return (BuildCommand[])this.getCommandsInternal().clone();
    }

    public String getName() {
        return this.m_Name;
    }
}

