/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataFactoryException;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mtm.MtmAggregationSpecification;
import oracle.olapi.metadata.mtm.MtmAggregationStep;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmObject;
import oracle.olapi.metadata.mtm.MtmObjectVisitor;
import oracle.olapi.metadata.mtm.MtmSolveSpecification;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.metadata.mtm.MtmXMLTags;

public class MtmUnsolvedCube
extends MtmBaseCube {
    MtmUnsolvedCube(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public Object acceptVisitor(MtmObjectVisitor mtmObjectVisitor, Object object) {
        return mtmObjectVisitor.visitMtmUnsolvedCube(this, object);
    }

    public String getAggregationForm() {
        return this.getPropertyStringValue(MtmXMLTags.AGGREGATION_FORM);
    }

    public MtmSolveSpecification getSolveSpecification() {
        Object object = this.getPropertyObjectValue(MtmXMLTags.SOLVE_SPEC);
        if (object == null) {
            return null;
        }
        return (MtmSolveSpecification)object;
    }

    public String getSQLHint() {
        return this.getPropertyStringValue(MtmXMLTags.SQL_HINT);
    }

    protected XMLTag getXMLTag() {
        return MtmXMLTags.UNSOLVED_CUBE_TAG;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        if (MtmXMLTags.AGGREGATION_FORM.matches(string, string2)) {
            return MtmXMLTags.AGGREGATION_FORM;
        }
        if (MtmXMLTags.SQL_HINT.matches(string, string2)) {
            return MtmXMLTags.SQL_HINT;
        }
        if (MtmXMLTags.SOLVE_SPEC.matches(string, string2)) {
            return MtmXMLTags.SOLVE_SPEC;
        }
        return super.getPropertyXMLTag(string, string2);
    }

    public void setAggregationForm(String string) {
        this.setPropertyStringValue(MtmXMLTags.AGGREGATION_FORM, string);
    }

    public void setSolveSpecification(MtmSolveSpecification mtmSolveSpecification) {
        this.setPropertyObjectValue(MtmXMLTags.SOLVE_SPEC, mtmSolveSpecification);
    }

    public void setSQLHint(String string) {
        this.setPropertyStringValue(MtmXMLTags.SQL_HINT, string);
    }

    public void addDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        super.addDimensionality(mtmCubeDimensionality);
        if (this.getSolveSpecification() instanceof MtmAggregationSpecification) {
            MtmAggregationSpecification mtmAggregationSpecification = (MtmAggregationSpecification)this.getSolveSpecification();
            mtmAggregationSpecification.addDimensionMap(mtmCubeDimensionality.getDimensionMap());
        }
    }

    public void removeDimensionality(MtmCubeDimensionality mtmCubeDimensionality) {
        super.removeDimensionality(mtmCubeDimensionality);
        if (this.getSolveSpecification() instanceof MtmAggregationSpecification) {
            MtmAggregationSpecification mtmAggregationSpecification = (MtmAggregationSpecification)this.getSolveSpecification();
            mtmAggregationSpecification.removeDimensionMap(mtmCubeDimensionality.getDimensionMap());
        }
    }

    public void applyAggregationStep(MtmAggregationStep mtmAggregationStep) {
        MtmObject mtmObject2;
        if (mtmAggregationStep.getDimensionMaps().isEmpty()) {
            for (MtmObject mtmObject2 : this.getDimensionMaps()) {
                mtmAggregationStep.addDimensionMap((MtmDimensionMap)mtmObject2);
            }
        }
        for (MtmObject mtmObject2 : mtmAggregationStep.getDimensionMaps()) {
            if (this.getDimensionMaps().contains(mtmObject2)) continue;
            throw new MetadataFactoryException("AggregationDimensionNotInCube_2", ((MtmSourceMap)mtmObject2).getMdmSource().getID(), this.getID());
        }
        if (!(this.getSolveSpecification() instanceof MtmAggregationSpecification)) {
            throw new MetadataFactoryException("AggregationSpecificationNotFound_1", this.getID());
        }
        mtmObject2 = (MtmAggregationSpecification)this.getSolveSpecification();
        ((MtmAggregationSpecification)mtmObject2).applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateSimple(MdmHierarchy mdmHierarchy, String string, MtmValueExpression mtmValueExpression) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMtmCustomObjectFactory().createSimpleAggregationStep(mdmHierarchy, string, mtmValueExpression);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateSum(MdmHierarchy mdmHierarchy) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMtmCustomObjectFactory().createSumAggregationStep(mdmHierarchy);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateFirst(MdmHierarchy mdmHierarchy, boolean bl) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMtmCustomObjectFactory().createFirstAggregationStep(mdmHierarchy, bl);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateLast(MdmHierarchy mdmHierarchy, boolean bl) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMtmCustomObjectFactory().createLastAggregationStep(mdmHierarchy, bl);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void aggregateWeightedAverage(MdmHierarchy mdmHierarchy, MtmValueExpression mtmValueExpression, boolean bl) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMtmCustomObjectFactory().createWeightedAverageAggregationStep(mdmHierarchy, mtmValueExpression, bl);
        this.applyAggregationStep(mtmAggregationStep);
    }

    public void removeAggregation(MdmHierarchy mdmHierarchy) {
        MtmAggregationStep mtmAggregationStep = ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMtmCustomObjectFactory().createNoAggregationStep(mdmHierarchy);
        this.applyAggregationStep(mtmAggregationStep);
    }
}

