/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.HashMap;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.metadata.mtm.MtmDataType;

public class MtmDataTypeConverter {
    private DataProvider m_DataProvider = null;
    private HashMap m_FundamentalToMtmMap = new HashMap(12);
    private HashMap m_MtmToFundamentalMap = new HashMap(12);

    public MtmDataTypeConverter(DataProvider dataProvider) {
        this.m_DataProvider = dataProvider;
        this.performInitialAssignments();
    }

    public DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    public FundamentalMetadataObject getFundamentalDataType(MtmDataType mtmDataType) {
        return this.getFundamentalDataType(mtmDataType.getSqlDataType());
    }

    public FundamentalMetadataObject getFundamentalDataType(String string) {
        Object v = this.m_MtmToFundamentalMap.get(string);
        if (null != v && v instanceof FundamentalMetadataObject) {
            return (FundamentalMetadataObject)v;
        }
        return this.getFundamentalProvider().getValueDataType();
    }

    public MtmDataType getMtmDataType(FundamentalMetadataObject fundamentalMetadataObject) {
        Object v = this.m_FundamentalToMtmMap.get(fundamentalMetadataObject.getID());
        if (null != v && v instanceof MtmDataType) {
            return (MtmDataType)v;
        }
        return (MtmDataType)this.m_FundamentalToMtmMap.get(this.getFundamentalProvider().getValueDataType());
    }

    public void setFundamentalDataType(MtmDataType mtmDataType, FundamentalMetadataObject fundamentalMetadataObject) {
        this.setFundamentalDataType(mtmDataType.getSqlDataType(), fundamentalMetadataObject);
    }

    public void setFundamentalDataType(String string, FundamentalMetadataObject fundamentalMetadataObject) {
        this.m_MtmToFundamentalMap.put(string, fundamentalMetadataObject);
    }

    public void setMtmDataType(FundamentalMetadataObject fundamentalMetadataObject, MtmDataType mtmDataType) {
        this.m_FundamentalToMtmMap.put(fundamentalMetadataObject.getID(), mtmDataType);
    }

    private FundamentalMetadataProvider getFundamentalProvider() {
        return this.m_DataProvider.getFundamentalMetadataProvider();
    }

    private void performInitialAssignments() {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalProvider();
        MtmDataType mtmDataType = new MtmDataType("NUMBER", 0, 5, true);
        MtmDataType mtmDataType2 = new MtmDataType("NUMBER", 0, 10, true);
        MtmDataType mtmDataType3 = new MtmDataType("NUMBER", 0, 0, true);
        MtmDataType mtmDataType4 = new MtmDataType("VARCHAR2", 127, 0, true);
        this.setMtmDataType(fundamentalMetadataProvider.getShortDataType(), mtmDataType);
        this.setMtmDataType(fundamentalMetadataProvider.getIntegerDataType(), mtmDataType2);
        this.setMtmDataType(fundamentalMetadataProvider.getFloatDataType(), mtmDataType3);
        this.setMtmDataType(fundamentalMetadataProvider.getDoubleDataType(), mtmDataType3);
        this.setMtmDataType(fundamentalMetadataProvider.getNumberDataType(), mtmDataType3);
        this.setMtmDataType(fundamentalMetadataProvider.getBooleanDataType(), mtmDataType);
        this.setMtmDataType(fundamentalMetadataProvider.getDateDataType(), new MtmDataType("DATE", 0, 0, true));
        this.setMtmDataType(fundamentalMetadataProvider.getStringDataType(), mtmDataType4);
        this.setMtmDataType(fundamentalMetadataProvider.getValueDataType(), mtmDataType4);
        this.setFundamentalDataType("NUMBER", fundamentalMetadataProvider.getNumberDataType());
        this.setFundamentalDataType("DATE", fundamentalMetadataProvider.getDateDataType());
        this.setFundamentalDataType("VARCHAR2", fundamentalMetadataProvider.getStringDataType());
        this.setFundamentalDataType("VARCHAR", fundamentalMetadataProvider.getStringDataType());
        this.setFundamentalDataType("NVARCHAR2", fundamentalMetadataProvider.getStringDataType());
        this.setFundamentalDataType("CHAR", fundamentalMetadataProvider.getStringDataType());
        this.setFundamentalDataType("NCHAR", fundamentalMetadataProvider.getStringDataType());
        this.setFundamentalDataType("LONG", fundamentalMetadataProvider.getStringDataType());
        this.setFundamentalDataType("CLOB", fundamentalMetadataProvider.getStringDataType());
        this.setFundamentalDataType("NCLOB", fundamentalMetadataProvider.getStringDataType());
    }
}

