/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.transaction.Transaction;

public final class MdmSourceDefinition
extends HiddenDefinition {
    MdmSource m_MdmSource;

    MdmSourceDefinition(MdmMetadataProvider mdmMetadataProvider, MdmSource mdmSource, DataProvider dataProvider) {
        super(mdmMetadataProvider, mdmSource.getID(), MdmSourceDefinition.createSourceID(mdmSource, mdmMetadataProvider, dataProvider), dataProvider);
        this.m_MdmSource = mdmSource;
    }

    private static String createSourceID(MdmSource mdmSource, MdmMetadataProvider mdmMetadataProvider, DataProvider dataProvider) {
        String string;
        block7: {
            int n;
            block8: {
                string = mdmSource.getID();
                n = mdmSource.getID().indexOf("..");
                if (n < 0) break block7;
                String string2 = dataProvider.getProperty("SourceIDFormat");
                String string3 = dataProvider.getProperty("MetadataReaderMode");
                if (string2 == null) break block7;
                if (!string2.equals("10g") || string3 == null) break block7;
                if (string3.equals("10_ONLY")) break block8;
                if (string3.equals("METADATA_READER_MODE_CHOICE_10103AWONLY")) break block8;
                if (!string3.equals("CWM2ONLY")) break block7;
            }
            BaseMetadataObject baseMetadataObject = mdmSource.getTopContainedByObject();
            String string4 = "";
            if (baseMetadataObject instanceof MdmDimension || baseMetadataObject instanceof MdmAttribute) {
                string4 = "D_";
            } else if (baseMetadataObject instanceof MdmMeasure || baseMetadataObject instanceof MdmCube) {
                string4 = "M_";
            } else {
                throw new RuntimeException("Unable to create 10g source ID for " + mdmSource.getID());
            }
            string = string4 = string4 + mdmSource.getID().substring(n + 2);
        }
        return dataProvider._getSourceIDProvider().createHiddenID(mdmMetadataProvider.getID(), string, dataProvider);
    }

    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        if (this.getMdmSource() instanceof MdmPrimaryDimension) {
            return ((MdmPrimaryDimension)this.getMdmSource()).getExtractModel();
        }
        return null;
    }

    protected final Set getExtractionInputDefinitions() {
        return Collections.EMPTY_SET;
    }

    protected final Set getInputDefinitions() {
        return this.getRegularInputDefinitions();
    }

    public MdmSource getMdmSource() {
        return this.m_MdmSource;
    }

    public final Model getModel() {
        return this.getMdmSource().getModel();
    }

    protected final List getOutputDefinitions() {
        return this.getMdmSource().getOutputDefinitions();
    }

    protected final Set getRegularInputDefinitions() {
        return this.getMdmSource().getInputDefinitions();
    }

    protected final SourceDefinition getTypeDefinition() {
        return this.getMdmSource().getTypeDefinition();
    }

    private void setMdmSource(MdmSource mdmSource) {
        this.m_MdmSource = mdmSource;
    }

    public final Transaction getActiveTransaction() {
        return this.getMdmSource().getActiveTransaction();
    }

    public Object getTransactionalState(Transaction transaction) {
        return this;
    }

    public void updatePersistentID() {
        this.setPersistentID(this.getMdmSource().getID());
        this.setID(MdmSourceDefinition.createSourceID(this.getMdmSource(), this.getMdmSource().getMetadataProvider(), this.getDataProvider()));
    }
}

