/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import org.xml.sax.SAXException;

public class MdmSchema
extends MdmObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.PRIMARY_DIMENSION_REF_CONTAINED, MdmXMLTags.MEASURE_REF, MdmXMLTags.SCHEMA_REF_CONTAINED, MdmXMLTags.CUBE_REF_CONTAINED, MdmXMLTags.MEASURE_DIM_REF_CONTAINED};
    static final String ROOT_SCHEMA_ID = "RootSchema";

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmSchema(this, object);
    }

    public List getDimensions() {
        return this.getPropertyListValues(MdmXMLTags.PRIMARY_DIMENSION_REF_CONTAINED);
    }

    public MdmMeasureDimension getMeasureDimension() throws MetadataNotFoundException {
        return (MdmMeasureDimension)this.getPropertyObjectValue(MdmXMLTags.MEASURE_DIM_REF_CONTAINED);
    }

    public List getMeasures() {
        return this.getPropertyListValues(MdmXMLTags.MEASURE_REF);
    }

    public List getSubSchemas() {
        return this.getPropertyListValues(MdmXMLTags.SCHEMA_REF_CONTAINED);
    }

    protected XMLTag getXMLTag() {
        return MdmXMLTags.SCHEMA_TAG;
    }

    public static final XMLTag classGetContainedByPropertyTag() {
        return null;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    protected MdmSchema(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmSchema(String string, String string2, short s, MdmDatabaseSchema mdmDatabaseSchema, BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider, string, string2, s, mdmDatabaseSchema);
    }

    public final void addMeasure(MdmMeasure mdmMeasure) {
        this.addToListProperty(MdmXMLTags.MEASURE_REF, mdmMeasure);
        if (this.getMeasureDimension() != null) {
            this.getMeasureDimension().addMeasure(mdmMeasure);
        }
    }

    public final void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeFromListProperty(MdmXMLTags.MEASURE_REF, mdmMeasure);
        if (this.getMeasureDimension() != null) {
            this.getMeasureDimension().removeMeasure(mdmMeasure);
        }
    }

    public final void addDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.addToListProperty(MdmXMLTags.PRIMARY_DIMENSION_REF_CONTAINED, mdmPrimaryDimension);
    }

    public final void removeDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.removeFromListProperty(MdmXMLTags.PRIMARY_DIMENSION_REF_CONTAINED, mdmPrimaryDimension);
    }

    public void addSubSchema(MdmSchema mdmSchema) {
        this.addToListProperty(MdmXMLTags.SCHEMA_REF_CONTAINED, mdmSchema);
    }

    public void removeSubSchema(MdmSchema mdmSchema) {
        this.removeFromListProperty(MdmXMLTags.SCHEMA_REF_CONTAINED, mdmSchema);
    }

    void setMeasureDimension(MdmMeasureDimension mdmMeasureDimension) {
        this.setPropertyObjectValue(MdmXMLTags.MEASURE_DIM_REF_CONTAINED, mdmMeasureDimension);
    }

    public final void addCube(MdmCube mdmCube) {
        this.addToListProperty(MdmXMLTags.CUBE_REF_CONTAINED, mdmCube);
    }

    public final void removeCube(MdmCube mdmCube) {
        this.removeFromListProperty(MdmXMLTags.CUBE_REF_CONTAINED, mdmCube);
    }

    public List getCubes() {
        return this.getPropertyListValues(MdmXMLTags.CUBE_REF_CONTAINED);
    }

    public final MdmSchema getOuterSchema() {
        return (MdmSchema)this.getContainedByObject();
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        if (MdmXMLTags.OWNER == xMLTag) {
            return string;
        }
        return MdmObject.generateIDFromXML(baseMetadataObject, xMLTag, string, string2, string3, metadataXMLReader);
    }
}

