/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.olapi.ArraySet;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.PersistentLanguageFetcher;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.deployment.CubeOrganization;
import oracle.olapi.metadata.deployment.DeploymentException;
import oracle.olapi.metadata.deployment.RolapCubeOrganization;
import oracle.olapi.metadata.mapping.CubeMap;
import oracle.olapi.metadata.mdm.Mdm11_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmDerivedMeasure;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmQuery;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.BaseQuery;
import oracle.olapi.syntax.Buildable;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.Query;
import oracle.olapi.transaction.Branch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdmCube
extends MdmDimensionedObject
implements MdmQuery,
Buildable {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.MEASURES, MdmXMLTags.CONSISTENT_SOLVE, MdmXMLTags.MEASURE_DIMENSION, MdmXMLTags.CUBE_MAPS, MdmXMLTags.OWNER, MdmXMLTags.NAMESPACE, MdmXMLTags.CUBE_ORGANIZATION, MdmXMLTags.ET_VIEW_NAME};
    private BaseQuery m_Query = null;

    MdmCube(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmCube(String string, String string2, short s, BaseMetadataProvider baseMetadataProvider) {
        super(string, string2, s, baseMetadataProvider, null);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public static final XMLTag classGetContainedByPropertyTag() {
        return null;
    }

    @Override
    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        if (mdmObjectVisitor instanceof Mdm11_ObjectVisitor) {
            return ((Mdm11_ObjectVisitor)mdmObjectVisitor).visitMdmCube(this, object);
        }
        return null;
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.CUBE_TAG;
    }

    public final MdmMeasure getMeasure(String string) {
        if (null == string) {
            return null;
        }
        List<MdmMeasure> list = this.getMeasures();
        for (MdmMeasure mdmMeasure : list) {
            if (!string.equals(mdmMeasure.getName())) continue;
            return mdmMeasure;
        }
        return null;
    }

    public final List<MdmMeasure> getMeasures() {
        return this.getPropertyListValues(MdmXMLTags.MEASURES);
    }

    public void addMeasure(MdmMeasure mdmMeasure) {
        this.addToListProperty(MdmXMLTags.MEASURES, mdmMeasure);
    }

    public void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeFromListProperty(MdmXMLTags.MEASURES, mdmMeasure);
    }

    @Override
    public final MdmDatabaseSchema getOwner() {
        return (MdmDatabaseSchema)this.getPropertyObjectValue(MdmXMLTags.OWNER);
    }

    public final void setOwner(MdmDatabaseSchema mdmDatabaseSchema) {
        this.setPropertyObjectValue(MdmXMLTags.OWNER, mdmDatabaseSchema);
    }

    public final String getNamespace() {
        return this.getPropertyStringValue(MdmXMLTags.NAMESPACE);
    }

    protected final void setNamespace(String string) {
        this.setPropertyStringValue(MdmXMLTags.NAMESPACE, string);
    }

    public final List getCubeMaps() {
        return this.getPropertyListValues(MdmXMLTags.CUBE_MAPS);
    }

    public final void addCubeMap(CubeMap cubeMap) {
        this.addToListProperty(MdmXMLTags.CUBE_MAPS, cubeMap);
    }

    public final void removeCubeMap(CubeMap cubeMap) {
        this.removeFromListProperty(MdmXMLTags.CUBE_MAPS, cubeMap);
    }

    private synchronized void createQuery() {
        if (null != this.m_Query) {
            return;
        }
        this.m_Query = new BaseQuery(this);
    }

    @Override
    protected final Set getInputDefinitions() {
        ArraySet arraySet = new ArraySet();
        return arraySet;
    }

    @Override
    protected final List getOutputDefinitions() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    @Override
    protected final SourceDefinition getTypeDefinition() {
        return this.getDataType().getSource().getDefinition();
    }

    public final CubeOrganization getOrganization() {
        return (CubeOrganization)this.getPropertyObjectValue(MdmXMLTags.CUBE_ORGANIZATION);
    }

    private final void setOrganization(CubeOrganization cubeOrganization) {
        this.setPropertyObjectValue(MdmXMLTags.CUBE_ORGANIZATION, cubeOrganization);
    }

    public final AWCubeOrganization createAWOrganization(AW aW, boolean bl) {
        Branch branch = this.getBaseMetadataProvider().getDataProvider().getCurrentSession().getBranch();
        CubeOrganization cubeOrganization = this.getOrganization();
        if (!(null == cubeOrganization || bl && null == branch)) {
            boolean bl2;
            boolean bl3 = bl2 = !bl;
            if (!bl2) {
                if (branch.getAWs().contains(aW)) {
                    bl2 = true;
                } else if (cubeOrganization instanceof AWCubeOrganization && branch.getAWs().contains(((AWCubeOrganization)cubeOrganization).getAW())) {
                    bl2 = true;
                }
            }
            if (bl2) {
                throw new DeploymentException("DimensionAlreadyDeployed", this.getID());
            }
        }
        String string = "$AW_ORGANIZATION";
        String string2 = MdmCube.generateID((BaseMetadataObject)this, string);
        AWCubeOrganization aWCubeOrganization = new AWCubeOrganization(string2, string, 0, (BaseMetadataObject)this);
        aWCubeOrganization.setAW(aW);
        this.setOrganization(aWCubeOrganization);
        if (null != branch && branch.getAWs().contains(aW)) {
            this.createIsolationState(branch);
        }
        return aWCubeOrganization;
    }

    public final AWCubeOrganization findOrCreateAWCubeOrganization(AW aW) {
        String string = "$AW_ORGANIZATION";
        String string2 = MdmCube.generateID((BaseMetadataObject)this, string);
        AWCubeOrganization aWCubeOrganization = (AWCubeOrganization)this.findOrCreateContainedObject(string2, string, (short)0, MdmXMLTags.CUBE_ORGANIZATION, AWCubeOrganization.class);
        aWCubeOrganization.setAW(aW);
        Branch branch = this.getBaseMetadataProvider().getDataProvider().getCurrentSession().getBranch();
        if (null != branch && branch.getAWs().contains(aW)) {
            this.createIsolationState(branch);
        }
        return aWCubeOrganization;
    }

    public final RolapCubeOrganization createRolapOrganization(boolean bl) {
        CubeOrganization cubeOrganization = this.getOrganization();
        if (null != cubeOrganization && !bl) {
            throw new DeploymentException("DimensionAlreadyDeployed", this.getID());
        }
        String string = "$ROLAP_ORGANIZATION";
        String string2 = MdmCube.generateID((BaseMetadataObject)this, string);
        RolapCubeOrganization rolapCubeOrganization = new RolapCubeOrganization(string2, string, 0, (BaseMetadataObject)this);
        this.setOrganization(rolapCubeOrganization);
        return rolapCubeOrganization;
    }

    public final RolapCubeOrganization findOrCreateRolapCubeOrganization() {
        String string = "$ROLAP_ORGANIZATION";
        String string2 = MdmCube.generateID((BaseMetadataObject)this, string);
        RolapCubeOrganization rolapCubeOrganization = (RolapCubeOrganization)this.findOrCreateContainedObject(string2, string, (short)0, MdmXMLTags.CUBE_ORGANIZATION, RolapCubeOrganization.class);
        return rolapCubeOrganization;
    }

    public final ConsistentSolveSpecification getConsistentSolveSpecification() {
        return (ConsistentSolveSpecification)this.getPropertyObjectValue(MdmXMLTags.CONSISTENT_SOLVE);
    }

    public final void setConsistentSolveSpecification(ConsistentSolveSpecification consistentSolveSpecification) {
        this.setPropertyObjectValue(MdmXMLTags.CONSISTENT_SOLVE, consistentSolveSpecification);
    }

    public final String getViewName() {
        return this.getPropertyStringValue(MdmXMLTags.ET_VIEW_NAME);
    }

    public final void setViewName(String string) {
        this.setPropertyStringValue(MdmXMLTags.ET_VIEW_NAME, string);
    }

    @Override
    public final Query getQuery() {
        if (null == this.m_Query) {
            this.createQuery();
        }
        return this.m_Query;
    }

    @Override
    public final List<MdmQueryColumn> getQueryColumns() {
        List list = this.getDimensionality();
        List<MdmMeasure> list2 = this.getMeasures();
        ArrayList<MdmQueryColumn> arrayList = new ArrayList<MdmQueryColumn>();
        for (MdmDimensionality mdmObject : list) {
            arrayList.add(mdmObject.getETColumn());
        }
        for (MdmMeasure mdmMeasure : list2) {
            arrayList.add(mdmMeasure.getETMeasureColumn());
        }
        return arrayList;
    }

    @Override
    public final String getQueryName() {
        return this.getID();
    }

    @Override
    public MdmQueryColumn getQueryColumn(String string) {
        if (null == string) {
            return null;
        }
        List list = this.getDimensionality();
        List<MdmMeasure> list2 = this.getMeasures();
        for (MdmDimensionality mdmObject : list) {
            if (!mdmObject.getETColumn().getName().equals(string)) continue;
            return mdmObject.getETColumn();
        }
        for (MdmMeasure mdmMeasure : list2) {
            if (!mdmMeasure.getETMeasureColumn().getName().equals(string)) continue;
            return mdmMeasure.getETMeasureColumn();
        }
        return null;
    }

    @Override
    public MetadataObject getType() {
        return this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider().getValueDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmBaseMeasure findOrCreateBaseMeasure(String string) {
        MdmBaseMeasure mdmBaseMeasure = null;
        String string2 = MdmCube.generateID((BaseMetadataObject)this, string);
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmBaseMeasure = new MdmBaseMeasure(string, 0, this);
                    this.addMeasure(mdmBaseMeasure);
                    return mdmBaseMeasure;
                }
            }
        }
        if (metadataObject instanceof MdmBaseMeasure) {
            mdmBaseMeasure = (MdmBaseMeasure)metadataObject;
            this.addMeasure(mdmBaseMeasure);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmBaseMeasure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmDerivedMeasure findOrCreateDerivedMeasure(String string) {
        MdmDerivedMeasure mdmDerivedMeasure = null;
        String string2 = MdmCube.generateID((BaseMetadataObject)this, string);
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string2);
                if (null == metadataObject) {
                    mdmDerivedMeasure = new MdmDerivedMeasure(string, 0, this);
                    this.addMeasure(mdmDerivedMeasure);
                    return mdmDerivedMeasure;
                }
            }
        }
        if (metadataObject instanceof MdmDerivedMeasure) {
            mdmDerivedMeasure = (MdmDerivedMeasure)metadataObject;
            this.addMeasure(mdmDerivedMeasure);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return mdmDerivedMeasure;
    }

    public CubeMap createCubeMap() {
        CubeMap cubeMap = null;
        int n = 1;
        List list = this.getCubeMaps();
        if (null != list) {
            n = list.size() + 1;
        }
        String string = "MAP" + n;
        cubeMap = new CubeMap(string, 0, this);
        this.addCubeMap(cubeMap);
        return cubeMap;
    }

    public final CubeMap findOrCreateCubeMap(String string) {
        String string2 = MdmCube.generateID((BaseMetadataObject)this, string);
        CubeMap cubeMap = (CubeMap)this.findOrCreateContainedObject(string2, string, (short)0, MdmXMLTags.CUBE_MAPS, CubeMap.class);
        return cubeMap;
    }

    public List getPersistentLanguages() {
        return PersistentLanguageFetcher.fetchPersistentLanguages(new String[]{this.getID()}, this.getMetadataProvider().getDataProvider());
    }

    @Override
    protected String generateInternalID() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(this.getInternalID().length());
        String string2 = this.getNamespace();
        if (null != string2 && string2.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append("..");
        }
        if (null != (string = this.getOwnerName()) && string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(".");
        }
        stringBuffer.append(this.getName());
        String string3 = stringBuffer.toString();
        if (string3.equals(this.getInternalID())) {
            return null;
        }
        return string3;
    }
}

