/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.olapi.metadata.mdm.CubeUpgradeInfoSelector;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_NamingConvention;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmAttributeModel;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmBaseObjectVisitor;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDerivedAttribute;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMeasureModel;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmMultiValuedDerivedAttribute;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.syntax.parser.Identifier;

public final class Mdm9iNamingConvention
extends MdmBaseObjectVisitor
implements Mdm10_1_0_3_NamingConvention {
    private String m_OwnerName;
    private MdmMetadataProvider m_MetadataProvider;
    private static int CLONE_COUNT = 0;
    public static final String DIMENSION_PREFIX = "D_";
    public static final String MEASURE_PREFIX = "M_";
    public static final String SCHEMA_PREFIX = "C_";
    public static final String LEVEL_COMPONENT = "L";
    public static final String MODEL_COMPONENT = "MODEL";
    public static final String CALCMODEL_COMPONENT = "CALCMODEL";
    public static final String STRING_COMPONENT = "DataType!String";
    public static final String BOOLEAN_COMPONENT = "DataType!Boolean";
    public static final String DATE_COMPONENT = "DataType!Date";
    public static final String NUMBER_COMPONENT = "DataType!Number";
    public static final String VALUE_COMPONENT = "DataType!Value";
    public static final String MEASURE_DIMENSION_ID = "MEASUREDIMENSION";
    public static final String PARENT_ATTR_STR = "PARENT_ATTRIBUTE";
    public static final String ANCESTORS_ATTR_STR = "ANCESTORS_ATTRIBUTE";
    public static final String LEVEL_ATTR_STR = "LEVEL_ATTRIBUTE";
    public static final String LEVEL_DEPTH_ATTR_STR = "LEVELDEPTH_ATTRIBUTE";
    public static final String LOCAL_VALUE_ATTR_STR = "LOCAL_VALUE_ATTRIBUTE";
    public static final String HIERARCHY_ATTR_STR = "HIERARCHY_ATTRIBUTE";
    public static final String IS_CUSTOM_MEMBER_ATTR_STR = "ISCUSTOMMEMBER_ATTRIBUTE";
    public static final String VALUE_LINEAGE_ATTR_STR = "VALUE_LINEAGE_ATTRIBUTE";

    public Mdm9iNamingConvention(String string, MdmMetadataProvider mdmMetadataProvider) {
        this.m_OwnerName = string;
        this.m_MetadataProvider = mdmMetadataProvider;
    }

    public String getOwnerName() {
        return this.m_OwnerName;
    }

    public static String getOwnerName(MdmMetadataProvider mdmMetadataProvider, MdmObject mdmObject) {
        String string = null;
        if (!mdmMetadataProvider.getDataProvider().read11gMetadata()) {
            string = Mdm9iNamingConvention.getIDComponent(mdmObject.getID(), 0);
        } else {
            MdmSchema mdmSchema = mdmObject.getOwner();
            string = mdmSchema.getName();
        }
        return string;
    }

    private void setOwnerName(String string) {
        this.m_OwnerName = string;
    }

    public String generateSchemaID(String string) {
        return this.generateSchemaID(string, false);
    }

    private String generateSchemaID(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(SCHEMA_PREFIX);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private String generateRootSchemaID() {
        return "RootSchema";
    }

    public String generatePrimaryDimensionID(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DIMENSION_PREFIX);
        stringBuffer.append(this.getOwnerName());
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String generateHierarchyID(MdmPrimaryDimension mdmPrimaryDimension, String string) {
        return this.generateHierarchyID(mdmPrimaryDimension.getID(), string);
    }

    private String generateHierarchyID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String generateLevelID(MdmLevelHierarchy mdmLevelHierarchy, String string) {
        return this.generateLevelID(mdmLevelHierarchy.getID(), string);
    }

    private String generateLevelID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(LEVEL_COMPONENT);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String generateAttributeID(MdmPrimaryDimension mdmPrimaryDimension, String string) {
        return this.generateAttributeID(mdmPrimaryDimension.getID(), string);
    }

    private String generateAttributeID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String generateDerivedAttributeID(MdmPrimaryDimension mdmPrimaryDimension, String string) {
        String string2 = null;
        if ("Parent" == string) {
            string2 = PARENT_ATTR_STR;
        } else if ("Ancestors" == string) {
            string2 = ANCESTORS_ATTR_STR;
        } else if ("Level" == string) {
            string2 = LEVEL_ATTR_STR;
        } else if ("LevelDepth" == string) {
            string2 = LEVEL_DEPTH_ATTR_STR;
        } else if ("LocalValue" == string) {
            string2 = LOCAL_VALUE_ATTR_STR;
        } else if ("Hierarchy" == string) {
            string2 = HIERARCHY_ATTR_STR;
        } else if ("IsCustomMember" == string) {
            string2 = IS_CUSTOM_MEMBER_ATTR_STR;
        } else if ("ValueLineage" == string) {
            string2 = VALUE_LINEAGE_ATTR_STR;
        }
        return this.generateDerivedAttributeID(mdmPrimaryDimension.getID(), string2, false);
    }

    private String generateDerivedAttributeID(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (!bl) {
            stringBuffer.append(".");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String generateMeasureID(MtmPartitionedCube mtmPartitionedCube, String string) {
        String string2 = mtmPartitionedCube.getCubeName();
        if (null == string2) {
            string2 = mtmPartitionedCube.getID();
        }
        return this.generateMeasureID(string2, string);
    }

    private String generateMeasureID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String generateCubeID(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MEASURE_PREFIX);
        stringBuffer.append(this.getOwnerName());
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String generateMeasureDimensionID() {
        return this.generateMeasureDimensionID(false, false);
    }

    private String generateMeasureDimensionID(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        if (bl) {
            stringBuffer.append(DIMENSION_PREFIX);
            bl3 = true;
        }
        if (!bl2) {
            stringBuffer.append(this.getOwnerName());
            bl3 = true;
        }
        if (bl3) {
            stringBuffer.append(".");
        }
        stringBuffer.append(MEASURE_DIMENSION_ID);
        return stringBuffer.toString();
    }

    public String generateCloneID(MdmObject mdmObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(mdmObject.getID());
        stringBuffer.append(".CLONE.");
        stringBuffer.append(CLONE_COUNT++);
        return stringBuffer.toString();
    }

    public String generateDimensionCalculationModelID(MdmPrimaryDimension mdmPrimaryDimension, String string) {
        return this.generateDimensionCalculationModelID(mdmPrimaryDimension.getID(), string);
    }

    private String generateDimensionCalculationModelID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(CALCMODEL_COMPONENT);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String generateAttributeModelID(MdmAttribute mdmAttribute) {
        return this.generateAttributeModelID(mdmAttribute.getID());
    }

    private String generateAttributeModelID(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(MODEL_COMPONENT);
        return stringBuffer.toString();
    }

    public String generateMeasureModelID(MdmMeasure mdmMeasure) {
        return this.generateMeasureModelID(mdmMeasure.getID());
    }

    private String generateMeasureModelID(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(MODEL_COMPONENT);
        return stringBuffer.toString();
    }

    public String generateCustomMemberID(MdmLevel mdmLevel, String string) {
        return this.generateCustomMemberID(mdmLevel.getID(), string);
    }

    public String generateCustomMemberID(MdmValueHierarchy mdmValueHierarchy, String string) {
        return this.generateCustomMemberID(mdmValueHierarchy.getID(), string);
    }

    private String generateCustomMemberID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String generateCustomMeasureID(MdmMeasureDimension mdmMeasureDimension, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CUSTOM_MEASURES.");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public final String generateID(MdmObject mdmObject) {
        if (!this.getMdmMetadataProvider().getDataProvider().isServerVersionLaterThan(new int[]{11, 0, 0, 0})) {
            return mdmObject.getID();
        }
        String string = Mdm9iNamingConvention.getOwnerName(this.getMdmMetadataProvider(), mdmObject);
        String string2 = this.getOwnerName();
        this.setOwnerName(string);
        String string3 = this.generateID(mdmObject, null);
        this.setOwnerName(string2);
        return string3;
    }

    private String generateID(MdmObject mdmObject, Object object) {
        return (String)mdmObject.acceptVisitor(this, object);
    }

    private String getObjectName(MdmObject mdmObject, Object object) {
        CubeUpgradeInfoSelector cubeUpgradeInfoSelector = this.getCubeUpgradeInfoSelector();
        String string = cubeUpgradeInfoSelector.getOldName(mdmObject);
        if (null != string) {
            return string;
        }
        return mdmObject.getName();
    }

    private CubeUpgradeInfoSelector getCubeUpgradeInfoSelector() {
        return CubeUpgradeInfoSelector.getInstance(this.getMdmMetadataProvider());
    }

    public Object visitMdmObject(MdmObject mdmObject, Object object) {
        return null;
    }

    public Object visitMdmOrganizationalSchema(MdmOrganizationalSchema mdmOrganizationalSchema, Object object) {
        String string = this.getObjectName(mdmOrganizationalSchema, object);
        return this.generateSchemaID(string, true);
    }

    public Object visitMdmRootSchema(MdmRootSchema mdmRootSchema, Object object) {
        return this.generateRootSchemaID();
    }

    public Object visitMdmSchema(MdmSchema mdmSchema, Object object) {
        if (mdmSchema.getName().equals("RootSchema")) {
            return this.generateRootSchemaID();
        }
        String string = this.getObjectName(mdmSchema, object);
        return this.generateSchemaID(string, true);
    }

    public Object visitMdmPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension, Object object) {
        String string = this.getObjectName(mdmPrimaryDimension, object);
        return this.generatePrimaryDimensionID(string);
    }

    public Object visitMdmMeasureDimension(MdmMeasureDimension mdmMeasureDimension, Object object) {
        boolean bl = object instanceof MdmHierarchy;
        return this.generateMeasureDimensionID(bl, true);
    }

    public Object visitMdmHierarchy(MdmHierarchy mdmHierarchy, Object object) {
        String string = this.generateID(mdmHierarchy.getPrimaryDimension(), mdmHierarchy);
        String string2 = this.getObjectName(mdmHierarchy, object);
        return this.generateHierarchyID(string, string2);
    }

    public Object visitMdmHierarchyLevel(MdmHierarchyLevel mdmHierarchyLevel, Object object) {
        String string = this.generateID(mdmHierarchyLevel.getLevelHierarchy(), null);
        String string2 = this.getObjectName(mdmHierarchyLevel, object);
        return this.generateLevelID(string, string2);
    }

    public Object visitMdmBaseAttribute(MdmBaseAttribute mdmBaseAttribute, Object object) {
        if (!this.getMdmMetadataProvider().getDataProvider().read11gMetadata()) {
            return this.visitMdmDerivedAttribute(mdmBaseAttribute, object);
        }
        return this.visitMdmAttribute(mdmBaseAttribute, object);
    }

    public Object visitMdmAttribute(MdmAttribute mdmAttribute, Object object) {
        String string = this.generateID(mdmAttribute.getPrimaryDimension(), null);
        String string2 = this.getObjectName(mdmAttribute, object);
        return this.generateAttributeID(string, string2);
    }

    public Object visitMdmDerivedAttribute(MdmDerivedAttribute mdmDerivedAttribute, Object object) {
        return this.visitMdmDerivedAttribute((MdmAttribute)mdmDerivedAttribute, object);
    }

    public Object visitMdmMultiValuedDerivedAttribute(MdmMultiValuedDerivedAttribute mdmMultiValuedDerivedAttribute, Object object) {
        return this.visitMdmDerivedAttribute(mdmMultiValuedDerivedAttribute, object);
    }

    private Object visitMdmDerivedAttribute(MdmAttribute mdmAttribute, Object object) {
        MdmPrimaryDimension mdmPrimaryDimension = mdmAttribute.getPrimaryDimension();
        String string = null;
        if (mdmPrimaryDimension.getParentAttribute() == mdmAttribute) {
            string = PARENT_ATTR_STR;
        } else if (mdmPrimaryDimension.getLevelAttribute() == mdmAttribute) {
            string = LEVEL_ATTR_STR;
        } else if (mdmPrimaryDimension.getLevelDepthAttribute() == mdmAttribute) {
            string = LEVEL_DEPTH_ATTR_STR;
        } else if (mdmPrimaryDimension.getLocalValueAttribute() == mdmAttribute) {
            string = LOCAL_VALUE_ATTR_STR;
        } else if (mdmPrimaryDimension.getHierarchyAttribute() == mdmAttribute) {
            string = HIERARCHY_ATTR_STR;
        } else if (mdmPrimaryDimension.getIsCustomMemberAttribute() == mdmAttribute) {
            string = IS_CUSTOM_MEMBER_ATTR_STR;
        } else if (mdmPrimaryDimension.getValueLineageAttribute() == mdmAttribute) {
            string = VALUE_LINEAGE_ATTR_STR;
        } else if (mdmPrimaryDimension.getAncestorsAttribute() == mdmAttribute) {
            string = ANCESTORS_ATTR_STR;
        } else {
            return this.visitMdmAttribute(mdmAttribute, object);
        }
        String string2 = this.generateID(mdmPrimaryDimension, null);
        return this.generateDerivedAttributeID(string2, string, true);
    }

    public Object visitMdmDimensionCalculationModel(MdmDimensionCalculationModel mdmDimensionCalculationModel, Object object) {
        MdmPrimaryDimension mdmPrimaryDimension = mdmDimensionCalculationModel.getMdmDimension();
        String string = null;
        if (mdmPrimaryDimension.getBooleanCalcModel() == mdmDimensionCalculationModel) {
            string = BOOLEAN_COMPONENT;
        } else if (mdmPrimaryDimension.getStringCalcModel() == mdmDimensionCalculationModel) {
            string = STRING_COMPONENT;
        } else if (mdmPrimaryDimension.getDateCalcModel() == mdmDimensionCalculationModel) {
            string = DATE_COMPONENT;
        } else if (mdmPrimaryDimension.getNumberCalcModel() == mdmDimensionCalculationModel) {
            string = NUMBER_COMPONENT;
        } else if (mdmPrimaryDimension instanceof MdmMeasureDimension && ((MdmMeasureDimension)mdmPrimaryDimension).getValueCalcModel() == mdmDimensionCalculationModel) {
            string = VALUE_COMPONENT;
        } else {
            return super.visitMdmDimensionCalculationModel(mdmDimensionCalculationModel, object);
        }
        String string2 = this.generateID(mdmPrimaryDimension, null);
        return this.generateDimensionCalculationModelID(string2, string);
    }

    public Object visitMdmAttributeModel(MdmAttributeModel mdmAttributeModel, Object object) {
        String string = this.generateID(mdmAttributeModel.getMdmAttribute(), null);
        return this.generateAttributeModelID(string);
    }

    public Object visitMdmMeasure(MdmMeasure mdmMeasure, Object object) {
        String string;
        Object object2;
        MdmCube mdmCube = mdmMeasure.getCube();
        String string2 = null;
        if (null == mdmCube) {
            string2 = Mdm9iNamingConvention.getIDComponent(mdmMeasure.getID(), 1);
            object2 = this.getCubeUpgradeInfoSelector();
            string = ((CubeUpgradeInfoSelector)object2).getOldCubeName(this.getOwnerName(), string2);
            if (null != string) {
                string2 = string;
            }
        } else {
            string2 = this.getObjectName(mdmCube, null);
        }
        object2 = this.generateCubeID(string2);
        string = this.getObjectName(mdmMeasure, object);
        return this.generateMeasureID((String)object2, string);
    }

    public Object visitMdmMeasureModel(MdmMeasureModel mdmMeasureModel, Object object) {
        String string = this.generateID(mdmMeasureModel.getMdmMeasure(), null);
        return this.generateMeasureModelID(string);
    }

    private MdmMetadataProvider getMdmMetadataProvider() {
        return this.m_MetadataProvider;
    }

    private static String getIDComponent(String string, int n) {
        Identifier identifier = Identifier.parseID(string);
        if (identifier.hasNamespace()) {
            ++n;
        }
        return identifier.getComponent(n);
    }
}

