/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAttribute;
import oracle.olapi.metadata.conversion.LegacyXMLAttributeProjection;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLObject;
import oracle.olapi.metadata.conversion.LegacyXMLPreComputeClause;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmViewColumn;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.HierarchicalCondition;
import oracle.olapi.syntax.ListComparisonCondition;
import oracle.olapi.syntax.NumberExpression;
import oracle.olapi.syntax.StringExpression;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LegacyXMLDimensionMemberExpression
extends LegacyXMLBaseObject {
    private LegacyXMLObject m_ExprObject = null;
    private List<String> m_ExprDimMembers = null;
    private String m_ExprHierRel = null;
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.EXPRESSION_TYPE, LegacyXMLTags.EXPRESSION, LegacyXMLTags.LEVEL_REF};
    private static final String EXPRESSION_ALL = "ALL";
    private static final String EXPRESSION_LIST = ":LIST:";
    private static final String EXPRESSION_PARENT = "PARENT";
    private static final String EXPRESSION_CHILDREN = "CHILDREN";
    private static final String EXPRESSION_ANCESTORS = "ANCESTORS";
    private static final String EXPRESSION_DESCENDANTS = "DESCENDANTS";
    private static final String HIERARCHY_ID = ".HIERARCHY";

    protected LegacyXMLDimensionMemberExpression(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getExpressionType() {
        return this.getPropertyStringValue(LegacyXMLTags.EXPRESSION_TYPE);
    }

    String getExpression() {
        return this.getPropertyStringValue(LegacyXMLTags.EXPRESSION);
    }

    LegacyXMLLevel getLevel() {
        return (LegacyXMLLevel)this.getPropertyObjectValue(LegacyXMLTags.LEVEL_REF);
    }

    LegacyXMLPreComputeClause getPreComputeClause() {
        return (LegacyXMLPreComputeClause)this.getContainedByObject();
    }

    LegacyXMLObject getExpressionObject() {
        return this.m_ExprObject;
    }

    List<String> getExpressionDimensionMemberValues() {
        return this.m_ExprDimMembers;
    }

    String getExpressionHierarchyRelation() {
        return this.m_ExprHierRel;
    }

    Condition createPrecomputeCondition() {
        Object object;
        List<String> list = this.getExpressionDimensionMemberValues();
        if (null != this.getLevel()) {
            String string = "=";
            if ("EXCLUDE" == this.getExpressionType()) {
                string = "!=";
            }
            LegacyXMLLevel legacyXMLLevel = this.getLevel();
            MdmDimensionLevel mdmDimensionLevel = legacyXMLLevel.getMdmDimensionLevel();
            StringExpression stringExpression = new StringExpression(mdmDimensionLevel.getName());
            LegacyXMLDimension legacyXMLDimension = legacyXMLLevel.getDimension();
            MdmPrimaryDimension mdmPrimaryDimension = legacyXMLDimension.getMdmPrimaryDimension();
            ColumnExpression columnExpression = new ColumnExpression(mdmPrimaryDimension.getETLevelNameColumn(), mdmPrimaryDimension.getQuery());
            return new ValueComparisonCondition(columnExpression, string, stringExpression);
        }
        if (null == this.getExpressionObject()) {
            String string = "=";
            if ("EXCLUDE" == this.getExpressionType()) {
                string = "!=";
            }
            NumberExpression numberExpression = new NumberExpression(1);
            NumberExpression numberExpression2 = new NumberExpression(1);
            return new ValueComparisonCondition(numberExpression, string, numberExpression2);
        }
        if (null != this.getExpressionHierarchyRelation()) {
            boolean bl = false;
            if ("EXCLUDE" == this.getExpressionType()) {
                bl = true;
            }
            LegacyXMLHierarchy legacyXMLHierarchy = (LegacyXMLHierarchy)this.getExpressionObject();
            MdmHierarchy mdmHierarchy = legacyXMLHierarchy.getMdmHierarchy();
            MdmPrimaryDimension mdmPrimaryDimension = mdmHierarchy.getPrimaryDimension();
            ColumnExpression columnExpression = new ColumnExpression(mdmPrimaryDimension.getETKeyColumn(), mdmPrimaryDimension.getQuery());
            StringExpression stringExpression = new StringExpression(list.get(0));
            String string = this.getExpressionHierarchyRelation();
            return new HierarchicalCondition(columnExpression, string, stringExpression, mdmHierarchy, bl, false);
        }
        if (list.size() > 1) {
            String string = "=";
            if ("EXCLUDE" == this.getExpressionType()) {
                string = "!=";
            }
            TypedExpression[] typedExpressionArray = new TypedExpression[list.size()];
            Iterator<String> iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                typedExpressionArray[n] = new StringExpression(iterator.next());
                ++n;
            }
            LegacyXMLDimension legacyXMLDimension = (LegacyXMLDimension)this.getExpressionObject();
            MdmPrimaryDimension mdmPrimaryDimension = legacyXMLDimension.getMdmPrimaryDimension();
            ColumnExpression columnExpression = new ColumnExpression(mdmPrimaryDimension.getETKeyColumn(), mdmPrimaryDimension.getQuery());
            return new ListComparisonCondition((TypedExpression)columnExpression, string, "ANY", typedExpressionArray);
        }
        String string = "=";
        if ("EXCLUDE" == this.getExpressionType()) {
            string = "!=";
        }
        StringExpression stringExpression = new StringExpression(list.get(0));
        MdmPrimaryDimension mdmPrimaryDimension = null;
        MdmViewColumn mdmViewColumn = null;
        if (this.getExpressionObject() instanceof LegacyXMLDimension) {
            object = (LegacyXMLDimension)this.getExpressionObject();
            mdmPrimaryDimension = ((LegacyXMLDimension)object).getMdmPrimaryDimension();
            mdmViewColumn = mdmPrimaryDimension.getETKeyColumn();
        } else {
            object = (LegacyXMLAttribute)this.getExpressionObject();
            MdmBaseAttribute mdmBaseAttribute = ((LegacyXMLAttribute)object).getMdmBaseAttribute();
            mdmPrimaryDimension = mdmBaseAttribute.getPrimaryDimension();
            mdmViewColumn = mdmBaseAttribute.getETAttributeColumn();
        }
        object = new ColumnExpression(mdmViewColumn, mdmPrimaryDimension.getQuery());
        return new ValueComparisonCondition((TypedExpression)object, string, stringExpression);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.DIMENSION_MEMBER_EXPRESSION_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        LegacyXMLDimension legacyXMLDimension = this.getPreComputeClause().getAggregationHierarchySpecification().getAggregationDimension();
        if (null == legacyXMLDimension) {
            return false;
        }
        if (null != this.getLevel()) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.EXPRESSION, this.getExpression(), this);
            if (this.getLevel().getDimension() != legacyXMLDimension) {
                legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.LEVEL_REF, this.getLevel(), this, false);
            }
        } else {
            legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.EXPRESSION, this.getExpression(), this);
            if (!this.parseExpression(legacyXMLConverter)) {
                legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.EXPRESSION, this.getExpression(), this, false);
            }
            if (null != this.getExpressionObject()) {
                if (!this.getExpressionObject().isValid()) {
                    return false;
                }
                LegacyXMLDimension legacyXMLDimension2 = null;
                legacyXMLDimension2 = this.getExpressionObject() instanceof LegacyXMLDimension ? (LegacyXMLDimension)this.getExpressionObject() : (this.getExpressionObject() instanceof LegacyXMLHierarchy ? ((LegacyXMLHierarchy)this.getExpressionObject()).getDimension() : ((LegacyXMLAttribute)this.getExpressionObject()).getDimension());
                if (legacyXMLDimension != legacyXMLDimension2) {
                    legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.EXPRESSION, this.getExpression(), this, false);
                }
            }
        }
        return true;
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        if (null != this.getLevel()) {
            return this.getLevel().getConvertOrderNumber(legacyXMLConverter);
        }
        if (this.parseExpression(legacyXMLConverter) && null != this.getExpressionObject()) {
            return this.getExpressionObject().getConvertOrderNumber(legacyXMLConverter);
        }
        return super.getBaseConvertOrderNumber(legacyXMLConverter);
    }

    private boolean parseExpression(LegacyXMLConverter legacyXMLConverter) {
        String string = this.getExpression();
        if (null == string) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        LegacyXMLObject legacyXMLObject = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        if (EXPRESSION_ALL.equals(string)) {
            return true;
        }
        int n = string.indexOf(46);
        if (-1 == n || string.length() - 1 == n) {
            return false;
        }
        int n2 = string.indexOf(46, n + 1);
        int n3 = string.indexOf(58, n + 1);
        if (-1 == n3) {
            n3 = string.indexOf(61, n + 1);
        }
        if (-1 == n3 || n3 == string.length() - 1) {
            return false;
        }
        if (n2 > n3) {
            n2 = -1;
        }
        String string3 = string.substring(0, n3);
        if (-1 != n2 && ':' == string.charAt(n3)) {
            string2 = string.substring(n + 1, n2);
            if (EXPRESSION_PARENT.equals(string2)) {
                string2 = EXPRESSION_PARENT;
            } else if (EXPRESSION_CHILDREN.equals(string2)) {
                string2 = "CHILD";
            } else if (EXPRESSION_ANCESTORS.equals(string2)) {
                string2 = "ANCESTOR";
            } else if (EXPRESSION_DESCENDANTS.equals(string2)) {
                string2 = "DESCENDANT";
            } else {
                return false;
            }
            string3 = string.substring(0, n) + string.substring(n2, n3) + HIERARCHY_ID;
        }
        if (null == (legacyXMLObject = legacyXMLConverter.getMetadataReader().lookupObjectReference(string3))) {
            return false;
        }
        if (null != string2 ? !(legacyXMLObject instanceof LegacyXMLHierarchy) : (-1 != n2 ? !(legacyXMLObject instanceof LegacyXMLAttribute) || legacyXMLObject instanceof LegacyXMLAttributeProjection : !(legacyXMLObject instanceof LegacyXMLDimension))) {
            return false;
        }
        String string4 = null;
        if (string.length() > n3 + EXPRESSION_LIST.length() && EXPRESSION_LIST.equals(string.substring(n3, n3 + EXPRESSION_LIST.length()))) {
            int n4 = string.indexOf(39, n3 + 1);
            while (-1 != n4) {
                if (string.length() - 1 == n4) {
                    return false;
                }
                int n5 = string.indexOf(39, n4 + 1);
                if (-1 == n5) {
                    return false;
                }
                string4 = string.substring(n4 + 1, n5);
                arrayList.add(string4);
                if (string.length() - 1 == n5) {
                    n4 = -1;
                    continue;
                }
                n4 = string.indexOf(39, n5 + 1);
            }
            if (0 == arrayList.size()) {
                return false;
            }
        } else {
            if (n3 + 2 >= string.length() || '\'' != string.charAt(n3 + 1) || '\'' != string.charAt(string.length() - 1)) {
                return false;
            }
            string4 = string.substring(n3 + 2, string.length() - 1);
            arrayList.add(string4);
        }
        this.m_ExprObject = legacyXMLObject;
        this.m_ExprHierRel = string2;
        this.m_ExprDimMembers = arrayList;
        return true;
    }
}

