/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAW;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLIndex;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLMemberSelection;
import oracle.olapi.metadata.conversion.LegacyXMLModel;
import oracle.olapi.metadata.conversion.LegacyXMLPermanentCalculatedMember;
import oracle.olapi.metadata.conversion.LegacyXMLSessionCalculatedMember;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWPrimaryDimensionOrganization;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LegacyXMLDimension
extends LegacyXMLAWObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.IS_TIME, LegacyXMLTags.IS_MEASURE, LegacyXMLTags.USE_NATIVE_KEY, LegacyXMLTags.HIERARCHIES, LegacyXMLTags.MEMBER_SELECTIONS, LegacyXMLTags.SESSION_CALCULATED_MEMBERS, LegacyXMLTags.PERMANENT_CALCULATED_MEMBERS, LegacyXMLTags.MODELS, LegacyXMLTags.INDEXES};

    protected LegacyXMLDimension(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    boolean getIsTime() {
        return this.getPropertyBooleanValue(LegacyXMLTags.IS_TIME);
    }

    boolean getIsMeasure() {
        return this.getPropertyBooleanValue(LegacyXMLTags.IS_MEASURE);
    }

    boolean getUseNativeKey() {
        return this.getPropertyBooleanValue(LegacyXMLTags.USE_NATIVE_KEY);
    }

    List<LegacyXMLHierarchy> getHierarchies() {
        return this.getPropertyListValues(LegacyXMLTags.HIERARCHIES);
    }

    List<LegacyXMLMemberSelection> getMemberSelections() {
        return this.getPropertyListValues(LegacyXMLTags.MEMBER_SELECTIONS);
    }

    List<LegacyXMLSessionCalculatedMember> getSessionCalculatedMembers() {
        return this.getPropertyListValues(LegacyXMLTags.SESSION_CALCULATED_MEMBERS);
    }

    List<LegacyXMLPermanentCalculatedMember> getPermanentCalculatedMembers() {
        return this.getPropertyListValues(LegacyXMLTags.PERMANENT_CALCULATED_MEMBERS);
    }

    List<LegacyXMLModel> getModels() {
        return this.getPropertyListValues(LegacyXMLTags.MODELS);
    }

    List<LegacyXMLIndex> getIndexes() {
        return this.getPropertyListValues(LegacyXMLTags.INDEXES);
    }

    LegacyXMLAW getAW() {
        return (LegacyXMLAW)this.getContainedByObject();
    }

    MdmPrimaryDimension getMdmPrimaryDimension() {
        return (MdmPrimaryDimension)this.getConvertToObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.DIMENSION_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        if (this.getIsMeasure()) {
            String[] stringArray = new String[]{"MeasureDimension", this.getID()};
            legacyXMLConverter.reportError("UnsupportedTypeConversion", stringArray);
        }
        return true;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmPrimaryDimension mdmPrimaryDimension = null;
        String string = this.getName();
        MdmDatabaseSchema mdmDatabaseSchema = this.getMdmDatabaseSchema(legacyXMLConverter);
        mdmPrimaryDimension = this.getIsTime() ? mdmDatabaseSchema.findOrCreateTimeDimension(string) : mdmDatabaseSchema.findOrCreateStandardDimension(string);
        if (mdmPrimaryDimension.isPersistent()) {
            legacyXMLConverter.reportError("DuplicateMetadataID", mdmPrimaryDimension.getID());
        }
        AW aW = this.getAW().getMdmAW();
        AWPrimaryDimensionOrganization aWPrimaryDimensionOrganization = mdmPrimaryDimension.findOrCreateAWPrimaryDimensionOrganization(aW);
        aWPrimaryDimensionOrganization.setAddUniqueKeyPrefix(!this.getUseNativeKey());
        this.setMdmPrimaryDimension(mdmPrimaryDimension);
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    void validateSubDimRefs(LegacyXMLConverter legacyXMLConverter, LegacyXMLHierarchy legacyXMLHierarchy, LegacyXMLLevel legacyXMLLevel, LegacyXMLBaseObject legacyXMLBaseObject) {
        if (null != legacyXMLHierarchy) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.HIERARCHY_REF, legacyXMLHierarchy, legacyXMLBaseObject);
        }
        if (null != legacyXMLLevel) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.LEVEL_REF, legacyXMLLevel, legacyXMLBaseObject);
        }
    }

    private void setMdmPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.setConvertToObject(mdmPrimaryDimension);
    }
}

