/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import oracle.olapi.version.Version;

public final class MetadataXMLFormat {
    public static final int MODE_10G = 0;
    public static final int MODE_11G_FULL_XML = 1;
    public static final int MODE_11G_PARTIAL_XML = 2;
    public static final String VERSION_LATEST = "1.2";
    public static final String VERSION_1_2 = "1.2";
    public static final String DB_VERSION_11_2 = "11.2";
    public static final String VERSION_1_1 = "1.1";
    public static final String DB_VERSION_11_1_0_7 = "11.1.0.7";
    public static final String VERSION_1_0 = "1.0";
    public static final String DB_VERSION_11_1_0_6 = "11.1.0.6";
    public static final String VERSION_0_1 = "0.1";
    private int m_Mode;
    private String m_VersionStr = null;
    private String m_DatabaseVersionStr = null;
    private Version m_Version = null;

    public MetadataXMLFormat(String string) {
        this(1, string);
    }

    public MetadataXMLFormat(int n, String string) {
        this.setMode(n);
        this.setVersionStr(string);
    }

    public int getMode() {
        return this.m_Mode;
    }

    public void setMode(int n) {
        this.m_Mode = n;
    }

    public String getVersion() {
        return this.m_VersionStr;
    }

    public String getDatabaseVersion() {
        return this.m_DatabaseVersionStr;
    }

    public void setVersionStr(String string) {
        if ("1.2".equals(string)) {
            this.m_VersionStr = "1.2";
            this.m_DatabaseVersionStr = DB_VERSION_11_2;
        } else if (VERSION_1_1.equals(string)) {
            this.m_VersionStr = VERSION_1_1;
            this.m_DatabaseVersionStr = DB_VERSION_11_1_0_7;
        } else if (VERSION_1_0.equals(string)) {
            this.m_VersionStr = VERSION_1_0;
            this.m_DatabaseVersionStr = DB_VERSION_11_1_0_6;
        } else {
            this.m_VersionStr = VERSION_0_1;
            this.m_DatabaseVersionStr = "";
        }
        this.m_Version = new Version(string);
    }

    public boolean is10gMode() {
        return this.getMode() == 0;
    }

    public boolean is11gFullXMLMode() {
        return this.getMode() == 1;
    }

    public boolean is11gPartialXMLMode() {
        return this.getMode() == 2;
    }

    public boolean isSameOrLaterThan(String string) {
        Version version = new Version(string);
        return this.m_Version.isSameOrLaterThan(version);
    }
}

