/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import oracle.olapi.log.LogEndEvent;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.LogEventVisitorAdapter;
import oracle.olapi.log.LogExceptionEvent;
import oracle.olapi.log.LogSimpleEvent;

class Formatter
extends LogEventVisitorAdapter {
    private StringWriter sWriter = new StringWriter();
    private PrintWriter exWriter = new PrintWriter(this.sWriter);
    private static String INDENT = "                         ";
    private static final MessageFormat simpleEventFormat = new MessageFormat("{0, date} {0, time} [{1}] : {2}");
    private static final MessageFormat durationEventFormat = new MessageFormat("{0, date} {0, time} [{1}] : {2} ({3} ms)");
    private static final MessageFormat exceptionEventFormat = new MessageFormat("{0, date} {0, time} [{1}] : {2}\n{3}");

    private void resetExWriter() {
        this.sWriter.getBuffer().setLength(0);
    }

    private String getIndentedMessage(LogEvent logEvent) {
        if (logEvent.getIndent() >= INDENT.length()) {
            return INDENT + logEvent.getMessage();
        }
        return INDENT.substring(0, logEvent.getIndent()) + logEvent.getMessage();
    }

    public Object visitLogSimpleEvent(LogSimpleEvent logSimpleEvent, Object object) {
        return simpleEventFormat.format(new Object[]{new Date(logSimpleEvent.getTimeStamp()), this.getInfoText(logSimpleEvent.getLevel()), this.getIndentedMessage(logSimpleEvent)});
    }

    public Object visitLogEndEvent(LogEndEvent logEndEvent, Object object) {
        return durationEventFormat.format(new Object[]{new Date(logEndEvent.getStartEvent().getTimeStamp()), this.getInfoText(logEndEvent.getLevel()), this.getIndentedMessage(logEndEvent), new Long(logEndEvent.getElapsedInMillis())});
    }

    public Object visitLogExceptionEvent(LogExceptionEvent logExceptionEvent, Object object) {
        this.resetExWriter();
        logExceptionEvent.getThrowable().printStackTrace(this.exWriter);
        this.exWriter.flush();
        return exceptionEventFormat.format(new Object[]{new Date(logExceptionEvent.getTimeStamp()), this.getInfoText(logExceptionEvent.getLevel()), this.getIndentedMessage(logExceptionEvent), this.exWriter.toString()});
    }

    private String getInfoText(int n) {
        switch (n) {
            case 1: {
                return "INFO   ";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "ERROR  ";
            }
            case 4: {
                return "FATAL  ";
            }
        }
        return "       ";
    }
}

