/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.LogHandler;
import oracle.olapi.log.LogHandlerFactory;
import oracle.olapi.log.LogNestedHandler;

public class BufferedLogHandler
implements LogHandlerFactory {
    public static final int DEFAULT_CACHE_SIZE = 20;
    public static final String BUFFERSIZE_KEY = "size";

    public LogHandler createLogHandler(Properties properties) {
        try {
            LogHandler logHandler;
            int n = Integer.parseInt(properties.getProperty(BUFFERSIZE_KEY, "0"));
            if (n <= 0) {
                n = 20;
            }
            return (logHandler = LogNestedHandler.createNestedInstance(properties)) != null ? new Handler(logHandler, n) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Handler
    extends LogNestedHandler {
        private Vector cache = null;
        private int maxSize = 0;

        public Handler(LogHandler logHandler, int n) {
            super(logHandler);
            this.maxSize = n;
        }

        public Handler(LogHandler logHandler) {
            this(logHandler, 20);
        }

        public synchronized void start() throws Exception {
            if (this.cache == null) {
                this.resetLog();
            }
            super.start();
        }

        public synchronized void stop() {
            this.sendLog();
            this.cache = null;
            super.stop();
        }

        public void addMessage(LogEvent logEvent) {
            this.cache.addElement(logEvent);
            if (this.cache.size() >= this.maxSize) {
                this.sendLog();
            }
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void resetLog() {
            this.cache = new Vector(this.maxSize);
        }

        public void sendLog() {
            if (this.cache == null) {
                return;
            }
            Vector vector = (Vector)this.cache.clone();
            this.resetLog();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                super.addMessage((LogEvent)enumeration.nextElement());
            }
        }
    }
}

