/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.UnexpectedException;
import oracle.express.idl.ExpressConnectionModule.ConnectionInterface;
import oracle.express.idl.ExpressConnectionModule.DatabaseInterface;
import oracle.express.idl.ExpressConnectionModule.ServerInterface;
import oracle.express.idl.ExpressConnectionModule.ServerInterfaceStub;
import oracle.express.idl.ExpressMdmModule.MetadataProviderInterface;
import oracle.express.idl.ExpressMdmModule.MetadataProviderInterfaceHelper;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataSourceModule.DataProviderInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.UnmatchedInputsException;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiExceptionHelper;
import oracle.express.idl.util.RpcProperties;
import oracle.express.idl.util.TypeMapHelper;
import oracle.express.idl.util.WstringHolder;
import oracle.express.mdm.MdmMetadataProvider;
import oracle.express.olapi.data.full.BaseCursorManager;
import oracle.express.olapi.data.full.CursorInputTemplate;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.ExpressGenerationInfoListener;
import oracle.express.olapi.data.full.ExpressSpecifiedCursorManager;
import oracle.express.olapi.data.full.UnknownServerVersionException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.olapi.BatchedException;
import oracle.olapi.Debug;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.XMLWriter;
import oracle.olapi.data.cursor.CursorManager;
import oracle.olapi.data.source.BooleanParameter;
import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.BuildProperties;
import oracle.olapi.data.source.BuildResult;
import oracle.olapi.data.source.BuildWarningsException;
import oracle.olapi.data.source.CompoundCursorSpecification;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CursorManagerSpecificationExpiredException;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DataProviderMismatchException;
import oracle.olapi.data.source.DateParameter;
import oracle.olapi.data.source.DateSource;
import oracle.olapi.data.source.DefaultSourceExpressionFactory;
import oracle.olapi.data.source.ExpressFundamentalIdProvider;
import oracle.olapi.data.source.FunctionDefinition;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.IncorrectDataValueException;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.NumberParameter;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.ParameterizedSourceDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.SQLCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourceExpressionFactory;
import oracle.olapi.data.source.SourceIDProvider;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.data.source.StringParameter;
import oracle.olapi.data.source.StringSource;
import oracle.olapi.data.source.ValueCursorSpecification;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataProvider;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLFileFetcher;
import oracle.olapi.metadata.conversion.TestUpgradeSucceededException;
import oracle.olapi.metadata.conversion.UpgradeException;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.mdm.MdmNamedBuildProcess;
import oracle.olapi.session.UserSession;
import oracle.olapi.session.UserSessionFactory;
import oracle.olapi.syntax.BuildProcess;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.transaction.ActiveSubtransactionsException;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.BaseTransactionProvider;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.version.Version;
import oracle.olapi.xml.OlapSettingReader;
import oracle.olapi.xml.XMLException;
import oracle.sql.NUMBER;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataProvider {
    public static final String SUPPORT_MTM = "SupportMTM";
    protected static final String MDM_COMPATIBILITY_MODE = "MdmCompatibilityMode";
    protected static final String XML_METADATA_FILE = "XMLMetadataFile";
    public static final String XML_CONFIG_KEY = "XML_CONFIG";
    private static final boolean READ_11G_METADATA_DEFAULT = true;
    public static final String SOURCE_ID_FORMAT_OPTION = "SourceIDFormat";
    public static final String SOURCE_ID_FORMAT_CHOICE_10G = "10g";
    public static final String METADATA_READER_MODE_OPTION = "MetadataReaderMode";
    public static final String METADATA_READER_MODE_CHOICE_10_ONLY = "10_ONLY";
    public static final String METADATA_READER_MODE_CHOICE_CWM2ONLY = "CWM2ONLY";
    public static final String METADATA_READER_MODE_CHOICE_10103AWONLY = "METADATA_READER_MODE_CHOICE_10103AWONLY";
    public static final String CURSOR_BLOCK_CACHE_SIZE = "CursorBlockCacheSize";
    public static final String UPGRADE_TARGET_VERSION_OPTION = "TargetVersion";
    public static final String UPGRADE_DELETE_CUSTOMIZATIONS_OPTION = "DeleteCustomizations";
    public static final String UPGRADE_DELETE_CUSTOMIZATIONS_CHOICE_YES = "Yes";
    public static final String UPGRADE_DELETE_CUSTOMIZATIONS_CHOICE_NO = "No";
    public static final String UPGRADE_TEST_UPGRADE_OPTION = "TestUpgradeMode";
    public static final String UPGRADE_TEST_UPGRADE_CHOICE_COMPLETE = "Complete";
    public static final String UPGRADE_TEST_UPGRADE_CHOICE_FAST = "Fast";
    public static final String UPGRADE_OBJECTS = "UpgradeObjects";
    public static final String DUMP_SERVER_XML = "DumpServerXML";
    public static final String DUMP_CLIENT_XML = "DumpClientXML";
    private Properties _defaultProps = null;
    private Locale _defaultLocale = null;
    private Map _metadataProviderMap = new HashMap();
    private MetadataProvider _defaultMetadataProvider = null;
    private oracle.olapi.metadata.mdm.MdmMetadataProvider _mdmMetadataProvider = null;
    private MetadataProviderInterface _metadataProviderInterface = null;
    private Version _serverVersion = null;
    private List _openDefinitionManagers = new ArrayList();
    private BaseTransactionProvider _transactionProvider = null;
    private SourceIDProvider _sourceIDProvider = new SourceIDProvider();
    private FundamentalMetadataProvider _fundamentalMetadataProvider = new FundamentalMetadataProvider(this, new ExpressFundamentalIdProvider());
    private boolean _read11gMetadata = true;
    private boolean _SupportMTMDefaulting = true;
    private boolean m_DumpServerXML = false;
    private ExpressGenerationInfoListener _generationInfoListener = null;
    private SourceExpressionFactory m_SourceExpressionFactory = new DefaultSourceExpressionFactory(this);
    private UserSessionFactory _userSessionFactory = new UserSessionFactory(this);
    private boolean m_loadedServerSettings = false;
    private Map _unopenedServerInterfaces = new HashMap();

    private DataProvider(Locale locale, String string, Properties properties, BaseTransactionProvider baseTransactionProvider) {
        this._defaultLocale = null != locale ? locale : Locale.getDefault();
        this._defaultProps = properties;
        this._defaultProps.put(XML_CONFIG_KEY, string);
        if (null != baseTransactionProvider) {
            baseTransactionProvider.initialize(this);
            this._transactionProvider = baseTransactionProvider;
        } else {
            this._transactionProvider = new BaseTransactionProvider(this, true);
        }
        this.initializeRead11gMetadataFlag();
        if ("YES".equalsIgnoreCase(this.getProperty(DUMP_SERVER_XML))) {
            this.m_DumpServerXML = true;
        }
        if ("YES".equalsIgnoreCase(this.getProperty(DUMP_CLIENT_XML))) {
            oracle.express.idl.util.XMLWriter.DEBUG_PRINT_XML = true;
        }
    }

    protected DataProvider(BaseTransactionProvider baseTransactionProvider, Locale locale, Properties properties) {
        this(locale, DataProvider.convertPropertiesToXML(properties), properties, baseTransactionProvider);
    }

    public DataProvider() {
        this(Locale.getDefault());
    }

    public DataProvider(Locale locale) {
        this(locale, new Properties());
    }

    public DataProvider(Locale locale, String string) throws SAXException {
        this(locale, string, DataProvider.convertXMLToProperties(string, null), null);
    }

    public DataProvider(Locale locale, Properties properties) {
        this(null, locale, properties);
    }

    private BaseTransaction getUserTransaction() {
        return this.getBaseTransactionProvider().getUserTransaction(true);
    }

    private DefinitionManager getCurrentDefinitionManager() throws TransactionalObjectInvalidException {
        return this.getUserTransaction().findOrCreateDefinitionManager(this);
    }

    private final synchronized void createMdmMetadataProvider() {
        if (null != this._mdmMetadataProvider) {
            return;
        }
        String string = this.getProperty(XML_METADATA_FILE);
        XMLFileFetcher xMLFileFetcher = null;
        if (null != string) {
            xMLFileFetcher = new XMLFileFetcher(string);
        }
        this._mdmMetadataProvider = new oracle.olapi.metadata.mdm.MdmMetadataProvider(this, xMLFileFetcher);
        String string2 = this.getProperty(MDM_COMPATIBILITY_MODE);
        this._defaultMetadataProvider = null != string2 && string2.equals("9.2") ? new MdmMetadataProvider(this._mdmMetadataProvider) : this._mdmMetadataProvider;
    }

    public void callGeneric(String string, oracle.express.idl.util.XMLWriter xMLWriter, WstringHolder wstringHolder) {
        this.callGeneric(string, xMLWriter, wstringHolder, this.getCurrentSession());
    }

    protected void callGeneric(String string, oracle.express.idl.util.XMLWriter xMLWriter, WstringHolder wstringHolder, UserSession userSession) {
        DataProviderInterface dataProviderInterface = userSession.getDataProviderInterface();
        try {
            dataProviderInterface.generic(string, xMLWriter, wstringHolder);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (UnmatchedInputsException unmatchedInputsException) {
            throw new UnexpectedException(unmatchedInputsException.toString());
        }
        catch (oracle.express.idl.ExpressModule.InvalidMetadataException invalidMetadataException) {
            throw new InvalidMetadataException(invalidMetadataException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    protected Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    protected Properties getDefaultProperties() {
        return this._defaultProps;
    }

    public BaseTransactionProvider getBaseTransactionProvider() {
        return this._transactionProvider;
    }

    public final SourceIDProvider _getSourceIDProvider() {
        return this._sourceIDProvider;
    }

    protected void _resetSourceIDProvider() {
        Debug.println("DataProvider: Resetting Object IDs.");
        this._sourceIDProvider = new SourceIDProvider();
    }

    public void _close() {
        this._defaultMetadataProvider = null;
        this._metadataProviderInterface = null;
    }

    public Source createSource(String string, String string2) {
        Expression expression = (Expression)SyntaxObject.fromSyntax(string, this.getMdmMetadataProvider(), string2);
        return expression.getSource(this);
    }

    public final NumberSource createConstantSource(double d) {
        return this.createListSource(new double[]{d});
    }

    public final NumberSource createConstantSource(float f) {
        return this.createListSource(new float[]{f});
    }

    public final NumberSource createConstantSource(int n) {
        return this.createListSource(new int[]{n});
    }

    public final StringSource createConstantSource(String string) {
        return this.createListSource(new String[]{string});
    }

    public final DateSource createConstantSource(Date date) {
        return this.createListSource(new Date[]{date});
    }

    public final Source createConstantSource(Source source) {
        return this.createListSource(new Source[]{source});
    }

    public final NumberSource createConstantSource(short s) {
        return this.createListSource(new short[]{s});
    }

    public final BooleanSource createConstantSource(boolean bl) {
        return this.createListSource(new boolean[]{bl});
    }

    public final SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification) throws CursorManagerSpecificationExpiredException {
        return this.createCursorManager(cursorManagerSpecification, null);
    }

    public SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray) throws CursorManagerSpecificationExpiredException {
        return this.createCursorManager(cursorManagerSpecification, sourceArray, (Properties)null);
    }

    public final CursorManager createCursorManager(Source source) {
        CursorManager[] cursorManagerArray = this.createCursorManagers(new Source[]{source});
        return cursorManagerArray[0];
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray) {
        int[] nArray = new int[sourceArray.length];
        CursorInfoSpecification[] cursorInfoSpecificationArray = new CursorInfoSpecification[sourceArray.length];
        for (int i = 0; i < sourceArray.length; ++i) {
            nArray[i] = 1000;
            cursorInfoSpecificationArray[i] = this.createCursorInfoSpecification(sourceArray[i]);
        }
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray);
    }

    public final CursorManager createCursorManager(Source source, int n, CursorInfoSpecification cursorInfoSpecification) {
        CursorManager[] cursorManagerArray = this.createCursorManagers(new Source[]{source}, new int[]{n}, new CursorInfoSpecification[]{cursorInfoSpecification});
        return cursorManagerArray[0];
    }

    public CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray) {
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, (Properties)null);
    }

    public void reserveBuildID(BuildResult buildResult) {
        if (!this.isServerVersionLaterThan(new int[]{11, 2})) {
            throw new UnsupportedOperationException();
        }
        DataProviderInterface dataProviderInterface = this.getCurrentSession().getDataProviderInterface();
        oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)dataProviderInterface), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        WstringHolder wstringHolder = new WstringHolder();
        this.callGeneric("ReserveBuildID", xMLWriter, wstringHolder);
        this.getBuildResult(buildResult, wstringHolder, false);
    }

    private void getBuildResult(BuildResult buildResult, WstringHolder wstringHolder, Boolean bl) {
        if ((null != buildResult || bl.booleanValue()) && null != wstringHolder.value) {
            InputSource inputSource = new InputSource(new StringReader(wstringHolder.value));
            short s = 1;
            MetadataXMLReader metadataXMLReader = new MetadataXMLReader(s, this.getMdmMetadataProvider());
            this.processXML(inputSource, metadataXMLReader);
            if (null != buildResult) {
                buildResult.setBuildID(metadataXMLReader.getBuildID());
            }
            if (null != metadataXMLReader.getRootCommitError()) {
                throw new BuildWarningsException(metadataXMLReader.getRootCommitError());
            }
        }
    }

    public final void executeBuild(BuildProcess buildProcess, BuildProperties buildProperties) {
        this.executeBuild(buildProcess, buildProperties, null);
    }

    public void executeBuild(BuildProcess buildProcess, BuildProperties buildProperties, BuildResult buildResult) {
        if (!this.isServerVersionLaterThan(new int[]{11, 0})) {
            throw new UnsupportedOperationException();
        }
        DataProviderInterface dataProviderInterface = this.getCurrentSession().getDataProviderInterface();
        oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)dataProviderInterface), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        xMLWriter.beginElement("Build");
        xMLWriter.appendAttribute("Script", buildProcess.toSyntax());
        if (null != buildProperties) {
            xMLWriter.appendAttribute("Parallelism", buildProperties.getParallelism());
            xMLWriter.appendAttribute("RefreshAfterErrors", buildProperties.getRefreshAfterErrors());
            xMLWriter.appendAttribute("AddDimensions", buildProperties.getAddDimensions());
            xMLWriter.appendAttribute("AutomaticOrder", buildProperties.getAutomaticOrder());
            xMLWriter.appendAttribute("AtomicRefresh", buildProperties.getAtomicRefresh());
            xMLWriter.appendAttribute("SchedulerJobName", buildProperties.getSchedulerJobName());
            xMLWriter.appendAttribute("RefreshMethod", buildProperties.getRefreshMethod());
            if (null != buildResult && this.isServerVersionLaterThan(new int[]{11, 2})) {
                xMLWriter.appendAttribute("BuildID", buildResult.getBuildID());
            }
        }
        xMLWriter.endElement();
        WstringHolder wstringHolder = new WstringHolder();
        this.callGeneric("BuildProcess", xMLWriter, wstringHolder);
        this.getBuildResult(buildResult, wstringHolder, true);
    }

    public void executeBuild(BuildProcess buildProcess, int n, BuildResult buildResult) {
        BuildProperties buildProperties = new BuildProperties();
        buildProperties.setParallelism(n);
        this.executeBuild(buildProcess, buildProperties, buildResult);
    }

    public void executeBuild(BuildProcess buildProcess, int n) {
        this.executeBuild(buildProcess, n, null);
    }

    public void executeBuild(MdmNamedBuildProcess mdmNamedBuildProcess, int n, BuildResult buildResult) {
        this.executeBuild(mdmNamedBuildProcess.getBuildProcess(), n, buildResult);
    }

    public void executeBuild(MdmNamedBuildProcess mdmNamedBuildProcess, int n) {
        this.executeBuild(mdmNamedBuildProcess.getBuildProcess(), n, null);
    }

    public final CursorInfoSpecification createCursorInfoSpecification(Source source) throws TransactionalObjectInvalidException {
        BaseTransaction baseTransaction = this.getUserTransaction();
        CursorInfoSpecification cursorInfoSpecification = this.createCursorInfoSpecification(source, baseTransaction);
        cursorInfoSpecification.setTransaction(baseTransaction);
        ((CursorSpecification)cursorInfoSpecification)._setDefaultFetchSize(100);
        return cursorInfoSpecification;
    }

    private final CursorInfoSpecification createCursorInfoSpecification(Source source, Transaction transaction) throws TransactionalObjectInvalidException {
        ArrayList arrayList = new ArrayList();
        source.getDefinition().accumulateOutputs(arrayList, transaction);
        if (arrayList.isEmpty()) {
            return new ValueCursorSpecification(source.getDefinition());
        }
        ArrayList<CursorSpecification> arrayList2 = new ArrayList<CursorSpecification>(arrayList.size());
        for (Source source2 : arrayList) {
            CursorSpecification cursorSpecification = (CursorSpecification)this.createCursorInfoSpecification(source2, transaction);
            arrayList2.add(cursorSpecification);
        }
        return new CompoundCursorSpecification(source.getDefinition(), arrayList2);
    }

    public final CursorManagerSpecification createCursorManagerSpecification(Source source) throws TransactionalObjectInvalidException {
        BaseTransaction baseTransaction = this.getUserTransaction();
        return new CursorManagerSpecification(source.getDefinition(), baseTransaction);
    }

    public final NumberSource createListSource(double[] dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Double(dArray[i]));
        }
        return (NumberSource)this._createList(arrayList, this.getFundamentalMetadataProvider().getDoubleDataType());
    }

    public final NumberSource createListSource(float[] fArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            arrayList.add(new Float(fArray[i]));
        }
        return (NumberSource)this._createList(arrayList, this.getFundamentalMetadataProvider().getFloatDataType());
    }

    public final NumberSource createListSource(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Integer(nArray[i]));
        }
        return (NumberSource)this._createList(arrayList, this.getFundamentalMetadataProvider().getIntegerDataType());
    }

    public final StringSource createListSource(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (null == stringArray[i]) {
                throw new IncorrectDataValueException("NonNullStringValueExpected");
            }
            arrayList.add(stringArray[i]);
        }
        return (StringSource)this._createList(arrayList, this.getFundamentalMetadataProvider().getStringDataType());
    }

    public final DateSource createListSource(Date[] dateArray) {
        ArrayList<Date> arrayList = new ArrayList<Date>(dateArray.length);
        for (int i = 0; i < dateArray.length; ++i) {
            arrayList.add(dateArray[i]);
        }
        return (DateSource)this._createList(arrayList, this.getFundamentalMetadataProvider().getDateDataType());
    }

    public final Source createListSource(Source[] sourceArray) {
        boolean bl = this.isServerVersionLaterThan(new int[]{10, 1, 0, 3});
        return this.createListOfSources(sourceArray, bl);
    }

    final Source createListOfSources(Source[] sourceArray, boolean bl) {
        Object object;
        TransactionalObject transactionalObject;
        Object object2;
        int n;
        BaseTransaction baseTransaction = this.getBaseTransactionProvider().getIncrementalTransaction();
        String[] stringArray = null;
        ArrayList<Object> arrayList = null;
        List[] listArray = null;
        if (bl) {
            stringArray = new String[sourceArray.length];
            listArray = new List[sourceArray.length];
        } else {
            arrayList = new ArrayList<Object>();
        }
        SourceDefinition sourceDefinition = null;
        int n2 = -1;
        for (n = 0; n < sourceArray.length; ++n) {
            object2 = sourceArray[n].getDefinition();
            ((SourceDefinition)object2).checkValidity(baseTransaction);
            sourceDefinition = sourceDefinition == null ? ((SourceDefinition)object2).getType(baseTransaction) : sourceDefinition.getCommonType((SourceDefinition)object2, baseTransaction);
            if (bl) {
                List list;
                stringArray[n] = sourceArray[n].getID();
                listArray[n] = list = ((SourceDefinition)object2).getOutputs();
                if (n2 != -1 && list.size() >= n2) continue;
                n2 = list.size();
                continue;
            }
            arrayList.add(object2);
        }
        if (!bl) {
            object2 = new ConstantListDefinition(arrayList, sourceDefinition, this.getFundamentalMetadataProvider().getStringDataType()._getSourceDefinition(), baseTransaction);
            return ((SourceDefinition)object2).findOrCreateSource(baseTransaction);
        }
        if (sourceDefinition instanceof FunctionDefinition) {
            sourceDefinition = sourceDefinition.getType(baseTransaction);
        }
        object2 = null;
        if (n2 > 0) {
            object2 = new Source[n2];
            for (int i = 0; i < n2; ++i) {
                transactionalObject = null;
                for (n = 0; n < sourceArray.length; ++n) {
                    object = listArray[n];
                    Source source = (Source)object.get(i);
                    transactionalObject = transactionalObject == null ? source.getDefinition() : ((SourceDefinition)transactionalObject).getCommonType(source.getDefinition(), baseTransaction);
                }
                if (transactionalObject instanceof FunctionDefinition) {
                    transactionalObject = ((SourceDefinition)transactionalObject).getType(baseTransaction);
                }
                object2[i] = ((SourceDefinition)transactionalObject).findOrCreateSource(baseTransaction);
            }
        }
        StringSource stringSource = this.createListSource(stringArray);
        transactionalObject = this.createModel(new Source[]{stringSource}, sourceDefinition.findOrCreateSource(baseTransaction), (Source[])object2);
        for (n = 0; n < sourceArray.length; ++n) {
            transactionalObject.assign(stringArray[n], sourceArray[n]);
        }
        object = (ConstantListDefinition)stringSource.getDefinition();
        ((ConstantListDefinition)object).setCalculationModel((Model)transactionalObject);
        return stringSource;
    }

    public final NumberSource createListSource(short[] sArray) {
        ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            arrayList.add(new Short(sArray[i]));
        }
        return (NumberSource)this._createList(arrayList, this.getFundamentalMetadataProvider().getShortDataType());
    }

    public final BooleanSource createListSource(boolean[] blArray) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            arrayList.add(new Boolean(blArray[i]));
        }
        return (BooleanSource)this._createList(arrayList, this.getFundamentalMetadataProvider().getBooleanDataType());
    }

    public final Source createListSource(Object[][] objectArray) {
        Object object;
        BaseTransaction baseTransaction = this.getBaseTransactionProvider().getIncrementalTransaction();
        if (!this._checkTuplesValidity(objectArray)) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            object = new ArrayList(objectArray[i].length);
            for (int j = 0; j < objectArray[i].length; ++j) {
                ((ArrayList)object).add(objectArray[i][j]);
            }
            arrayList.add(object);
        }
        SourceDefinition sourceDefinition = this.getConstantDataType(objectArray[0][0])._getSourceDefinition();
        object = sourceDefinition;
        if (objectArray[0][0] instanceof Source) {
            object = this.getFundamentalMetadataProvider().getStringDataType()._getSourceDefinition();
        }
        ConstantListDefinition constantListDefinition = new ConstantListDefinition(arrayList, sourceDefinition, (SourceDefinition)object, baseTransaction);
        return constantListDefinition.findOrCreateSource(baseTransaction);
    }

    private boolean _checkTuplesValidity(Object[][] objectArray) {
        int n;
        int n2 = objectArray[0].length;
        for (n = 1; n < objectArray.length; ++n) {
            if (n2 == objectArray[n].length) continue;
            return false;
        }
        for (n = 0; n < n2; ++n) {
            FundamentalMetadataObject fundamentalMetadataObject = this.getConstantDataType(objectArray[0][n]);
            for (int i = 1; i < objectArray.length; ++i) {
                if (fundamentalMetadataObject == this.getConstantDataType(objectArray[i][n])) continue;
                return false;
            }
        }
        return true;
    }

    public final FundamentalMetadataObject getConstantDataType(Object object) {
        FundamentalMetadataObject fundamentalMetadataObject = null;
        if (object instanceof Short) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getShortDataType();
        } else if (object instanceof Integer) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getIntegerDataType();
        } else if (object instanceof Float) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getFloatDataType();
        } else if (object instanceof Double) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDoubleDataType();
        } else if (object instanceof String) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getStringDataType();
        } else if (object instanceof Date) {
            fundamentalMetadataObject = this.getFundamentalMetadataProvider().getDateDataType();
        }
        return fundamentalMetadataObject;
    }

    private final Source _createList(List list, FundamentalMetadataObject fundamentalMetadataObject) {
        BaseTransaction baseTransaction = this.getBaseTransactionProvider().getIncrementalTransaction();
        ConstantListDefinition constantListDefinition = new ConstantListDefinition(list, fundamentalMetadataObject._getSourceDefinition(), fundamentalMetadataObject._getSourceDefinition(), baseTransaction);
        return constantListDefinition.findOrCreateSource(baseTransaction);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source, Source[] sourceArray2, Model[] modelArray) {
        BaseTransaction baseTransaction = this.getBaseTransactionProvider().getIncrementalTransaction();
        return new CustomModel(this, sourceArray, source, sourceArray2, modelArray, baseTransaction);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source, Source[] sourceArray2) {
        return this.createModel(sourceArray, source, sourceArray2, null);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source, Model[] modelArray) {
        return this.createModel(sourceArray, source, null, modelArray);
    }

    public final CustomModel createModel(Source[] sourceArray, Source source) {
        return this.createModel(sourceArray, source, null, null);
    }

    public final CustomModel createModel(Source[] sourceArray) {
        return this.createModel(sourceArray, this.getFundamentalMetadataProvider().getNumberDataType().getSource());
    }

    public final CustomModel createModel(Source source, Source source2) {
        return this.createModel(new Source[]{source}, source2);
    }

    public final CustomModel createModel(Source source) {
        return this.createModel(new Source[]{source});
    }

    public final StringSource createParameterizedSource(StringParameter stringParameter) {
        return (StringSource)this.internalCreateParameterizedSource(stringParameter, this.getFundamentalMetadataProvider().getStringDataType());
    }

    public final DateSource createParameterizedSource(DateParameter dateParameter) {
        return (DateSource)this.internalCreateParameterizedSource(dateParameter, this.getFundamentalMetadataProvider().getDateDataType());
    }

    public final BooleanSource createParameterizedSource(BooleanParameter booleanParameter) {
        return (BooleanSource)this.internalCreateParameterizedSource(booleanParameter, this.getFundamentalMetadataProvider().getBooleanDataType());
    }

    public final NumberSource createParameterizedSource(NumberParameter numberParameter) {
        return (NumberSource)this.internalCreateParameterizedSource(numberParameter, this.getFundamentalMetadataProvider().getNumberDataType());
    }

    final Source internalCreateParameterizedSource(Parameter parameter, FundamentalMetadataObject fundamentalMetadataObject) {
        if (!this.isServerVersionLaterThan(new int[]{10, 0, 0, 0})) {
            throw new UnsupportedOperationException();
        }
        BaseTransaction baseTransaction = this.getBaseTransactionProvider().getIncrementalTransaction();
        ParameterizedSourceDefinition parameterizedSourceDefinition = new ParameterizedSourceDefinition(parameter, fundamentalMetadataObject._getSourceDefinition(), (Transaction)baseTransaction);
        return parameterizedSourceDefinition.findOrCreateSource(baseTransaction);
    }

    public final NumberSource createRangeSource(int n, int n2) {
        return this.createRangeSource(this.createConstantSource(n), this.createConstantSource(n2));
    }

    public final NumberSource createRangeSource(int n, NumberSource numberSource) {
        return this.createRangeSource(this.createConstantSource(n), numberSource);
    }

    public final NumberSource createRangeSource(NumberSource numberSource, int n) {
        return this.createRangeSource(numberSource, this.createConstantSource(n));
    }

    public final NumberSource createRangeSource(NumberSource numberSource, NumberSource numberSource2) {
        BaseTransaction baseTransaction = this.getBaseTransactionProvider().getIncrementalTransaction();
        SourceDefinition sourceDefinition = numberSource.getDefinition();
        sourceDefinition.checkValidity(baseTransaction);
        SourceDefinition sourceDefinition2 = numberSource2.getDefinition();
        sourceDefinition2.checkValidity(baseTransaction);
        RangeDefinition rangeDefinition = new RangeDefinition(sourceDefinition, sourceDefinition2, (Transaction)baseTransaction);
        return (NumberSource)rangeDefinition.findOrCreateSource(baseTransaction);
    }

    public final Source getEmptySource() {
        return this._fundamentalMetadataProvider.getEmptyDataType().getSource();
    }

    public final FundamentalMetadataProvider getFundamentalMetadataProvider() {
        return this._fundamentalMetadataProvider;
    }

    public MetadataProvider getMetadataProvider(String string) {
        return (MetadataProvider)this._metadataProviderMap.get(string);
    }

    public final SourceExpressionFactory getSourceExpressionFactory() {
        return this.m_SourceExpressionFactory;
    }

    public final TransactionProvider getTransactionProvider() {
        return this.getBaseTransactionProvider();
    }

    public final Source getVoidSource() {
        return this._fundamentalMetadataProvider.getVoidDataType().getSource();
    }

    public void registerMetadataProvider(MetadataProvider metadataProvider) {
        this._metadataProviderMap.put(metadataProvider.getID(), metadataProvider);
    }

    public final void setSourceExpressionFactory(SourceExpressionFactory sourceExpressionFactory) {
        this.m_SourceExpressionFactory = sourceExpressionFactory;
        sourceExpressionFactory.setDataProvider(this);
    }

    public void unregisterMetadataProvider(MetadataProvider metadataProvider) {
        this._metadataProviderMap.remove(metadataProvider.getID());
    }

    public final SQLCursorManager createSQLCursorManager(Source source) throws TransactionalObjectInvalidException {
        SQLCursorManager[] sQLCursorManagerArray = this.createSQLCursorManagers(new Source[]{source});
        return sQLCursorManagerArray[0];
    }

    public UserSession getDefaultUserSession() {
        return this._userSessionFactory.getDefaultSession();
    }

    public void setDefaultUserSession(UserSession userSession) {
        this._userSessionFactory.setDefaultSession(userSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties convertXMLToProperties(String string, Properties properties) throws SAXException {
        Properties properties2;
        Properties properties3 = properties2 = properties == null ? new Properties() : (Properties)properties.clone();
        if (string != null && string.length() > 0) {
            Properties properties4 = null;
            OlapSettingReader olapSettingReader = new OlapSettingReader();
            StringReader stringReader = new StringReader(string);
            try {
                properties4 = olapSettingReader.readSettings(new InputSource(stringReader));
            }
            finally {
                stringReader.close();
            }
            properties2.putAll((Map<?, ?>)properties4);
            properties2.put(XML_CONFIG_KEY, string);
        }
        return properties2;
    }

    protected static String convertPropertiesToXML(Properties properties) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.setStringBuffer(new StringBuffer());
        xMLWriter.beginElement("olapsettings");
        xMLWriter.closeTag();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string == null || string.length() == 0 || string2 == null) continue;
            xMLWriter.beginElement("setting");
            xMLWriter.appendAttribute("name", string);
            xMLWriter.appendAttribute("value", string2);
            xMLWriter.endElement();
        }
        xMLWriter.endElement("olapsettings");
        return xMLWriter.getStringBuffer().toString();
    }

    protected UserSession initializeSession(OracleConnection oracleConnection, Properties properties, Locale locale) throws SQLException {
        TypeMapHelper.setTypeMap(oracleConnection);
        UserSession userSession = this._userSessionFactory.findUserSession(oracleConnection);
        if (userSession != null) {
            return userSession;
        }
        ServerInterface serverInterface = this.getServerInterface(oracleConnection, properties, locale);
        userSession = this.connect(oracleConnection, serverInterface, properties, locale);
        this.getBaseTransactionProvider().createRootTransaction(userSession);
        return userSession;
    }

    protected ServerInterface getServerInterface(OracleConnection oracleConnection) throws SQLException {
        return this.getServerInterface(oracleConnection, this.getDefaultProperties(), this.getDefaultLocale());
    }

    protected ServerInterface getServerInterface(OracleConnection oracleConnection, Properties properties, Locale locale) throws SQLException {
        if (null == oracleConnection) {
            throw OlapiExceptionHelper.newInstance("NULL_CONN", locale, null);
        }
        boolean bl = false;
        try {
            if (!oracleConnection.isClosed()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            throw OlapiExceptionHelper.newInstance("BAD_CONN", locale, null);
        }
        OracleCallableStatement oracleCallableStatement = null;
        NUMBER nUMBER = null;
        String string = null;
        String string2 = null;
        UserSession userSession = this._userSessionFactory.findUserSession(oracleConnection);
        if (userSession != null) {
            return userSession.getServerInterface();
        }
        ServerInterface serverInterface = (ServerInterface)this._unopenedServerInterfaces.get(oracleConnection);
        if (serverInterface != null) {
            return serverInterface;
        }
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("{ ? = call OlapiBootstrap2(?, ?, ?) }");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setString(2, "11.2.0.0.0");
            oracleCallableStatement.registerOutParameter(3, 1);
            oracleCallableStatement.registerOutParameter(4, 1);
            oracleCallableStatement.execute();
            nUMBER = oracleCallableStatement.getNUMBER(1);
            string = oracleCallableStatement.getString(3);
            string2 = "ORAOLAP" + oracleCallableStatement.getString(4);
            serverInterface = new ServerInterfaceStub(oracleConnection, string2, nUMBER, string, new RpcProperties(properties), locale);
            this._unopenedServerInterfaces.put(oracleConnection, serverInterface);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw OlapiExceptionHelper.newInstance("BOOT_FAIL", locale, null);
        }
        finally {
            if (null != oracleCallableStatement) {
                oracleCallableStatement.close();
            }
        }
        return serverInterface;
    }

    protected UserSession connect(OracleConnection oracleConnection, ServerInterface serverInterface, Properties properties, Locale locale) {
        UserSession userSession = null;
        properties.put("VERSION", this.getClientVersion(serverInterface));
        properties.put("OraOlapVersion", Version.getClientVersion().getVersionString());
        InterfaceStub interfaceStub = (InterfaceStub)((Object)serverInterface);
        properties.put("RpcCompression", new Long(interfaceStub.getRpcProperties().getRpcCompression()).toString());
        userSession = this._userSessionFactory.createUserSession(oracleConnection, serverInterface, locale, properties);
        this._unopenedServerInterfaces.remove(oracleConnection);
        if (!this.m_loadedServerSettings) {
            this.loadServerSettings(userSession);
            this.m_loadedServerSettings = true;
        }
        return userSession;
    }

    protected String getClientVersion(ServerInterface serverInterface) {
        String string = 9 + "." + 2;
        return string;
    }

    public final void _definitionManagerOpened(DefinitionManager definitionManager) {
        this._openDefinitionManagers.add(definitionManager);
    }

    public final void _definitionManagerClosed(DefinitionManager definitionManager) {
        this._openDefinitionManagers.remove(definitionManager);
    }

    public Version getServerVersion() {
        if (null == this._serverVersion) {
            this.initializeServerVersion(null);
        }
        return this._serverVersion.getClientCompatibleVersion();
    }

    public Version getServerVersion(UserSession userSession) {
        if (null == this._serverVersion) {
            this.initializeServerVersion(userSession);
        }
        return this._serverVersion.getClientCompatibleVersion();
    }

    protected final synchronized void initializeServerVersion(UserSession userSession) {
        if (null != this._serverVersion) {
            return;
        }
        MetadataProviderInterface metadataProviderInterface = this.getMetadataProviderInterface(userSession);
        InterfaceStub interfaceStub = (InterfaceStub)((Object)metadataProviderInterface);
        String string = interfaceStub.getServerVsnnum();
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(97, 122);
            streamTokenizer.wordChars(65, 90);
            int n = streamTokenizer.nextToken();
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(48, 57);
            streamTokenizer.whitespaceChars(46, 46);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            n = streamTokenizer.nextToken();
            while (n != -1) {
                switch (n) {
                    case -3: {
                        arrayList.add(new Integer(streamTokenizer.sval));
                        break;
                    }
                    default: {
                        arrayList.add(new Integer(n));
                    }
                }
                n = streamTokenizer.nextToken();
            }
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                Integer n2 = (Integer)arrayList.get(i);
                nArray[i] = n2;
            }
            this._serverVersion = new Version(nArray);
        }
        catch (IOException iOException) {
            throw new UnknownServerVersionException(string);
        }
    }

    public ConnectionInterface getConnectionInterface(UserSession userSession) {
        return userSession.getConnectionInterface();
    }

    public ConnectionInterface getConnectionInterface() {
        return this.getConnectionInterface(this.getCurrentSession());
    }

    public final MetadataProviderInterface getMetadataProviderInterface(UserSession userSession) {
        if (null == this._metadataProviderInterface) {
            try {
                DatabaseInterface databaseInterface = this.getConnectionInterface(userSession).getDefaultDatabase();
                this._metadataProviderInterface = MetadataProviderInterfaceHelper.narrow(databaseInterface);
            }
            catch (RemoteObjectClosedException remoteObjectClosedException) {
                throw new ObjectClosedException(remoteObjectClosedException.toString());
            }
            catch (ExpressException expressException) {
                throw new ExpressServerException(expressException);
            }
        }
        return this._metadataProviderInterface;
    }

    public final MetadataProviderInterface getMetadataProviderInterface() {
        return this.getMetadataProviderInterface(this.getCurrentSession());
    }

    public UserSession getCurrentSession() {
        UserSession userSession = null;
        try {
            userSession = this.getBaseTransactionProvider().getCurrentSystemTransaction().getUserSession();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return userSession != null ? userSession : this.getDefaultUserSession();
    }

    public boolean isServerVersionLaterThan(int[] nArray) {
        return this.getServerVersion().isSameOrLaterThan(nArray);
    }

    public CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, Properties properties) {
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, properties, 0L);
    }

    public CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, String string) throws SAXException {
        Properties properties = DataProvider.convertXMLToProperties(string, null);
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, properties, 0L);
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, String string, long l) throws SAXException {
        Properties properties = DataProvider.convertXMLToProperties(string, null);
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, properties, l);
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, Properties properties, long l) {
        if (!this.isServerVersionLaterThan(new int[]{10, 0, 0, 0, 0})) {
            throw new UnsupportedOperationException();
        }
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 |= expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        CursorManager[] cursorManagerArray = null;
        if (sourceArray[0].getDataProvider() != this) {
            throw new DataProviderMismatchException();
        }
        if (cursorInfoSpecificationArray[0].getTransaction() != this.getUserTransaction()) {
            throw new TransactionalObjectInvalidException();
        }
        DefinitionManager definitionManager = this.getCurrentDefinitionManager();
        cursorManagerArray = definitionManager.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, l2, properties);
        if (null != expressGenerationInfoListener) {
            for (int i = 0; i < sourceArray.length; ++i) {
                expressGenerationInfoListener.notifyOfCreateCursorManager((BaseCursorManager)((Object)cursorManagerArray[i]));
            }
        }
        return cursorManagerArray;
    }

    public OracleConnection getConnection() {
        UserSession userSession = this.getCurrentSession();
        return userSession != null ? userSession.getConnection() : null;
    }

    public final CursorManager[] createCursorManagers(Source[] sourceArray, int[] nArray, CursorInfoSpecification[] cursorInfoSpecificationArray, long l) {
        return this.createCursorManagers(sourceArray, nArray, cursorInfoSpecificationArray, (Properties)null, l);
    }

    public final SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray, Properties properties) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.internalCreateCursorManager(cursorManagerSpecification, sourceArray, properties, 0L);
    }

    public final SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray, String string) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException, SAXException {
        Properties properties = DataProvider.convertXMLToProperties(string, null);
        return this.internalCreateCursorManager(cursorManagerSpecification, sourceArray, properties, 0L);
    }

    protected SpecifiedCursorManager internalCreateCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray, Properties properties, long l) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        Source[] sourceArray2 = sourceArray;
        if (null == sourceArray2) {
            sourceArray2 = new Source[]{};
        }
        if (this.isServerVersionLaterThan(new int[]{9, 2, 0, 7, 0})) {
            CursorManagerSpecification[] cursorManagerSpecificationArray = new CursorManagerSpecification[]{cursorManagerSpecification};
            Source[][] sourceArray3 = new Source[][]{sourceArray};
            SpecifiedCursorManager[] specifiedCursorManagerArray = this.createCursorManagers(cursorManagerSpecificationArray, sourceArray3, properties, l);
            return specifiedCursorManagerArray[0];
        }
        Source source = cursorManagerSpecification.getRootCursorSpecification().getSource();
        CursorInputTemplate cursorInputTemplate = new CursorInputTemplate(source, sourceArray2, ExpressSpecifiedCursorManager.calculateInputSourceTypes(sourceArray2), this.getUserTransaction());
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 |= expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        ExpressSpecifiedCursorManager expressSpecifiedCursorManager = this.createCursorManager(cursorManagerSpecification, cursorInputTemplate, l2);
        if (null != expressGenerationInfoListener) {
            expressGenerationInfoListener.notifyOfCreateCursorManager(expressSpecifiedCursorManager);
        }
        return expressSpecifiedCursorManager;
    }

    protected ExpressSpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, CursorInputTemplate cursorInputTemplate, long l) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        Source source = cursorInputTemplate.getSource();
        if (source.getDataProvider() != this) {
            throw new DataProviderMismatchException();
        }
        if (cursorManagerSpecification.getTransaction() != this.getUserTransaction()) {
            throw new TransactionalObjectInvalidException();
        }
        DefinitionManager definitionManager = this.getCurrentDefinitionManager();
        return definitionManager.createCursorManager(cursorManagerSpecification, cursorInputTemplate, l, null);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, String string, long l) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException, SAXException {
        Properties properties = DataProvider.convertXMLToProperties(string, null);
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, properties, l);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, Properties properties, long l) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        int n = cursorManagerSpecificationArray.length;
        if (0 == n) {
            return new ExpressSpecifiedCursorManager[0];
        }
        if (sourceArray.length != n) {
            throw new IllegalArgumentException();
        }
        BaseTransaction baseTransaction = this.getUserTransaction();
        for (int i = 0; i < n; ++i) {
            CursorManagerSpecification cursorManagerSpecification = cursorManagerSpecificationArray[i];
            Source source = cursorManagerSpecification.getRootCursorSpecification().getSource();
            if (source.getDataProvider() != this) {
                throw new DataProviderMismatchException();
            }
            if (!cursorManagerSpecification.getTransaction().equals(baseTransaction)) {
                throw new TransactionalObjectInvalidException();
            }
            if (null != sourceArray[i]) continue;
            sourceArray[i] = new Source[0];
        }
        DefinitionManager definitionManager = this.getCurrentDefinitionManager();
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 = l | expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        CursorInputTemplate[] cursorInputTemplateArray = new CursorInputTemplate[n];
        for (int i = 0; i < n; ++i) {
            CursorInputTemplate cursorInputTemplate;
            Source source = cursorManagerSpecificationArray[i].getRootCursorSpecification().getSource();
            cursorInputTemplateArray[i] = cursorInputTemplate = new CursorInputTemplate(source, sourceArray[i], ExpressSpecifiedCursorManager.calculateInputSourceTypes(sourceArray[i]), baseTransaction);
        }
        SpecifiedCursorManager[] specifiedCursorManagerArray = definitionManager.createCursorManagers(cursorManagerSpecificationArray, cursorInputTemplateArray, l2, properties);
        if (null != expressGenerationInfoListener) {
            for (int i = 0; i < n; ++i) {
                expressGenerationInfoListener.notifyOfCreateCursorManager((BaseCursorManager)((Object)specifiedCursorManagerArray[i]));
            }
        }
        return specifiedCursorManagerArray;
    }

    public final int[] getOraolapServerVersionArray() {
        return this.getServerVersion().getVersionArray();
    }

    public final SpecifiedCursorManager createCursorManager(CursorManagerSpecification cursorManagerSpecification, Source[] sourceArray, long l) throws CursorManagerSpecificationExpiredException, DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.internalCreateCursorManager(cursorManagerSpecification, sourceArray, null, l);
    }

    public final boolean isOpen() {
        boolean bl = false;
        try {
            bl = !this.getConnection().isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    public void setGenerationInfoListener(ExpressGenerationInfoListener expressGenerationInfoListener) {
        this._generationInfoListener = expressGenerationInfoListener;
    }

    public ExpressGenerationInfoListener getGenerationInfoListener() {
        return this._generationInfoListener;
    }

    public String getProperty(String string) {
        return this._defaultProps.getProperty(string);
    }

    public Transaction getRootTransaction(OracleConnection oracleConnection) {
        if (!Version.getClientVersion().supportsDataProviderSharing()) {
            throw new UnsupportedOperationException();
        }
        UserSession userSession = this._userSessionFactory.findUserSession(oracleConnection);
        return userSession == null ? null : userSession.getRootTransaction();
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray) {
        return this.createSQLCursorManagers(sourceArray, 0L, false, false, null, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, String[] stringArray) {
        return this.createSQLCursorManagers(sourceArray, 0L, false, true, stringArray, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, boolean bl, String[] stringArray) {
        return this.createSQLCursorManagers(sourceArray, 0L, bl, true, stringArray, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, long l, boolean bl, boolean bl2, String[] stringArray) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.createSQLCursorManagers(sourceArray, l, bl, bl2, stringArray, null);
    }

    public final SQLCursorManager[] createSQLCursorManagers(Source[] sourceArray, long l, boolean bl, boolean bl2, String[] stringArray, Properties properties) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        int n = sourceArray.length;
        if (0 == n) {
            return new SQLCursorManager[0];
        }
        if (bl2 && (null == stringArray || stringArray.length != n)) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            if (sourceArray[i].getDataProvider() == this) continue;
            throw new DataProviderMismatchException();
        }
        DefinitionManager definitionManager = this.getCurrentDefinitionManager();
        long l2 = l;
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            l2 = l | expressGenerationInfoListener.getGenerationInfoTypeForCreateCursorManager();
        }
        SQLCursorManager[] sQLCursorManagerArray = null;
        sQLCursorManagerArray = definitionManager.createSQLCursorManagers(sourceArray, l2, bl, bl2, stringArray, properties);
        if (null != expressGenerationInfoListener) {
            for (int i = 0; i < n; ++i) {
                expressGenerationInfoListener.notifyOfCreateCursorManager((BaseCursorManager)((Object)sQLCursorManagerArray[i]));
            }
        }
        return sQLCursorManagerArray;
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray) throws DataProviderMismatchException, ExpressServerException, ObjectClosedException, TransactionalObjectInvalidException {
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, (Properties)null, 0L);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, String string) throws SAXException {
        Properties properties = DataProvider.convertXMLToProperties(string, null);
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, properties, 0L);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, Properties properties) {
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, properties, 0L);
    }

    public final SpecifiedCursorManager[] createCursorManagers(CursorManagerSpecification[] cursorManagerSpecificationArray, Source[][] sourceArray, long l) {
        return this.createCursorManagers(cursorManagerSpecificationArray, sourceArray, (Properties)null, l);
    }

    public synchronized MetadataProvider getDefaultMetadataProvider() {
        if (null == this._defaultMetadataProvider) {
            this.createMdmMetadataProvider();
        }
        return this._defaultMetadataProvider;
    }

    public final oracle.olapi.metadata.mdm.MdmMetadataProvider getMdmMetadataProvider() {
        if (null == this._mdmMetadataProvider) {
            this.createMdmMetadataProvider();
        }
        return this._mdmMetadataProvider;
    }

    public UserSession createSession(OracleConnection oracleConnection) throws SQLException {
        try {
            return this.createSession(oracleConnection, null, Locale.getDefault());
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public UserSession createSession(OracleConnection oracleConnection, String string) throws SQLException, SAXException {
        return this.createSession(oracleConnection, string, Locale.getDefault());
    }

    public UserSession createSession(OracleConnection oracleConnection, String string, Locale locale) throws SQLException, SAXException {
        if (!Version.getClientVersion().supportsDataProviderSharing()) {
            throw new UnsupportedOperationException();
        }
        if (oracleConnection == null) {
            throw new OlapiException("NOCONNECTION", "No OracleConnection specified.");
        }
        if (this._userSessionFactory.findUserSession(oracleConnection) != null) {
            throw new OlapiException("DUPLICATECONN", "The specified OracleConnection is already in use.");
        }
        Properties properties = DataProvider.convertXMLToProperties(string, this._defaultProps);
        UserSession userSession = this.initializeSession(oracleConnection, properties, locale);
        return userSession;
    }

    private void loadServerSettings(UserSession userSession) {
        if (this.getServerVersion(userSession).supportsGeneric()) {
            try {
                oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)userSession.getDataProviderInterface()), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
                WstringHolder wstringHolder = new WstringHolder();
                this.callGeneric("getProperties", xMLWriter, wstringHolder, userSession);
                Properties properties = DataProvider.convertXMLToProperties(wstringHolder.value, null);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    if (!this._SupportMTMDefaulting || !string.equalsIgnoreCase(SUPPORT_MTM) || !string2.equalsIgnoreCase("YES") || !this.read11gMetadata()) continue;
                    this.setRead11gMetadata(false);
                }
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public final String getShortXMLTag() {
        return "Short";
    }

    public final String getIntegerXMLTag() {
        return "Long";
    }

    public final String getLongXMLTag() {
        return "LongLong";
    }

    public final String getFloatXMLTag() {
        return "Float";
    }

    public final String getDoubleXMLTag() {
        return "Double";
    }

    public final String getStringXMLTag() {
        return "Wstring";
    }

    public final String getBooleanXMLTag() {
        return "Boolean";
    }

    public final String getDateXMLTag() {
        return "Date";
    }

    public boolean areParametersSupported() {
        return this.isServerVersionLaterThan(new int[]{10, 0, 0, 0, 0});
    }

    public void close() {
        this._userSessionFactory.closeAll();
    }

    public void initialize() throws SQLException {
    }

    public boolean supportsBulkSend() {
        return this.isServerVersionLaterThan(new int[]{9, 2, 0, 7, 0}) && !this.isServerVersionLaterThan(new int[]{10, 0, 0, 0, 0}) || this.isServerVersionLaterThan(new int[]{10, 1, 0, 5, 0}) && !this.isServerVersionLaterThan(new int[]{10, 2, 0, 0, 0});
    }

    public void bulkSendMetadata() {
        if (!this.supportsBulkSend()) {
            return;
        }
        BaseTransaction baseTransaction = this.getUserTransaction();
        DefinitionManager definitionManager = new DefinitionManager(baseTransaction, this);
        definitionManager.bulkSendMetadata();
        definitionManager.rollback();
    }

    public WstringHolder getMetadataXML(String[] stringArray, int n) {
        DataProviderInterface dataProviderInterface = this.getCurrentSession().getDataProviderInterface();
        oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)dataProviderInterface), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        xMLWriter.beginElement("MetadataFetchRequest");
        xMLWriter.appendAttribute("FetchLevel", new Integer(n).toString());
        xMLWriter.closeTag();
        for (int i = 0; i < stringArray.length; ++i) {
            xMLWriter.beginElement("Object");
            xMLWriter.appendAttribute("ID", stringArray[i]);
            xMLWriter.endElement();
        }
        xMLWriter.endElement("MetadataFetchRequest");
        WstringHolder wstringHolder = new WstringHolder();
        this.callGeneric("getMetadataObjects", xMLWriter, wstringHolder);
        return wstringHolder;
    }

    public WstringHolder getPersistentLanguagesXML(String[] stringArray) {
        DataProviderInterface dataProviderInterface = this.getCurrentSession().getDataProviderInterface();
        oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)dataProviderInterface), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        xMLWriter.beginElement("MetadataFetchRequest");
        xMLWriter.appendAttribute("FetchLevel", new Integer(0).toString());
        xMLWriter.closeTag();
        for (int i = 0; i < stringArray.length; ++i) {
            xMLWriter.beginElement("Object");
            xMLWriter.appendAttribute("ID", stringArray[i]);
            xMLWriter.endElement();
        }
        xMLWriter.endElement("MetadataFetchRequest");
        WstringHolder wstringHolder = new WstringHolder();
        this.callGeneric("getPersistentLanguages", xMLWriter, wstringHolder);
        return wstringHolder;
    }

    public WstringHolder addAWsToBranch(UserSession userSession, List list, List list2) {
        DataProviderInterface dataProviderInterface = userSession.getDataProviderInterface();
        oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)dataProviderInterface), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        xMLWriter.beginElement("Branch");
        xMLWriter.appendAttribute("Action", "AddAWs");
        xMLWriter.closeTag();
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            xMLWriter.beginElement("AW");
            xMLWriter.appendAttribute("ID", ((AW)list.get(i)).getID());
            xMLWriter.appendAttribute("AttachType", (String)list2.get(i));
            xMLWriter.endElement();
        }
        xMLWriter.endElement("Branch");
        WstringHolder wstringHolder = new WstringHolder();
        this.callGeneric("createAlterBranch", xMLWriter, wstringHolder);
        return wstringHolder;
    }

    public WstringHolder removeAWsFromBranch(UserSession userSession, List list) {
        DataProviderInterface dataProviderInterface = userSession.getDataProviderInterface();
        oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)dataProviderInterface), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        xMLWriter.beginElement("Branch");
        xMLWriter.appendAttribute("Action", "RemoveAWs");
        xMLWriter.closeTag();
        for (int i = 0; i < list.size(); ++i) {
            xMLWriter.beginElement("AW");
            xMLWriter.appendAttribute("ID", ((AW)list.get(i)).getID());
            xMLWriter.endElement();
        }
        xMLWriter.endElement("Branch");
        WstringHolder wstringHolder = new WstringHolder();
        this.callGeneric("createAlterBranch", xMLWriter, wstringHolder);
        return wstringHolder;
    }

    public WstringHolder closeBranch(UserSession userSession) {
        DataProviderInterface dataProviderInterface = userSession.getDataProviderInterface();
        oracle.express.idl.util.XMLWriter xMLWriter = new oracle.express.idl.util.XMLWriter((InterfaceStub)((Object)dataProviderInterface), "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        xMLWriter.beginElement("Branch");
        xMLWriter.appendAttribute("Action", "Close");
        xMLWriter.closeTag();
        xMLWriter.endElement("Branch");
        WstringHolder wstringHolder = new WstringHolder();
        this.callGeneric("createAlterBranch", xMLWriter, wstringHolder);
        return wstringHolder;
    }

    public void setRead11gMetadata(boolean bl) {
        this._read11gMetadata = bl;
    }

    public final boolean read11gMetadata() {
        return this._read11gMetadata && this.isServerVersionLaterThan(new int[]{11});
    }

    public final boolean getDumpServerXML() {
        return this.m_DumpServerXML;
    }

    private void initializeRead11gMetadataFlag() {
        String string = this.getProperty(SUPPORT_MTM);
        if (null == string) {
            this.setRead11gMetadata(true);
        } else {
            this.setRead11gMetadata(!string.equalsIgnoreCase("YES"));
            this._SupportMTMDefaulting = false;
        }
    }

    private void processXML(InputSource inputSource, MetadataXMLReader metadataXMLReader) {
        if (null == inputSource) {
            return;
        }
        try {
            metadataXMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void upgrade(List list, Properties properties) throws UpgradeException, NotCommittableException, ActiveSubtransactionsException {
        Object object;
        Properties properties2 = null;
        properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        StringBuffer stringBuffer = new StringBuffer(list.size() * 30);
        boolean bl = true;
        for (Object e : list) {
            object = (MetadataObject)e;
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(object.getID());
        }
        properties2.put(UPGRADE_OBJECTS, stringBuffer.toString());
        DefinitionManager definitionManager = this.getCurrentDefinitionManager();
        try {
            definitionManager.commitRoot(properties2);
        }
        catch (NotCommittableException notCommittableException) {
            throw notCommittableException;
        }
        catch (ActiveSubtransactionsException activeSubtransactionsException) {
            throw activeSubtransactionsException;
        }
        catch (TestUpgradeSucceededException testUpgradeSucceededException) {
            throw testUpgradeSucceededException;
        }
        catch (XMLException xMLException) {
            if (xMLException.getCause() instanceof TestUpgradeSucceededException) {
                throw (TestUpgradeSucceededException)xMLException.getCause();
            }
        }
        catch (Exception exception) {
            object = new UpgradeException("UpgradeException");
            ((BatchedException)object).addException(exception, false);
            throw object;
        }
    }

    public boolean testUpgrade(List list, Properties properties) throws UpgradeException, NotCommittableException, ActiveSubtransactionsException {
        Properties properties2 = null;
        properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        if (null == properties2.getProperty(UPGRADE_TEST_UPGRADE_OPTION)) {
            properties2.setProperty(UPGRADE_TEST_UPGRADE_OPTION, UPGRADE_TEST_UPGRADE_CHOICE_COMPLETE);
        }
        try {
            this.upgrade(list, properties2);
        }
        catch (TestUpgradeSucceededException testUpgradeSucceededException) {
            // empty catch block
        }
        return true;
    }
}

