/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.Set;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockFetcher;
import oracle.express.olapi.data.CursorBlockManager;
import oracle.express.olapi.data.CursorBlockProvider;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.olapi.data.cursor.PositionOutOfBoundsException;
import oracle.olapi.data.cursor.StructureUpdatedException;

final class PrimaryCursorBlockProvider
extends CursorBlockProvider {
    private CursorBlockFetcher _cursorBlockFetcher;
    private boolean _dead;

    public PrimaryCursorBlockProvider(CursorBlockFetcher cursorBlockFetcher, CursorBlockManager cursorBlockManager) {
        super(cursorBlockManager);
        this._cursorBlockFetcher = cursorBlockFetcher;
        this._dead = false;
    }

    public final CursorBlock getCursorBlock(CursorTreeManager cursorTreeManager, Set set) {
        int n;
        int n2;
        if (this._dead) {
            throw new StructureUpdatedException();
        }
        long[] lArray = new long[cursorTreeManager.getNumCursors()];
        for (n2 = 0; n2 < cursorTreeManager.getNumCursors(); ++n2) {
            lArray[n2] = cursorTreeManager.getCursor(n2).getPositionDirect();
        }
        n2 = 0;
        for (int i = 0; i < cursorTreeManager.getNumCursors(); ++i) {
            if (cursorTreeManager.getCursor(i).getFetchSizeDirect() == -1) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < cursorTreeManager.getNumCursors(); ++i) {
            n = cursorTreeManager.getCursor(i).getFetchSizeDirect();
            if (n == -1) continue;
            nArray[n3++] = n;
        }
        CursorBlock cursorBlock = this._cursorBlockFetcher.fetchCursorBlock(lArray, nArray, cursorTreeManager.getParameters(), cursorTreeManager);
        this.getCursorBlockManager().initialize(cursorBlock);
        n = cursorTreeManager.validateWithBlock(cursorBlock, set) ? 1 : 0;
        if (n == 0) {
            throw new PositionOutOfBoundsException();
        }
        return cursorBlock;
    }

    public final CursorBlock getAnyCursorBlock(CursorTreeManager cursorTreeManager) {
        if (this._dead) {
            throw new StructureUpdatedException();
        }
        CursorBlock cursorBlock = this._cursorBlockFetcher.fetchAnyCursorBlock(cursorTreeManager.getParameters(), cursorTreeManager);
        this.getCursorBlockManager().initialize(cursorBlock);
        return cursorBlock;
    }

    public void die() {
        this._dead = true;
    }
}

