/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.Iterator;
import oracle.express.olapi.data.AncestorRequestedCursorPositionState;
import oracle.express.olapi.data.CursorPositionState;
import oracle.express.olapi.data.CursorStructure;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.CursorValidationContext;
import oracle.express.olapi.data.ExpressCompoundCursor;
import oracle.express.olapi.data.RequestedCursorPositionState;
import oracle.express.olapi.data.ValidCursorPositionState;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.cursor.NotSpecifiedException;
import oracle.olapi.data.cursor.PositionOutOfBoundsException;
import oracle.olapi.data.cursor.SourceIdentifier;

abstract class ExpressCursor
implements Cursor {
    private CursorStructure _cursorStructure;
    private long _position;
    private int _fetchSize;
    private ExpressCompoundCursor _parent;
    private CursorTreeManager _cursorTreeManager;
    private CursorPositionState _positionState;
    private int _index;
    private long _extent;

    protected ExpressCursor(CursorStructure cursorStructure, ExpressCompoundCursor expressCompoundCursor, CursorTreeManager cursorTreeManager) {
        this._cursorStructure = cursorStructure;
        this._fetchSize = cursorStructure._getDefaultFetchSize();
        this._parent = expressCompoundCursor;
        this._cursorTreeManager = cursorTreeManager;
        this.setPositionToValid(1L, 0, 0);
        this._extent = -1L;
        cursorTreeManager.registerCursor(cursorStructure._getId(), this);
    }

    final boolean isValid() {
        return this._positionState == ValidCursorPositionState.INSTANCE;
    }

    final boolean isRequested() {
        return this._positionState == RequestedCursorPositionState.INSTANCE;
    }

    final int getId() {
        return this.getCursorStructure()._getId();
    }

    final ExpressCompoundCursor getParent() {
        return this._parent;
    }

    final CursorTreeManager getCursorTreeManager() {
        return this._cursorTreeManager;
    }

    public final SourceIdentifier getSource() {
        return this._cursorStructure._getSourceIdentifier();
    }

    public final long getPosition() {
        boolean bl = this.getCursorTreeManager().checkEmpty();
        if (!this.isValid() || !bl) {
            this.getCursorTreeManager().revalidate();
        }
        return this.getPositionDirect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosition(long l) throws PositionOutOfBoundsException {
        if (l < 1L) {
            throw new PositionOutOfBoundsException();
        }
        CursorTreeManager cursorTreeManager = this.getCursorTreeManager();
        synchronized (cursorTreeManager) {
            this.getCursorTreeManager().checkEmpty();
            this.getCursorTreeManager().setInvalid();
            this._cursorStructure._setPosition(l, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean next() {
        CursorTreeManager cursorTreeManager = this.getCursorTreeManager();
        synchronized (cursorTreeManager) {
            this.getCursorTreeManager().checkEmpty();
            this.getCursorTreeManager().revalidate();
            this.getCursorTreeManager().setInvalid();
            return this._cursorStructure._next(this.getCursorTreeManager());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getExtent() throws NotSpecifiedException {
        CursorTreeManager cursorTreeManager = this.getCursorTreeManager();
        synchronized (cursorTreeManager) {
            boolean bl = this.getCursorTreeManager().checkEmpty();
            if (this.isValid() && this._extent != -1L && bl) {
                return this._extent;
            }
            this.getCursorTreeManager().revalidate();
            this._extent = this._cursorStructure._getExtent(this.getCursorTreeManager());
            return this._extent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getParentStart() throws NotSpecifiedException {
        CursorTreeManager cursorTreeManager = this.getCursorTreeManager();
        synchronized (cursorTreeManager) {
            this.getCursorTreeManager().checkEmpty();
            this.getCursorTreeManager().revalidate();
            return this._cursorStructure._getParentStart(this.getCursorTreeManager());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getParentEnd() throws NotSpecifiedException {
        CursorTreeManager cursorTreeManager = this.getCursorTreeManager();
        synchronized (cursorTreeManager) {
            this.getCursorTreeManager().checkEmpty();
            this.getCursorTreeManager().revalidate();
            return this._cursorStructure._getParentEnd(this.getCursorTreeManager());
        }
    }

    public final int getFetchSize() {
        return this._cursorStructure._getFetchSize(this.getCursorTreeManager());
    }

    public final void setFetchSize(int n) throws NotSpecifiedException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this._cursorStructure._setFetchSize(n, this.getCursorTreeManager());
    }

    public final long getPositionDirect() {
        return this._position;
    }

    public final void setPositionToInvalid(CursorPositionState cursorPositionState) {
        this._position = -1L;
        this._positionState = cursorPositionState;
    }

    public final void setPositionToRequested(long l) {
        this._position = l;
        this._positionState = RequestedCursorPositionState.INSTANCE;
    }

    public final void setPositionToValid(long l, int n, int n2) {
        this._position = l;
        this._index = n;
        this.setDataIndex(n2);
        this._extent = -1L;
        this._positionState = ValidCursorPositionState.INSTANCE;
    }

    public void setDataIndex(int n) {
    }

    public final void requestPosition(long l) {
        this.getCursorTreeManager().setInvalid();
        this._positionState.requestPosition(l, this);
    }

    public final void validatePosition(CursorValidationContext cursorValidationContext) {
        this._positionState.validatePosition(cursorValidationContext, this);
    }

    public final void validateRequest(CursorValidationContext cursorValidationContext) {
        this._positionState.validateRequest(cursorValidationContext, this);
    }

    public int getIndex(CursorValidationContext cursorValidationContext) {
        if (this.isValid() && this.getCursorTreeManager().getCurrentCursorBlock() == cursorValidationContext.getCursorBlock()) {
            return this._index;
        }
        return this._cursorStructure.getIndex(cursorValidationContext);
    }

    public final int getIndexDirect() {
        return this._index;
    }

    public final void exteriorDependencyRequested() {
        this._positionState.exteriorDependencyRequested(this);
    }

    public final int getFetchSizeDirect() {
        return this._fetchSize;
    }

    public final void setFetchSizeDirect(int n) {
        this._fetchSize = n;
    }

    protected void broadcastPositionRequestToAncestors() {
        if (this._parent != null) {
            this._parent.descendantRequested();
        }
    }

    protected abstract void broadcastPositionRequestToDescendants();

    protected final void broadcastPositionRequestToExteriorDependents() {
        Iterator iterator = this.getCursorTreeManager().getCursorBlockManager()._getExteriorDependentIds(this.getCursorStructure()._getId(), this.getCursorTreeManager()).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n >= this.getCursorTreeManager().getNumCursors()) continue;
            this.getCursorTreeManager().getCursor(n).exteriorDependencyRequested();
        }
    }

    protected final void ancestorRequested() {
        this.setPositionToInvalid(AncestorRequestedCursorPositionState.INSTANCE);
        this.broadcastPositionRequestToDescendants();
    }

    protected abstract void aggregatePositionFromInteriorDependencies(CursorValidationContext var1);

    protected abstract void allocatePositionToInteriorDependencies(CursorValidationContext var1);

    protected final CursorStructure getCursorStructure() {
        return this._cursorStructure;
    }

    public abstract void setDescendantPositionsToOne();

    public abstract void validateAncestorRequestedLeaves();

    public final void setPositionToOneIfAncestorRequested() {
        if (this._positionState == AncestorRequestedCursorPositionState.INSTANCE) {
            this.setPositionToValid(1L, -1, -1);
        }
    }

    public final boolean validateWithBlock(CursorValidationContext cursorValidationContext) {
        this.validatePosition(cursorValidationContext);
        return this.getCursorStructure().validateWithBlock(cursorValidationContext);
    }
}

