/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class OlapiTracer {
    private static final String RPC_TRACING = "RpcTracing";
    private static final String OLAPI_TRACING_DUMP_FILE = "OlapiTracingDumpFile";
    private static boolean _rpcTracing = false;
    private static PrintStream _rpcTracingPS = null;
    private static String _indent = null;

    private OlapiTracer() {
    }

    public static void init() {
        Properties properties = System.getProperties();
        String string = properties.getProperty(RPC_TRACING);
        _rpcTracing = null != string && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true"));
        String string2 = properties.getProperty(OLAPI_TRACING_DUMP_FILE);
        if (_rpcTracing) {
            try {
                _rpcTracingPS = new PrintStream(new FileOutputStream(string2, true));
            }
            catch (Exception exception) {
                _rpcTracingPS = null;
            }
        }
    }

    public static boolean isTracingEnabled() {
        return _rpcTracing && null != _rpcTracingPS;
    }

    public static void enter(String string) {
        if (!OlapiTracer.isTracingEnabled()) {
            return;
        }
        _indent = null != _indent ? _indent + " " : "";
        OlapiTracer.log("entering " + string);
    }

    public static void leave(String string) {
        if (!OlapiTracer.isTracingEnabled()) {
            return;
        }
        if (null == _indent) {
            return;
        }
        OlapiTracer.log("leaving " + string);
        _indent = 0 == _indent.length() ? null : _indent.substring(1);
    }

    public static void log(StringBuffer stringBuffer) {
        if (!OlapiTracer.isTracingEnabled()) {
            return;
        }
        if (null == stringBuffer) {
            return;
        }
        OlapiTracer.log(stringBuffer.toString());
    }

    public static void log(char[] cArray) {
        if (!OlapiTracer.isTracingEnabled()) {
            return;
        }
        if (null == cArray) {
            return;
        }
        OlapiTracer.log(new String(cArray));
    }

    public static void log(String string) {
        if (!OlapiTracer.isTracingEnabled()) {
            return;
        }
        if (null == string) {
            return;
        }
        try {
            _rpcTracingPS.println(_indent + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(Exception exception) {
        if (!OlapiTracer.isTracingEnabled()) {
            return;
        }
        if (null == exception) {
            return;
        }
        exception.printStackTrace(_rpcTracingPS);
    }
}

