/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.AssociativeLink;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.library.Book;

public class XMLLinkParser {
    public static final String TAG_LINK = "link";
    public static final String TAG_LINKITEM = "linkitem";
    public static final String TAG_LINKENTRY = "linkentry";
    public static final String PROP_TOPIC = "topic";
    public static final String PROP_TARGET = "target";
    public static final String PROP_TEXT = "text";
    private ArrayList _links;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociativeLink[] parseLinkFile(URL url, String encoding, Book book) throws IOException, XMLParseException {
        AssociativeLink[] linkArr = null;
        InputStreamReader reader = null;
        try {
            reader = LocaleUtils.createInputStreamReader(url.openStream(), encoding);
            linkArr = this.parseLinkFile(reader, book);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return linkArr;
    }

    public AssociativeLink[] parseLinkFile(Reader reader, Book book) throws XMLParseException {
        Parser parser = ParserFactory.createParser(reader);
        XMLNode root = parser.getRoot();
        this._links = new ArrayList();
        this._handleLinks(root.getFirstChild(), book);
        AssociativeLink[] linkArr = null;
        if (this._links.size() > 0) {
            linkArr = new AssociativeLink[this._links.size()];
            this._links.toArray(linkArr);
        }
        return linkArr;
    }

    private void _handleLinks(XMLNode node, Book book) throws XMLParseException {
        if (node == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!node.tokenEquals(TAG_LINK)) {
            throw new XMLParseException("Toplevel tag is not link: " + node.getTokenValue());
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            this._handleLinkItem(node, book);
        }
    }

    private void _handleLinkItem(XMLNode node, Book book) throws XMLParseException {
        if (!node.tokenEquals(TAG_LINKITEM)) {
            throw new XMLParseException("Expecting linkitem, got: " + node.getTokenValue());
        }
        String linkId = node.getTokenProperty(PROP_TOPIC);
        if (linkId == null || linkId.equals("")) {
            throw new XMLParseException("Found null topic in linkitem");
        }
        AssociativeLink aLink = new AssociativeLink(linkId);
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            this._handleLinkEntry(node, aLink, book);
        }
        if (aLink.getTopicCount() > 0) {
            this._links.add(aLink);
        }
    }

    private void _handleLinkEntry(XMLNode node, AssociativeLink aLink, Book book) throws XMLParseException {
        if (!node.tokenEquals(TAG_LINKENTRY)) {
            throw new XMLParseException("Expecting linkentry, got: " + node.getTokenValue());
        }
        String topicId = node.getTokenProperty(PROP_TARGET);
        if (topicId == null || topicId.equals("")) {
            throw new XMLParseException("Found null target in linkentry");
        }
        String topicTitle = node.getTokenProperty(PROP_TEXT);
        if (topicTitle == null || topicTitle.equals("")) {
            throw new XMLParseException("Found null title in linkentry");
        }
        IndirectTarget theTarget = new IndirectTarget(book, topicId);
        SimpleTopic theTopic = new SimpleTopic(topicTitle, theTarget);
        aLink.addTopic(theTopic);
    }
}

