/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpbook;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.help.common.util.LocaleUtils;

public class OhtParser {
    private byte[] buffer = new byte[256];
    private final int BUF_SIZE = 256;
    private final String IDMAP_BEGIN = "<ID_MAP>";
    private final String IDMAP_END = "</ID_MAP>";
    private static final boolean _debugOut = false;

    public static HashMap getTopicsHashMap(URL url, String encoding) {
        HashMap result = new HashMap();
        OhtParser.getTopicsHashMap(url, encoding, result, null);
        return result;
    }

    public static void getTopicsHashMap(URL url, String encoding, HashMap hash, HashMap reverseHash) {
        OhtParser parser = new OhtParser();
        try {
            InputStream inStream = OhtParser.openInputStream(url);
            BufferedReader reader = new BufferedReader(LocaleUtils.createInputStreamReader(inStream, encoding));
            parser.parseOht(reader, hash, reverseHash);
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private OhtParser() {
    }

    private void parseOht(BufferedReader reader, HashMap result, HashMap reverseHash) throws IOException {
        String line = "";
        String key = "";
        String value = "";
        while ((line = reader.readLine()) != null) {
            int colonLocation;
            int equalsLocation;
            if (line.toUpperCase().indexOf("</ID_MAP>") != -1 || line.toUpperCase().indexOf("<ID_MAP>") != -1 || line.length() == 0 || line.charAt(0) == ';' || (equalsLocation = line.indexOf(61)) == -1) continue;
            key = line.substring(0, equalsLocation).trim();
            if (key.charAt(0) == '\"') {
                key = key.substring(1, key.length() - 1);
            }
            if ((colonLocation = (value = line.substring(equalsLocation + 1).trim()).indexOf(58)) != -1) {
                value = value.substring(0, colonLocation).trim();
            }
            if (value.charAt(0) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            result.put(key, value);
            if (reverseHash != null) {
                ArrayList<String> topics = (ArrayList<String>)reverseHash.get(value);
                if (topics == null) {
                    topics = new ArrayList<String>();
                }
                topics.add(key);
                reverseHash.put(value, topics);
            }
            this._debug("key value = " + key + " " + value);
        }
    }

    private static InputStream openInputStream(URL url) throws IOException {
        InputStream inStream = null;
        if (url.getProtocol().equals("file")) {
            try {
                inStream = new FileInputStream(url.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inStream == null) {
            inStream = url.openStream();
        }
        return inStream;
    }

    private void _debug(String string) {
    }
}

