/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.AssociativeLink;
import oracle.help.common.AssociativeLinkRepository;
import oracle.help.common.View;
import oracle.help.common.WindowType;
import oracle.help.common.WindowTypeRepository;
import oracle.help.library.Book;
import oracle.help.library.LibraryEvent;
import oracle.help.library.LibraryException;
import oracle.help.library.LibraryListener;

public class Library {
    private ArrayList _books = new ArrayList();
    private ListenerManager _listeners = new ListenerManager();
    private WindowTypeRepository _windowTypes = new WindowTypeRepository();
    private AssociativeLinkRepository _associativeLinks = new AssociativeLinkRepository();

    public void addLibraryListener(LibraryListener listener) {
        if (listener != null) {
            this._listeners.addListener((EventListener)listener);
        }
    }

    public void removeLibraryListener(LibraryListener listener) {
        if (listener != null) {
            this._listeners.removeListener((EventListener)listener);
        }
    }

    public void addBook(Book book) throws LibraryException {
        if (book != null) {
            if (this._books.contains(book)) {
                throw new LibraryException("Library: Cannot add the same book twice.");
            }
        } else {
            throw new LibraryException("Library: Cannot add a NULL book");
        }
        this._books.add(book);
        this._windowTypes.addWindowTypesInBook(book);
        this._associativeLinks.addLinksInBook(book);
        this._fireLibraryChanged(new LibraryEvent(this, 2001, book));
    }

    public int getBookCount() {
        return this._books.size();
    }

    public Book[] getBooks() {
        Book[] bookArr = null;
        if (this._books.size() > 0) {
            bookArr = new Book[this._books.size()];
            this._books.toArray(bookArr);
        }
        return bookArr;
    }

    public Book getBookByName(String bookTitle) {
        if (bookTitle != null) {
            for (Book book : this._books) {
                if (!bookTitle.equals(book.getBookTitle())) continue;
                return book;
            }
        }
        return null;
    }

    public void removeBook(Book book) throws LibraryException {
        if (book != null) {
            if (!this._books.contains(book)) {
                throw new LibraryException("Library: Attempted to remove a book not in the library.");
            }
        } else {
            throw new LibraryException("Library: Cannot remove a NULL book");
        }
        this._books.remove(book);
        this._windowTypes.removeWindowTypesInBook(book);
        this._associativeLinks.removeLinksInBook(book);
        this._fireLibraryChanged(new LibraryEvent(this, 2002, book));
    }

    public View[] getAllViews() {
        return this._createViewArray(false, null);
    }

    public View[] getViewsByType(String type) {
        if (type == null) {
            return null;
        }
        return this._createViewArray(true, type);
    }

    public WindowType getDefaultWindowType() {
        return this._windowTypes.getDefaultWindowType();
    }

    public WindowType getWindowType(String name) {
        return this._windowTypes.getWindowType(name);
    }

    public AssociativeLink getAssociativeLink(String linkID) {
        return this._associativeLinks.getLink(linkID);
    }

    public URL mapIDToURL(String id) {
        URL foundURL = null;
        for (int iter = 0; foundURL == null && iter < this._books.size(); ++iter) {
            Book aBook = (Book)this._books.get(iter);
            if (aBook == null) continue;
            foundURL = aBook.mapIDToURL(id);
        }
        return foundURL;
    }

    public String mapURLToWindowTypeName(URL url) {
        String foundName = null;
        for (int iter = 0; foundName == null && iter < this._books.size(); ++iter) {
            Book aBook = (Book)this._books.get(iter);
            if (aBook == null) continue;
            foundName = aBook.mapURLToWindowTypeName(url);
        }
        return foundName;
    }

    public WindowType mapURLToWindowType(URL url) {
        WindowType winType = null;
        String windowName = this.mapURLToWindowTypeName(url);
        if (windowName != null) {
            winType = this.getWindowType(windowName);
        }
        if (winType == null) {
            winType = this.getDefaultWindowType();
        }
        return winType;
    }

    private void _fireLibraryChanged(LibraryEvent event) {
        Enumeration listeners = this._listeners.getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                LibraryListener l = (LibraryListener)listeners.nextElement();
                l.libraryChanged(event);
            }
        }
    }

    private View[] _createViewArray(boolean byType, String type) {
        int iter = 0;
        int viewIter = 0;
        ArrayList<View> views = new ArrayList<View>();
        if (byType && type == null) {
            return null;
        }
        for (iter = 0; iter < this._books.size(); ++iter) {
            Book aBook = (Book)this._books.get(iter);
            View[] viewArr = null;
            viewArr = byType ? aBook.getViewsByType(type) : aBook.getAllViews();
            if (viewArr == null) continue;
            for (viewIter = 0; viewIter < viewArr.length; ++viewIter) {
                if (views.contains(viewArr[viewIter])) continue;
                views.add(viewArr[viewIter]);
            }
        }
        View[] combinedViews = null;
        if (views.size() > 0) {
            combinedViews = new View[views.size()];
            views.toArray(combinedViews);
        }
        return combinedViews;
    }
}

