/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import oracle.help.common.xml.XMLToken;

public class XMLTokenizer {
    private BufferedReader _reader;
    private boolean _newLine = true;
    private XMLToken _heldToken;

    public XMLTokenizer(Reader reader) {
        this._reader = new BufferedReader(reader);
    }

    public XMLToken nextToken() throws IOException {
        if (this._heldToken != null) {
            XMLToken token = this._heldToken;
            this._heldToken = null;
            return token;
        }
        String token = this._nextToken();
        if (token == null) {
            return null;
        }
        if (token.equals("<")) {
            int space;
            token = this._nextToken();
            this._nextToken();
            if (token.charAt(0) == '/') {
                return new XMLToken(token.substring(1), 2, null);
            }
            if (token.charAt(0) == '?') {
                return new XMLToken(token, 4, null);
            }
            if (token.charAt(0) == '!') {
                return new XMLToken(token, 5, null);
            }
            boolean selfTerminate = false;
            if (token.charAt(token.length() - 1) == '/') {
                token = token.substring(0, token.length() - 1);
                selfTerminate = true;
            }
            if ((space = token.indexOf(32)) == -1) {
                if (selfTerminate) {
                    this._heldToken = new XMLToken(token, 2, null);
                }
                return new XMLToken(token, 1, null);
            }
            String tagName = token.substring(0, space);
            String attributes = token.substring(space + 1);
            HashMap<String, String> properties = new HashMap<String, String>(11);
            int attrEnd = 0;
            while (true) {
                String attrValue;
                int equals = attributes.indexOf("=", attrEnd);
                String attrName = attributes.substring(attrEnd, equals);
                if (attributes.charAt(equals + 1) == '\"') {
                    attrEnd = attributes.indexOf("\"", equals + 2);
                    attrValue = attributes.substring(equals + 2, attrEnd);
                    attrEnd += 2;
                } else {
                    attrEnd = attributes.indexOf(" ", equals + 1);
                    if (attrEnd == -1) {
                        attrValue = attributes.substring(equals + 1);
                    } else {
                        attrValue = attributes.substring(equals + 1, attrEnd);
                        ++attrEnd;
                    }
                }
                properties.put(attrName, attrValue);
                if (attrEnd == -1 || attrEnd >= attributes.length()) break;
                equals = attrEnd;
            }
            if (selfTerminate) {
                this._heldToken = new XMLToken(tagName, 2, null);
            }
            return new XMLToken(tagName, 1, properties);
        }
        return new XMLToken(token, 3, null);
    }

    private String _nextToken() throws IOException {
        boolean inString = false;
        StringBuffer output = null;
        while (true) {
            this._reader.mark(1);
            int character = this._reader.read();
            if (character == -1) {
                return null;
            }
            if (this._newLine && (character == 32 || character == 9 || character == 13 || character == 10)) continue;
            if (this._newLine && character == 33) {
                this._reader.readLine();
                continue;
            }
            this._newLine = false;
            if (character == 60 || character == 62) {
                if (inString) {
                    this._reader.reset();
                    return new String(output);
                }
                return String.valueOf((char)character);
            }
            if (character == 10 || character == 13) {
                character = 32;
                this._newLine = true;
                continue;
            }
            inString = true;
            if (output == null) {
                output = new StringBuffer();
            }
            output.append((char)character);
        }
    }
}

