/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;

public class QueryStringBreaker {
    private QueryStringBreaker() {
    }

    public static void breakQueryString(String queryString, Locale locale, ArrayList wordsList, boolean caseSensitive) {
        BreakIterator boundary = BreakIterator.getWordInstance(locale);
        boundary.setText(queryString);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String wordStart = queryString.substring(start, end).trim();
            if (wordStart.length() != 0 && !wordStart.equals("*")) {
                if (!caseSensitive) {
                    wordStart = wordStart.toLowerCase();
                }
                start = end;
                end = boundary.next();
                if (end == -1) {
                    wordsList.add(wordStart);
                    return;
                }
                String wordMiddle = queryString.substring(start, end).trim();
                if (wordMiddle.length() == 0) {
                    wordsList.add(wordStart);
                } else if (!wordMiddle.equals("*")) {
                    end = boundary.previous();
                    wordsList.add(wordStart);
                } else {
                    start = end;
                    end = boundary.next();
                    if (end == -1) {
                        wordsList.add(wordStart + "*");
                        return;
                    }
                    String wordEnd = queryString.substring(start, end).trim();
                    if (wordEnd.length() == 0 || wordEnd.equals("*")) {
                        wordsList.add(wordStart + "*");
                    } else {
                        if (!caseSensitive) {
                            wordEnd = wordEnd.toLowerCase();
                        }
                        wordsList.add(wordStart + "*" + wordEnd);
                    }
                }
            }
            start = end;
            end = boundary.next();
        }
    }
}

