/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.QueryResult;
import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;

public class IndexFileQueryHandler
extends QueryHandler {
    private URL _url;
    private View _view;
    private char[] _alphabet;
    private long[] _alphaOffsets;
    private long _eowOffset;
    private long _fsOffset;
    private String _productTitle;
    private int _version;
    private String _encoding;
    private boolean _fileCase;
    private boolean _scoreAvailable;
    private boolean _positionsAvailable;
    private boolean _titlesAvailable;
    private String _rootPath;
    private String _sourceIdentifier;
    private ResultObjectContainerType _defaultContainerType = ResultObjectContainerType.LINKED_HASH_MAP;
    private final ResultObjectMap _emptyResultObjectMap = new ResultObjectEmptyMap();
    private boolean _stopSearch = false;
    private boolean _needToParseHeader = true;
    private static final int VERSION_10 = 10;
    private static final int VERSION_11 = 11;
    private static final int VERSION_20 = 20;
    private static final int VERSION_21 = 21;
    static final String INDEX_VERSION = "OIN-INDEX-VERSION";
    static final String CHARACTER_SET = "CHARACTER-SET";
    static final String PRODUCT_TITLE = "PRODUCT-TITLE";
    static final String CASESENSITIVE = "CASESENSITIVE";
    static final String TITLES = "TITLES";
    static final String BLOCK_SIZE = "BLOCK-SIZE";
    static final String SCORES = "SCORES";
    static final String POSITIONS = "POSITIONS";
    static final String ROOT_PATH = "ROOTPATH";
    static final String TRUE = "TRUE";

    public static IndexFileQueryHandler getInstance(View view, String basePath, URL url) {
        IndexFileQueryHandler object = null;
        try {
            object = new IndexFileQueryHandler(view, basePath, url);
            return object;
        }
        catch (Exception e) {
            System.out.println("Invalid IDX file URL.  IOException when accessing " + url.toString());
            e.printStackTrace();
            return null;
        }
    }

    public URL getIndexFileUrl() {
        return this._url;
    }

    @Override
    public void stopSearch() {
        this._stopSearch = true;
    }

    @Override
    public boolean supportsCaseSensitiveSearches() {
        return true;
    }

    @Override
    public Set getSupportedSources() {
        if (this._sourceIdentifier == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(this._sourceIdentifier);
    }

    public String productTitle() {
        return this._productTitle;
    }

    @Override
    public synchronized List executeQuery(String[] words, boolean allWords, boolean caseSensitive, Set selectedSources) throws SearchException {
        this._stopSearch = false;
        this._checkSources(selectedSources);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        ResultObjectMap results = null;
        try {
            results = this._executeStringQuery(words, allWords, caseSensitive);
        }
        catch (SearchInterruptedError e) {
            return Collections.EMPTY_LIST;
        }
        if (results.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResultObject> sortedResults = results.toList();
        if (this._scoreAvailable && !sortedResults.isEmpty()) {
            IndexFileQueryHandler._quickSort(sortedResults, 0, sortedResults.size() - 1);
        }
        return sortedResults;
    }

    @Override
    public synchronized List executeQuery(SearchExpression expression, Set selectedSources) throws SearchException {
        this._stopSearch = false;
        this._checkSources(selectedSources);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        ResultObjectMap results = null;
        try {
            results = this._executeBooleanQuery(expression);
        }
        catch (SearchInterruptedError e) {
            return Collections.EMPTY_LIST;
        }
        if (results.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResultObject> sortedResults = results.toList();
        if (this._scoreAvailable && !sortedResults.isEmpty()) {
            IndexFileQueryHandler._quickSort(sortedResults, 0, sortedResults.size() - 1);
        }
        return sortedResults;
    }

    private void _checkSources(Set selectedSources) throws SearchException {
        if (selectedSources != null && !selectedSources.isEmpty()) {
            for (String source : selectedSources) {
                if (source.equals(this._sourceIdentifier)) continue;
                throw new SearchException("IndexFileQueryHandler: " + this._url + "\n" + "Called with unsupported source: " + source);
            }
        }
    }

    private void _checkStopSearch() {
        if (this._stopSearch) {
            throw new SearchInterruptedError("Search Interrupted");
        }
    }

    private ResultObjectMap _executeStringQuery(String[] words, boolean allWords, boolean caseSensitive) throws SearchException {
        int expr;
        if (words == null || words.length == 0) {
            return this._emptyResultObjectMap;
        }
        List<StringQuery> queryList = this._processQueryWords(words);
        Iterator<StringQuery> iter = queryList.iterator();
        if (!iter.hasNext()) {
            return this._emptyResultObjectMap;
        }
        StringQuery query = iter.next();
        ResultObjectMap combinedResults = this._processSingleStringQuery(query, allWords, !this._fileCase || caseSensitive);
        int n = expr = allWords ? 1 : 2;
        while (iter.hasNext()) {
            query = iter.next();
            ResultObjectMap queryResults = this._processSingleStringQuery(query, allWords, !this._fileCase || caseSensitive);
            this._combineResults(combinedResults, queryResults, expr);
        }
        return combinedResults;
    }

    private ResultObjectMap _processSingleStringQuery(StringQuery stringQuery, boolean allWords, boolean caseSensitive) throws SearchException {
        InputStream inStream = null;
        try {
            inStream = this._openInputStream(this._url);
        }
        catch (Exception e) {
            this._closeInputStream(inStream);
            this._throwSearchException(e);
        }
        InputStreamWrapper inWrapper = new InputStreamWrapper(inStream);
        if (stringQuery.isWildcardQuery()) {
            stringQuery.removeWildcardRedundancies();
        }
        String[] searchWords = stringQuery.getSortedUniqueWordsAsArray();
        LinkedList<IndexWord> indexWords = new LinkedList<IndexWord>();
        int totalSearchWordsFound = 0;
        try {
            totalSearchWordsFound = this._findMatchingIndexWords(inWrapper, searchWords, allWords, caseSensitive, indexWords);
        }
        catch (Exception e) {
            this._closeInputStream(inStream);
            this._throwSearchException(e);
        }
        if (totalSearchWordsFound == 0 || allWords && totalSearchWordsFound < searchWords.length) {
            this._closeInputStream(inStream);
            return this._emptyResultObjectMap;
        }
        ResultObjectMap results = null;
        try {
            results = this._getResults(inWrapper, indexWords, searchWords, allWords);
        }
        catch (Exception e) {
            this._closeInputStream(inStream);
            this._throwSearchException(e);
        }
        if (stringQuery.isExactPhraseQuery()) {
            this._doExactPhraseMatching(results, stringQuery);
        } else {
            this._adjustScoresUsingPositionData(results);
        }
        if (results.isEmpty()) {
            this._closeInputStream(inStream);
            return results;
        }
        try {
            inWrapper.skipToOffset(this._fsOffset);
            this._readFileNames(inWrapper, results, null);
        }
        catch (Exception e) {
            this._closeInputStream(inStream);
            this._throwSearchException(e);
        }
        this._closeInputStream(inStream);
        return results;
    }

    private int _findMatchingIndexWords(InputStreamWrapper inWrapper, String[] searchWords, boolean allWords, boolean caseSensitive, List<IndexWord> indexWords) throws IOException {
        byte[] buffer = new byte[1000];
        byte[] str = this._version < 20 ? new byte[512] : new byte[255];
        boolean[] wasSearchWordFound = new boolean[searchWords.length];
        wasSearchWordFound[0] = false;
        int totalSearchWordsFound = 0;
        ArrayList<Integer> searchWordBoundaries = new ArrayList<Integer>(searchWords.length);
        char firstChar = searchWords[0].charAt(0);
        for (int i = 1; i < searchWords.length; ++i) {
            wasSearchWordFound[i] = false;
            char nextChar = searchWords[i].charAt(0);
            if (nextChar == firstChar) continue;
            searchWordBoundaries.add(i);
            firstChar = nextChar;
        }
        searchWordBoundaries.add(searchWords.length);
        int nloops = caseSensitive ? 1 : 2;
        for (int pass = 0; pass < nloops; ++pass) {
            int start = 0;
            for (Integer end : searchWordBoundaries) {
                char c = !caseSensitive && pass == 0 ? Character.toUpperCase(searchWords[start].charAt(0)) : searchWords[start].charAt(0);
                int alphaIndex = this._getAlphabetIndex(c);
                if (alphaIndex == -1) {
                    if (allWords) {
                        if (nloops == 1) {
                            return totalSearchWordsFound;
                        }
                        if (pass == nloops - 1) {
                            for (int i = start; i < end; ++i) {
                                if (wasSearchWordFound[i]) continue;
                                return totalSearchWordsFound;
                            }
                        }
                    }
                    start = end;
                    continue;
                }
                long offset = this._alphaOffsets[alphaIndex];
                if (inWrapper.getPosition() > offset) {
                    start = end;
                    continue;
                }
                long boundingOffset = alphaIndex == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[alphaIndex + 1];
                inWrapper.skipToOffset(offset);
                int totalBytesAvailable = (int)(boundingOffset - offset);
                int buffIdx = 0;
                boolean doneReadingIndexData = false;
                while (!doneReadingIndexData) {
                    int currBytesAvailable;
                    int spaceAvailable = buffer.length - buffIdx;
                    if (totalBytesAvailable <= spaceAvailable) {
                        currBytesAvailable = totalBytesAvailable;
                        doneReadingIndexData = true;
                    } else {
                        currBytesAvailable = spaceAvailable;
                        totalBytesAvailable -= currBytesAvailable;
                    }
                    inWrapper.read(buffer, buffIdx, currBytesAvailable);
                    currBytesAvailable += buffIdx;
                    int loc = 0;
                    int wordIndex = 0;
                    String indexWord = null;
                    String lowercaseIndexWord = null;
                    while (start < end) {
                        int idx = 0;
                        wordIndex = loc;
                        if (this._version < 20) {
                            boolean finishedWord = true;
                            do {
                                if (loc >= currBytesAvailable) {
                                    finishedWord = false;
                                    break;
                                }
                                str[idx++] = buffer[loc++];
                            } while (str[idx - 1] != 32);
                            if (!finishedWord) break;
                            indexWord = new String(str, 0, idx - 1);
                        } else {
                            int len;
                            if (loc >= currBytesAvailable) break;
                            if ((len = buffer[loc++]) < 0) {
                                len = 256 + len;
                            }
                            boolean finishedWord = true;
                            while (len != 0) {
                                if (loc >= currBytesAvailable) {
                                    finishedWord = false;
                                    break;
                                }
                                str[idx++] = buffer[loc++];
                                --len;
                            }
                            if (!finishedWord) break;
                            try {
                                indexWord = new String(str, 0, idx, this._encoding);
                            }
                            catch (UnsupportedEncodingException e) {
                                indexWord = new String(str, 0, idx);
                            }
                        }
                        if (loc + 3 >= currBytesAvailable) break;
                        if (!caseSensitive) {
                            lowercaseIndexWord = indexWord.toLowerCase();
                        }
                        long fileOffset = -1L;
                        for (int i = start; i < end; ++i) {
                            int strcmp = this._searchWordCompareToIndexWord(searchWords[i], indexWord, lowercaseIndexWord);
                            if (strcmp < 0) {
                                if (i == start) {
                                    ++start;
                                }
                                if (!allWords || pass != nloops - 1 || wasSearchWordFound[i]) continue;
                                return totalSearchWordsFound;
                            }
                            if (strcmp != 0) continue;
                            if (fileOffset == -1L) {
                                fileOffset = 0L;
                                for (int j = 0; j < 4; ++j) {
                                    int ch = buffer[loc + j];
                                    if (ch < 0) {
                                        ch = 256 + ch;
                                    }
                                    fileOffset |= (long)(ch << 8 * (3 - j));
                                }
                            }
                            if (!wasSearchWordFound[i]) {
                                wasSearchWordFound[i] = true;
                                ++totalSearchWordsFound;
                            }
                            indexWords.add(new IndexWord(fileOffset, (byte)i));
                        }
                        loc += 4;
                    }
                    if (start == end || doneReadingIndexData) break;
                    int i = 0;
                    while (wordIndex < currBytesAvailable) {
                        buffer[i] = buffer[wordIndex++];
                        ++i;
                    }
                    buffIdx = i;
                }
                this._checkStopSearch();
                start = end;
            }
        }
        return totalSearchWordsFound;
    }

    private void _throwSearchException(Exception e) throws SearchException {
        throw new SearchException("IndexFileQueryHandler: " + this._url + "\n" + "Error encountered executing search: " + e.getMessage(), e);
    }

    private void _closeInputStream(InputStream inStream) {
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int _searchWordCompareToIndexWord(String searchWord, String indexWord, String lowercaseIndexWord) {
        int suffixLen;
        Character searchWordChar;
        int i;
        int indexWordLen;
        int minLen;
        int searchWordLen = searchWord.length();
        int n = minLen = searchWordLen < (indexWordLen = indexWord.length()) ? searchWordLen : indexWordLen;
        if (lowercaseIndexWord == null) {
            int suffixLen2;
            Character searchWordChar2;
            int i2;
            for (i2 = 1; i2 < minLen && (searchWordChar2 = Character.valueOf(searchWord.charAt(i2))).charValue() != '*'; ++i2) {
                int charcmp = searchWordChar2.compareTo(Character.valueOf(indexWord.charAt(i2)));
                if (charcmp == 0) continue;
                return charcmp;
            }
            if (i2 == minLen) {
                if (indexWordLen >= searchWordLen) {
                    return searchWordLen - indexWordLen;
                }
                if (searchWord.charAt(i2) != '*') {
                    return 1;
                }
            }
            if ((suffixLen2 = searchWordLen - ++i2) == 0) {
                return 0;
            }
            if (indexWordLen >= searchWordLen - 1) {
                --indexWordLen;
                --searchWordLen;
                int j = 0;
                while (j < suffixLen2) {
                    searchWordChar2 = Character.valueOf(searchWord.charAt(searchWordLen));
                    if (!searchWordChar2.equals(Character.valueOf(indexWord.charAt(indexWordLen)))) {
                        return 1;
                    }
                    ++j;
                    --indexWordLen;
                    --searchWordLen;
                }
                return 0;
            }
            return 1;
        }
        boolean isEqualIgnoreCase = true;
        int strcmp = 0;
        for (i = 1; i < minLen && (searchWordChar = Character.valueOf(searchWord.charAt(i))).charValue() != '*'; ++i) {
            if (strcmp == 0) {
                strcmp = searchWordChar.compareTo(Character.valueOf(indexWord.charAt(i)));
            }
            if (isEqualIgnoreCase = searchWordChar.equals(Character.valueOf(lowercaseIndexWord.charAt(i)))) continue;
            return strcmp;
        }
        if (i == minLen) {
            if (indexWordLen == searchWordLen) {
                return 0;
            }
            if (indexWordLen > searchWordLen) {
                return strcmp != 0 ? strcmp : -1;
            }
            if (searchWord.charAt(i) != '*') {
                return strcmp != 0 ? strcmp : 1;
            }
        }
        if ((suffixLen = searchWordLen - ++i) == 0) {
            return 0;
        }
        if (indexWordLen >= searchWordLen - 1) {
            --indexWordLen;
            --searchWordLen;
            int j = 0;
            while (j < suffixLen) {
                searchWordChar = Character.valueOf(searchWord.charAt(searchWordLen));
                if (!searchWordChar.equals(Character.valueOf(lowercaseIndexWord.charAt(indexWordLen)))) {
                    return strcmp != 0 ? strcmp : 1;
                }
                ++j;
                --indexWordLen;
                --searchWordLen;
            }
            return 0;
        }
        return strcmp != 0 ? strcmp : 1;
    }

    private void _adjustScoresUsingPositionData(ResultObjectMap results) throws SearchException {
        if (this._positionsAvailable && !results.isEmpty()) {
            for (ResultObject result : results) {
                LinkedHashMap<String, List<int[]>> positionDataMap = result.getPositionDataMap();
                if (positionDataMap != null && positionDataMap.size() > 1) {
                    int destStartOffset = 0;
                    int[] combinedPositions = new int[result.getTotalPositionCount()];
                    for (String word : positionDataMap.keySet()) {
                        for (int[] positions : positionDataMap.get(word)) {
                            if (positions.length <= 0) continue;
                            System.arraycopy(positions, 0, combinedPositions, destStartOffset, positions.length);
                            destStartOffset += positions.length;
                        }
                    }
                    if (combinedPositions.length > 0) {
                        double scoreIncrease = 0.0;
                        Arrays.sort(combinedPositions);
                        int inARow = 0;
                        block8: for (int pIndex = 1; pIndex < combinedPositions.length; ++pIndex) {
                            int currentDelta = combinedPositions[pIndex] - combinedPositions[pIndex - 1];
                            switch (currentDelta) {
                                case 1: {
                                    scoreIncrease = scoreIncrease + 4.0 + 1.5 * (double)inARow;
                                    if (combinedPositions[pIndex] < 25) {
                                        scoreIncrease = combinedPositions[pIndex] < 10 ? (combinedPositions[pIndex] < 5 ? scoreIncrease + 15.0 + (double)(5 * inARow) : scoreIncrease + 10.0 + (double)(5 * inARow)) : (scoreIncrease += 5.0);
                                    }
                                    ++inARow;
                                    continue block8;
                                }
                                case 2: {
                                    inARow = 0;
                                    scoreIncrease += 2.0;
                                    if (combinedPositions[pIndex] >= 25) continue block8;
                                    if (combinedPositions[pIndex] < 10) {
                                        if (combinedPositions[pIndex] < 5) {
                                            scoreIncrease += 10.0;
                                            continue block8;
                                        }
                                        scoreIncrease += 7.0;
                                        continue block8;
                                    }
                                    scoreIncrease += 3.0;
                                    continue block8;
                                }
                                case 3: {
                                    inARow = 0;
                                    scoreIncrease += 0.75;
                                    continue block8;
                                }
                                default: {
                                    inARow = 0;
                                }
                            }
                        }
                        result.setHitNumber(result.getHitNumber() + (int)scoreIncrease);
                    }
                }
                this._checkStopSearch();
            }
        }
    }

    private void _doExactPhraseMatching(ResultObjectMap results, StringQuery query) throws SearchException {
        if (this._positionsAvailable && !results.isEmpty()) {
            String[] phrase = query.getExactPhraseWordsAsArray();
            for (ResultObject result : results) {
                LinkedHashMap<String, List<int[]>> positionDataMap = result.getPositionDataMap();
                if (positionDataMap != null && result.getTotalPositionCount() > 0) {
                    Set<String> wordSet = positionDataMap.keySet();
                    if (wordSet.size() == query.getSortedUniqueWords().size()) {
                        int nextCombinedOffset = 0;
                        int[] combinedPositions = new int[result.getTotalPositionCount()];
                        for (int phraseIndex = 0; phraseIndex < phrase.length; ++phraseIndex) {
                            for (int[] positions : positionDataMap.get(phrase[phraseIndex])) {
                                if (positions.length <= 0) continue;
                                for (int posIndex = 0; posIndex < positions.length; ++posIndex) {
                                    if (nextCombinedOffset == combinedPositions.length) {
                                        int[] biggerArray = new int[combinedPositions.length + (positions.length - posIndex)];
                                        System.arraycopy(combinedPositions, 0, biggerArray, 0, combinedPositions.length);
                                        combinedPositions = biggerArray;
                                    }
                                    combinedPositions[nextCombinedOffset] = positions[posIndex] - phraseIndex;
                                    ++nextCombinedOffset;
                                }
                            }
                        }
                        Arrays.sort(combinedPositions);
                        int inARow = 1;
                        int phraseFrequency = 0;
                        int bonusPoints = 0;
                        for (int cpIndex = 1; cpIndex < combinedPositions.length; ++cpIndex) {
                            if (combinedPositions[cpIndex] == combinedPositions[cpIndex - 1]) {
                                if (++inARow != phrase.length) continue;
                                ++phraseFrequency;
                                if (combinedPositions[cpIndex] >= 25) continue;
                                if (combinedPositions[cpIndex] < 10) {
                                    if (combinedPositions[cpIndex] < 5) {
                                        bonusPoints += 20;
                                        continue;
                                    }
                                    bonusPoints += 15;
                                    continue;
                                }
                                bonusPoints += 10;
                                continue;
                            }
                            inARow = 1;
                        }
                        if (phraseFrequency > 0) {
                            double newScore = (double)result.getHitNumber() * 0.25 + (double)(phraseFrequency * phrase.length * 5) + (double)bonusPoints;
                            result.setHitNumber((int)Math.round(newScore));
                        } else {
                            result.useful = false;
                        }
                    } else {
                        result.useful = false;
                    }
                }
                this._checkStopSearch();
            }
            this._filterResults(results);
        }
    }

    private ResultObjectMap _executeBooleanQuery(SearchExpression expression) throws SearchException {
        ResultObjectMap res2;
        ResultObjectMap res1;
        if (expression.getOperator() == 0) {
            return this._executeStringQuery(expression.getData(), true, expression.isCaseSensitive());
        }
        SearchExpression expression1 = expression.getExpression1();
        ResultObjectMap resultObjectMap = res1 = expression1 != null ? this._executeBooleanQuery(expression1) : this._emptyResultObjectMap;
        if (res1.isEmpty() && expression.getOperator() == 4) {
            return this._emptyResultObjectMap;
        }
        if (expression.getOperator() == 3) {
            return this._evaluateNOT(res1);
        }
        SearchExpression expression2 = expression.getExpression2();
        ResultObjectMap resultObjectMap2 = res2 = expression2 != null ? this._executeBooleanQuery(expression2) : this._emptyResultObjectMap;
        if (res2.isEmpty() && expression.getOperator() == 1 && expression2 instanceof StringExpression) {
            List<StringQuery> queryList;
            StringExpression sExp = (StringExpression)expression2;
            String[] sExpWords = sExp.getData();
            if (sExpWords != null && (queryList = this._processQueryWords(sExpWords)).isEmpty()) {
                return res1;
            }
            return this._emptyResultObjectMap;
        }
        if (res1.isEmpty() && expression.getOperator() == 1 && expression1 instanceof StringExpression) {
            List<StringQuery> queryList;
            StringExpression sExp = (StringExpression)expression1;
            String[] sExpWords = sExp.getData();
            if (sExpWords != null && (queryList = this._processQueryWords(sExpWords)).isEmpty()) {
                return res2;
            }
            return this._emptyResultObjectMap;
        }
        return this._combineResults(res1, res2, expression.getOperator());
    }

    @Deprecated
    public List<ResultObject> combineResultsLists(List<ResultObject> res1, List<ResultObject> res2, int operator) {
        if (operator == 1) {
            ArrayList<ResultObject> intersection = new ArrayList<ResultObject>();
            block0: for (ResultObject res1Result : res1) {
                for (ResultObject res2Result : res2) {
                    if (res1Result.fileno != res2Result.fileno) continue;
                    intersection.add(res1Result);
                    res1Result.setHitNumber(res1Result.getHitNumber() + res2Result.getHitNumber());
                    res1Result.addPositionData(res2Result.getPositionDataMap());
                    continue block0;
                }
            }
            return intersection;
        }
        if (operator == 2) {
            if (res1.isEmpty()) {
                return res2;
            }
            if (res2.isEmpty()) {
                return res1;
            }
            ArrayList<ResultObject> combinedResults = new ArrayList<ResultObject>(res1.size() + res2.size());
            combinedResults.addAll(res1);
            for (ResultObject res2Result : res2) {
                boolean duplicate = false;
                for (ResultObject res1Result : res1) {
                    if (res2Result.fileno != res1Result.fileno) continue;
                    duplicate = true;
                    res1Result.setHitNumber(res1Result.getHitNumber() + res2Result.getHitNumber());
                    res1Result.addPositionData(res2Result.getPositionDataMap());
                    break;
                }
                if (duplicate) continue;
                combinedResults.add(res2Result);
            }
            return combinedResults;
        }
        if (operator == 4) {
            if (res2.isEmpty()) {
                return res1;
            }
            ArrayList<ResultObject> difference = new ArrayList<ResultObject>(res1.size());
            for (ResultObject res1Result : res1) {
                boolean inBoth = false;
                for (ResultObject res2Result : res2) {
                    if (res1Result.fileno != res2Result.fileno) continue;
                    inBoth = true;
                    break;
                }
                if (inBoth) continue;
                difference.add(res1Result);
            }
            return difference;
        }
        return Collections.emptyList();
    }

    private String _bytesToString(byte[] bytes, int index, int length) {
        boolean debug = false;
        try {
            return new String(bytes, index, length, this._encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, index, length);
        }
    }

    private IndexFileQueryHandler(View view, String basePath, URL url) {
        this._url = url;
        this._view = view;
        String viewTitle = this._view.getTitle();
        this._sourceIdentifier = viewTitle != null && viewTitle.length() > 0 ? viewTitle : null;
    }

    private InputStream _openInputStream(URL url) throws IOException {
        InputStream inStream = null;
        if (url.getProtocol().equals("file")) {
            try {
                inStream = new FileInputStream(url.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inStream == null) {
            inStream = url.openStream();
        }
        return inStream;
    }

    private void _handleCorruptIndexFile(String reason) throws SearchException {
        throw new SearchException("IndexFileQueryHandler:  " + this._url + "\n" + "Corrupt IDX File Encountered:  " + reason);
    }

    private void _parseHeader() throws SearchException {
        this._needToParseHeader = false;
        InputStream inStream = null;
        try {
            inStream = this._openInputStream(this._url);
            InputStreamWrapper inWrapper = new InputStreamWrapper(inStream);
            boolean debug = false;
            String line = inWrapper.readLine();
            if (!line.startsWith(INDEX_VERSION)) {
                this._handleCorruptIndexFile("Missing Index Version");
            }
            if (line.equals("OIN-INDEX-VERSION 1.0")) {
                this._version = 10;
            } else if (line.equals("OIN-INDEX-VERSION 1.1")) {
                this._version = 11;
            } else if (line.equals("OIN-INDEX-VERSION 2.0")) {
                this._version = 20;
            } else if (line.equals("OIN-INDEX-VERSION 2.1")) {
                this._version = 21;
            } else {
                this._handleCorruptIndexFile("Unsupported Index Version");
            }
            line = inWrapper.readLine();
            if (this._version >= 20) {
                this._encoding = line.substring(CHARACTER_SET.length() + 1);
            }
            if (!(line = inWrapper.readLine()).startsWith(PRODUCT_TITLE)) {
                this._handleCorruptIndexFile("Missing Product Title");
            }
            this._productTitle = line.substring(PRODUCT_TITLE.length() + 1);
            line = inWrapper.readLine();
            if (!line.startsWith(TITLES)) {
                this._handleCorruptIndexFile("Missing Titles Marker");
            }
            this._titlesAvailable = line.endsWith(TRUE);
            line = inWrapper.readLine();
            if (!line.startsWith(CASESENSITIVE)) {
                this._handleCorruptIndexFile("Missing Case Sensitive Marker");
            }
            this._fileCase = line.endsWith(TRUE);
            inWrapper.readLine();
            if (this._version > 10) {
                line = inWrapper.readLine();
                if (!line.startsWith(SCORES)) {
                    this._handleCorruptIndexFile("Missing Scores Marker");
                }
                this._scoreAvailable = line.endsWith(TRUE);
            }
            if (this._version >= 21) {
                line = inWrapper.readLine();
                if (!line.startsWith(POSITIONS)) {
                    this._handleCorruptIndexFile("Missing Positions Marker");
                }
                this._positionsAvailable = line.endsWith(TRUE);
            }
            if (!(line = inWrapper.readLine()).startsWith(ROOT_PATH)) {
                this._handleCorruptIndexFile("Missing Root Path");
            }
            this._rootPath = line.substring(ROOT_PATH.length() + 1);
            int alphaCount = inWrapper.readUb2();
            this._alphabet = new char[alphaCount];
            this._alphaOffsets = new long[alphaCount];
            byte[] charBytes = new byte[16];
            for (int i = 0; i < alphaCount; ++i) {
                if (this._version < 20) {
                    this._alphabet[i] = (char)inWrapper.readUb1();
                } else {
                    int charLength = inWrapper.readUb1();
                    if (charLength > 16) {
                        throw new SearchException("IndexFileQueryHandler:  " + this._url + "\n" + "Oracle Help Indexer does not support " + "encodings requiring more than 16 bytes " + "to specify a character.  This IDX file" + "may be corrupt.");
                    }
                    for (int j = 0; j < charLength; ++j) {
                        charBytes[j] = (byte)inWrapper.readUb1();
                    }
                    String str = new String(charBytes, 0, charLength, this._encoding);
                    this._alphabet[i] = str.charAt(0);
                }
                this._alphaOffsets[i] = inWrapper.readUb4();
            }
            this._eowOffset = inWrapper.readUb4();
            this._fsOffset = inWrapper.readUb4();
        }
        catch (IOException ioE) {
            throw new SearchException("Error encountered parsing IDX file header:  " + this._url + ioE.getMessage(), ioE);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                    inStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private int _getAlphabetIndex(char c) {
        for (int i = 0; i < this._alphabet.length; ++i) {
            if (this._alphabet[i] != c) continue;
            return i;
        }
        return -1;
    }

    private void _readFileIndicesDoUnion(InputStreamWrapper inWrapper, ResultObjectMap results, String[] searchWords, int[] searchWordIndices) throws IOException {
        int fileno;
        int score = 0;
        int[] positionData = null;
        while ((fileno = inWrapper.readUb2()) != 65535) {
            ResultObject object;
            if (this._scoreAvailable) {
                score = inWrapper.readUb1();
            }
            if (this._positionsAvailable) {
                positionData = this._readPositionData(inWrapper);
            }
            if ((object = results.get(fileno)) == null) {
                object = new ResultObject();
                object.view = this._view;
                object.fileno = fileno;
                results.put(object);
            }
            for (int searchWordIdx : searchWordIndices) {
                object.setHitNumber(object.getHitNumber() + score);
                object.addPositionData(searchWords[searchWordIdx], positionData);
            }
        }
    }

    private ResultObjectMap _getResults(InputStreamWrapper inWrapper, List<IndexWord> indexWords, String[] searchWords, boolean allWords) throws IOException {
        ResultObjectMap results = this._createResultObjectMap();
        int indexWordsSize = indexWords.size();
        for (int i = 0; i < indexWordsSize; ++i) {
            int end;
            IndexWord indexWord = indexWords.get(i);
            inWrapper.skipToOffset(indexWord.offset);
            for (end = i + 1; end < indexWordsSize && indexWords.get((int)end).offset == indexWord.offset; ++end) {
            }
            int nSearchWordsMatched = end - i;
            int[] searchWordIndices = new int[nSearchWordsMatched];
            int arrayIdx = 0;
            int j = i;
            while (j < end) {
                searchWordIndices[arrayIdx] = indexWords.get((int)j).searchWordIndex;
                ++j;
                ++arrayIdx;
            }
            this._readFileIndicesDoUnion(inWrapper, results, searchWords, searchWordIndices);
            i = end - 1;
            this._checkStopSearch();
        }
        if (!allWords || searchWords.length == 1) {
            return results;
        }
        Iterator<ResultObject> iter = results.iterator();
        while (iter.hasNext()) {
            ResultObject obj = iter.next();
            if (obj.getPositionDataMap().size() >= searchWords.length) continue;
            iter.remove();
        }
        return results;
    }

    private ResultObjectMap _combineResults(ResultObjectMap master, ResultObjectMap slave, int operator) {
        switch (operator) {
            case 1: {
                return this._combineResultsDoIntersection(master, slave);
            }
            case 2: {
                return this._combineResultsDoUnion(master, slave);
            }
            case 4: {
                return this._combineResultsDoDifference(master, slave);
            }
        }
        return this._emptyResultObjectMap;
    }

    private ResultObjectMap _combineResultsDoIntersection(ResultObjectMap master, ResultObjectMap slave) {
        Iterator<ResultObject> iter = master.iterator();
        while (iter.hasNext()) {
            iter.next().useful = false;
        }
        for (ResultObject slaveObj : slave) {
            ResultObject masterObj = master.get(slaveObj.fileno);
            if (masterObj == null) continue;
            masterObj.setHitNumber(masterObj.getHitNumber() + slaveObj.getHitNumber());
            masterObj.addPositionData(slaveObj.getPositionDataMap());
            masterObj.useful = true;
        }
        this._filterResults(master);
        return master;
    }

    private ResultObjectMap _combineResultsDoUnion(ResultObjectMap master, ResultObjectMap slave) {
        for (ResultObject slaveObj : slave) {
            ResultObject masterObj = master.get(slaveObj.fileno);
            if (masterObj != null) {
                masterObj.setHitNumber(masterObj.getHitNumber() + slaveObj.getHitNumber());
                masterObj.addPositionData(slaveObj.getPositionDataMap());
                continue;
            }
            master.put(slaveObj);
        }
        return master;
    }

    private ResultObjectMap _combineResultsDoDifference(ResultObjectMap master, ResultObjectMap slave) {
        for (ResultObject slaveObj : slave) {
            ResultObject masterObj = master.get(slaveObj.fileno);
            if (masterObj == null) continue;
            masterObj.useful = false;
        }
        this._filterResults(master);
        return master;
    }

    private void _readFileNames(InputStreamWrapper inWrapper, ResultObjectMap results, byte[] buffer) throws IOException {
        if (buffer == null) {
            buffer = new byte[255];
        }
        int fileCount = inWrapper.readUb2();
        for (int i = 0; i < fileCount; ++i) {
            int length = inWrapper.readUb1();
            inWrapper.read(buffer, 0, length);
            ResultObject object = results.get(i);
            if (object != null) {
                object.view = this._view;
                object.urlName = this._version < 20 ? new String(buffer, 0, length) : this._bytesToString(buffer, 0, length);
            }
            if (this._titlesAvailable) {
                length = inWrapper.readUb1();
                inWrapper.read(buffer, 0, length);
                if (object != null) {
                    object.label = this._version < 20 ? new String(buffer, 0, length) : this._bytesToString(buffer, 0, length);
                }
            }
            if (i % 20 != 0) continue;
            this._checkStopSearch();
        }
    }

    private ResultObjectMap _evaluateNOT(ResultObjectMap wordResults) throws SearchException {
        ResultObjectMap results = null;
        byte[] buffer = new byte[256];
        InputStream inStream = null;
        try {
            inStream = this._openInputStream(this._url);
            InputStreamWrapper inWrapper = new InputStreamWrapper(inStream);
            inWrapper.skipToOffset(this._fsOffset);
            int fileCount = inWrapper.readUb2();
            int wordResultSize = wordResults.size();
            if (wordResultSize >= fileCount) {
                ResultObjectMap resultObjectMap = this._emptyResultObjectMap;
                return resultObjectMap;
            }
            results = this._createResultObjectMap();
            for (int i = 0; i < fileCount; ++i) {
                int length = inWrapper.readUb1();
                inWrapper.read(buffer, 0, length);
                ResultObject resObj = wordResults.get(i);
                ResultObject newResult = null;
                if (resObj == null) {
                    newResult = new ResultObject();
                    newResult.fileno = i;
                    newResult.view = this._view;
                    String string = newResult.urlName = this._version < 20 ? new String(buffer, 0, length) : this._bytesToString(buffer, 0, length);
                }
                if (this._titlesAvailable) {
                    length = inWrapper.readUb1();
                    inWrapper.read(buffer, 0, length);
                    if (newResult != null) {
                        String string = newResult.label = this._version < 20 ? new String(buffer, 0, length) : this._bytesToString(buffer, 0, length);
                    }
                }
                if (newResult == null) continue;
                results.put(newResult);
            }
        }
        catch (Exception e) {
            throw new SearchException("Error encountered executing NOT boolean search: " + e.getMessage(), e);
        }
        finally {
            try {
                inStream.close();
                inStream = null;
            }
            catch (Exception exception) {}
        }
        return results;
    }

    private void _filterResults(ResultObjectMap results) {
        Iterator<ResultObject> iter = results.iterator();
        while (iter.hasNext()) {
            if (iter.next().useful) continue;
            iter.remove();
        }
    }

    private List<StringQuery> _processQueryWords(String[] wordsOriginal) {
        ArrayList<StringQuery> queryList = new ArrayList<StringQuery>();
        StringQuery regularQuery = new StringQuery(false);
        StringQuery currentExactPhraseQuery = null;
        String currentWord = null;
        for (int i = 0; i < wordsOriginal.length; ++i) {
            currentWord = wordsOriginal[i];
            if (currentWord == null || currentWord.length() <= 0) continue;
            if (!this._fileCase) {
                currentWord = currentWord.toLowerCase();
            }
            if (currentWord.length() > 1) {
                if (currentExactPhraseQuery != null) {
                    currentExactPhraseQuery.addWord(currentWord);
                    continue;
                }
                regularQuery.addWord(currentWord);
                continue;
            }
            if ('\"' != currentWord.charAt(0)) continue;
            if (currentExactPhraseQuery == null) {
                currentExactPhraseQuery = new StringQuery(true);
                continue;
            }
            if (currentExactPhraseQuery.getExactPhraseWords().size() > 1) {
                queryList.add(currentExactPhraseQuery);
            } else {
                regularQuery.addWords(currentExactPhraseQuery.getSortedUniqueWords());
            }
            currentExactPhraseQuery = null;
        }
        if (currentExactPhraseQuery != null) {
            if (currentExactPhraseQuery.getExactPhraseWords().size() > 1) {
                queryList.add(currentExactPhraseQuery);
            } else {
                regularQuery.addWords(currentExactPhraseQuery.getSortedUniqueWords());
            }
        }
        if (regularQuery.getSortedUniqueWords().size() > 0) {
            queryList.add(regularQuery);
        }
        return queryList;
    }

    private int _readVariableLengthInteger(InputStreamWrapper inWrapper) throws IOException {
        int result = 0;
        for (int i = 0; i < 5; ++i) {
            byte b = inWrapper.readRawByte();
            result = result << 7 | b & 0x7F;
            if ((b & 0xFFFFFF80) != 0) continue;
            return result;
        }
        throw new IOException("IDX file contained corrupted variable length integer");
    }

    private int[] _readPositionData(InputStreamWrapper inWrapper) throws IOException {
        int count = this._readVariableLengthInteger(inWrapper);
        if (count > 500) {
            throw new IOException("IDX file contained corrupted position count");
        }
        int lastPosition = 0;
        int[] positionData = new int[count];
        for (int i = 0; i < count; ++i) {
            positionData[i] = this._readVariableLengthInteger(inWrapper) + lastPosition;
            lastPosition = positionData[i];
        }
        return positionData;
    }

    private static void _quickSort(List results, int left, int right) {
        if (right > left) {
            int val = ((ResultObject)results.get(right)).getHitNumber();
            int i = left - 1;
            int j = right;
            while (true) {
                if (((ResultObject)results.get(++i)).getHitNumber() > val) {
                    continue;
                }
                while (((ResultObject)results.get(--j)).getHitNumber() < val && j > 0) {
                }
                if (i >= j) break;
                IndexFileQueryHandler._swapObject(results, i, j);
            }
            IndexFileQueryHandler._swapObject(results, i, right);
            IndexFileQueryHandler._quickSort(results, left, i - 1);
            IndexFileQueryHandler._quickSort(results, i + 1, right);
        }
    }

    private static void _swapObject(List objects, int i, int j) {
        ResultObject temp = (ResultObject)objects.get(i);
        objects.set(i, objects.get(j));
        objects.set(j, temp);
    }

    private ResultObjectMap _createResultObjectMap() {
        return this._createResultObjectMap(this._defaultContainerType);
    }

    private ResultObjectMap _createResultObjectMap(ResultObjectContainerType type) {
        switch (type) {
            case TREE_MAP: {
                return new ResultObjectTreeMap();
            }
            case LINKED_HASH_MAP: {
                return new ResultObjectLinkedHashMap();
            }
        }
        return this._emptyResultObjectMap;
    }

    private class SearchInterruptedError
    extends Error {
        public SearchInterruptedError(String message) {
            super(message);
        }
    }

    private class IndexWord {
        public long offset;
        public byte searchWordIndex;

        public IndexWord(long off, byte sidx) {
            this.offset = off;
            this.searchWordIndex = sidx;
        }
    }

    private class StringQuery {
        private TreeSet<String> _sortedUniqueWords = new TreeSet();
        private ArrayList<String> _exactPhrase = null;
        private boolean _isWildcardQuery = false;

        public StringQuery(boolean isExactPhrase) {
            if (isExactPhrase) {
                this._exactPhrase = new ArrayList();
            }
        }

        public Set<String> getSortedUniqueWords() {
            return this._sortedUniqueWords;
        }

        public String[] getSortedUniqueWordsAsArray() {
            return this._sortedUniqueWords.toArray(new String[0]);
        }

        public List<String> getExactPhraseWords() {
            return this._exactPhrase;
        }

        public String[] getExactPhraseWordsAsArray() {
            return this._exactPhrase.toArray(new String[0]);
        }

        public boolean isExactPhraseQuery() {
            return this._exactPhrase != null;
        }

        public boolean isWildcardQuery() {
            return this._isWildcardQuery;
        }

        public void addWord(String word) {
            if (this._sortedUniqueWords.size() == 127) {
                return;
            }
            int wildIdx = word.indexOf(42);
            if (this._exactPhrase != null) {
                if (wildIdx != -1) {
                    word = word.substring(0, wildIdx) + word.substring(wildIdx + 1);
                }
                this._exactPhrase.add(word);
            } else if (wildIdx != -1) {
                this._isWildcardQuery = true;
            }
            this._sortedUniqueWords.add(word);
        }

        public void addWords(Collection<String> words) {
            if (words != null) {
                for (String word : words) {
                    this.addWord(word);
                }
            }
        }

        public void removeWildcardRedundancies() {
            if (this._exactPhrase != null) {
                return;
            }
            boolean foundRedundancy = false;
            String[] sortedUniqueWords = this._sortedUniqueWords.toArray(new String[0]);
            block0: for (int i = 0; i < sortedUniqueWords.length; ++i) {
                int wildIdx;
                String currentWord = sortedUniqueWords[i];
                if (currentWord == null || (wildIdx = currentWord.indexOf(42)) == -1) continue;
                String currentWordPrefix = currentWord.substring(0, wildIdx);
                String currentWordSuffix = currentWord.substring(wildIdx + 1);
                if (currentWordSuffix.length() == 0 && i - 1 >= 0 && currentWordPrefix.equals(sortedUniqueWords[i - 1])) {
                    sortedUniqueWords[i - 1] = null;
                    foundRedundancy = true;
                }
                for (int j = i + 1; j < sortedUniqueWords.length; ++j) {
                    String nextWord = sortedUniqueWords[j];
                    if (nextWord == null) continue;
                    if (!nextWord.startsWith(currentWordPrefix)) continue block0;
                    if (!nextWord.endsWith(currentWordSuffix) || nextWord.lastIndexOf(currentWordSuffix) < currentWordPrefix.length()) continue;
                    sortedUniqueWords[j] = null;
                    foundRedundancy = true;
                }
            }
            if (!foundRedundancy) {
                return;
            }
            this._sortedUniqueWords.clear();
            for (String word : sortedUniqueWords) {
                if (word == null) continue;
                this._sortedUniqueWords.add(word);
            }
        }
    }

    private class InputStreamWrapper {
        private InputStream _inStream;
        private long _pos;

        public InputStreamWrapper(InputStream inStream) {
            this._inStream = inStream;
            this._pos = 0L;
        }

        public long readUb4() throws IOException {
            long val = 0L;
            val = (long)this.readUb1() << 24 | (long)this.readUb1() << 16 | (long)this.readUb1() << 8 | (long)this.readUb1();
            return val;
        }

        public int readUb2() throws IOException {
            int ub2 = this.readUb1() << 8 | this.readUb1();
            return ub2;
        }

        public int readUb1() throws IOException {
            int ub1 = this._inStream.read();
            if (ub1 < 0) {
                ub1 += 256;
            }
            ++this._pos;
            return ub1;
        }

        public byte readRawByte() throws IOException {
            byte[] rawByte = new byte[1];
            this._inStream.read(rawByte, 0, 1);
            ++this._pos;
            return rawByte[0];
        }

        public void skipToOffset(long offset) throws IOException {
            long toDo = offset - this._pos;
            while (toDo > 0L) {
                long actualSkipped = this._inStream.skip(toDo);
                if (actualSkipped != -1L) {
                    toDo -= actualSkipped;
                    this._pos += actualSkipped;
                    continue;
                }
                throw new IOException("IndexFileQueryHandler attempting to skip past end of file: " + IndexFileQueryHandler.this._url);
            }
        }

        public String readLine() throws IOException {
            char c;
            int capacity = 40;
            StringBuffer buffer = new StringBuffer(capacity);
            while ((c = (char)this._inStream.read()) != '\n') {
                if (buffer.length() == capacity) {
                    buffer.setLength(capacity += 40);
                }
                buffer.append(c);
                ++this._pos;
            }
            ++this._pos;
            return buffer.toString();
        }

        public void read(byte[] buffer, int index, int length) throws IOException {
            int byteCount = 0;
            while (byteCount != length) {
                int temp = this._inStream.read(buffer, index + byteCount, length - byteCount);
                if (temp == -1) {
                    throw new IOException();
                }
                byteCount += temp;
                this._pos += (long)temp;
            }
        }

        public long getPosition() {
            return this._pos;
        }
    }

    private class ResultObjectEmptyMap
    implements ResultObjectMap {
        private ResultObjectEmptyMap() {
        }

        @Override
        public ResultObject get(int fileno) {
            return null;
        }

        @Override
        public void put(ResultObject obj) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ArrayList<ResultObject> toList() {
            return (ArrayList)Collections.EMPTY_LIST;
        }

        @Override
        public Iterator<ResultObject> iterator() {
            return Collections.EMPTY_LIST.iterator();
        }
    }

    private class ResultObjectLinkedHashMap
    implements ResultObjectMap {
        private LinkedHashMap<Integer, List<ResultObject>> _map = new LinkedHashMap(32);
        private int _size = 0;

        @Override
        public ResultObject get(int fileno) {
            List<ResultObject> list = this._map.get(fileno);
            if (list == null) {
                return null;
            }
            for (ResultObject iter : list) {
                if (iter.fileno != fileno) continue;
                return iter;
            }
            return null;
        }

        @Override
        public void put(ResultObject obj) {
            List<ResultObject> list = this._map.get(obj.fileno);
            if (list == null) {
                list = new LinkedList<ResultObject>();
                this._map.put(obj.fileno, list);
            }
            list.add(obj);
            ++this._size;
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public ArrayList<ResultObject> toList() {
            if (this._map.isEmpty()) {
                return (ArrayList)Collections.EMPTY_LIST;
            }
            ArrayList<ResultObject> list = new ArrayList<ResultObject>(this._size);
            Iterator<List<ResultObject>> iter = this._map.values().iterator();
            while (iter.hasNext()) {
                list.addAll((Collection<ResultObject>)iter.next());
            }
            return list;
        }

        @Override
        public Iterator<ResultObject> iterator() {
            return new LinkedHashMapIterator(this._map);
        }

        private class LinkedHashMapIterator
        implements Iterator<ResultObject> {
            private Iterator<List<ResultObject>> _mapIter;
            private Iterator<ResultObject> _listIter;
            private List<ResultObject> _list;
            private boolean _needNextList = true;

            LinkedHashMapIterator(LinkedHashMap<Integer, List<ResultObject>> map) {
                this._mapIter = map.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this._needNextList) {
                    this._getNextList();
                }
                return this._listIter != null;
            }

            @Override
            public ResultObject next() {
                if (this._needNextList) {
                    this._getNextList();
                }
                ResultObject next = this._listIter.next();
                if (!this._listIter.hasNext()) {
                    this._needNextList = true;
                }
                return next;
            }

            @Override
            public void remove() {
                this._listIter.remove();
                --ResultObjectLinkedHashMap.this._size;
                if (this._list.isEmpty()) {
                    this._mapIter.remove();
                }
            }

            private void _getNextList() {
                if (this._mapIter.hasNext()) {
                    this._list = this._mapIter.next();
                    this._listIter = this._list.iterator();
                } else {
                    this._listIter = null;
                }
                this._needNextList = false;
            }
        }
    }

    private class ResultObjectTreeMap
    implements ResultObjectMap {
        private TreeMap<Integer, ResultObject> _map = new TreeMap();

        @Override
        public ResultObject get(int fileno) {
            return this._map.get(fileno);
        }

        @Override
        public void put(ResultObject obj) {
            this._map.put(obj.fileno, obj);
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public ArrayList<ResultObject> toList() {
            if (this._map.isEmpty()) {
                return (ArrayList)Collections.EMPTY_LIST;
            }
            return new ArrayList<ResultObject>(this._map.values());
        }

        @Override
        public Iterator<ResultObject> iterator() {
            return this._map.values().iterator();
        }
    }

    private static interface ResultObjectMap
    extends Iterable<ResultObject> {
        public ResultObject get(int var1);

        public void put(ResultObject var1);

        public boolean isEmpty();

        public int size();

        public ArrayList<ResultObject> toList();

        @Override
        public Iterator<ResultObject> iterator();
    }

    private static enum ResultObjectContainerType {
        TREE_MAP,
        LINKED_HASH_MAP,
        INVALID_TYPE;

    }

    private class ResultObject
    implements QueryResult {
        public int fileno = -1;
        public String urlName = null;
        public String label = null;
        public boolean useful = true;
        public View view = null;
        private int _hitNumber = 0;
        private LinkedHashMap<String, List<int[]>> _wordToPositionData = null;
        private int _totalPositionCount = 0;

        private ResultObject() {
        }

        @Override
        public Topic getResultTopic() {
            SimpleURLTarget theTarget = new SimpleURLTarget(this.view, this.urlName);
            SimpleTopic theTopic = new SimpleTopic(this.label, theTarget);
            return theTopic;
        }

        @Override
        public int getResultScore() {
            return this._hitNumber;
        }

        @Override
        public String getResultSource() {
            return IndexFileQueryHandler.this._sourceIdentifier;
        }

        public int getHitNumber() {
            return this._hitNumber;
        }

        public void setHitNumber(int hitNumber) {
            this._hitNumber = hitNumber;
        }

        public LinkedHashMap<String, List<int[]>> getPositionDataMap() {
            return this._wordToPositionData;
        }

        public int getTotalPositionCount() {
            return this._totalPositionCount;
        }

        public void addPositionData(String word, int[] positionData) {
            if (this._wordToPositionData == null) {
                this._wordToPositionData = new LinkedHashMap(5);
            }
            if (positionData == null) {
                this._wordToPositionData.put(word, null);
                return;
            }
            List<int[]> positionDataList = this._wordToPositionData.get(word);
            if (positionDataList == null) {
                positionDataList = new ArrayList<int[]>(1);
                this._wordToPositionData.put(word, positionDataList);
            }
            this._totalPositionCount += positionData.length;
            positionDataList.add(positionData);
        }

        public void addPositionData(LinkedHashMap<String, List<int[]>> positionDataMap) {
            if (positionDataMap == null) {
                return;
            }
            for (String word : positionDataMap.keySet()) {
                List<int[]> positionDataList = positionDataMap.get(word);
                for (int[] positionData : positionDataList) {
                    this.addPositionData(word, positionData);
                }
            }
        }
    }
}

