/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.searchNavigator;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.QueryResult;
import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.util.java.StaticLocaleContext;

public class SearchModel {
    public static final int COLUMN_RANK = 0;
    public static final int COLUMN_TITLE = 1;
    public static final int COLUMN_SOURCE = 2;
    private static final String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static final String UNTITLED_DOCUMENT_STRING = "navigator.searchNavigator.untitledDocument";
    @CodeSharingSafe(value="MutableStaticField")
    private static String _untitledDocName = null;
    private Vector _queryHandlerInfos;
    private Vector _queryViews;
    private SearchModelData _searchModelData;
    private static final Logger _LOGGER = Logger.getLogger(SearchModel.class.getName(), "oracle.help.share.resource.LoggerBundle");

    public SearchModel(SearchModelData searchModelData, View[] initialViews) {
        this._searchModelData = searchModelData;
        this._queryViews = new Vector();
        this._queryHandlerInfos = new Vector();
        int iter = 0;
        if (initialViews != null) {
            for (iter = 0; iter < initialViews.length; ++iter) {
                QueryHandler aHandler;
                View aView = initialViews[iter];
                if (this._queryViews.contains(aView) || (aHandler = this._getQueryHandler(aView)) == null) continue;
                this._queryViews.addElement(aView);
                this._queryHandlerInfos.addElement(new QueryHandlerInfo(aHandler, aView));
            }
        }
    }

    public SearchModelData getSearchModelData() {
        return this._searchModelData;
    }

    public static Object getData(Object data, int column, int row, SearchModelData searchModelData) {
        if (column == 2) {
            View source = (View)data;
            String title = source.getTitle();
            if (title == null) {
                title = new String("");
            }
            return title;
        }
        if (column == 1) {
            QueryResult item = (QueryResult)data;
            String title = item.getResultTopic().getLabel();
            if (title != null) {
                title.trim();
                if (title.length() == 0) {
                    title = SearchModel.getUntitledDocumentName();
                }
            } else {
                title = SearchModel.getUntitledDocumentName();
            }
            return title;
        }
        QueryResult item = (QueryResult)data;
        return searchModelData.getRank(item);
    }

    public synchronized void startSearch(SearchExpression searchExp) {
        int queryIter = 0;
        this.resetModel();
        for (queryIter = 0; queryIter < this._queryHandlerInfos.size(); ++queryIter) {
            List someResults = Collections.EMPTY_LIST;
            View currentView = null;
            try {
                QueryHandlerInfo anInfo = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(queryIter);
                QueryHandler aHandler = anInfo.handler;
                currentView = anInfo.view;
                someResults = aHandler.executeQuery(searchExp, null);
            }
            catch (SearchException sE) {
                _LOGGER.log(Level.WARNING, "HELP-00003", sE);
                _LOGGER.log(Level.WARNING, "HELP-00003", sE.getSourceException());
                someResults = Collections.EMPTY_LIST;
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "", e);
                someResults = Collections.EMPTY_LIST;
            }
            this._addResults(someResults, currentView);
        }
        this._searchModelData.sort(0, false);
    }

    public synchronized void startSearch(String[] words, boolean allWords, boolean caseSensitive) {
        int queryIter = 0;
        this.resetModel();
        for (queryIter = 0; queryIter < this._queryHandlerInfos.size(); ++queryIter) {
            List someResults = Collections.EMPTY_LIST;
            View currentView = null;
            try {
                QueryHandlerInfo anInfo = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(queryIter);
                QueryHandler aHandler = anInfo.handler;
                currentView = anInfo.view;
                someResults = aHandler.executeQuery(words, allWords, caseSensitive, null);
            }
            catch (SearchException sE) {
                _LOGGER.log(Level.WARNING, "HELP-00003", sE);
                _LOGGER.log(Level.WARNING, "HELP-00003", sE.getSourceException());
                someResults = Collections.EMPTY_LIST;
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "", e);
                someResults = Collections.EMPTY_LIST;
            }
            this._addResults(someResults, currentView);
        }
        this._searchModelData.sort(0, false);
    }

    public void stopSearch() {
        int queryIter = 0;
        for (queryIter = 0; queryIter < this._queryHandlerInfos.size(); ++queryIter) {
            QueryHandlerInfo anInfo = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(queryIter);
            QueryHandler aHandler = anInfo.handler;
            aHandler.stopSearch();
        }
    }

    public Topic getTopicForRow(int row) {
        Topic resultTopic = null;
        QueryResult item = (QueryResult)this._searchModelData.getRealData(1, row);
        if (item != null) {
            resultTopic = item.getResultTopic();
        }
        return resultTopic;
    }

    public static String getUntitledDocumentName() {
        if (_untitledDocName == null) {
            ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
            _untitledDocName = bundle.getString(UNTITLED_DOCUMENT_STRING);
        }
        return _untitledDocName;
    }

    public synchronized void resetModel() {
        this._searchModelData.resetModel();
    }

    private void _addResults(List someResults, View source) {
        this._searchModelData.addResults(someResults, source);
    }

    public synchronized void addView(View aView) {
        QueryHandler aHandler;
        if (!this._queryViews.contains(aView) && (aHandler = this._getQueryHandler(aView)) != null) {
            this._queryViews.addElement(aView);
            this._queryHandlerInfos.addElement(new QueryHandlerInfo(aHandler, aView));
        }
    }

    public synchronized void removeView(View aView) {
        if (this._queryViews.contains(aView)) {
            int iter = 0;
            this._queryViews.removeElement(aView);
            for (iter = this._queryHandlerInfos.size() - 1; iter >= 0; --iter) {
                QueryHandlerInfo anInfo = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(iter);
                if (anInfo.view != aView) continue;
                this._queryHandlerInfos.removeElementAt(iter);
            }
            for (iter = this._searchModelData.getRowCount() - 1; iter >= 0; --iter) {
                View rowView = (View)this._searchModelData.getRealData(2, iter);
                if (aView != rowView) continue;
                this._searchModelData.removeRows(iter, 1);
            }
        }
    }

    private QueryHandler _getQueryHandler(View aView) {
        QueryHandler theHandler = null;
        if (aView != null) {
            try {
                theHandler = (QueryHandler)aView.getViewData();
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "HELP-00004", e);
                theHandler = null;
            }
        }
        return theHandler;
    }

    private class QueryHandlerInfo {
        public View view = null;
        public QueryHandler handler = null;

        public QueryHandlerInfo(QueryHandler handler, View view) {
            this.handler = handler;
            this.view = view;
        }
    }
}

