/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.ArrayList;
import java.util.EventListener;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.Topic;
import oracle.help.common.View;

public class TopicTreeNode
implements Comparable<TopicTreeNode> {
    private TopicTreeNode _parent;
    private ArrayList _children;
    private Topic _topic;
    private Object _clientData;
    private View _view;
    private ListenerManager _manager;
    private int _sortVal;

    public TopicTreeNode(View view) {
        this(view, null);
    }

    public TopicTreeNode(View view, Topic topic) {
        this(view, topic, null);
    }

    public TopicTreeNode() {
    }

    public TopicTreeNode(View view, Topic topic, TopicTreeNode parent) {
        this._view = view;
        this._parent = parent;
        this._topic = topic;
        this._children = null;
        this._clientData = null;
    }

    @Override
    public int compareTo(TopicTreeNode node) {
        return this._sortVal - node.getSortValue();
    }

    public View getView() {
        return this._view;
    }

    public TopicTreeNode getParent() {
        return this._parent;
    }

    public void setParent(TopicTreeNode parent) {
        this._parent = parent;
    }

    public ArrayList getChildren() {
        if (this._children == null) {
            this._children = new ArrayList(5);
        }
        return this._children;
    }

    public TopicTreeNode getChildByIndex(int index) throws IndexOutOfBoundsException {
        TopicTreeNode aChild = null;
        if (index >= this.getNumChildren()) {
            throw new IndexOutOfBoundsException("Child Index out of Bounds");
        }
        aChild = (TopicTreeNode)this.getChildren().get(index);
        return aChild;
    }

    public int removeChild(TopicTreeNode node) {
        int nodeIndex = this.getChildren().indexOf(node);
        if (nodeIndex != -1) {
            this.getChildren().remove(nodeIndex);
        }
        return nodeIndex;
    }

    public boolean isBranch() {
        return this.getNumChildren() > 0;
    }

    public int getNumChildren() {
        ArrayList children = this.getChildren();
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    public Topic getTopic() {
        return this._topic;
    }

    public Topic[] getAllTopicsInSubTree() {
        ArrayList topicList = new ArrayList();
        this._recursiveTopicHelper(this, topicList);
        Topic[] topicArr = null;
        if (topicList.size() > 0) {
            topicArr = new Topic[topicList.size()];
            topicList.toArray(topicArr);
        }
        return topicArr;
    }

    public void setTopic(Topic theTopic) {
        this._topic = theTopic;
    }

    public TopicTreeNode addChild(TopicTreeNode child) {
        child.setParent(this);
        this.getChildren().add(child);
        return child;
    }

    public void clearChildren() {
        if (this.getChildren() != null) {
            this.getChildren().clear();
        }
    }

    public boolean isTraversable() {
        return true;
    }

    public boolean allowsChildMerging() {
        return true;
    }

    public boolean hasChildren() {
        ArrayList children = this.getChildren();
        if (children == null) {
            return false;
        }
        return !children.isEmpty();
    }

    public void setClientData(Object data) {
        this._clientData = data;
    }

    public Object getClientData() {
        return this._clientData;
    }

    public void addModelListener(EventListener listener) {
        if (listener != null) {
            if (this._manager == null) {
                this._manager = new ListenerManager();
            }
            this._manager.addListener(listener);
        }
    }

    public void removeModelListener(EventListener listener) {
        if (listener != null && this._manager != null) {
            this._manager.removeListener(listener);
        }
    }

    public ListenerManager getListenerManager() {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        return this._manager;
    }

    public int getSortValue() {
        return this._sortVal;
    }

    public void setSortValue(int val) {
        this._sortVal = val;
    }

    final void __setChildrenDirectly(ArrayList children) {
        this._children = children;
    }

    final ArrayList __getChildrenDirectly() {
        return this._children;
    }

    private void _recursiveTopicHelper(TopicTreeNode currentNode, ArrayList topicList) {
        if (currentNode != null) {
            ArrayList currentChildren;
            Topic currentTopic = currentNode.getTopic();
            if (currentTopic != null) {
                topicList.add(currentTopic);
            }
            if ((currentChildren = currentNode.getChildren()) != null) {
                for (int iter = 0; iter < currentChildren.size(); ++iter) {
                    TopicTreeNode childNode = (TopicTreeNode)currentChildren.get(iter);
                    this._recursiveTopicHelper(childNode, topicList);
                }
            }
        }
    }
}

