/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.producer;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.List;
import oracle.maps.util.TransformUtils;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.producer.AbstractDataSetProducer;

public class GeometrySetProducer
extends AbstractDataSetProducer {
    public GeometrySetProducer(GeometrySetLayer layer) {
        super(layer);
    }

    @Override
    public String getSpatialType() {
        return AbstractDataSet.GEOMETRY_SET;
    }

    @Override
    public String buildQuery(Area queryArea, int srid) {
        String baseTable = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        String keyColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
        String spatialColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        String queryCondition = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition");
        String sridString = srid > 0 ? "" + srid : "NULL";
        String tableAlias = "";
        String attrSelect = "select *";
        if (keyColumn.equalsIgnoreCase("rowid")) {
            tableAlias = "abs_set_edt";
            attrSelect = "select " + tableAlias + ".rowid, " + tableAlias + ".*";
        }
        StringBuilder filter = new StringBuilder("(");
        List<Rectangle2D> rectangles = TransformUtils.areaToRectangles(queryArea);
        if (rectangles.size() > 30 || rectangles.size() == 0) {
            rectangles.clear();
            rectangles.add(queryArea.getBounds2D());
        }
        for (Rectangle2D rec : rectangles) {
            if (filter.length() > 1) {
                filter.append(" OR ");
            }
            filter.append("SDO_FILTER(" + spatialColumn + ", SDO_GEOMETRY(2003, " + sridString + ", NULL" + ", SDO_ELEM_INFO_ARRAY(1, 1003, 3)" + ", SDO_ORDINATE_ARRAY(" + rec.getMinX() + "," + rec.getMinY() + "," + rec.getMaxX() + "," + rec.getMaxY() + "))) = 'TRUE'");
        }
        filter.append(")");
        return attrSelect + " FROM " + baseTable + " " + tableAlias + " WHERE " + filter.toString() + (queryCondition == null ? "" : " AND " + queryCondition);
    }
}

