/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.wfs.layer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.maps.core.Layer;
import oracle.maps.layer.BasicLayer;
import oracle.maps.util.PropertySupportObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.EditorAppletInfo;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.mdeditor.wfs.layer.WFSLayer;
import oracle.mdeditor.wfs.ui.WFSConnectionPanel;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.Theme;
import oracle.sdovis.WFSTheme;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.theme.WFSThemeProducer;
import oracle.sdovis.util.WSAuthenticator;
import oracle.sdovis.util.WfsCapabilities;
import oracle.sdovis.util.WfsFeatureType;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.security.ChecksumHelper;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WFSLayerProvider
implements LayerProvider {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private final int timeout = 30000;
    private final String version = "1.0.0";
    protected MainAppPanel mainApp = null;
    protected ArrayList<WfsCapabilities> connections = new ArrayList();
    protected EmptyNonLeaf rootNode = new EmptyNonLeaf(this);
    protected static final String ADDCONNECTION = "Connect to WFS server";
    protected static Hashtable<String, ArrayList<String>> addConnAuthParams = new Hashtable();

    public WFSLayerProvider(MainAppPanel mainApp) {
        this.mainApp = mainApp;
    }

    @Override
    public Layer createLayer(Element xmlElement) {
        return this.createLayer(xmlElement, null, null);
    }

    private Layer createLayer(Element xmlElement, WfsCapabilities capabilities, WfsFeatureType wfstype) {
        String authPwd;
        String authUser;
        String geomColumn;
        String featTypeName;
        String serverURL;
        BasicLayer layer;
        block23: {
            layer = null;
            String className = xmlElement.getAttribute("class");
            if (className != null && !className.trim().isEmpty()) {
                try {
                    layer = (WFSLayer)Class.forName(className).newInstance();
                    ((GeometrySetLayer)layer).fromXMLElement(xmlElement);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            serverURL = layer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.serverURL");
            featTypeName = layer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeName");
            geomColumn = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
            if (geomColumn != null && geomColumn.equalsIgnoreCase("null")) {
                geomColumn = null;
            }
            if ((authUser = layer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationUser")) != null && authUser.equalsIgnoreCase("null")) {
                authUser = null;
            }
            if ((authPwd = layer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationPassword")) != null && authPwd.equalsIgnoreCase("null")) {
                authPwd = null;
            }
            if (authPwd != null && authPwd.length() >= 32) {
                authPwd = ChecksumHelper.decAsc((String)authPwd);
            }
            if (capabilities == null) {
                String featNSAlias = layer.getProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeNSAlias");
                try {
                    capabilities = this.getCapabilities(serverURL, authUser, authPwd);
                    if (capabilities == null) break block23;
                    for (Object t : capabilities.getFeatureTypes()) {
                        WfsFeatureType type = (WfsFeatureType)t;
                        if (type.getName() == null || !type.getName().equalsIgnoreCase(featTypeName) || !type.getNameSpaceAlias().equalsIgnoreCase(featNSAlias)) continue;
                        wfstype = type;
                        break;
                    }
                }
                catch (Exception ex) {
                    log.warning("Unable to read capabilities: " + ex.getMessage());
                    return layer;
                }
            }
        }
        if (capabilities != null && wfstype != null && wfstype.getAttributeTypes() == null) {
            String describeUrl_get = capabilities.describeFeatureTypeGetURL();
            String describeUrl_post = capabilities.describeFeatureTypePostURL();
            if (describeUrl_get != null) {
                wfstype.readAttributesWithTypesUsingHttpGet(describeUrl_get, 30000L, "1.0.0");
            } else if (describeUrl_post != null) {
                wfstype.readAttributesWithTypesUsingHttpPost(describeUrl_post, 30000L, "1.0.0");
            }
            if (wfstype.getAttributeTypes() == null) {
                log.warning("Attribute types list is null.");
                return layer;
            }
        }
        StylingRule styleRule = new StylingRule();
        ArrayList<String> geomAttrs = new ArrayList<String>();
        ArrayList<String> nonGeomAttrs = new ArrayList<String>(wfstype.getAttributeTypes().size());
        Set entries = wfstype.getAttributeTypes().entrySet();
        for (Map.Entry e : entries) {
            String attrName = e.getKey().toString();
            String attrType = e.getValue().toString();
            if (this.isOGCgeometryType(attrType)) {
                geomAttrs.add(attrName);
                continue;
            }
            nonGeomAttrs.add(attrName);
        }
        styleRule.setAttributeColumns(nonGeomAttrs.toArray(new String[nonGeomAttrs.size()]));
        if (geomColumn == null) {
            if (geomAttrs.size() == 1) {
                geomColumn = (String)geomAttrs.get(0);
            } else {
                SpatialAttributePanel panel = new SpatialAttributePanel(wfstype.getAttributeTypes());
                OlafDialog dlg = new OlafDialog(this.mainApp.getFrameForDialog(), "", panel);
                dlg.setVisible(true);
                if (!dlg.isCancelled()) {
                    geomColumn = panel.getSpatialColumn();
                }
            }
            layer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn", geomColumn);
        }
        if (geomColumn == null) {
            log.warning("WFS layer geometry attribute is null.");
            return null;
        }
        WFSThemeDefinition themeDef = new WFSThemeDefinition(layer.getName(), null, serverURL, null, featTypeName, geomColumn, new StylingRule[]{styleRule}, null, null);
        themeDef.setAuthentication(authUser, authPwd);
        themeDef.readCapabilities(30000L);
        WFSTheme theme = new WFSTheme(themeDef);
        theme.getDecorator().setRequestTimeout(30000L);
        WFSThemeProducer producer = new WFSThemeProducer((Theme)theme);
        ((WFSLayer)layer).setThemeProducer(producer);
        return layer;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String getProviderName() {
        return "WFS layers";
    }

    @Override
    public Layer getEditorObject(TreePath path) {
        Object[] objPath = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObjectPath();
        WfsFeatureType wfstype = (WfsFeatureType)objPath[objPath.length - 1];
        WfsCapabilities capabilities = (WfsCapabilities)objPath[objPath.length - 2];
        PropertySupportObject props = new PropertySupportObject(this);
        props.setProperty("oracle.maps.core.Layer.name", wfstype.getName());
        props.setProperty("oracle.mdeditor.wfs.layer.WFSLayer.serverURL", capabilities.getCapabilitiesGetURL());
        props.setProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeName", wfstype.getName());
        props.setProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeNSAlias", wfstype.getNameSpaceAlias());
        props.setProperty("oracle.mdeditor.wfs.layer.WFSLayer.featureTypeNSURI", wfstype.getNameSpaceAliasURL());
        ArrayList<String> authParams = addConnAuthParams.get(capabilities.getCapabilitiesGetURL().toLowerCase());
        if (authParams != null) {
            props.setProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationUser", authParams.get(0));
            props.setProperty("oracle.mdeditor.wfs.layer.WFSLayer.authenticationPassword", ChecksumHelper.encAsc((String)authParams.get(1)));
        }
        XMLDocument doc = new XMLDocument();
        doc.setXmlVersion("1.0");
        Element root = doc.createElement("layer");
        root.setAttribute("class", WFSLayer.class.getCanonicalName());
        if (props.size() > 0) {
            try {
                Element propsElem = props.toXMLElement();
                if (propsElem != null) {
                    root.appendChild(doc.adoptNode((Node)propsElem));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (SAXException ex) {
                ex.printStackTrace();
            }
        }
        return this.createLayer(root, capabilities, wfstype);
    }

    @Override
    public Layer removeEditorObject(TreePath layerDesc) {
        return null;
    }

    @Override
    public DefaultMutableTreeNode getProviderRootNode() {
        return this.rootNode;
    }

    @Override
    public TreeCellRenderer getTreeCellRenderer() {
        return new MyTreeCellRenderer();
    }

    @Override
    public TreeExpansionListener getTreeExpansionListener() {
        return null;
    }

    @Override
    public TreeWillExpandListener getTreeWillExpandListener() {
        return new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                WFSLayerProvider.this.populate(evt.getPath(), (JTree)evt.getSource());
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) {
            }
        };
    }

    private void populate(TreePath path, JTree tree) throws ExpandVetoException {
        EmptyNonLeaf root = (EmptyNonLeaf)path.getLastPathComponent();
        Object obj = root.getUserObject();
        if (obj instanceof WFSLayerProvider && root.getChildCount() == 0) {
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            root.removeAllChildren();
            model.insertNodeInto(new DefaultMutableTreeNode(ADDCONNECTION), root, root.getChildCount());
            for (WfsCapabilities conn : this.connections) {
                EmptyNonLeaf connectionNode = new EmptyNonLeaf(conn);
                model.insertNodeInto(connectionNode, root, root.getChildCount());
            }
            model.nodeStructureChanged(root);
        }
    }

    @Override
    public TreeSelectionListener getTreeSelectionListener() {
        return new TreeSelectionListener(){
            boolean supressEvent = false;

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreePath newSel = evt.getNewLeadSelectionPath();
                if (!this.supressEvent && newSel != null && newSel.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)newSel.getLastPathComponent();
                    Object obj = node.getUserObject();
                    if (node instanceof EmptyNonLeaf || WFSLayerProvider.ADDCONNECTION == obj) {
                        TreeSelectionModel selModel = ((JTree)evt.getSource()).getSelectionModel();
                        if (WFSLayerProvider.ADDCONNECTION == obj) {
                            WFSLayerProvider.this.addConnection(newSel, (JTree)evt.getSource());
                        }
                        this.supressEvent = true;
                        selModel.removeSelectionPath(newSel);
                        this.supressEvent = false;
                    }
                }
            }
        };
    }

    private void addConnection(TreePath path, JTree tree) {
        String baseURL = null;
        EditorAppletInfo bean = this.mainApp.getContextBean();
        if (bean != null) {
            baseURL = bean.getMapViewerBaseUrl();
            int idx = baseURL.lastIndexOf("/mapviewer");
            baseURL = idx != -1 ? baseURL.substring(0, idx) + "/SpatialWS-SpatialWS-context-root/xmlwfsservlet" : null;
        }
        WFSConnectionPanel connPanel = new WFSConnectionPanel(baseURL);
        OlafDialog connDlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Select_data_source"), connPanel);
        connDlg.getHelpButton().setVisible(false);
        connDlg.setVisible(true);
        if (connDlg.isCancelled()) {
            return;
        }
        String serverURL = connPanel.getServer();
        if (serverURL == null || serverURL.trim().isEmpty()) {
            ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), "error", "error", 0);
            return;
        }
        String version = connPanel.getVersion();
        String authUser = null;
        String authPwd = null;
        if (connPanel.isAuthenticationEnabled()) {
            authUser = connPanel.getUser();
            authPwd = connPanel.getPassword();
        }
        try {
            URL url = new URL(serverURL);
        }
        catch (MalformedURLException ex) {
            ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Error"), MessagesBundle.getMessage("Error"), 0);
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2);
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        EmptyNonLeaf placeHolderNode = new EmptyNonLeaf("");
        placeHolderNode.setWorking(true);
        model.insertNodeInto(placeHolderNode, root, 1);
        if (authUser != null && authPwd != null) {
            ArrayList<String> authParams = new ArrayList<String>();
            authParams.add(authUser);
            authParams.add(authPwd);
            addConnAuthParams.put(serverURL.toLowerCase(), authParams);
        } else {
            addConnAuthParams.remove(serverURL.toLowerCase());
        }
        new GetCapabilitiesWorker(serverURL, authUser, authPwd, placeHolderNode, tree).execute();
    }

    private WfsCapabilities getCapabilities(String url, String user, String pwd) throws Exception {
        String docGetURL;
        WfsCapabilities capabilities = null;
        if (url == null || url.trim().length() == 0) {
            throw new Exception("Unable to get Capabilities from empmty url.");
        }
        CacheGroup cg = CacheMgr2.getGroup((String)"WFS_URL", (String)"WFS_CAPABILITIES");
        if (cg != null) {
            capabilities = (WfsCapabilities)cg.get((Object)(url.trim() + "1.0.0"));
        }
        if (capabilities != null) {
            return capabilities;
        }
        WSAuthenticator authenticator = null;
        if (user != null && pwd != null) {
            authenticator = WSAuthenticator.getInstance();
            this.addProtectedURL(authenticator, url, user, pwd);
        }
        if (!(capabilities = new WfsCapabilities()).readUsingHttpGet(url, 30000L, "1.0.0")) {
            throw new Exception("Unable to get Capabilities from url: " + url);
        }
        if (user != null && pwd != null && (docGetURL = capabilities.getCapabilitiesGetURL()) != null && !docGetURL.equalsIgnoreCase(url)) {
            ArrayList<String> authParams = new ArrayList<String>();
            authParams.add(user);
            authParams.add(pwd);
            addConnAuthParams.put(docGetURL.toLowerCase(), authParams);
        }
        String transactionGetUrl = capabilities.getTransactionGetURL();
        String transactionPostUrl = capabilities.getTransactionPostURL();
        if (transactionGetUrl == null && transactionPostUrl == null) {
            throw new Exception("WFS server at " + url + " does not support transaction");
        }
        if (authenticator != null) {
            this.doCompleteAuthentication(authenticator, user, pwd, capabilities);
        }
        if (cg == null) {
            if (!CacheMgr2.isReady()) {
                CacheMgr2.init();
            }
            CacheMgr2.createSubRegion((String)"WFS_URL");
            CacheMgr2.createGroup((String)"WFS_URL", (String)"WFS_CAPABILITIES");
            cg = CacheMgr2.getGroup((String)"WFS_URL", (String)"WFS_CAPABILITIES");
        }
        if (cg != null) {
            cg.put((Object)(url.trim() + "1.0.0"), (Object)capabilities, 0L);
        }
        return capabilities;
    }

    @Override
    public MouseListener getMouseListener() {
        return null;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public MouseWheelListener getMouseWheelListener() {
        return null;
    }

    private void doCompleteAuthentication(WSAuthenticator authenticator, String user, String pwd, WfsCapabilities capabilities) {
        if (authenticator != null && user != null && pwd != null && capabilities != null) {
            String describeUrl_get = capabilities.describeFeatureTypeGetURL();
            this.addProtectedURL(authenticator, describeUrl_get, user, pwd);
            String describeUrl_post = capabilities.describeFeatureTypePostURL();
            this.addProtectedURL(authenticator, describeUrl_post, user, pwd);
            String getfeatureGetUrl = capabilities.getFeatureGetURL();
            this.addProtectedURL(authenticator, getfeatureGetUrl, user, pwd);
            String getfeaturePostUrl = capabilities.getFeaturePostURL();
            this.addProtectedURL(authenticator, getfeaturePostUrl, user, pwd);
            String featurewithlockGetUrl = capabilities.getFeatureWithLockGetURL();
            this.addProtectedURL(authenticator, featurewithlockGetUrl, user, pwd);
            String featurewithlockPostUrl = capabilities.getFeatureWithLockPostURL();
            this.addProtectedURL(authenticator, featurewithlockPostUrl, user, pwd);
            String lockfeatureGetURL = capabilities.getLockFeatureGetURL();
            this.addProtectedURL(authenticator, lockfeatureGetURL, user, pwd);
            String lockfeaturePostUrl = capabilities.getLocFeaturePostURL();
            this.addProtectedURL(authenticator, lockfeaturePostUrl, user, pwd);
            String transactionGetUrl = capabilities.getTransactionGetURL();
            this.addProtectedURL(authenticator, transactionGetUrl, user, pwd);
            String transactionPostUrl = capabilities.getTransactionPostURL();
            this.addProtectedURL(authenticator, transactionPostUrl, user, pwd);
        }
    }

    private void addProtectedURL(WSAuthenticator authenticator, String urlString, String user, String pwd) {
        if (authenticator != null && urlString != null && user != null && pwd != null) {
            if (urlString.endsWith("?")) {
                authenticator.addProtectedURL(urlString.substring(0, urlString.length() - 1), user, pwd);
            } else {
                authenticator.addProtectedURL(urlString, user, pwd);
            }
        }
    }

    private boolean isOGCgeometryType(String type) {
        if (type == null) {
            return false;
        }
        return type.toUpperCase().indexOf("AbstractGeometryType".toUpperCase()) > -1 || type.toUpperCase().indexOf("GeometryCollectionType".toUpperCase()) > -1 || type.toUpperCase().indexOf("GeometryAssociationType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PointMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LineStringMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PolygonMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LinearRingMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LinearRingMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PointType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LineStringType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LinearRingType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PolygonType".toUpperCase()) > -1 || type.toUpperCase().indexOf("BoxType".toUpperCase()) > -1 || type.toUpperCase().indexOf("GeometryCollectionType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPointType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiLineStringType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPolygonType".toUpperCase()) > -1 || type.toUpperCase().indexOf("CoordType".toUpperCase()) > -1 || type.toUpperCase().indexOf("CoordinatesType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LinearRingMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LineStringMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LineStringPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiGeometryPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiLineStringPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPointPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPolygonPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PointMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PointPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PolygonMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PolygonPropertyType".toUpperCase()) > -1;
    }

    private class SpatialAttributePanel
    extends JPanel {
        private JLabel attrSelectLabel = null;
        private JComboBox attrSelect = new JComboBox();

        public SpatialAttributePanel(Hashtable attrTypes) {
            for (Object attrName : attrTypes.keySet()) {
                this.attrSelect.addItem(attrName);
            }
            this.attrSelectLabel = new JLabel(MessagesBundle.getMessage("Label_wfs_select_geom_attr"));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.attrSelectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.attrSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public String getSpatialColumn() {
            return this.attrSelect.getSelectedItem().toString();
        }
    }

    private class EmptyNonLeaf
    extends DefaultMutableTreeNode {
        private boolean working;

        public EmptyNonLeaf(Object userObject) {
            super(userObject);
            this.working = false;
        }

        @Override
        public boolean isLeaf() {
            return this.isWorking();
        }

        public void setWorking(boolean working) {
            this.working = working;
        }

        public boolean isWorking() {
            return this.working;
        }
    }

    private class GetCapabilitiesWorker
    extends SwingWorker {
        private String user = null;
        private String pwd = null;
        private String url = null;
        private EmptyNonLeaf placeHolder = null;
        private JTree tree = null;
        private EmptyNonLeaf connRoot = null;

        public GetCapabilitiesWorker(String url, String user, String pwd, EmptyNonLeaf placeHolder, JTree tree) {
            this.user = user;
            this.pwd = pwd;
            this.url = url;
            this.placeHolder = placeHolder;
            this.tree = tree;
        }

        public Object doInBackground() {
            try {
                log.info("Reading WFS capabilities for URL: " + this.url);
                WfsCapabilities capabilities = WFSLayerProvider.this.getCapabilities(this.url, this.user, this.pwd);
                if (capabilities != null && WFSLayerProvider.this.connections.add(capabilities)) {
                    this.connRoot = new EmptyNonLeaf(capabilities);
                    Vector types = capabilities.getFeatureTypes();
                    for (Object type : types) {
                        DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(type);
                        this.connRoot.add(layerNode);
                    }
                }
                log.info("Done with reading WFS capabilities.");
            }
            catch (Exception ex) {
                log.severe("Exception: " + ex.getMessage());
                ex.printStackTrace();
                ErrorDialog.showErrorDialog(null, WFSLayerProvider.this.mainApp.getFrameForDialog(), ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = (DefaultTreeModel)GetCapabilitiesWorker.this.tree.getModel();
                    int idx = WFSLayerProvider.this.rootNode.getIndex(GetCapabilitiesWorker.this.placeHolder);
                    model.removeNodeFromParent((MutableTreeNode)WFSLayerProvider.this.rootNode.getChildAt(idx));
                    if (GetCapabilitiesWorker.this.connRoot != null) {
                        model.insertNodeInto(GetCapabilitiesWorker.this.connRoot, WFSLayerProvider.this.rootNode, idx);
                        GetCapabilitiesWorker.this.tree.expandPath(new TreePath(GetCapabilitiesWorker.this.connRoot.getPath()));
                    }
                }
            });
            return null;
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            String txt = "";
            ImageIcon icon = null;
            if (value instanceof EmptyNonLeaf && ((EmptyNonLeaf)value).isWorking()) {
                txt = "Working...";
                icon = Icons.getIcon("refresh.png");
            } else if (obj instanceof WFSLayerProvider) {
                txt = ((WFSLayerProvider)obj).getProviderName();
            } else if (obj instanceof WfsCapabilities) {
                txt = ((WfsCapabilities)obj).getServiceName();
                icon = Icons.getIcon("db_connected.png");
            } else if (obj instanceof WfsFeatureType) {
                WfsFeatureType type = (WfsFeatureType)obj;
                txt = type.getNameSpaceAlias() + ":" + type.getName() + " [" + type.getSRS() + "]";
                icon = Icons.getIcon("earth16.gif");
            } else {
                txt = obj.toString();
                if (WFSLayerProvider.ADDCONNECTION == obj) {
                    icon = Icons.getIcon("connect_ena.png");
                }
            }
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, txt, selected, expanded, leaf, row, hasFocus);
            if (icon != null) {
                label.setIcon(icon);
            }
            return label;
        }
    }
}

