/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.session.layer.EditSessionLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;

public class TopologyLayerPropertyPanel
extends JPanel {
    private JLabel nameLabel = new JLabel();
    private JLabel nameTxt = new JLabel();
    private JLabel basetableLabel = new JLabel();
    private JLabel basetableTxt = new JLabel();
    private JCheckBox jCheckBox1 = new JCheckBox();
    private JLabel jLabel2 = new JLabel();
    private JComboBox jComboBox1 = new JComboBox();
    private JComboBox jComboBox2 = new JComboBox();
    private EditSessionLayer sessionLayer = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel keyLabel = new JLabel();
    private JComboBox keyComboBox = new JComboBox();
    private JLabel topologyLabel = new JLabel();
    private JComboBox topologyCombo = new JComboBox();
    private JLabel conditionLabel = new JLabel();
    private JTextField conditionTxt = new JTextField();
    private boolean allowLabelChanges = true;
    private String[] spatialColumns = null;
    private String[] tableAttrs = null;
    static ImageIcon editableIcon = Icons.getIcon("edit16.png");
    private JLabel livescaleLabel = new JLabel();
    private JTextField livescaleTxt = new JTextField();
    private JCheckBox keysequenceBox = new JCheckBox();
    private JComboBox keysequenceComboBox = new JComboBox();
    private String[] seqNames = null;
    private AbstractDataSource dataSource = null;

    public TopologyLayerPropertyPanel(EditSessionLayer layer, String[] geomColumns, String[] simpleAttrs, String[] sequences, AbstractDataSource dsrc) {
        this.sessionLayer = layer;
        this.spatialColumns = geomColumns;
        this.tableAttrs = simpleAttrs;
        this.seqNames = sequences;
        this.dataSource = dsrc;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(311, 240));
        this.nameLabel.setText(MessagesBundle.getMessage("Label_name"));
        this.jCheckBox1.setText(MessagesBundle.getMessage("Label_label_column"));
        this.jLabel2.setText(MessagesBundle.getMessage("Label_topology_column"));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopologyLayerPropertyPanel.this.jComboBox1_actionPerformed(e);
            }
        });
        this.keyLabel.setText(MessagesBundle.getMessage("Label_key_column"));
        this.basetableLabel.setText(MessagesBundle.getMessage("Label_base_table"));
        this.livescaleLabel.setText(MessagesBundle.getMessage("Label_live_scale"));
        this.livescaleTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_live_scale"));
        this.conditionLabel.setText(MessagesBundle.getMessage("Label_query_condition"));
        this.keysequenceBox.setText(MessagesBundle.getMessage("Label_key_sequence"));
        this.topologyLabel.setText(MessagesBundle.getMessage("Label_topology"));
        this.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.nameTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.basetableLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.basetableTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.keyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.keyComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.keysequenceBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.keysequenceComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.jComboBox1, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.topologyLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.topologyCombo, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.jCheckBox1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.jComboBox2, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.conditionLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.conditionTxt, new GridBagConstraints(1, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.livescaleLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.livescaleTxt, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.fillUIparameters();
        this.updateLabelFieldsStatus();
    }

    public void allowLabelChanges(boolean allow) {
        this.allowLabelChanges = allow;
        this.updateLabelFieldsStatus();
    }

    private void updateLabelFieldsStatus() {
        this.jCheckBox1.setEnabled(this.allowLabelChanges);
        this.jComboBox2.setEnabled(this.allowLabelChanges);
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.nameTxt.setText("");
        } else {
            this.nameTxt.setText(name);
        }
    }

    public String getGeometryColumn() {
        if (this.jComboBox1.getItemCount() < 1) {
            return null;
        }
        return this.jComboBox1.getSelectedItem().toString();
    }

    public String getLabelColumn() {
        if (this.jComboBox2.getItemCount() < 1) {
            return null;
        }
        return this.jComboBox2.getSelectedItem().toString();
    }

    public boolean isLabelSelected() {
        return this.jCheckBox1.isSelected();
    }

    public void setLabelSelected(boolean select) {
        this.jCheckBox1.setSelected(select);
    }

    public void setGeometryColumns(String[] columns) {
        this.jComboBox1.removeAllItems();
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this.jComboBox1.addItem(columns[i].toUpperCase());
        }
    }

    public void setGeometryColumn(String geomCol) {
        if (geomCol == null) {
            return;
        }
        this.jComboBox1.setSelectedItem(geomCol.toUpperCase());
    }

    public void setLabelColumns(String[] columns) {
        this.jComboBox2.removeAllItems();
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this.jComboBox2.addItem(columns[i].toUpperCase());
        }
    }

    public void setLabelColumn(String labelCol) {
        if (labelCol == null) {
            return;
        }
        this.jComboBox2.setSelectedItem(labelCol.toUpperCase());
    }

    private void fillUIparameters() {
        if (this.sessionLayer == null) {
            return;
        }
        this.setName(this.sessionLayer.getName());
        this.setLiveScale(this.sessionLayer.getLiveScale());
        String basetable = this.sessionLayer.getBaseTable();
        this.basetableTxt.setText(basetable);
        String geomColumn = this.sessionLayer.getSpatialColumn();
        String[] geomAttrs = this.spatialColumns;
        this.setGeometryColumns(geomAttrs);
        this.setGeometryColumn(geomColumn);
        String[] seqs = this.seqNames;
        this.setKeySequences(seqs);
        String seqName = this.sessionLayer.getParameterValue("keySequence");
        this.setKeySequence(seqName);
        if (seqName != null) {
            this.setKeySequenceSelected(true);
        } else {
            this.setKeySequenceSelected(false);
            this.setKeySequence(basetable + "_" + this.sessionLayer.getKeyColumn() + "_SEQ");
        }
        String[] attrs = this.tableAttrs;
        this.setKeyColumns(attrs);
        this.setKeyColumn(this.sessionLayer.getKeyColumn());
        this.setLabelColumns(attrs);
        String labelCol = this.sessionLayer.getParameterValue("labelColumn");
        if (labelCol != null) {
            this.setLabelSelected(true);
            this.setLabelColumn(labelCol);
        } else {
            this.setLabelSelected(false);
        }
        this.setQueryCondition(this.sessionLayer.getParameterValue("queryCondition"));
        this.fillTopologyCombo();
    }

    public void setKeyColumns(String[] colnames) {
        this.keyComboBox.removeAllItems();
        this.keyComboBox.addItem("ROWID");
        if (colnames == null) {
            return;
        }
        for (int i = 0; i < colnames.length; ++i) {
            if (colnames[i].equalsIgnoreCase("ROWID")) continue;
            this.keyComboBox.addItem(colnames[i].toUpperCase());
        }
    }

    public void setKeyColumn(String colname) {
        if (colname == null) {
            return;
        }
        this.keyComboBox.setSelectedItem(colname.toUpperCase());
    }

    public String getKeyColumn() {
        if (this.keyComboBox.getItemCount() == 0) {
            return null;
        }
        return this.keyComboBox.getSelectedItem().toString();
    }

    public void setKeySequences(String[] seqs) {
        this.keysequenceComboBox.removeAllItems();
        if (seqs == null) {
            return;
        }
        for (int i = 0; i < seqs.length; ++i) {
            if (seqs[i].toUpperCase().startsWith("MDRS_") && seqs[i].toUpperCase().endsWith("$")) continue;
            this.keysequenceComboBox.addItem(seqs[i].toUpperCase());
        }
    }

    public void setKeySequence(String seqname) {
        if (seqname == null) {
            return;
        }
        this.keysequenceComboBox.setSelectedItem(seqname.toUpperCase());
    }

    public void setKeySequenceSelected(boolean selected) {
        this.keysequenceBox.setSelected(selected);
    }

    public boolean isKeySequenceSelected() {
        return this.keysequenceBox.isSelected();
    }

    public String getKeySequence() {
        if (this.keysequenceComboBox.getItemCount() == 0) {
            return null;
        }
        return this.keysequenceComboBox.getSelectedItem().toString();
    }

    public void isEditingMode(boolean mode) {
        if (mode) {
            this.keyComboBox.setEnabled(false);
            this.jComboBox1.setEnabled(false);
            this.conditionTxt.setEnabled(false);
        } else {
            this.keyComboBox.setEnabled(true);
            this.jComboBox1.setEnabled(true);
            this.conditionTxt.setEnabled(true);
        }
    }

    public double getLiveScale() {
        String text = this.livescaleTxt.getText();
        if (text == null || text.length() == 0) {
            return 0.0;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            double scale = nf.parse(text).doubleValue();
            if (scale <= 0.0) {
                return Double.NaN;
            }
            return scale;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void setLiveScale(double scale) {
        if (Double.isNaN(scale)) {
            this.livescaleTxt.setText("");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            this.livescaleTxt.setText(nf.format(scale));
        }
    }

    public void setQueryCondition(String filter) {
        if (filter == null) {
            this.conditionTxt.setText("");
        } else {
            this.conditionTxt.setText(filter);
        }
    }

    public String getQueryCondition() {
        if (this.conditionTxt.getText() == null) {
            return null;
        }
        String filter = this.conditionTxt.getText().trim();
        if (filter.length() == 0) {
            return null;
        }
        return filter;
    }

    public String getTopology() {
        if (this.topologyCombo.getItemCount() == 0) {
            return null;
        }
        return this.topologyCombo.getSelectedItem().toString();
    }

    public void setTopology(String topology) {
        if (topology == null || this.topologyCombo.getItemCount() == 0) {
            return;
        }
        this.topologyCombo.setSelectedItem(topology.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTopologyCombo() {
        this.topologyCombo.removeAllItems();
        String table = this.basetableTxt.getText();
        if (this.dataSource == null || this.jComboBox1.getItemCount() == 0) {
            return;
        }
        String column = this.jComboBox1.getSelectedItem().toString();
        AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
        Throwable exception = null;
        try {
            dataAccess.openConnection();
            String[] topologies = dataAccess.getFeatureTableTopologies(table, column);
            if (topologies != null && topologies.length > 0) {
                for (int i = 0; i < topologies.length; ++i) {
                    String topoUser = null;
                    String topoName = topologies[i];
                    int idx = topologies[i].indexOf(".");
                    if (idx > -1) {
                        topoUser = topologies[i].substring(0, idx);
                        topoName = topologies[i].substring(idx + 1);
                    }
                    this.topologyCombo.addItem(topoName);
                }
            }
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void jComboBox1_actionPerformed(ActionEvent e) {
        this.fillTopologyCombo();
    }
}

