/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.maps.core.Layer;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.RenderLabelPanel;
import oracle.mdeditor.ui.SDEUIComponent;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class TopoPrimitivesRenderLabelPanel
extends JPanel
implements SDEUIComponent,
ListSelectionListener {
    private MainAppPanel mainApp = null;
    private JTabbedPane tabPane = new JTabbedPane();
    private RenderLabelPanel nodeStylePanel = null;
    private RenderLabelPanel edgeStylePanel = null;
    private RenderLabelPanel faceStylePanel = null;
    private JButton applyButton = new JButton(MessagesBundle.getMessage("Apply"));

    public TopoPrimitivesRenderLabelPanel(MainAppPanel mainApp) {
        this.mainApp = mainApp;
        this.nodeStylePanel = new RenderLabelPanel(mainApp);
        this.edgeStylePanel = new RenderLabelPanel(mainApp);
        this.faceStylePanel = new RenderLabelPanel(mainApp);
        this.mainApp.getEditSessionPanel().getSelectionModel().addListSelectionListener(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName(MessagesBundle.getMessage("Topology_primitives_properties"));
        this.setLayout(new GridBagLayout());
        this.nodeStylePanel.setRenderStyle(StyleModelUtils.defaultMarkerName);
        this.nodeStylePanel.setLabelStyle(StyleModelUtils.defaultTextName);
        this.edgeStylePanel.setRenderStyle(StyleModelUtils.defaultLineName);
        this.edgeStylePanel.setLabelStyle(StyleModelUtils.defaultTextName);
        this.faceStylePanel.setRenderStyle(StyleModelUtils.defaultColorName);
        this.faceStylePanel.setLabelStyle(StyleModelUtils.defaultTextName);
        this.nodeStylePanel.setRenderLineTabEnabled(false);
        this.edgeStylePanel.setRenderMarkerTabEnabled(false);
        this.faceStylePanel.setRenderLineTabEnabled(false);
        this.faceStylePanel.setRenderMarkerTabEnabled(false);
        this.tabPane.addTab(MessagesBundle.getMessage("Node"), this.nodeStylePanel);
        this.tabPane.addTab(MessagesBundle.getMessage("Edge"), this.edgeStylePanel);
        this.tabPane.addTab(MessagesBundle.getMessage("Face"), this.faceStylePanel);
        this.tabPane.setSelectedIndex(1);
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Layer layer = TopoPrimitivesRenderLabelPanel.this.mainApp.getEditSessionPanel().getSelectedLayer();
                if (layer == null) {
                    return;
                }
                String nodeRenderStyle = TopoPrimitivesRenderLabelPanel.this.getNodeRenderStyle();
                String nodeLabelStyle = TopoPrimitivesRenderLabelPanel.this.getNodeLabelStyle();
                layer.setProperty("nodeRenderStyle", nodeRenderStyle);
                layer.setProperty("nodeLabelStyle", nodeLabelStyle);
                String edgeRenderStyle = TopoPrimitivesRenderLabelPanel.this.getEdgeRenderStyle();
                String edgeLabelStyle = TopoPrimitivesRenderLabelPanel.this.getEdgeLabelStyle();
                layer.setProperty("edgeRenderStyle", edgeRenderStyle);
                layer.setProperty("edgeLabelStyle", edgeLabelStyle);
                String faceRenderStyle = TopoPrimitivesRenderLabelPanel.this.getFaceRenderStyle();
                String faceLabelStyle = TopoPrimitivesRenderLabelPanel.this.getFaceLabelStyle();
                layer.setProperty("faceRenderStyle", faceRenderStyle);
                layer.setProperty("faceLabelStyle", faceLabelStyle);
            }
        });
        this.add((Component)this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.applyButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateUIStatus() {
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e != null && e.getValueIsAdjusting()) {
            return;
        }
        this.applyButton.setEnabled(false);
        Layer layer = this.mainApp.getEditSessionPanel().getSelectedLayer();
        if (layer != null) {
            this.setNodeRenderStyle(layer.getProperty("nodeRenderStyle"));
            this.setNodeLabelStyle(layer.getProperty("nodeLabelStyle"));
            this.setEdgeRenderStyle(layer.getProperty("edgeRenderStyle"));
            this.setEdgeLabelStyle(layer.getProperty("edgeLabelStyle"));
            this.setFaceRenderStyle(layer.getProperty("faceRenderStyle"));
            this.setFaceLabelStyle(layer.getProperty("faceLabelStyle"));
            this.applyButton.setEnabled(true);
        }
    }

    public String getNodeRenderStyle() {
        if (this.nodeStylePanel.isRenderSelected()) {
            StyleModel model = this.nodeStylePanel.getRenderStyleModel();
            if (model == null) {
                return null;
            }
            return model.getName();
        }
        return null;
    }

    public void setNodeRenderStyle(String style) {
        if (style == null) {
            this.nodeStylePanel.setRenderSelected(false);
        } else {
            this.nodeStylePanel.setRenderSelected(true);
            this.nodeStylePanel.setRenderStyle(style);
        }
    }

    public String getEdgeRenderStyle() {
        if (this.edgeStylePanel.isRenderSelected()) {
            StyleModel model = this.edgeStylePanel.getRenderStyleModel();
            if (model == null) {
                return null;
            }
            return model.getName();
        }
        return null;
    }

    public void setEdgeRenderStyle(String style) {
        if (style == null) {
            this.edgeStylePanel.setRenderSelected(false);
        } else {
            this.edgeStylePanel.setRenderSelected(true);
            this.edgeStylePanel.setRenderStyle(style);
        }
    }

    public String getFaceRenderStyle() {
        if (this.faceStylePanel.isRenderSelected()) {
            StyleModel model = this.faceStylePanel.getRenderStyleModel();
            if (model == null) {
                return null;
            }
            return model.getName();
        }
        return null;
    }

    public void setFaceRenderStyle(String style) {
        if (style == null) {
            this.faceStylePanel.setRenderSelected(false);
        } else {
            this.faceStylePanel.setRenderSelected(true);
            this.faceStylePanel.setRenderStyle(style);
        }
    }

    public String getNodeLabelStyle() {
        if (this.nodeStylePanel.isLabelSelected()) {
            StyleModel model = this.nodeStylePanel.getLabelStyleModel();
            if (model == null) {
                return null;
            }
            return model.getName();
        }
        return null;
    }

    public void setNodeLabelStyle(String style) {
        if (style == null) {
            this.nodeStylePanel.setLabelSelected(false);
        } else {
            this.nodeStylePanel.setLabelSelected(true);
            this.nodeStylePanel.setLabelStyle(style);
        }
    }

    public String getEdgeLabelStyle() {
        if (this.edgeStylePanel.isLabelSelected()) {
            StyleModel model = this.edgeStylePanel.getLabelStyleModel();
            if (model == null) {
                return null;
            }
            return model.getName();
        }
        return null;
    }

    public void setEdgeLabelStyle(String style) {
        if (style == null) {
            this.edgeStylePanel.setLabelSelected(false);
        } else {
            this.edgeStylePanel.setLabelSelected(true);
            this.edgeStylePanel.setLabelStyle(style);
        }
    }

    public String getFaceLabelStyle() {
        if (this.faceStylePanel.isLabelSelected()) {
            StyleModel model = this.faceStylePanel.getLabelStyleModel();
            if (model == null) {
                return null;
            }
            return model.getName();
        }
        return null;
    }

    public void setFaceLabelStyle(String style) {
        if (style == null) {
            this.faceStylePanel.setLabelSelected(false);
        } else {
            this.faceStylePanel.setLabelSelected(true);
            this.faceStylePanel.setLabelStyle(style);
        }
    }
}

