/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class MultiRowFlowLayout
extends FlowLayout
implements LayoutManager2 {
    public static final Integer EXPAND_HORIZONTALLY = 1;
    private Hashtable<Component, Integer> compTable = new Hashtable();

    public MultiRowFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    public MultiRowFlowLayout(int align) {
        super(align, 0, 0);
    }

    public MultiRowFlowLayout() {
        super(0, 0, 0);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        super.addLayoutComponent(null, comp);
        if (constraints instanceof Integer) {
            this.compTable.put(comp, new Integer((Integer)constraints));
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        super.removeLayoutComponent(comp);
        this.compTable.remove(comp);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstRowComponent = true;
            boolean useBaseline = this.getAlignOnBaseline();
            int maxAscent = 0;
            int maxDescent = 0;
            Insets insets = target.getInsets();
            int availableWidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, target);
            if (scrollPane != null) {
                availableWidth = scrollPane.getWidth() - (1 + insets.left + insets.right + this.getHgap() * 3);
                if (scrollPane.getVerticalScrollBar().isShowing()) {
                    availableWidth -= scrollPane.getVerticalScrollBar().getWidth();
                }
            }
            Dimension rowDim = new Dimension(0, 0);
            for (int i = 0; i < nmembers; ++i) {
                int baseline;
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (rowDim.width + d.width > availableWidth) {
                    if (useBaseline) {
                        rowDim.height = Math.max(maxAscent + maxDescent, rowDim.height);
                    }
                    maxAscent = 0;
                    maxDescent = 0;
                    dim.width = Math.max(dim.width, rowDim.width);
                    dim.height += rowDim.height;
                    rowDim.width = 0;
                    rowDim.height = 0;
                    firstRowComponent = true;
                }
                rowDim.height = Math.max(rowDim.height, d.height + this.getVgap());
                if (firstRowComponent) {
                    firstRowComponent = false;
                } else {
                    rowDim.width += this.getHgap();
                }
                Integer con = this.compTable.get(m);
                if (con != null && con.equals(EXPAND_HORIZONTALLY)) {
                    d.width = Math.max(d.width, availableWidth - rowDim.width);
                }
                rowDim.width += d.width;
                if (!useBaseline || (baseline = m.getBaseline(d.width, d.height)) < 0) continue;
                maxAscent = Math.max(maxAscent, baseline);
                maxDescent = Math.max(maxDescent, d.height - baseline);
            }
            dim.width = Math.max(dim.width, rowDim.width);
            dim.height += rowDim.height;
            dim.width += insets.left + insets.right + this.getHgap() * 2;
            dim.height += insets.top + insets.bottom + this.getVgap() * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, target);
            if (scrollPane != null) {
                maxwidth = scrollPane.getWidth() - (1 + insets.left + insets.right + this.getHgap() * 3);
                if (scrollPane.getVerticalScrollBar().isShowing()) {
                    maxwidth -= scrollPane.getVerticalScrollBar().getWidth();
                }
            }
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            boolean useBaseline = this.getAlignOnBaseline();
            int[] ascent = null;
            int[] descent = null;
            if (useBaseline) {
                ascent = new int[nmembers];
                descent = new int[nmembers];
            }
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                Integer con = this.compTable.get(m);
                if (con != null && con.equals(EXPAND_HORIZONTALLY)) {
                    d.width = Math.max(d.width, maxwidth - x);
                }
                m.setSize(d.width, d.height);
                if (useBaseline) {
                    int baseline = m.getBaseline(d.width, d.height);
                    if (baseline >= 0) {
                        ascent[i] = baseline;
                        descent[i] = d.height - baseline;
                    } else {
                        ascent[i] = -1;
                    }
                }
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += this.getHgap();
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                if (con != null && con.equals(EXPAND_HORIZONTALLY)) {
                    m.setSize(maxwidth, d.height);
                }
                rowh = this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, i, ltr, useBaseline, ascent, descent);
                x = m.getWidth();
                y += this.getVgap() + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, nmembers, ltr, useBaseline, ascent, descent);
        }
    }

    private int moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr, boolean useBaseline, int[] ascent, int[] descent) {
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        int maxAscent = 0;
        int nonbaselineHeight = 0;
        int baselineOffset = 0;
        if (useBaseline) {
            int maxDescent = 0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ascent[i] >= 0) {
                    maxAscent = Math.max(maxAscent, ascent[i]);
                    maxDescent = Math.max(maxDescent, descent[i]);
                    continue;
                }
                nonbaselineHeight = Math.max(m.getHeight(), nonbaselineHeight);
            }
            height = Math.max(maxAscent + maxDescent, nonbaselineHeight);
            baselineOffset = (height - maxAscent - maxDescent) / 2;
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            int cy = useBaseline && ascent[i] >= 0 ? y + baselineOffset + maxAscent - ascent[i] : y + (height - m.getHeight()) / 2;
            if (ltr) {
                m.setLocation(x, cy);
            } else {
                m.setLocation(target.getWidth() - x - m.getWidth(), cy);
            }
            x += m.getWidth() + this.getHgap();
        }
        return height;
    }
}

