/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.MapRegion;
import oracle.mdeditor.ui.PrevNextCoveragePanel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class MapCoveragePanel
extends JToolBar
implements ChangeListener {
    protected PrevNextCoveragePanel prevnextPanel = new PrevNextCoveragePanel();
    private JLabel jLabel1 = new JLabel(MessagesBundle.getMessage("Label_center_x"));
    private JTextField jTextField_cx = new JTextField();
    private JLabel jLabel2 = new JLabel(MessagesBundle.getMessage("Label_center_y"));
    private JTextField jTextField_cy = new JTextField();
    private JComboBox jComboBox_size = new JComboBox();
    private JTextField jTextField_size = new JTextField();
    private JPopupMenu clipboardMenu = new JPopupMenu();
    private JMenuItem copyItem = new JMenuItem();
    private JMenuItem pasteItem = new JMenuItem();
    private JMenuItem clearItem = new JMenuItem();
    private double dataHeight = Double.NaN;
    private double ratioScale = Double.NaN;

    public MapCoveragePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setRollover(true);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int button = e.getButton();
                if (button == 3) {
                    MapCoveragePanel.this.clipboardMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.jTextField_cx.setToolTipText(MessagesBundle.getMessage("Tooltip_preview_map_cx"));
        this.jTextField_cy.setToolTipText(MessagesBundle.getMessage("Tooltip_preview_map_cy"));
        this.jComboBox_size.addItem(MessagesBundle.getMessage("Label_height"));
        this.jComboBox_size.addItem(MessagesBundle.getMessage("Label_scale"));
        this.jComboBox_size.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCoveragePanel.this.jComboBox_size_actionPerformed(e);
            }
        });
        this.updateSizeTooltip();
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(0, 0));
        this.add((Component)spacer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.prevnextPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jTextField_cx, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 50, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jTextField_cy, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 50, 0));
        this.add((Component)this.jComboBox_size, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jTextField_size, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 30, 0));
        this.clear();
        Object copyAction = null;
        Object pasteAction = null;
        Object clearAction = null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof MapRegion) {
            MapRegion reg = (MapRegion)src;
            Rectangle2D rect = reg.getDataWindow();
            if (rect == null) {
                this.clear();
                return;
            }
            this.dataHeight = rect.getHeight();
            this.ratioScale = reg.getCurrentRatioScale();
            if (!Double.isNaN(this.ratioScale) && this.getSizeMode() == 1) {
                this.setCenterSize(rect.getCenterX(), rect.getCenterY(), this.ratioScale);
            } else {
                this.setSizeMode(0);
                this.setCenterSize(rect.getMinX() + rect.getWidth() / 2.0, rect.getMinY() + rect.getHeight() / 2.0, rect.getHeight());
            }
        } else {
            this.clear();
        }
    }

    public void clear() {
        this.dataHeight = Double.NaN;
        this.ratioScale = Double.NaN;
        this.setCenterSize(Double.NaN, Double.NaN, Double.NaN);
        this.updateUIStatus();
    }

    public double[] getCenterSize() {
        String v = this.jTextField_size.getText();
        if (v == null || v.length() == 0) {
            return null;
        }
        v = this.jTextField_cx.getText();
        if (v == null || v.length() == 0) {
            return null;
        }
        v = this.jTextField_cy.getText();
        if (v == null || v.length() == 0) {
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        double s = 0.0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(6);
        try {
            x = nf.parse(this.jTextField_cx.getText()).doubleValue();
            y = nf.parse(this.jTextField_cy.getText()).doubleValue();
            s = nf.parse(this.jTextField_size.getText()).doubleValue();
        }
        catch (Exception ex) {
            return null;
        }
        return new double[]{x, y, s};
    }

    public void setCenterSize(double x, double y, double size) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        String v = "";
        int columns = 3;
        if (!Double.isNaN(x)) {
            v = nf.format(x);
            columns = 0;
        }
        this.jTextField_cx.setColumns(columns);
        this.jTextField_cx.setText(v);
        v = "";
        columns = 3;
        if (!Double.isNaN(y)) {
            v = nf.format(y);
            columns = 0;
        }
        this.jTextField_cy.setColumns(columns);
        this.jTextField_cy.setText(v);
        v = "";
        columns = 3;
        if (!Double.isNaN(size)) {
            v = this.getSizeMode() == 0 ? nf.format(size) : nf.format((long)Math.rint(size));
            columns = 0;
        }
        this.jTextField_size.setColumns(columns);
        this.jTextField_size.setText(v);
        this.updateUIStatus();
        this.validate();
    }

    public String getCenterX() {
        return this.jTextField_cx.getText();
    }

    public String getCenterY() {
        return this.jTextField_cy.getText();
    }

    public String getViewSize() {
        return this.jTextField_size.getText();
    }

    public int getSizeMode() {
        return this.jComboBox_size.getSelectedIndex();
    }

    public void setSizeMode(int index) {
        if (index < 0 || index > 1) {
            return;
        }
        this.jComboBox_size.setSelectedIndex(index);
        this.updateSizeTooltip();
    }

    public double getDataHeight() {
        return this.dataHeight;
    }

    public void setDataHeight(double height) {
        this.dataHeight = height;
    }

    public double getRatioScale() {
        return this.ratioScale;
    }

    public void setRatioScale(double scale) {
        this.ratioScale = scale;
    }

    private void jComboBox_size_actionPerformed(ActionEvent e) {
        double[] xys = this.getCenterSize();
        double x = Double.NaN;
        double y = Double.NaN;
        if (xys != null) {
            x = xys[0];
            y = xys[1];
        }
        this.setCenterSize(x, y, this.getSizeMode() == 0 ? this.dataHeight : this.ratioScale);
        this.updateSizeTooltip();
    }

    private void updateSizeTooltip() {
        if (this.getSizeMode() == 0) {
            this.jTextField_size.setToolTipText(MessagesBundle.getMessage("Tooltip_mapsize_in_data_height"));
        } else {
            this.jTextField_size.setToolTipText(MessagesBundle.getMessage("Tooltip_mapsize_in_scale"));
        }
    }

    private void setAllEnabled(boolean status) {
        this.jLabel1.setEnabled(status);
        this.jTextField_cx.setEnabled(status);
        this.jLabel2.setEnabled(status);
        this.jTextField_cy.setEnabled(status);
        this.jComboBox_size.setEnabled(status);
        this.jTextField_size.setEnabled(status);
    }

    public void updateUIStatus() {
        this.setAllEnabled(true);
    }
}

