/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapUndoManager;
import oracle.maps.tools.Tool;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.help.MapEditorHelp;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.MapCoveragePanel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class MapActionsToolBar
extends JToolBar
implements ChangeListener,
EditChangeListener {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    protected MainAppPanel mainApp = null;
    protected MapCanvas canvas = null;
    protected MapEditorHelp help = new MapEditorHelp();
    public JButton refresh = new JButton(Icons.getIcon("refresh.png"));
    public JButton stop = new JButton(Icons.getIcon("stop.png"));
    public JButton save = new JButton(Icons.getIcon("filesave.png"));
    public JButton saveall = new JButton(Icons.getIcon("saveall.png"));
    public JButton undo = new JButton(Icons.getIcon("undo.png"));
    public JButton redo = new JButton(Icons.getIcon("redo_ena.png"));
    public JButton helpButton = new JButton(Icons.getIcon("help_17.png"));
    public JToggleButton identify = new JToggleButton(Icons.getIcon("identify.gif"));
    public JButton clearcachedgeom = new JButton(Icons.getIcon("clear.png"));
    public JButton preferences = new JButton(Icons.getIcon("view.png"));
    protected MapCoveragePanel coverPane = null;
    protected AbstractButton[] buttons = new AbstractButton[]{this.refresh, this.stop, this.save, this.saveall, this.undo, this.redo, this.helpButton, this.identify, this.clearcachedgeom, this.preferences};
    protected ButtonGroup buttonGroup = new ButtonGroup();

    public MapActionsToolBar(MapCanvas canvas, MainAppPanel mainApp) {
        this.canvas = canvas;
        this.mainApp = mainApp;
        this.coverPane = new MapCoveragePanel();
        HelpUtils.setDefaultHelpProvider((HelpProvider)this.help.getHelpProvider());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setRollover(true);
        this.refresh.setToolTipText(MessagesBundle.getMessage("Tooltip_refresh_map"));
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapActionsToolBar.this.canvas == null) {
                    return;
                }
                double[] xys = MapActionsToolBar.this.coverPane.getCenterSize();
                if (xys == null) {
                    return;
                }
                if (MapActionsToolBar.this.coverPane.getSizeMode() == 0) {
                    MapActionsToolBar.this.canvas.getMapRegion().setDataWindowByHeight(xys[0], xys[1], xys[2]);
                } else {
                    try {
                        MapActionsToolBar.this.canvas.getMapRegion().setDataWindowByScale(xys[0], xys[1], xys[2]);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                        return;
                    }
                }
            }
        });
        this.stop.setToolTipText(MessagesBundle.getMessage("Tooltip_stop_map_action"));
        this.save.setToolTipText(MessagesBundle.getMessage("Tooltip_save_edited_data"));
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Void, Void> w = new SwingWorker<Void, Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        if (MapActionsToolBar.this.canvas == null) {
                            return null;
                        }
                        Layer tool = MapActionsToolBar.this.canvas.getLayerManager().getLayerByTag("toolLayer");
                        if (tool instanceof Tool && ((Tool)tool).isInAction()) {
                            JOptionPane.showMessageDialog(MapActionsToolBar.this.canvas.getFrameForDialog(), "Cannot save while digitizing lines or polygons. End digitizing first.", "Warning", 2);
                            return null;
                        }
                        Layer l = MapActionsToolBar.this.canvas.getLayerManager().getLayerByTag("targetLayer");
                        if (!(l instanceof EditableLayer)) {
                            return null;
                        }
                        this.getPropertyChangeSupport().firePropertyChange("progressIndeterminate", null, (Object)true);
                        this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getMessage("Progressbar_savingdata"));
                        EditableLayer layer = (EditableLayer)l;
                        if (layer.isModified() && layer.save()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MapActionsToolBar.this.save.setEnabled(false);
                                }
                            });
                            log.info("Layer [" + layer.getName() + "] saved.");
                            Iterator<Layer> iterator = MapActionsToolBar.this.canvas.getLayerManager().iterator();
                            boolean allSaved = true;
                            while (iterator.hasNext()) {
                                Layer le = iterator.next();
                                if (!(le instanceof EditableLayer) || !((EditableLayer)le).isModified()) continue;
                                allSaved = false;
                                break;
                            }
                            if (allSaved) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MapActionsToolBar.this.saveall.setEnabled(false);
                                    }
                                });
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MapActionsToolBar.this.saveall.setEnabled(true);
                                    }
                                });
                            }
                        }
                        return null;
                    }
                };
                if (MapActionsToolBar.this.canvas != null) {
                    w.addPropertyChangeListener(MapActionsToolBar.this.canvas);
                    w.execute();
                }
            }
        });
        this.saveall.setToolTipText(MessagesBundle.getMessage("Tooltip_saveall_edited_data"));
        this.saveall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Void, Void> w = new SwingWorker<Void, Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        if (MapActionsToolBar.this.canvas == null) {
                            return null;
                        }
                        Layer tool = MapActionsToolBar.this.canvas.getLayerManager().getLayerByTag("toolLayer");
                        if (tool instanceof Tool && ((Tool)tool).isInAction()) {
                            JOptionPane.showMessageDialog(MapActionsToolBar.this.canvas.getFrameForDialog(), "Cannot save while digitizing lines or polygons. End digitizing first.", "Warning", 2);
                            return null;
                        }
                        this.getPropertyChangeSupport().firePropertyChange("progressIndeterminate", null, (Object)true);
                        this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getMessage("Progressbar_savingdata"));
                        Iterator<Layer> iterator = MapActionsToolBar.this.canvas.getLayerManager().iterator();
                        boolean savedAll = true;
                        while (iterator.hasNext()) {
                            Layer l = iterator.next();
                            if (!(l instanceof EditableLayer) || !((EditableLayer)l).isModified()) continue;
                            if (!((EditableLayer)l).save()) {
                                savedAll = false;
                                log.info("Unable to save Layer [" + l.getName() + "].");
                                continue;
                            }
                            log.info("Layer [" + l.getName() + "] saved.");
                        }
                        if (savedAll) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MapActionsToolBar.this.saveall.setEnabled(false);
                                    MapActionsToolBar.this.save.setEnabled(false);
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MapActionsToolBar.this.saveall.setEnabled(true);
                                    Layer l = MapActionsToolBar.this.canvas.getLayerManager().getLayerByTag("targetLayer");
                                    if (!(l instanceof EditableLayer)) {
                                        return;
                                    }
                                    EditableLayer layer = (EditableLayer)l;
                                    if (layer.isModified()) {
                                        MapActionsToolBar.this.save.setEnabled(true);
                                    }
                                }
                            });
                        }
                        return null;
                    }
                };
                if (MapActionsToolBar.this.canvas != null) {
                    w.addPropertyChangeListener(MapActionsToolBar.this.canvas);
                    w.execute();
                }
            }
        });
        this.undo.setToolTipText(MessagesBundle.getMessage("Tooltip_undo_last_action"));
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapActionsToolBar.this.canvas == null) {
                    return;
                }
                try {
                    MapActionsToolBar.this.canvas.getUndoManager().undo();
                }
                catch (CannotUndoException ex) {
                    ErrorDialog.showErrorDialog(ex, MapActionsToolBar.this, "Couldn't perform undo", "Error", 2);
                }
            }
        });
        this.redo.setToolTipText(MessagesBundle.getMessage("Tooltip_redo_last_action"));
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapActionsToolBar.this.canvas == null) {
                    return;
                }
                try {
                    MapActionsToolBar.this.canvas.getUndoManager().redo();
                }
                catch (CannotRedoException ex) {
                    ErrorDialog.showErrorDialog(ex, MapActionsToolBar.this, "Couldn't perform redo", "Error", 2);
                }
            }
        });
        this.helpButton.setToolTipText(MessagesBundle.getMessage("Tooltip_help"));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapActionsToolBar.this.help.showContent();
                MapActionsToolBar.this.help.showTopic("introduction");
            }
        });
        this.identify.setToolTipText(MessagesBundle.getMessage("Tooltip_identify_data_features"));
        this.clearcachedgeom.setToolTipText(MessagesBundle.getMessage("Tooltip_clear_cached_geometries"));
        this.preferences.setToolTipText(MessagesBundle.getMessage("Tooltip_display_preferences"));
        this.preferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        int gridX = 0;
        this.add((Component)this.save, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.saveall, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.undo, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.redo, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.helpButton, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.coverPane, new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.refresh, new GridBagConstraints(gridX++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setMapButtonsEnabled(boolean v) {
        this.identify.setEnabled(v);
        this.clearcachedgeom.setEnabled(v);
    }

    public void clearMapToggleButtons() {
        this.identify.setSelected(false);
    }

    public MapCoveragePanel getCoveragePane() {
        return this.coverPane;
    }

    public void setButtonsEnabled(boolean flag) {
        for (AbstractButton btn : this.buttons) {
            btn.setEnabled(flag);
        }
    }

    public void updateButtonStatus() {
        this.getCoveragePane().updateUIStatus();
        this.setButtonsEnabled(false);
        this.helpButton.setEnabled(true);
        if (this.canvas == null) {
            return;
        }
        this.preferences.setEnabled(true);
        this.refresh.setEnabled(true);
        MapUndoManager um = this.canvas.getUndoManager();
        this.undo.setToolTipText(um.getUndoPresentationName());
        this.undo.setEnabled(um.canUndo());
        this.redo.setToolTipText(um.getRedoPresentationName());
        this.redo.setEnabled(um.canRedo());
        Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        if (targetLayer instanceof EditableLayer) {
            this.save.setEnabled(((EditableLayer)targetLayer).isModified());
        }
        for (Layer l : this.canvas.getLayerManager()) {
            if (!(l instanceof EditableLayer) || !((EditableLayer)l).isModified()) continue;
            this.saveall.setEnabled(true);
            break;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateButtonStatus();
    }

    @Override
    public void editStateChanged(ChangeEvent e) {
        this.updateButtonStatus();
    }

    public void setCanvas(MapCanvas canvas) {
        this.canvas = canvas;
        Object src = this;
        if (canvas != null) {
            src = canvas.getMapRegion();
        }
        this.coverPane.stateChanged(new ChangeEvent(src));
    }
}

