/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.UIManager;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class LookAndFeelHelper {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);

    public static void setupLookAndFeel() {
        ArrayList<LaFDefaults> lafs = new ArrayList<LaFDefaults>(5);
        LaFDefaults ld = new LaFDefaults("Nimbus", true);
        ld.put("ToolBar.handleIcon", null);
        ld.put("Button[Enabled].backgroundPainter", null);
        ld.put("Button.contentMargins", new Insets(5, 5, 5, 5));
        ld.put("ToggleButton.contentMargins", new Insets(5, 5, 5, 5));
        ld.put("Tree.drawHorizontalLines", true);
        ld.put("Tree.drawVerticalLines", true);
        lafs.add(ld);
        ld = new LaFDefaults("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        ld.put("Button.margin", new Insets(1, 1, 1, 1));
        ld.put("ToggleButton.margin", new Insets(1, 1, 1, 1));
        lafs.add(ld);
        ld = new LaFDefaults("oracle.bali.ewt.olaf2.OracleLookAndFeel");
        lafs.add(ld);
        ld = new LaFDefaults(UIManager.getSystemLookAndFeelClassName());
        lafs.add(ld);
        for (LaFDefaults laf : lafs) {
            try {
                if (laf.isFindIt()) {
                    boolean found = false;
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!info.getName().equals(laf.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        found = true;
                        break;
                    }
                    if (!found) {
                        continue;
                    }
                } else {
                    UIManager.setLookAndFeel(laf.getName());
                }
                HashMap defaults = laf.getDefaults();
                for (Object key : defaults.keySet()) {
                    UIManager.getLookAndFeelDefaults().put(key, defaults.get(key));
                }
                log.info(MessagesBundle.getFormattedMessage("Look_and_feel_set", UIManager.getLookAndFeel().getName()));
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class LaFDefaults {
        private boolean findIt = false;
        private String name;
        private HashMap defaults;

        public LaFDefaults(String name) {
            this(name, false);
        }

        public LaFDefaults(String name, boolean findIt) {
            this.findIt = findIt;
            this.name = name;
            this.defaults = new HashMap();
        }

        public Object put(Object k, Object v) {
            return this.defaults.put(k, v);
        }

        public String getName() {
            return this.name;
        }

        public HashMap getDefaults() {
            return this.defaults;
        }

        public boolean isFindIt() {
            return this.findIt;
        }
    }
}

