/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.mdeditor.ui.OlafDialog;
import oracle.spatial.edit.model.MDSException;

public class ErrorDialog {
    public static Frame getFrameForDialog(Container c) {
        while (c != null) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static void showErrorDialog(Throwable exception, Container parent, String message, String title, int messageType) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int gridY = 0;
        panel.add((Component)new JLabel(message), new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (exception != null) {
            String code;
            exception.printStackTrace();
            String codeStr = "";
            if (exception instanceof MDSException && (code = ((MDSException)exception).getCode()) != null) {
                codeStr = code + ": ";
            }
            codeStr = codeStr + exception.getMessage();
            JLabel codeLBL = new JLabel(codeStr);
            codeLBL.setToolTipText(codeStr);
            panel.add((Component)codeLBL, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            String detailsStr = null;
            if (exception instanceof MDSException) {
                String details = ((MDSException)exception).getDetails();
                if (details != null) {
                    detailsStr = details;
                }
            } else {
                StringWriter result = new StringWriter();
                PrintWriter pw = new PrintWriter(result);
                exception.printStackTrace(pw);
                detailsStr = ((Object)result).toString();
            }
            if (detailsStr != null) {
                JTextArea ta = new JTextArea(10, 40);
                ta.setText(detailsStr);
                ta.setEditable(false);
                ta.setCaretPosition(0);
                JScrollPane scrlPanel = new JScrollPane(ta);
                scrlPanel.setVerticalScrollBarPolicy(20);
                scrlPanel.setHorizontalScrollBarPolicy(30);
                panel.add((Component)new JLabel("Details:"), new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
                panel.add((Component)scrlPanel, new GridBagConstraints(0, gridY++, 1, 5, 1.0, 1.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        OlafDialog errorDlg = new OlafDialog(ErrorDialog.getFrameForDialog(parent), title, panel);
        errorDlg.setAsCloseSelection(true);
        errorDlg.setSize(500, 280);
        errorDlg.setVisible(true);
        errorDlg.dispose();
    }
}

