/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import oracle.maps.resources.icons.IconLoader;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.CollapsibleDockFrame;

public class CollapsiblePanel
extends JPanel
implements PropertyChangeListener {
    private boolean collapsible = true;
    private boolean undockable = true;
    private boolean expanded = false;
    private String title = null;
    private HeaderPanel headerPanel = null;
    private Container contentPanel = null;
    private JPanel spacer = new JPanel();
    private static ImageIcon openIcon = IconLoader.getIcon("arrow_right.png");
    private static ImageIcon closeIcon = IconLoader.getIcon("arrow_down.png");
    private static Color headerFontColor = Color.decode("0x333333");
    private Floater floater = new Floater();

    public CollapsiblePanel() {
        this(null, null);
    }

    public CollapsiblePanel(String title) {
        this(title, null);
    }

    public CollapsiblePanel(Component contentPane) {
        this(null, contentPane);
    }

    public CollapsiblePanel(String title, Component content) {
        this.title = title;
        this.headerPanel = new HeaderPanel();
        if (content instanceof Container) {
            this.contentPanel = (Container)content;
        } else {
            this.contentPanel = new JPanel();
            this.contentPanel.add(content);
        }
        this.contentPanel.addPropertyChangeListener(this);
        this.spacer.setPreferredSize(new Dimension(0, 0));
        super.setLayout(new GridBagLayout());
        super.addImpl(this.headerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0), -1);
        super.addImpl(this.contentPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0), -1);
        super.addImpl(this.spacer, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0), -1);
        this.contentPanel.setVisible(this.expanded);
        this.spacer.setVisible(!this.expanded);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp.equals(this.getContentPane())) {
            return;
        }
        this.getContentPane().add(comp, constraints, index);
    }

    @Override
    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.getContentPane() == null) {
            super.setLayout(mgr);
        } else {
            this.getContentPane().setLayout(mgr);
        }
    }

    @Override
    public LayoutManager getLayout() {
        return this.getContentPane().getLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equalsIgnoreCase("name")) {
            this.headerPanel.repaint();
            this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    }

    public Container getContentPane() {
        return this.contentPanel;
    }

    public JPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public CollapsibleDockFrame getDockFrame() {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof CollapsibleDockFrame); p = p.getParent()) {
        }
        return (CollapsibleDockFrame)p;
    }

    public void toggleExpanded() {
        this.setExpanded(!this.isExpanded());
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean flag) {
        if (this.isCollapsible() && flag != this.expanded) {
            this.expanded = flag;
            this.contentPanel.setVisible(flag);
            this.spacer.setVisible(!flag);
            this.validate();
            this.firePropertyChange("expanded", !flag, flag);
        }
    }

    @Override
    public String getName() {
        String name = "";
        if (this.title != null) {
            name = this.title;
        } else if (this.contentPanel != null && this.contentPanel.getName() != null) {
            name = this.contentPanel.getName();
        }
        return name;
    }

    public void setUndockable(boolean undockable) {
        this.undockable = undockable;
    }

    public boolean isUndockable() {
        return this.undockable;
    }

    public void setCollapsible(boolean collapsable) {
        this.collapsible = collapsable;
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public Floater getFloater() {
        return this.floater;
    }

    public static CollapsiblePanel getCollapsiblePanelParent(Component c) {
        Container p;
        for (p = c.getParent(); p != null && !(p instanceof CollapsiblePanel); p = p.getParent()) {
        }
        return (CollapsiblePanel)p;
    }

    public class Floater
    extends JComponent {
        private MyPopup popup = null;
        private BufferedImage img = null;

        public void prepare() {
            Dimension d = CollapsiblePanel.this.getSize();
            this.img = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
            CollapsiblePanel.this.paintAll(this.img.createGraphics());
            this.popup = new MyPopup(CollapsiblePanel.this, this, 0, 0);
            this.setPreferredSize(d);
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            this.popup.setVisible(aFlag);
        }

        @Override
        public void setLocation(int x, int y) {
            this.popup.reset(CollapsiblePanel.this, this, x, y);
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.img, this.getX(), this.getY(), null);
        }

        private class MyPopup {
            private Component component;

            public MyPopup(Component owner, Component contents, int x, int y) {
                this();
                if (contents == null) {
                    throw new IllegalArgumentException("Contents must be non-null");
                }
                this.reset(owner, contents, x, y);
            }

            public MyPopup() {
            }

            public void setVisible(boolean aFlag) {
                Component component = this.getComponent();
                if (component != null) {
                    component.setVisible(aFlag);
                    if (component instanceof JWindow) {
                        ((JWindow)component).getContentPane().removeAll();
                    }
                    if (!aFlag) {
                        this.dispose();
                    }
                }
            }

            public void dispose() {
                Component component = this.getComponent();
                Window window = SwingUtilities.getWindowAncestor(component);
                if (component instanceof JWindow) {
                    ((Window)component).dispose();
                    component = null;
                }
                if (window instanceof DefaultFrame) {
                    window.dispose();
                }
            }

            public void reset(Component owner, Component contents, int ownerX, int ownerY) {
                Component c;
                if (this.getComponent() == null) {
                    this.component = this.createComponent(owner);
                }
                if ((c = this.getComponent()) instanceof JWindow) {
                    JWindow component = (JWindow)this.getComponent();
                    component.setLocation(ownerX, ownerY);
                    component.getContentPane().add(contents, "Center");
                    contents.invalidate();
                    if (component.isVisible()) {
                        this.pack();
                    }
                }
            }

            public void pack() {
                Component component = this.getComponent();
                if (component instanceof Window) {
                    ((Window)component).pack();
                }
            }

            private Window getParentWindow(Component owner) {
                Window window = null;
                if (owner instanceof Window) {
                    window = (Window)owner;
                } else if (owner != null) {
                    window = SwingUtilities.getWindowAncestor(owner);
                }
                if (window == null) {
                    window = new DefaultFrame();
                }
                return window;
            }

            public Component createComponent(Component owner) {
                if (GraphicsEnvironment.isHeadless()) {
                    return null;
                }
                return new HeavyWeightWindow(this.getParentWindow(owner));
            }

            public Component getComponent() {
                return this.component;
            }

            private class DefaultFrame
            extends Frame {
                private DefaultFrame() {
                }
            }

            private class HeavyWeightWindow
            extends JWindow {
                HeavyWeightWindow(Window parent) {
                    super(parent);
                    this.setFocusableWindowState(false);
                    this.setName("###overrideRedirect###");
                    try {
                        this.setAlwaysOnTop(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }

                @Override
                public void update(Graphics g) {
                    this.paint(g);
                }

                @Override
                public void show() {
                    this.pack();
                    super.show();
                }
            }
        }
    }

    private class HeaderMouseAdapter
    extends MouseAdapter {
        private boolean dragging = false;

        private HeaderMouseAdapter() {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem mi = new JMenuItem((CollapsiblePanel.this.isExpanded() ? "Collapse" : "Expand") + " panel");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CollapsiblePanel.this.toggleExpanded();
                    }
                });
                menu.add(mi);
                CollapsibleDockFrame df = CollapsiblePanel.this.getDockFrame();
                if (df != null) {
                    mi = new JMenuItem("Use extra space");
                    GridBagConstraints gbc = ((GridBagLayout)df.getLayout()).getConstraints(CollapsiblePanel.this);
                    mi.setIcon(Icons.getIcon(gbc.weighty > 0.0 ? "check.png" : "checkbox.gif"));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GridBagLayout gbl = (GridBagLayout)CollapsiblePanel.this.getDockFrame().getLayout();
                            GridBagConstraints gbc = gbl.getConstraints(CollapsiblePanel.this);
                            double oldVal = gbc.weighty;
                            gbc.weighty = gbc.weighty > 0.0 ? 0.0 : 1.0;
                            gbl.setConstraints(CollapsiblePanel.this, gbc);
                            gbl.invalidateLayout(CollapsiblePanel.this.getDockFrame());
                            CollapsiblePanel.this.getDockFrame().repaint();
                            CollapsiblePanel.this.firePropertyChange("weightY", oldVal, gbc.weighty);
                        }
                    });
                    menu.add(mi);
                }
                menu.show(CollapsiblePanel.this, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                CollapsiblePanel.this.toggleExpanded();
            }
            this.maybeShowPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
            if (this.dragging) {
                this.dragging = false;
                CollapsiblePanel cp = CollapsiblePanel.this;
                CollapsibleDockFrame src = cp.getDockFrame();
                if (src != null) {
                    src.moveComponent(cp, e.getLocationOnScreen());
                }
                cp.getFloater().setVisible(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (CollapsiblePanel.this.isUndockable()) {
                CollapsiblePanel cp = CollapsiblePanel.this;
                if (!this.dragging) {
                    this.dragging = true;
                    cp.getFloater().prepare();
                    cp.getFloater().setVisible(true);
                }
                Point p = e.getLocationOnScreen();
                cp.getFloater().setLocation((int)p.getX() + 10, (int)p.getY() + 10);
            }
        }
    }

    private class HeaderPanel
    extends JPanel {
        private Font font = new Font("Tahoma", 1, 12);
        private final int OFFSET = 20;
        private final int PAD = 2;

        public HeaderPanel() {
            Dimension d = new Dimension(0, 20);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            HeaderMouseAdapter ma = new HeaderMouseAdapter();
            this.addMouseListener(ma);
            this.addMouseMotionListener(ma);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int h = 16;
            GradientPaint paint = new GradientPaint(new Point2D.Double((double)this.getWidth() / 2.0, 0.0), Color.lightGray, new Point2D.Double((double)this.getWidth() / 2.0, this.getHeight()), Color.white);
            g2.setPaint(paint);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            Image img = CollapsiblePanel.this.isExpanded() ? closeIcon.getImage() : openIcon.getImage();
            g2.drawImage(img, 2, 2, h, h, this);
            g2.setFont(this.font);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontRenderContext frc = g2.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics(CollapsiblePanel.this.getName(), frc);
            float height = lm.getAscent() + lm.getDescent();
            float x = 20.0f;
            float y = ((float)h + height) / 2.0f - lm.getDescent();
            g.setColor(headerFontColor);
            g2.drawString(CollapsiblePanel.this.getName(), x, y);
        }
    }
}

