/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.mdeditor.ui.CollapsiblePanel;

public class CollapsibleDockFrame
extends JInternalFrame
implements PropertyChangeListener {
    private boolean acceptingDrops = true;
    private boolean autoTitle = false;
    private JPanel contentPane = new JPanel(new GridBagLayout());
    private JScrollPane scrollPane = new JScrollPane(this.contentPane);
    private JPanel spacer = new JPanel();

    public CollapsibleDockFrame() {
        this(null, true, true, true, true);
    }

    public CollapsibleDockFrame(String title) {
        this(title, true, true, true, true);
    }

    public CollapsibleDockFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        JInternalFrame.JDesktopIcon icon = this.getDesktopIcon();
        for (MouseMotionListener mouseMotionListener : icon.getMouseMotionListeners()) {
            icon.removeMouseMotionListener(mouseMotionListener);
        }
        for (EventListener eventListener : icon.getMouseListeners()) {
            icon.removeMouseListener((MouseListener)eventListener);
        }
        icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    CollapsibleDockFrame.this.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CollapsibleDockFrame.this.isIcon()) {
                    try {
                        CollapsibleDockFrame.this.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        });
        if (title == null) {
            this.autoTitle = true;
        }
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        super.getContentPane().add(this.scrollPane);
        this.spacer.setPreferredSize(new Dimension(0, 0));
        this.setVisible(true);
    }

    @Override
    public Container getContentPane() {
        return this.contentPane;
    }

    private boolean hasNonZeroWeightY() {
        GridBagLayout layout = (GridBagLayout)this.getContentPane().getLayout();
        for (Component c : this.getContentPane().getComponents()) {
            GridBagConstraints gbc = layout.getConstraints(c);
            if (!(gbc.weighty > 0.0)) continue;
            return true;
        }
        return false;
    }

    private int maxGridY() {
        int maxGridY = Integer.MIN_VALUE;
        GridBagLayout layout = (GridBagLayout)this.getContentPane().getLayout();
        for (Component c : this.getContentPane().getComponents()) {
            GridBagConstraints gbc = layout.getConstraints(c);
            if (maxGridY >= gbc.gridy) continue;
            maxGridY = gbc.gridy;
        }
        return maxGridY;
    }

    public boolean canUndock() {
        if (this.getContentPane().getComponentCount() == 2) {
            Component c = this.getContentPane().getComponent(0);
            if (c instanceof CollapsiblePanel) {
                return ((CollapsiblePanel)c).isUndockable();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        int y;
        if (this.getContentPane() == null) {
            super.addImpl(comp, constraints, index);
            return;
        }
        GridBagLayout layout = (GridBagLayout)this.getContentPane().getLayout();
        GridBagConstraints newConstraints = null;
        if (constraints instanceof Integer) {
            y = (Integer)constraints;
            newConstraints = new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        } else if (constraints instanceof Point) {
            Point p = (Point)constraints;
            int y2 = (int)layout.location((int)p.getX(), (int)p.getY()).getY();
            newConstraints = new GridBagConstraints(0, y2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        } else if (constraints instanceof GridBagConstraints) {
            newConstraints = (GridBagConstraints)constraints;
        } else if (constraints == null) {
            y = index != -1 ? index : this.maxGridY();
            newConstraints = new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        } else {
            throw new IllegalArgumentException("Constraints must be Integer, Point, GridBagConstraints or null.");
        }
        for (Component c : this.getContentPane().getComponents()) {
            GridBagConstraints gbc = layout.getConstraints(c);
            if (gbc.gridy < newConstraints.gridy) continue;
            ++gbc.gridy;
            layout.setConstraints(c, gbc);
        }
        comp.addPropertyChangeListener(this);
        super.addImpl(comp, newConstraints, -1);
        this.updateSpacer();
        if (this.autoTitle) {
            this.updateTitle();
        }
        this.validate();
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        if (this.getContentPane() != null) {
            comp.removePropertyChangeListener(this);
            if (this.isClosable() && this.getContentPane() != null && this.getContentPane().getComponentCount() == 1 && this.getContentPane().getComponent(0).equals(this.spacer)) {
                try {
                    this.setClosed(true);
                }
                catch (PropertyVetoException ex) {
                    ex.printStackTrace();
                }
            } else {
                if (this.autoTitle) {
                    this.updateTitle();
                }
                this.validate();
            }
        }
    }

    private void updateSpacer() {
        super.remove(this.spacer);
        super.addImpl(this.spacer, new GridBagConstraints(0, this.maxGridY() + 1, 1, 1, 1.0, this.hasNonZeroWeightY() ? 0.0 : 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0), -1);
        this.validate();
    }

    @Override
    public LayoutManager getLayout() {
        if (this.isRootPaneCheckingEnabled()) {
            return this.getContentPane().getLayout();
        }
        return super.getLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.updateSpacer();
        if (this.autoTitle) {
            this.updateTitle();
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.autoTitle = title == null;
    }

    public CollapsibleDockFrame findSiblingOn(Point point) {
        JDesktopPane desktopPane = this.getDesktopPane();
        CollapsibleDockFrame dst = null;
        int minZ = Integer.MAX_VALUE;
        for (Component c : desktopPane.getComponents()) {
            if (this.equals(c) || !(c instanceof CollapsibleDockFrame) || !c.isVisible()) continue;
            Point p = new Point(point);
            SwingUtilities.convertPointFromScreen(p, c);
            if (!c.contains(p) || desktopPane.getComponentZOrder(c) >= minZ) continue;
            dst = (CollapsibleDockFrame)c;
            minZ = desktopPane.getComponentZOrder(c);
        }
        return dst;
    }

    public void moveComponent(Component comp, Point point) {
        if (comp instanceof CollapsiblePanel && !((CollapsiblePanel)comp).isUndockable()) {
            return;
        }
        JDesktopPane desktopPane = this.getDesktopPane();
        boolean newFrame = false;
        Cloneable constraints = null;
        CollapsibleDockFrame dst = this.findSiblingOn(point);
        if (dst == null || !dst.isAcceptingDrops()) {
            Point p = new Point(point);
            SwingUtilities.convertPointFromScreen(p, this);
            if (this.contains(p)) {
                return;
            }
            newFrame = true;
            dst = new CollapsibleDockFrame();
            dst.setMaximizable(false);
            Point dp = new Point(point);
            SwingUtilities.convertPointFromScreen(dp, desktopPane);
            dst.setLocation(dp);
            desktopPane.add(dst);
            constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        } else {
            constraints = new Point(point);
            SwingUtilities.convertPointFromScreen(constraints, dst.getContentPane());
        }
        this.remove(comp);
        this.checkHeaders();
        dst.add(comp, constraints);
        dst.checkHeaders();
        dst.moveToFront();
        if (newFrame) {
            dst.pack();
        }
        desktopPane.repaint();
    }

    public void checkHeaders() {
        int num = this.getContentPane().getComponentCount();
        boolean show = num > 2;
        for (Component c : this.getContentPane().getComponents()) {
            CollapsiblePanel cp;
            if (!(c instanceof CollapsiblePanel) || !(cp = (CollapsiblePanel)c).isUndockable()) continue;
            cp.getHeaderPanel().setVisible(show);
            if (show) continue;
            cp.setExpanded(true);
        }
    }

    private void updateTitle() {
        StringBuilder sb = new StringBuilder("");
        for (Component c : this.contentPane.getComponents()) {
            if (c.getName() == null || c.getName().isEmpty() || c instanceof CollapsiblePanel && !((CollapsiblePanel)c).isExpanded()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(c.getName());
        }
        super.setTitle(sb.toString());
    }

    public void setAcceptingDrops(boolean acceptingDrops) {
        this.acceptingDrops = acceptingDrops;
    }

    public boolean isAcceptingDrops() {
        return this.acceptingDrops;
    }
}

