/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.maps.core.Layer;
import oracle.maps.layer.ServerMapLayer;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.AnnotationTextMetadataAttrsPanel;
import oracle.mdeditor.ui.ListPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.annotationtext.AnnotationTextSet;

public class AnnotationTextMetadataPanel
extends JPanel {
    private static Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPBUILDER);
    private AbstractDataSource dataSource = null;
    private String baseTable = null;
    private String baseColumn = null;
    private String[] tableAttrs = null;
    private AnnotationTextMetadata atextMetadata = null;
    private Layer layer = null;
    private JLabel mbscaleLabel = new JLabel();
    private JTextField mbscaleTxt = new JTextField();
    private JLabel textexpLabel = new JLabel();
    private JTextField textexpTxt = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel textattrLabel = new JLabel();
    private AnnotationTextMetadataAttrsPanel textattrPanel = new AnnotationTextMetadataAttrsPanel(null);
    private JLabel basetableLabel = new JLabel();
    private JLabel basecolumnLabel = new JLabel();
    private JTextField basetableTxt = new JTextField();
    private JTextField basecolumnTxt = new JTextField();
    private JButton updateMetadata = new JButton();
    private JButton tableColumns = new JButton();
    private EventListenerList listenerList = new EventListenerList();

    public AnnotationTextMetadataPanel(AbstractDataSource dsrc, String table, String atextColumn, String[] tableColumns, Layer layer, AnnotationTextMetadata atmeta) {
        this.dataSource = dsrc;
        this.baseTable = table;
        this.baseColumn = atextColumn;
        this.tableAttrs = tableColumns;
        this.layer = layer;
        this.atextMetadata = atmeta;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dsrc != null && table != null && atextColumn != null) {
            this.basetableTxt.setText(table);
            this.basecolumnTxt.setText(atextColumn);
        }
        this.updateFields();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(381, 410));
        this.setPreferredSize(new Dimension(275, 335));
        this.basetableLabel.setText(MessagesBundle.getMessage("Table"));
        this.add((Component)this.basetableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.basetableTxt.setEditable(false);
        this.basecolumnTxt.setEditable(false);
        this.add((Component)this.basetableTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.basecolumnLabel.setText(MessagesBundle.getMessage("Label_annotation_column"));
        this.add((Component)this.basecolumnLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.basecolumnTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.mbscaleLabel.setText(MessagesBundle.getMessage("Label_map_base_scale"));
        this.add((Component)this.mbscaleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.mbscaleTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.textexpLabel.setText(MessagesBundle.getMessage("Label_text_expression"));
        this.add((Component)this.textexpLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.textexpTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.textattrLabel.setText(MessagesBundle.getMessage("Text_attributes"));
        this.add((Component)this.textattrLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.textattrPanel, new GridBagConstraints(0, 5, 3, 2, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.updateMetadata.setText(MessagesBundle.getMessage("Update_metadata"));
        this.updateMetadata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationTextMetadataPanel.this.updateMetadata_actionPerformed(e);
            }
        });
        this.add((Component)this.updateMetadata, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.tableColumns.setText(MessagesBundle.getMessage("Column"));
        if (this.tableAttrs == null || this.tableAttrs.length == 0) {
            this.tableColumns.setEnabled(false);
        } else {
            this.tableColumns.setEnabled(true);
        }
        this.tableColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationTextMetadataPanel.this.tableColumns_actionPerformed(e);
            }
        });
        this.add((Component)this.tableColumns, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setMapBaseScale(double scale) {
        NumberFormat nf = NumberFormat.getInstance();
        if (Double.isNaN(scale) || scale < 1.0) {
            this.mbscaleTxt.setText("");
        } else {
            this.mbscaleTxt.setText(nf.format(scale));
        }
    }

    public double getMapBaseScale() {
        String text = this.mbscaleTxt.getText();
        if (text == null || text.length() == 0) {
            return Double.NaN;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            double scale = nf.parse(text).doubleValue();
            if (scale < 0.0) {
                return Double.NaN;
            }
            return scale;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public String getExpression() {
        return this.textexpTxt.getText();
    }

    public void setExpression(String expr) {
        if (expr == null) {
            this.textexpTxt.setText("");
        } else {
            this.textexpTxt.setText(expr);
        }
    }

    public AnnotationTextMetadataAttrsPanel getMetadataAttributesPanel() {
        return this.textattrPanel;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getBaseColumn() {
        return this.baseColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFields() {
        if (this.dataSource == null || this.baseTable == null || this.baseColumn == null) {
            this.setMapBaseScale(0.0);
            this.setExpression("");
            this.textattrPanel.updateUI(null);
            return;
        }
        if (this.layer != null && this.atextMetadata == null) {
            if (this.layer instanceof ServerMapLayer) {
                AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
                try {
                    da.openConnection();
                    this.atextMetadata = da.loadAnnotationTextMetadata(this.baseTable, this.baseColumn);
                }
                catch (MDSException ex) {
                    this.atextMetadata = null;
                }
                catch (Exception ex) {
                    this.atextMetadata = null;
                }
                finally {
                    try {
                        da.closeConnection();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            } else if (this.layer instanceof AnnotationTextSetLayer) {
                this.atextMetadata = ((AnnotationTextSet)((AnnotationTextSetLayer)this.layer).getIndexedDataSet().getDataSet()).getMetadata();
            }
        }
        if (this.atextMetadata == null) {
            this.setMapBaseScale(0.0);
            this.setExpression("");
            this.textattrPanel.updateUI(null);
        } else {
            this.setMapBaseScale(this.atextMetadata.getMapBaseScale());
            this.setExpression(this.atextMetadata.getTextExpression());
            this.textattrPanel.updateUI(this.atextMetadata.getTextAtttributes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateMetadata_actionPerformed(ActionEvent e) {
        NumberFormat nf = NumberFormat.getInstance();
        if (this.mbscaleTxt.getText().trim().length() > 0) {
            try {
                double scale = nf.parse(this.mbscaleTxt.getText()).doubleValue();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Invalid_scale_value"), MessagesBundle.getMessage("Warning"), 2);
                return false;
            }
        }
        AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
        boolean status = false;
        try {
            da.openConnection();
            status = da.updateAnnotationTextMetadata(this.baseTable, this.baseColumn, this.getMapBaseScale(), this.getExpression(), this.textattrPanel.getCurrentXML());
            if (status && this.atextMetadata != null) {
                this.atextMetadata.setMapBaseScale(this.getMapBaseScale());
                this.atextMetadata.setTextExpression(this.getExpression());
                this.atextMetadata.setTextAttributes(this.textattrPanel.getCurrentXML());
            }
        }
        catch (MDSException ex) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Unable_toupdate_metadata") + " " + ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Unable_toupdate_metadata") + " " + ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        if (status) {
            this.fireStateChanged();
            String message = "Update of annotation text metadata for table " + this.baseTable + " and column " + this.baseColumn + " was successful.";
            System.out.println(message);
        }
        return status;
    }

    private void tableColumns_actionPerformed(ActionEvent e) {
        Object[] items;
        String[] allAttributes = this.tableAttrs;
        if (allAttributes == null) {
            return;
        }
        ArrayList<String> attrs = new ArrayList<String>(allAttributes.length);
        for (String attr : allAttributes) {
            attrs.add(attr);
        }
        ListPanel listPanel = new ListPanel(attrs, "Attributes", 0);
        OlafDialog txtDlg = new OlafDialog(this.getFrameForDialog(), MessagesBundle.getMessage("Select_table_attribute"), listPanel);
        txtDlg.setVisible(true);
        if (!txtDlg.isCancelled() && (items = listPanel.getSelectedItems()) != null && items.length > 0) {
            this.setExpression(items[0].toString());
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    private Frame getFrameForDialog() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }
}

