/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.help;

import java.awt.Component;
import java.net.URL;
import oracle.help.CSHManager;
import oracle.help.Help;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSet;
import oracle.help.navigator.Navigator;

public class MapEditorHelp {
    Help help = new Help(true, false, true);
    HelpSet hs = null;
    CSHManager contextManager = null;

    public MapEditorHelp() {
        URL helpURL = MapEditorHelp.class.getResource("helpfiles/helpset.xml");
        try {
            this.hs = new HelpSet(helpURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Could not open help file!");
        }
        this.contextManager = new CSHManager(this.help);
        if (this.hs != null) {
            this.contextManager.addBook((Book)this.hs, true);
            this.contextManager.setDefaultBook((Book)this.hs);
        }
    }

    public void showContent() {
        Navigator[] navs = this.contextManager.getAllNavigators();
        if (navs != null) {
            this.contextManager.showNavigatorWindow(navs[0]);
        }
    }

    public void showIndex() {
        Navigator[] navs = this.contextManager.getAllNavigators();
        if (navs != null) {
            this.contextManager.showNavigatorWindow(navs[1]);
        }
    }

    public void showSearch() {
        Navigator[] navs = this.contextManager.getAllNavigators();
        if (navs != null) {
            this.contextManager.showNavigatorWindow(navs[2]);
        }
    }

    public void addComponent(Component component, String topic) {
        this.contextManager.addComponent(component, topic, true, false);
    }

    public void removeComponent(Component component) {
        this.contextManager.removeComponent(component);
    }

    public void showTopic(String topic) {
        this.help.showTopic((Book)this.hs, topic);
    }

    public Help getHelpProvider() {
        return this.help;
    }
}

