/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import oracle.mdeditor.MDEAboutBox;
import oracle.mdeditor.MapDataEditor;
import oracle.mdeditor.ui.MainAppPanel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class MDEFrameView
extends FrameView {
    private MainAppPanel mainPanel = null;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public MDEFrameView(SingleFrameApplication app, String[] args) {
        super((Application)app);
        ArrayList<Object> plugins = new ArrayList<Object>();
        if (args != null && args.length > 0 && args[0] != null) {
            try {
                String pluginPath = args[0];
                File pluginFolder = new File(pluginPath);
                if (pluginFolder != null && pluginFolder.isDirectory()) {
                    for (File sub : pluginFolder.listFiles()) {
                        if (!sub.isDirectory()) continue;
                        String mainClass = null;
                        ArrayList<URL> libs = new ArrayList<URL>();
                        for (File lib : sub.listFiles()) {
                            if (!lib.getName().endsWith(".jar")) continue;
                            try {
                                Attributes attr;
                                JarFile jar = new JarFile(lib);
                                if (lib.getName().equals(sub.getName() + ".jar") && ((mainClass = (attr = jar.getManifest().getMainAttributes()).getValue("SDEPlugin-Class")) == null || mainClass.isEmpty())) {
                                    System.err.println(lib.getAbsolutePath() + " is missing \"SDEPlugin-Class\" attribute in MANIFEST file");
                                    break;
                                }
                                libs.add(lib.toURI().toURL());
                            }
                            catch (IOException ex) {
                                System.err.println("File " + lib.getAbsolutePath() + " skipped");
                                ex.printStackTrace();
                            }
                        }
                        if (mainClass != null && !mainClass.isEmpty()) {
                            plugins.add(mainClass);
                            URL[] jars = libs.toArray(new URL[libs.size()]);
                            plugins.add(jars);
                            continue;
                        }
                        System.err.println(sub.getName() + " plugin failed to load.");
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("Plugin loading failed:" + args[0]);
                ex.printStackTrace();
            }
        }
        this.mainPanel = new MainAppPanel(plugins.toArray());
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MDEFrameView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MDEFrameView.this.busyIconIndex = (MDEFrameView.this.busyIconIndex + 1) % MDEFrameView.this.busyIcons.length;
                MDEFrameView.this.statusAnimationLabel.setIcon(MDEFrameView.this.busyIcons[MDEFrameView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!MDEFrameView.this.busyIconTimer.isRunning()) {
                        MDEFrameView.this.statusAnimationLabel.setIcon(MDEFrameView.this.busyIcons[0]);
                        MDEFrameView.this.busyIconIndex = 0;
                        MDEFrameView.this.busyIconTimer.start();
                    }
                    MDEFrameView.this.progressBar.setVisible(true);
                    MDEFrameView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    MDEFrameView.this.busyIconTimer.stop();
                    MDEFrameView.this.statusAnimationLabel.setIcon(MDEFrameView.this.idleIcon);
                    MDEFrameView.this.progressBar.setVisible(false);
                    MDEFrameView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    MDEFrameView.this.statusMessageLabel.setText(text == null ? "" : text);
                    MDEFrameView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    MDEFrameView.this.progressBar.setVisible(true);
                    MDEFrameView.this.progressBar.setIndeterminate(false);
                    MDEFrameView.this.progressBar.setValue(value);
                }
            }
        });
    }

    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MapDataEditor.getApplication().getMainFrame();
            this.aboutBox = new MDEAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MapDataEditor.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.menuBar.setName("menuBar");
        ResourceMap resourceMap = ((MapDataEditor)Application.getInstance(MapDataEditor.class)).getContext().getResourceMap(MDEFrameView.class);
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = ((MapDataEditor)Application.getInstance(MapDataEditor.class)).getContext().getActionMap(MDEFrameView.class, (Object)this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 720, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 550, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
    }
}

