/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

class DynoFloatArray {
    static int delta = 120;
    int capacity;
    int count;
    float[] array;

    public DynoFloatArray(int initCap) {
        if (initCap < 0 || initCap > 10000000) {
            throw new IllegalArgumentException("Illegal capacity.");
        }
        this.array = new float[initCap];
    }

    public void clear() {
        this.count = 0;
    }

    public void add(float v) {
        this.ensureCapacity(this.count + 1);
        this.array[this.count] = v;
        ++this.count;
    }

    public float[] getActualArray() {
        float[] res = new float[this.count];
        System.arraycopy(this.array, 0, res, 0, this.count);
        return res;
    }

    private void ensureCapacity(int cap) {
        if (this.capacity >= cap) {
            return;
        }
        int newCap = (cap / delta + 1) * delta;
        if (newCap > 10000000) {
            throw new IllegalArgumentException("max capacity reached.");
        }
        float[] temp = new float[newCap];
        System.arraycopy(this.array, 0, temp, 0, this.count);
        this.array = temp;
    }
}

