/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.ui.ShapeDrawingLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.tools.RectangleDrawer;
import oracle.maps.util.PropertySupportObject;
import oracle.maps.util.TransformUtils;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.geometry.JGeometry;

public class FeatureRectangleTool
extends BasicTool
implements ShapeDrawingLayer {
    public static JGeometry Rectangle = new JGeometry(0.0, 0.0, 10.0, 10.0, 0);
    public static JGeometry Circle = JGeometry.createCircle((double)5.0, (double)5.0, (double)5.0, (int)0);
    private JGeometry newGeom = Rectangle;
    private RectangleDrawer rectDrawer = new RectangleDrawer(this);
    private Rectangle2D box = null;
    private Point2D cursorPoint = null;
    private Stroke lineBorderStroke = new BasicStroke(2.0f);
    private Stroke vertexBorderStroke = new BasicStroke(2.0f);
    private AnimatedStroke ghostAnimatedStroke = new AnimatedStroke();
    private MainAppPanel mainApp = null;

    public FeatureRectangleTool(MapCanvas canvas) {
        super(canvas);
        Layer l;
        if (canvas != null && (l = canvas.getLayerManager().getLayerByTag("drawingToolsConfigLayer")) != null && l.getProperties() instanceof PropertySupportObject) {
            this.properties = (PropertySupportObject)l.getProperties();
        }
        this.ghostAnimatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.ghostAnimatedStroke.setWidth(3.0f);
    }

    @Override
    public long render(Graphics2D g) {
        long t1 = System.currentTimeMillis();
        AffineTransform at = this.canvas.getMapRegion().getViewportTransform();
        if (this.box != null && this.box.getWidth() > 0.0 && this.box.getHeight() > 0.0) {
            JGeometry geom = null;
            try {
                geom = this.getResizedGeometry();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (geom != null) {
                Shape shp = geom.createShape();
                g.setColor(this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.rubberbandSegmentColor"));
                g.setStroke(this.ghostAnimatedStroke.getStroke());
                g.draw(shp);
                if (!this.newGeom.isCircle()) {
                    PathIterator pi = shp.getPathIterator(null);
                    double[] coords = new double[6];
                    while (!pi.isDone()) {
                        int type = pi.currentSegment(coords);
                        switch (type) {
                            case 1: {
                                this.drawPoint(g, new Point2D.Double(coords[0], coords[1]), false);
                            }
                        }
                        pi.next();
                    }
                }
            }
        } else if (this.cursorPoint != null) {
            Point2D.Double p = new Point2D.Double();
            at.transform(this.cursorPoint, p);
            this.drawPoint(g, p, false);
        }
        return System.currentTimeMillis() - t1;
    }

    private void drawPoint(Graphics2D g, Point2D point, boolean isSnapPoint) {
        if (point == null) {
            return;
        }
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color borderColor = isSnapPoint ? this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.snapBorderColor") : this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointBorderColor");
        g.setColor(borderColor);
        g.setStroke(this.vertexBorderStroke);
        double cx = point.getX();
        double cy = point.getY();
        double w = 8.0;
        double h = 8.0;
        g.drawOval((int)(cx - w * 0.5 - 2.0), (int)(cy - h * 0.5 - 2.0), (int)(w + 4.0), (int)(h + 4.0));
        Color centerColor = isSnapPoint ? this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.snapCenterColor") : this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointCenterColor");
        g.setColor(centerColor);
        g.setStroke(this.lineBorderStroke);
        g.drawLine((int)(cx - 2.5), (int)cy, (int)(cx + 2.5), (int)cy);
        g.drawLine((int)cx, (int)(cy - 2.5), (int)cx, (int)(cy + 2.5));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
    }

    private Color getColorProperty(String property) {
        try {
            Integer i = Integer.decode(this.getProperty(property));
            return new Color(i);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void update(long elapsedTime) {
        this.ghostAnimatedStroke.update(elapsedTime);
    }

    @Override
    public void setShape(Shape shape) {
        this.box = (Rectangle2D)shape;
    }

    @Override
    public void shapeCompleted(MouseEvent e) {
        try {
            AffineTransform invAT = this.canvas.getViewportTransform().createInverse();
            this.box = invAT.createTransformedShape(this.box).getBounds2D();
            this.finish();
            this.box = null;
        }
        catch (NoninvertibleTransformException ex) {
            ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toadd_rectangle"), MessagesBundle.getMessage("Warning"), 2);
        }
    }

    @Override
    public Point2D getSnapPoint(Point2D point) {
        try {
            GeometrySetLayer gl = (GeometrySetLayer)this.canvas.getLayerManager().getLayerByTag("snapLayer");
            AffineTransform at = this.canvas.getViewportTransform();
            Point2D.Double pt = new Point2D.Double();
            at.inverseTransform(point, pt);
            double wcTolerance = TransformUtils.getWCTolerance(pt, 3, at);
            JGeometrySegmentPoint segPt = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPoint(pt, wcTolerance, true, true, true, true);
            at.transform(segPt.getPoint(), pt);
            return pt;
        }
        catch (Exception ex) {
            return point;
        }
    }

    @Override
    public void clear() {
        this.rectDrawer = new RectangleDrawer(this);
        this.box = null;
        this.cursorPoint = null;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        if (evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            switch (id) {
                case 503: {
                    try {
                        this.cursorPoint = new Point2D.Double();
                        this.canvas.getViewportTransform().inverseTransform(e.getPoint(), this.cursorPoint);
                    }
                    catch (NoninvertibleTransformException ex) {
                        this.cursorPoint = null;
                    }
                    break;
                }
                case 505: {
                    this.cursorPoint = null;
                    break;
                }
                case 501: 
                case 506: {
                    if ((e.getModifiersEx() & 0x400) != 1024) break;
                    this.rectDrawer.handleEvent(e);
                    propagate = false;
                    break;
                }
                case 502: {
                    if (e.getButton() != 1) break;
                    this.rectDrawer.handleEvent(e);
                    propagate = false;
                }
            }
        }
        return propagate;
    }

    private void finish() {
        if (this.box != null && this.box.getWidth() != 0.0 && this.box.getHeight() != 0.0) {
            try {
                int sel;
                EditableLayer gl = (EditableLayer)this.canvas.getLayerManager().getLayerByTag("targetLayer");
                boolean newFeature = true;
                List<GeoObject> selected = null;
                if (gl instanceof SelectableLayer) {
                    selected = ((SelectableLayer)((Object)gl)).getSelection();
                }
                if (selected != null && selected.size() > 0 && (sel = JOptionPane.showConfirmDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Question_append_spatial_element"), MessagesBundle.getMessage("Append_spatial_element"), 0)) == 0) {
                    newFeature = false;
                }
                JGeometry geom = this.getResizedGeometry();
                geom.setSRID(gl.getSRID());
                if (newFeature) {
                    gl.newObject(geom, null);
                } else {
                    gl.appendToObject(selected.get(0).getKey().toString(), geom);
                }
            }
            catch (Exception ex) {
                ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toadd_rectangle"), MessagesBundle.getMessage("Warning"), 2);
            }
        }
        this.clear();
    }

    public void setNewGeom(JGeometry newGeom) {
        this.newGeom = newGeom;
    }

    public JGeometry getNewGeom() {
        return this.newGeom;
    }

    public void setMainApp(MainAppPanel mainApp) {
        this.mainApp = mainApp;
    }

    private JGeometry getResizedGeometry() throws Exception {
        JGeometry jc = this.getNewGeom();
        double[] d = jc.getMBR();
        Rectangle2D.Double sh = new Rectangle2D.Double(d[0], d[1], d[2] - d[0], d[3] - d[1]);
        AffineTransform at = new AffineTransform();
        at.setToTranslation(this.box.getCenterX(), this.box.getCenterY());
        at.scale(this.box.getWidth() / ((Rectangle2D)sh).getBounds2D().getWidth(), this.box.getHeight() / ((Rectangle2D)sh).getBounds2D().getHeight());
        at.translate(-((Rectangle2D)sh).getBounds2D().getCenterX(), -((Rectangle2D)sh).getBounds2D().getCenterY());
        return JGeometryUtil.transformGeometry((JGeometry)jc, (AffineTransform)at);
    }
}

