/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.logging.Logger;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.geometry.JGeometry;

public class FeatureElementRemoveTool
extends BasicTool {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    public static String UNKNOWN_ELEMENT = "UNKNWON_ELEMENT";
    public static String FULL_ELEMENT = "FULL_ELEMENT";
    public static String VOID_ELEMENT = "VOID_ELEMENT";
    private GeometrySetLayer targetLayer = null;
    private ActiveFeaturesLayer featureLayer = null;
    private GeoObject activeFeature = null;
    private String elementType = UNKNOWN_ELEMENT;
    private Point lastDrag = null;
    private Point startDrag = new Point();
    private boolean recStarted = false;
    Rectangle2D boxDrag = null;

    public FeatureElementRemoveTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Remove feature element");
    }

    @Override
    public void handleTheEvent(EventObject evt) {
        if (this.elementType.equalsIgnoreCase(UNKNOWN_ELEMENT)) {
            return;
        }
        Layer tg = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        if (tg == null || !(tg instanceof GeometrySetLayer)) {
            return;
        }
        this.targetLayer = (GeometrySetLayer)tg;
        if (this.featureLayer == null) {
            return;
        }
        this.activeFeature = this.featureLayer.getActiveFeature();
        if (evt instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)evt;
            int id = me.getID();
            switch (id) {
                case 500: {
                    this.mouseClicked(me);
                    break;
                }
                case 501: {
                    this.mousePressed(me);
                    break;
                }
                case 506: {
                    this.mouseDragged(me);
                    break;
                }
                case 502: {
                    this.mouseReleased(me);
                }
            }
        }
    }

    protected void mouseClicked(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        int elemIndex = -1;
        int elemType = -1;
        int[] polyvoid = null;
        Point2D.Double center = new Point2D.Double();
        try {
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(evt.getX(), evt.getY()), center);
        }
        catch (Exception ex) {
            return;
        }
        double wcTolerance = TransformUtils.getWCTolerance(center, 3, this.canvas.getViewportTransform());
        GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
        GeometrySetLayer gl = this.targetLayer;
        String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
        String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
        if (this.elementType.equalsIgnoreCase(FULL_ELEMENT)) {
            elemIndex = JGeometryUtil.identifyPointElement((JGeometry)selectedFeature.getSpatialAttribute(), (Point2D)center, (double)wcTolerance);
            if (elemIndex < 0) {
                elemIndex = JGeometryUtil.identifyLineElement((JGeometry)selectedFeature.getSpatialAttribute(), (Point2D)center, (double)wcTolerance);
                if (elemIndex < 0) {
                    elemIndex = JGeometryUtil.identifyPolygonElement((JGeometry)selectedFeature.getSpatialAttribute(), (Point2D)center);
                    if (elemIndex > -1) {
                        elemType = 2;
                    }
                } else {
                    elemType = 1;
                }
            } else {
                elemType = 0;
            }
            if (elemIndex < 0) {
                log.warning("Geometry element not found.");
                return;
            }
            try {
                if (elemType == 0) {
                    gl.removePointElement(key, elemIndex);
                } else if (elemType == 1) {
                    gl.removeLineElement(key, elemIndex);
                } else if (elemType == 2) {
                    gl.removePolygonElement(key, elemIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (this.elementType.equalsIgnoreCase(VOID_ELEMENT)) {
            polyvoid = JGeometryUtil.identifyPolygonElementAndVoidIndex((JGeometry)selectedFeature.getSpatialAttribute(), (Point2D)center);
            if (polyvoid == null || polyvoid.length < 2) {
                log.warning("Polygon element and void not found.");
                return;
            }
            try {
                gl.removeVoidPolygonElement(key, polyvoid[0], polyvoid[1]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            return;
        }
    }

    protected void mousePressed(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null || this.elementType.equalsIgnoreCase(UNKNOWN_ELEMENT)) {
            return;
        }
        if (!this.recStarted) {
            this.startDrag.x = evt.getX();
            this.startDrag.y = evt.getY();
            this.boxDrag = new Rectangle2D.Float(this.startDrag.x, this.startDrag.y, 0.0f, 0.0f);
            this.featureLayer.setDragBox(this.boxDrag);
            this.recStarted = true;
            this.lastDrag = null;
        }
        this.featureLayer.getVertexHandles().clear();
    }

    protected void mouseDragged(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null || this.elementType.equalsIgnoreCase(UNKNOWN_ELEMENT)) {
            return;
        }
        int x = -1;
        int y = -1;
        if (this.recStarted) {
            if (this.lastDrag == null) {
                this.lastDrag = new Point();
            }
            this.lastDrag.x = evt.getX();
            this.lastDrag.y = evt.getY();
            if (this.boxDrag != null) {
                int w = Math.abs(this.lastDrag.x - this.startDrag.x);
                int h = Math.abs(this.lastDrag.y - this.startDrag.y);
                this.boxDrag.setRect(this.lastDrag.x < this.startDrag.x ? (double)this.lastDrag.x : (double)this.startDrag.x, this.lastDrag.y < this.startDrag.y ? (double)this.lastDrag.y : (double)this.startDrag.y, w, h);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mouseReleased(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null || this.elementType.equalsIgnoreCase(UNKNOWN_ELEMENT)) {
            return;
        }
        if (this.recStarted) {
            this.recStarted = false;
            this.boxDrag = null;
            this.featureLayer.setDragBox(this.boxDrag);
            if (this.lastDrag != null && this.lastDrag.x >= 0 && this.lastDrag.y >= 0 && this.startDrag.x != this.lastDrag.x && this.startDrag.y != this.lastDrag.y) {
                Point2D.Double startPT = new Point2D.Double(this.startDrag.x, this.startDrag.y);
                Point2D.Double lastPT = new Point2D.Double(this.lastDrag.x, this.lastDrag.y);
                Point2D.Double sdC = new Point2D.Double();
                Point2D.Double ldC = new Point2D.Double();
                try {
                    this.canvas.getViewportTransform().inverseTransform(lastPT, ldC);
                    this.canvas.getViewportTransform().inverseTransform(startPT, sdC);
                }
                catch (Exception ex) {
                    this.lastDrag = null;
                    this.recStarted = false;
                    return;
                }
                double xmin = Math.min(((Point2D)sdC).getX(), ((Point2D)ldC).getX());
                double xmax = Math.max(((Point2D)sdC).getX(), ((Point2D)ldC).getX());
                double ymin = Math.min(((Point2D)sdC).getY(), ((Point2D)ldC).getY());
                double ymax = Math.max(((Point2D)sdC).getY(), ((Point2D)ldC).getY());
                Rectangle2D.Double searchMbr = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
                GeometrySetLayer gl = this.targetLayer;
                GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                String keyColumn = ((IndexedGeometrySet)gl.getIndexedDataSet()).getGeometrySet().getKeyColumn();
                String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
                this.canvas.getUndoManager().startChangeBlock("remove feature elements");
                try {
                    JGeometry geom;
                    JGeometry[] geomElems;
                    if (this.elementType.equalsIgnoreCase(FULL_ELEMENT)) {
                        JGeometry geom2 = selectedFeature.getSpatialAttribute();
                        int[] indexes = JGeometryUtil.getGeometryElementsWithinBox((JGeometry)geom2, (Rectangle2D)searchMbr);
                        if (indexes != null) {
                            JGeometry change = JGeometryUtil.removeElements((JGeometry)geom2, (int[])indexes);
                            ((IndexedGeometrySet)gl.getIndexedDataSet()).updateSpatialAttribute(key, change);
                        }
                    } else if (this.elementType.equalsIgnoreCase(VOID_ELEMENT) && (geomElems = JGeometryUtil.getElements((JGeometry)(geom = selectedFeature.getSpatialAttribute()))) != null) {
                        if (geomElems.length == 1) {
                            int[] voidElems = this.getVoidElementsWithinBox(geom, searchMbr);
                            if (voidElems != null && voidElems.length > 0) {
                                JGeometry change = this.removeVoidElements(geom, voidElems);
                                ((IndexedGeometrySet)gl.getIndexedDataSet()).updateSpatialAttribute(key, change);
                            }
                        } else {
                            int dim = geom.getDimensions();
                            for (int i = 0; i < geomElems.length; ++i) {
                                int[] voidElems;
                                Rectangle2D.Double rect;
                                double[] mbr;
                                if (geomElems[i].getType() != 3 || (mbr = geomElems[i].getMBR()) == null || !(rect = new Rectangle2D.Double(mbr[0], mbr[1], mbr[dim] - mbr[0], mbr[dim + 1] - mbr[1])).contains(searchMbr) || (voidElems = this.getVoidElementsWithinBox(geomElems[i], searchMbr)) == null || voidElems.length <= 0) continue;
                                JGeometry subchange = this.removeVoidElements(geomElems[i], voidElems);
                                JGeometry change = JGeometryUtil.removePolygon((JGeometry)geom, (int)i);
                                change = JGeometryUtil.addPolygon((JGeometry)change, (JGeometry)subchange);
                                ((IndexedGeometrySet)gl.getIndexedDataSet()).updateSpatialAttribute(key, change);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    log.severe("(FeatureElementRemoveTool:mouseReleased) " + ex.getMessage());
                }
                finally {
                    this.canvas.getUndoManager().endChangeBlock("remove feature elements");
                }
            }
            this.lastDrag = null;
        }
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String type) {
        this.elementType = type == null && !type.equalsIgnoreCase(FULL_ELEMENT) && !type.equalsIgnoreCase(VOID_ELEMENT) ? UNKNOWN_ELEMENT : type.toUpperCase();
    }

    public Layer getActiveFeatureLayer() {
        return this.featureLayer;
    }

    public void setFeatureLayer(ActiveFeaturesLayer featureLayer) {
        this.featureLayer = featureLayer;
    }

    private int[] getVoidElementsWithinBox(JGeometry geom, Rectangle2D mbr) {
        if (geom == null || mbr == null) {
            return null;
        }
        if (geom.getType() != 3) {
            return null;
        }
        double[] geomMbr = geom.getMBR();
        if (geomMbr == null) {
            return null;
        }
        double[] oords = geom.getOrdinatesArray();
        int[] einfo = geom.getElemInfo();
        if (oords == null || einfo == null) {
            return null;
        }
        int dim = geom.getDimensions();
        int numRings = einfo.length / 3;
        if (numRings < 2) {
            return null;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 1; i < numRings; ++i) {
            Rectangle2D.Double embr;
            double[] box;
            JGeometry voidGeom = JGeometryUtil.getVoidBoundaryAsGeometry((JGeometry)geom, (int)i);
            if (voidGeom == null || (box = voidGeom.getMBR()) == null || !mbr.contains(embr = new Rectangle2D.Double(box[0], box[1], box[dim] - box[0], box[dim + 1] - box[1]))) continue;
            indexes.add(new Integer(i));
        }
        if (indexes.size() == 0) {
            return null;
        }
        int[] output = new int[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            output[i] = (Integer)indexes.get(i);
        }
        return output;
    }

    public JGeometry removeVoidElements(JGeometry geom, int[] voidElements) {
        if (geom == null || voidElements == null || voidElements.length == 0) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype != 3) {
            return null;
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return null;
        }
        int dim = geom.getDimensions();
        int numRings = eInfo.length / 3;
        if (numRings < 2) {
            return (JGeometry)geom.clone();
        }
        int startoords = eInfo[0];
        int endoords = eInfo[3];
        int size = endoords - startoords;
        int[] newEinfo = new int[]{1, 1003, eInfo[2]};
        double[] newOords = new double[size];
        for (int i = 0; i < size; ++i) {
            newOords[i] = oords[i + startoords - 1];
        }
        JGeometry outGeom = new JGeometry(dim * 1000 + 3, geom.getSRID(), newEinfo, newOords);
        for (int i = 1; i < numRings; ++i) {
            JGeometry voidElem;
            boolean toRemove = false;
            for (int j = 0; j < voidElements.length; ++j) {
                if (voidElements[j] != i) continue;
                toRemove = true;
                break;
            }
            if (toRemove || (voidElem = JGeometryUtil.getVoidBoundaryAsGeometry((JGeometry)geom, (int)i)) == null || voidElem.getType() != 3) continue;
            outGeom = JGeometryUtil.addVoidPolygon((JGeometry)outGeom, (int)0, (JGeometry)voidElem);
        }
        return outGeom;
    }
}

