/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.TileLayerConfig;
import oracle.maps.layer.BasicLayer;
import oracle.maps.layer.MVImageLayer;
import oracle.maps.layer.ui.ShapeDrawingLayer;
import oracle.maps.tools.RectangleDrawer;
import oracle.mdeditor.resources.icons.Icons;

public class MapNavLayer
extends BasicLayer
implements ShapeDrawingLayer,
ChangeListener,
PropertyChangeListener {
    public static final float BORDER_ALPHA = 1.0f;
    public static final float BKGND_ALPHA = 0.2f;
    public static final float ZOOMBOX_BORDER_ALPHA = 0.4f;
    public static final float ZOOMBOX_BKGND_ALPHA = 0.25f;
    public static final Color ENABLED_BLUE = new Color(57, 76, 107);
    public static final Color MOUSEOVER_BLUE = new Color(24, 77, 216);
    public static final int PAN_DELTA = 100;
    private RectangleDrawer recDrawer = null;
    private Rectangle2D zoomBox;
    private boolean barEnabled = false;
    private SlidingBar slider;
    private boolean sliding = false;
    private int prevSliderPos = -1;
    private ArrayList<SimpleButton> buttons;
    private Shape guiBackground;
    private Shape guiBackgroundShadow;
    private AffineTransform at;

    public MapNavLayer(MapCanvas parent) {
        super(parent);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Map Navigation Layer");
        this.at = new AffineTransform();
        this.at.translate(7.0, 7.0);
        this.buildGUI(null);
    }

    @Override
    public void setCanvas(MapCanvas canvas) {
        if (this.canvas != null) {
            this.canvas.getLayerManager().removePropertyChangeListener("oracle.maps.core.Layer.visible", this);
            this.canvas.getLayerManager().removeChangeListener(this);
        }
        super.setCanvas(canvas);
        if (canvas != null) {
            canvas.getLayerManager().addPropertyChangeListener("oracle.maps.core.Layer.visible", this);
            canvas.getLayerManager().addChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof MVImageLayer && ((MVImageLayer)evt.getSource()).getTileLayerConfig() != null) {
            this.sessionChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.sessionChanged();
    }

    private void sessionChanged() {
        TileLayerConfig tlConfig = this.canvas.getTileLayerConfig();
        if (tlConfig != null && !this.barEnabled) {
            this.barEnabled = true;
            this.buildGUI(tlConfig);
        } else if (tlConfig == null && this.barEnabled) {
            this.barEnabled = false;
            this.buildGUI(null);
        }
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        int zoomId;
        Rectangle2D dataWindow;
        TileLayerConfig tlConfig = this.canvas.getTileLayerConfig();
        if (tlConfig != null && this.barEnabled && (dataWindow = this.canvas.getMapRegion().getDataWindow()) != null && (zoomId = tlConfig.getClosestScaleID(dataWindow, this.canvas.getHeight())) != -1) {
            this.slider.setDiscretePosition(zoomId);
        }
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        if (evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            if (this.recDrawer != null) {
                this.canvas.setCursor(Cursor.getPredefinedCursor(12));
                if (!this.recDrawer.handleEvent(evt)) {
                    return false;
                }
            }
            block8: for (SimpleButton btn : this.buttons) {
                if (btn.getActiveArea().contains(e.getPoint())) {
                    this.canvas.setCursor(Cursor.getPredefinedCursor(12));
                    propagate = false;
                    switch (id) {
                        case 500: {
                            btn.fireMouseClicked(e);
                            continue block8;
                        }
                        case 501: {
                            btn.fireMousePressed(e);
                            continue block8;
                        }
                        case 502: {
                            btn.fireMouseReleased(e);
                            continue block8;
                        }
                        case 503: {
                            if (!btn.isMouseOver()) {
                                btn.fireMouseEntered(e);
                                continue block8;
                            }
                            btn.fireMouseMoved(e);
                            continue block8;
                        }
                        case 506: {
                            btn.fireMouseDragged(e);
                            continue block8;
                        }
                        case 505: {
                            btn.fireMouseExited(e);
                            continue block8;
                        }
                    }
                    propagate = true;
                    continue;
                }
                if (!btn.isMouseOver()) continue;
                btn.fireMouseExited(e);
            }
        }
        return propagate;
    }

    @Override
    public long render(Graphics2D g) {
        long t1 = System.currentTimeMillis();
        int alphaType = 3;
        g = (Graphics2D)g.create();
        g.setStroke(new BasicStroke());
        Object oldAAHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite origComposite = g.getComposite();
        g.setColor(Color.BLACK);
        g.setComposite(AlphaComposite.getInstance(alphaType, 0.3f));
        g.fill(this.guiBackgroundShadow);
        g.setColor(Color.WHITE);
        g.setComposite(AlphaComposite.getInstance(alphaType, 0.2f));
        g.fill(this.guiBackground);
        g.setComposite(AlphaComposite.getInstance(alphaType, 1.0f));
        g.draw(this.guiBackground);
        g.setComposite(origComposite);
        for (SimpleButton btn : this.buttons) {
            btn.paint(g);
        }
        if (this.zoomBox != null) {
            g.setColor(Color.BLUE);
            g.setComposite(AlphaComposite.getInstance(3, 0.25f));
            g.fill(this.zoomBox);
            g.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g.draw(this.zoomBox);
            g.setComposite(origComposite);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    @Override
    public void setShape(Shape zoomBox) {
        this.zoomBox = (Rectangle2D)zoomBox;
    }

    @Override
    public void shapeCompleted(MouseEvent e) {
        if (this.zoomBox != null) {
            this.canvas.getMapRegion().zoomBox(this.zoomBox);
            this.zoomBox = null;
            this.recDrawer = null;
        }
    }

    @Override
    public Point2D getSnapPoint(Point2D point) {
        return point;
    }

    public void setSliderEnabled(boolean enabled) {
        this.barEnabled = enabled;
    }

    public boolean getSliderEnabled() {
        return this.barEnabled;
    }

    public void setNumTicks(int numTicks) {
        this.slider.setNumTicks(numTicks);
    }

    private void buildGUI(TileLayerConfig tlc) {
        int dialX = 3;
        int dialY = 3;
        int dialWidth = 42;
        int dialHeight = 42;
        int buttonWidth = 22;
        int buttonHeight = 20;
        int buttonYStart = dialY + dialHeight + 3;
        int buttonXStart = 3;
        int buttonYPos = buttonYStart;
        this.buttons = new ArrayList(5);
        SimpleButton sB = new PanningDial();
        sB.setActiveArea(this.at.createTransformedShape(new Ellipse2D.Double(dialX, dialY, dialWidth, dialHeight)));
        sB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PanningDial pD = (PanningDial)evt.getSource();
                Rectangle2D bnds = pD.getBounds();
                double angle = Math.atan2((double)evt.getY() - bnds.getCenterY(), (double)evt.getX() - bnds.getCenterX());
                pD.setAngle(angle);
                MapNavLayer.this.canvas.getMapRegion().pan((int)(100.0 * Math.cos(pD.getAngle())), (int)(-100.0 * Math.sin(pD.getAngle())));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PanningDial pD = (PanningDial)evt.getSource();
                pD.setAngle(0.0);
                super.mouseExited(evt);
            }
        });
        sB.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PanningDial pD = (PanningDial)evt.getSource();
                Rectangle2D bnds = pD.getBounds();
                double angle = Math.atan2((double)evt.getY() - bnds.getCenterY(), (double)evt.getX() - bnds.getCenterX());
                pD.setAngle(angle);
            }
        });
        this.buttons.add(sB);
        sB = new SimpleButton();
        sB.setActiveArea(this.at.createTransformedShape(new Rectangle2D.Double(buttonXStart, buttonYPos, buttonWidth, buttonHeight)));
        buttonYPos += buttonHeight + 1;
        sB.setEnabledImage(Icons.getIcon("mapnav/zoombox_ena.png").getImage());
        sB.setMouseOverImage(Icons.getIcon("mapnav/zoombox_ovr.png").getImage());
        sB.setMouseDownImage(Icons.getIcon("mapnav/zoombox_dwn.png").getImage());
        sB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MapNavLayer.this.recDrawer = new RectangleDrawer(MapNavLayer.this);
            }
        });
        this.buttons.add(sB);
        sB = new SimpleButton();
        sB.setActiveArea(this.at.createTransformedShape(new Rectangle2D.Double(buttonXStart, buttonYPos, buttonWidth, buttonHeight)));
        buttonYPos += buttonHeight + 1;
        sB.setEnabledImage(Icons.getIcon("mapnav/zoomin_ena.png").getImage());
        sB.setMouseOverImage(Icons.getIcon("mapnav/zoomin_ovr.png").getImage());
        sB.setMouseDownImage(Icons.getIcon("mapnav/zoomin_dwn.png").getImage());
        sB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MapNavLayer.this.canvas.getMapRegion().zoomIn();
            }
        });
        this.buttons.add(sB);
        int barSize = 0;
        if (this.barEnabled && tlc != null) {
            barSize = tlc.getZoomLevelCount() + (tlc.getZoomLevelCount() + 1) * 5;
            sB = new SlidingBar();
            sB.setActiveArea(this.at.createTransformedShape(new Rectangle2D.Double(buttonXStart, buttonYPos, buttonWidth, barSize)));
            buttonYPos += barSize + 1;
            sB.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    SlidingBar sB = (SlidingBar)evt.getSource();
                    int pPos = sB.getDiscretePosition();
                    double rY = (sB.getBounds().getMaxY() - (double)evt.getY()) / sB.getBounds().getHeight();
                    sB.setPosition(rY);
                    sB.snap();
                    int nPos = sB.getDiscretePosition();
                    MapNavLayer.this.canvas.getMapRegion().zoom(null, 0.0, nPos - pPos);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (MapNavLayer.this.sliding) {
                        MapNavLayer.this.sliding = false;
                        SlidingBar sB = (SlidingBar)evt.getSource();
                        sB.snap();
                        int nPos = sB.getDiscretePosition();
                        MapNavLayer.this.canvas.getMapRegion().zoom(null, 0.0, nPos - MapNavLayer.this.prevSliderPos);
                    }
                }
            });
            sB.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    SlidingBar sB = (SlidingBar)evt.getSource();
                    if (!MapNavLayer.this.sliding) {
                        MapNavLayer.this.prevSliderPos = sB.getDiscretePosition();
                        MapNavLayer.this.sliding = true;
                    }
                    double rY = (sB.getBounds().getMaxY() - (double)evt.getY()) / sB.getBounds().getHeight();
                    sB.setPosition(rY);
                }
            });
            this.slider = (SlidingBar)sB;
            this.slider.setTileConfig(tlc);
            this.buttons.add(sB);
        }
        sB = new SimpleButton();
        sB.setActiveArea(this.at.createTransformedShape(new Rectangle2D.Double(buttonXStart, buttonYPos, buttonWidth, buttonHeight)));
        buttonYPos += buttonHeight + 1;
        sB.setEnabledImage(Icons.getIcon("mapnav/zoomout_ena.png").getImage());
        sB.setMouseOverImage(Icons.getIcon("mapnav/zoomout_ovr.png").getImage());
        sB.setMouseDownImage(Icons.getIcon("mapnav/zoomout_dwn.png").getImage());
        sB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MapNavLayer.this.canvas.getMapRegion().zoomOut();
            }
        });
        this.buttons.add(sB);
        Shape btnBackground = this.at.createTransformedShape(new RoundRectangle2D.Double(buttonXStart - 3, dialY - 3, buttonWidth + 6, buttonYPos - dialY + 5, 12.0, 12.0));
        Shape panDialBackground = this.at.createTransformedShape(new RoundRectangle2D.Double(dialX - 3, dialY - 3, dialWidth + 6, dialHeight + 6, 12.0, 12.0));
        Shape btnBckgndShdw = this.at.createTransformedShape(new RoundRectangle2D.Double(buttonXStart - 3, dialY - 3, buttonWidth + 8, buttonYPos - dialY + 7, 12.0, 12.0));
        Shape pDBckgndShdw = this.at.createTransformedShape(new RoundRectangle2D.Double(dialX - 3, dialY - 3, dialWidth + 8, dialHeight + 8, 12.0, 12.0));
        this.guiBackground = new Area(btnBackground);
        ((Area)this.guiBackground).add(new Area(panDialBackground));
        this.guiBackgroundShadow = new Area(btnBckgndShdw);
        ((Area)this.guiBackgroundShadow).add(new Area(pDBckgndShdw));
    }

    private class SimpleButton {
        private Shape activeArea;
        private Rectangle2D areaBounds;
        private Image enabledImage;
        private Image mouseOverImage;
        private Image mouseDownImage;
        private boolean mouseOver = false;
        private boolean mouseDown = false;
        private EventListenerList listenerList = new EventListenerList();

        private SimpleButton() {
        }

        public void paint(Graphics2D g) {
            this.paint(g, null);
        }

        public void paint(Graphics2D g, AffineTransform at) {
            if (this.isMouseOver()) {
                g.setPaint(new GradientPaint((float)(this.getBounds().getMinX() + this.getBounds().getWidth() / 2.0), (float)this.getBounds().getMinY(), new Color(1.0f, 1.0f, 1.0f, 1.0f), (float)(this.getBounds().getMinX() + this.getBounds().getWidth() / 2.0), (float)(this.getBounds().getMinY() + this.getBounds().getHeight() / 2.0), new Color(1.0f, 1.0f, 1.0f, 0.0f), true));
                g.fill(this.getBounds());
            }
            if (this.getDisplayImage() == null) {
                return;
            }
            if (at == null) {
                at = new AffineTransform();
            }
            at.translate(this.getBounds().getMinX(), this.getBounds().getMinY());
            at.scale(this.getBounds().getWidth() / (double)this.getDisplayImage().getWidth(null), this.getBounds().getHeight() / (double)this.getDisplayImage().getHeight(null));
            g.drawImage(this.getDisplayImage(), at, null);
        }

        public Image getDisplayImage() {
            Image i = this.enabledImage;
            if (this.mouseOver && this.mouseOverImage != null) {
                i = this.mouseOverImage;
            }
            if (this.mouseDown && this.mouseDownImage != null) {
                i = this.mouseDownImage;
            }
            return i;
        }

        public void setActiveArea(Shape activeArea) {
            this.activeArea = activeArea;
            this.areaBounds = activeArea.getBounds2D();
        }

        public Shape getActiveArea() {
            return this.activeArea;
        }

        public Rectangle2D getBounds() {
            return this.areaBounds;
        }

        public void setEnabledImage(Image enabledImage) {
            this.enabledImage = enabledImage;
        }

        public Image getEnabledImage() {
            return this.enabledImage;
        }

        public void setMouseOverImage(Image mouseOverImage) {
            this.mouseOverImage = mouseOverImage;
        }

        public Image getMouseOverImage() {
            return this.mouseOverImage;
        }

        public void setMouseDownImage(Image mouseDownImage) {
            this.mouseDownImage = mouseDownImage;
        }

        public Image getMouseDownImage() {
            return this.mouseDownImage;
        }

        public void addMouseWheelListener(MouseWheelListener l) {
            this.listenerList.add(MouseWheelListener.class, l);
        }

        public void removeMouseWheelListener(MouseWheelListener l) {
            this.listenerList.remove(MouseWheelListener.class, l);
        }

        public void fireMouseWheelMoved(MouseWheelEvent e) {
            e.setSource(this);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseWheelListener.class) continue;
                ((MouseWheelListener)listeners[i + 1]).mouseWheelMoved(e);
            }
        }

        public void addMouseMotionListener(MouseMotionListener l) {
            this.listenerList.add(MouseMotionListener.class, l);
        }

        public void removeMouseMotionListener(MouseMotionListener l) {
            this.listenerList.remove(MouseMotionListener.class, l);
        }

        public void fireMouseMoved(MouseEvent e) {
            e.setSource(this);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseMotionListener.class) continue;
                ((MouseMotionListener)listeners[i + 1]).mouseMoved(e);
            }
        }

        public void fireMouseDragged(MouseEvent e) {
            e.setSource(this);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseMotionListener.class) continue;
                ((MouseMotionListener)listeners[i + 1]).mouseDragged(e);
            }
        }

        public void addMouseListener(MouseListener l) {
            this.listenerList.add(MouseListener.class, l);
        }

        public void removeMouseListener(MouseListener l) {
            this.listenerList.remove(MouseListener.class, l);
        }

        public void fireMouseClicked(MouseEvent e) {
            e.setSource(this);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseListener.class) continue;
                ((MouseListener)listeners[i + 1]).mouseClicked(e);
            }
        }

        public void fireMouseEntered(MouseEvent e) {
            e.setSource(this);
            this.setMouseOver(true);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseListener.class) continue;
                ((MouseListener)listeners[i + 1]).mouseEntered(e);
            }
        }

        public void fireMouseExited(MouseEvent e) {
            e.setSource(this);
            this.setMouseOver(false);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseListener.class) continue;
                ((MouseListener)listeners[i + 1]).mouseExited(e);
            }
        }

        public void fireMousePressed(MouseEvent e) {
            e.setSource(this);
            this.setMouseDown(true);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseListener.class) continue;
                ((MouseListener)listeners[i + 1]).mousePressed(e);
            }
        }

        public void fireMouseReleased(MouseEvent e) {
            e.setSource(this);
            this.setMouseDown(false);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MouseListener.class) continue;
                ((MouseListener)listeners[i + 1]).mouseReleased(e);
            }
        }

        public void setMouseOver(boolean mouseOver) {
            this.mouseOver = mouseOver;
        }

        public boolean isMouseOver() {
            return this.mouseOver;
        }

        public void setMouseDown(boolean mouseDown) {
            this.mouseDown = mouseDown;
        }

        public boolean isMouseDown() {
            return this.mouseDown;
        }
    }

    private class PanningDial
    extends SimpleButton {
        private double angle = 0.0;
        private final Shape arrows;
        private final float arrowPadding = 0.9f;
        private final double snapTol = 0.2;
        private final double[] snapPoints = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, -2.356194490192345, -1.5707963267948966, -0.7853981633974483};

        public PanningDial() {
            GeneralPath arrow = new GeneralPath();
            arrow.moveTo(0.0f, 13.0f);
            arrow.lineTo(3.0f, 10.0f);
            arrow.lineTo(3.0f, 16.0f);
            arrow.lineTo(0.0f, 13.0f);
            arrow.closePath();
            Area area = new Area(arrow);
            AffineTransform aat = new AffineTransform();
            aat.setToRotation(1.5707963267948966, arrow.getBounds2D().getMaxX() + 10.0, arrow.getBounds2D().getMinY() + arrow.getBounds2D().getHeight() / 2.0);
            area.add(new Area(aat.createTransformedShape(arrow)));
            aat.setToRotation(Math.PI, arrow.getBounds2D().getMaxX() + 10.0, arrow.getBounds2D().getMinY() + arrow.getBounds2D().getHeight() / 2.0);
            area.add(new Area(aat.createTransformedShape(arrow)));
            aat.setToRotation(4.71238898038469, arrow.getBounds2D().getMaxX() + 10.0, arrow.getBounds2D().getMinY() + arrow.getBounds2D().getHeight() / 2.0);
            area.add(new Area(aat.createTransformedShape(arrow)));
            this.arrows = area;
        }

        @Override
        public void paint(Graphics2D g) {
            g.setColor(Color.WHITE);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.draw(this.getActiveArea());
            g.setPaint(new GradientPaint((float)(this.getBounds().getMinX() + this.getBounds().getWidth() / 2.0), (float)(this.getBounds().getMinY() + this.getBounds().getHeight() * 0.1428), new Color(1.0f, 1.0f, 1.0f, 0.4f), (float)(this.getBounds().getMinX() + this.getBounds().getWidth() / 2.0), (float)(this.getBounds().getMinY() + this.getBounds().getHeight() / 2.0), new Color(1.0f, 1.0f, 1.0f, 0.0f), true));
            g.fill(this.getActiveArea());
            AffineTransform at = new AffineTransform();
            at.translate(this.getBounds().getMinX() + this.getBounds().getWidth() * 0.10000002384185791 / 2.0, this.getBounds().getMinY() + this.getBounds().getHeight() * 0.10000002384185791 / 2.0);
            at.scale(this.getBounds().getWidth() * (double)0.9f / this.arrows.getBounds2D().getWidth(), this.getBounds().getHeight() * (double)0.9f / this.arrows.getBounds2D().getHeight());
            at.rotate(this.angle, this.arrows.getBounds2D().getCenterX(), this.arrows.getBounds2D().getCenterY());
            if (this.isMouseOver()) {
                g.setColor(MOUSEOVER_BLUE);
            } else {
                g.setColor(ENABLED_BLUE);
            }
            g.fill(at.createTransformedShape(this.arrows));
        }

        public void setAngle(double angle) {
            for (double sP : this.snapPoints) {
                if (!(angle > sP - 0.2) || !(angle < sP + 0.2)) continue;
                this.angle = sP;
                return;
            }
            if (angle > 2.941592653589793 || angle < -2.941592653589793) {
                this.angle = Math.PI;
                return;
            }
            this.angle = angle;
        }

        public double getAngle() {
            return this.angle;
        }
    }

    private class SlidingBar
    extends SimpleButton {
        private Rectangle2D sliderBox;
        private double position = 0.5;
        private int discretePosition = 0;
        private TileLayerConfig tileConfig;
        private int numTicks = 2;
        private double tickSpacing = 2.0;

        private SlidingBar() {
        }

        @Override
        public void paint(Graphics2D g) {
            for (int i = 0; i < this.numTicks; ++i) {
                int minX = (int)this.getBounds().getMinX() + 3;
                int maxX = (int)this.getBounds().getMaxX() - 3;
                int y = (int)(this.getBounds().getMaxY() - (double)(i + 1) * this.tickSpacing - (double)(i + 1));
                g.setColor(ENABLED_BLUE);
                g.drawLine(minX, y, maxX, y);
                g.setColor(Color.WHITE);
                g.drawLine(minX, y + 1, maxX, y + 1);
            }
            this.sliderBox = new Rectangle2D.Double(this.getBounds().getMinX() + 1.0, this.getBounds().getMaxY() - this.getBounds().getHeight() * this.position - this.tickSpacing / 2.0, this.getBounds().getWidth() - 2.0, this.tickSpacing);
            g.setPaint(new GradientPaint((float)(this.sliderBox.getMinX() + this.sliderBox.getWidth() / 2.0), (float)this.sliderBox.getMinY(), new Color(1.0f, 1.0f, 1.0f, 1.0f), (float)(this.sliderBox.getMinX() + this.sliderBox.getWidth() / 2.0), (float)(this.sliderBox.getMinY() + this.sliderBox.getHeight() / 2.0), new Color(1.0f, 1.0f, 1.0f, 0.0f), true));
            g.fill(this.sliderBox);
            g.setColor(Color.WHITE);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.draw(this.sliderBox);
        }

        public void setTileConfig(TileLayerConfig tileConfig) {
            int zoomId;
            this.tileConfig = tileConfig;
            this.setNumTicks(tileConfig.getZoomLevelCount());
            this.tickSpacing = (this.getBounds().getHeight() - (double)this.numTicks) / (double)(this.numTicks + 1);
            Rectangle2D dataWindow = MapNavLayer.this.canvas.getMapRegion().getDataWindow();
            if (dataWindow == null) {
                double[] bounds = tileConfig.getCoordinateSystemBound();
                dataWindow = new Rectangle2D.Double(bounds[0], bounds[1], bounds[2] - bounds[0], bounds[3] - bounds[1]);
            }
            if ((zoomId = tileConfig.getClosestScaleID(dataWindow, MapNavLayer.this.canvas.getHeight())) != -1) {
                this.setDiscretePosition(zoomId);
            }
        }

        public TileLayerConfig getTileConfig() {
            return this.tileConfig;
        }

        public void setNumTicks(int numTicks) {
            this.numTicks = numTicks;
        }

        public int getNumTicks() {
            return this.numTicks;
        }

        public void setPosition(double position) {
            this.position = position;
        }

        public double getPosition() {
            return this.position;
        }

        public int getDiscretePosition() {
            return this.discretePosition;
        }

        public void setDiscretePosition(int discretePosition) {
            this.setPosition(((double)(discretePosition + 1) * this.tickSpacing + (double)(discretePosition + 1)) / this.getBounds().getHeight());
            this.discretePosition = discretePosition;
        }

        public void snap() {
            double tickPos;
            double dif;
            double closest = (this.tickSpacing + 1.0) / this.getBounds().getHeight();
            int num = 0;
            double lastDiff = Math.abs(closest - this.getPosition());
            int i = 1;
            while (i < this.numTicks && lastDiff > 0.0 && (dif = Math.abs((tickPos = ((double)(i + 1) * this.tickSpacing + (double)(i + 1)) / this.getBounds().getHeight()) - this.getPosition())) < lastDiff) {
                closest = tickPos;
                num = i++;
                lastDiff = dif;
            }
            this.setPosition(closest);
            this.discretePosition = num;
        }

        public double getSelectedScale() {
            return this.tileConfig.getScale(this.discretePosition);
        }
    }
}

